/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _AST_TREE_H_
#define _AST_TREE_H_

#include <list>
#include <GTLCore/ScopedName.h>

namespace llvm {
  class Module;
  class LLVMContext;
}

namespace LLVMBackend {
  class CodeGenerator;
}

namespace GTLCore {
  class VariableNG;
  class Type;
  class ModuleData;
  namespace AST {
    class Expression;
    class FunctionDeclaration;
    /**
     * @internal
     * @ingroup GTLCore_AST
     */
    class GTLCORE_EXPORT GlobalConstantDeclaration {
      public:
        /**
         * Create an external global constant
         */
        GlobalConstantDeclaration( const GTLCore::ScopedName& _name, const GTLCore::Type* _type, Expression* _initialiser, bool _dependant, bool _external);
        GlobalConstantDeclaration( const GTLCore::ScopedName& _name, const GTLCore::Type* _type, const std::list< int >& sizes,bool _dependant, bool _external);
        ~GlobalConstantDeclaration();
        GTLCore::ScopedName name() const { return m_name; }
        const Expression* initialiser() const { return m_initialiser; }
        Expression* initialiser() { return m_initialiser; }
        GTLCore::VariableNG* variable() { return m_variable; }
        const GTLCore::Type* type() { return m_type; }
        void generate( ModuleData* _module, llvm::Module* _llvmModule, LLVMBackend::CodeGenerator* _codeGenerator, llvm::LLVMContext* _llvmContext);
        bool isConstant() const { return m_constant; }
      private:
        GTLCore::String nameToSymbol();
      public:
        static GTLCore::String nameToSymbol(const GTLCore::ScopedName& name);
      private:
        GTLCore::ScopedName m_name;
        Expression* m_initialiser;
        GTLCore::VariableNG* m_variable;
        const GTLCore::Type* m_type;
        std::list< int > m_sizes;
        bool m_constant;
        bool m_external;
    };
    /**
     * @internal
     * @ingroup GTLCore_AST
     */
    class GTLCORE_EXPORT Tree {
      public:
        Tree();
        ~Tree();
        const std::list<FunctionDeclaration*>& functionsDeclarations() const;
        void append(FunctionDeclaration* fd);
        const std::list<GlobalConstantDeclaration*>& globalConstantDeclarations() const;
        void append( GlobalConstantDeclaration* constant );
        bool containsGlobalConstant( const GTLCore::ScopedName& _name ) const;
        void generate( ModuleData* _module, llvm::Module* _llvmModule, LLVMBackend::CodeGenerator* _codeGenerator, llvm::LLVMContext* _llvmContext);
      private:
        std::list<FunctionDeclaration*> m_functions;
        std::list<GlobalConstantDeclaration*> m_globalConstants;
    };
  }
}

#endif
