
import "TestFramework";

int main()
{
  int errorcount = 0;
  Test::checkNearEqual( cosh(0.0), 1.0, errorcount);
  Test::checkNearEqual( cosh(1.0), cosh(-1.0), errorcount);
  Test::checkNearEqual( cosh(1.0), 0.5 * (M_E + 1.0 / M_E), errorcount);
  Test::checkNearEqual( sinh(0.0), 0.0, errorcount);
  Test::checkNearEqual( sinh(-1.0), -sinh(1.0), errorcount);
  Test::checkNearEqual( sinh(1.0), 0.5 * (M_E - 1.0 / M_E), errorcount);
  Test::checkNearEqual( tanh(0.0), 0, errorcount);
  Test::checkNearEqual( tanh(-1.0), -tanh(1.0), errorcount);
  
  Test::checkNearEqual( exp(1.0), M_E, errorcount);
  Test::checkNearEqual( exp(0.0), 1.0, errorcount);
  Test::checkNearEqual( exp(-1.0), 1 / M_E, errorcount);
  Test::checkNearEqual( log(1.0), 0.0, errorcount);
  Test::checkNearEqual( log(M_E), 1.0, errorcount);
  Test::checkNearEqual( log10(10.0), 1.0, errorcount);
  Test::checkNearEqual( log10(100.0), 2.0, errorcount);
  
  // Multiple checks
  float v = -10.0;
  while(v <= 10.0)
  {
    Test::checkNearEqual( tanh(v), sinh(v)/cosh(v), errorcount);
    Test::checkNearEqual( exp(log(v)), v, errorcount);
    Test::checkNearEqual( exp(v), 1.0 / exp( -v), errorcount);
    Test::checkNearEqual( log(v), -log(1.0 / v), errorcount);
    v = v + 0.1;
  }

  return errorcount;
}
