#-*- coding:utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    mga@tinyerp.com
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

{
    "name" : "Email Gateway",
    "version" : "1.0",
    "depends" : ["base", 'mail'],
    "author" : "OpenERP SA",
    "category": 'Tools',
    "description": """
Retrieve incoming email on POP / IMAP servers
=============================================

Enter the parameters of your POP/IMAP account(s), and any incoming
emails on these accounts will be automatically downloaded into your OpenERP
system. All POP3/IMAP-compatible servers are supported, included those
that require an encrypted SSL/TLS connection.

This can be used to easily create email-based workflows for many
email-enabled OpenERP documents, such as:

 * CRM Leads/Opportunities
 * CRM Claims
 * Project Issues
 * Project Tasks
 * Human Resource Recruitments (Applicants)
 * etc.

Just install the relevant application, and you can assign any of
these document types (Leads, Project Issues, etc.) to your incoming
email accounts. New emails will automatically spawn new documents
of the chosen type, so it's a snap to create a mailbox-to-OpenERP
integration. Even better: these documents directly act as mini
conversations synchronized by email. You can reply from within
OpenERP, and the answers will automatically be collected when
they come back, and attached to the same *conversation* document.

For more specific needs, you may also assign custom-defined actions
(technically: Server Actions) to be triggered for each incoming
mail. 
    """,
    'website': 'http://www.openerp.com',
    'init_xml': [],
    'update_xml': [
        "fetchmail_view.xml",
        "fetchmail_data.xml",
        'security/ir.model.access.csv',
        'fetchmail_installer_view.xml'
    ],
    'demo_xml': [

    ],
    'installable': True,
    'auto_install': False,
    'certificate' : '00692978332890137453',
    'images': ['images/1_email_servers.jpeg'],
}

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
