/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHPROTOCOLPROVIDESENDPOINTACCESS_H_
#define OPENDRIM_SSHPROTOCOLPROVIDESENDPOINTACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_SSHProtocolProvidesEndpoint.h"
#include "assocOpenDRIM_SSHProtocolProvidesEndpoint.h"

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_unload(string& errorMessage);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHProtocolProvidesEndpoint>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHProtocolProvidesEndpoint& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolProvidesEndpoint& newInstance, const OpenDRIM_SSHProtocolProvidesEndpoint& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolProvidesEndpoint& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolProvidesEndpoint& instance, string& errorMessage);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_SSHProtocolProvidesEndpoint>& OpenDRIM_SSHProtocolProvidesEndpoint_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_SSHProtocolProvidesEndpoint>& OpenDRIM_SSHProtocolProvidesEndpoint_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHProtocolProvidesEndpoint_populate(OpenDRIM_SSHProtocolProvidesEndpoint& instance, string& errorMessage);

#endif /*OPENDRIM_SSHPROTOCOLPROVIDESENDPOINTACCESS_H_*/
