#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
VERSION=$2
TAR=../opencsv_$VERSION.orig.tar.gz
DIR=opencsv-$VERSION

tar -zxf $3
rm $3
GZIP=--best tar -c -z -f $TAR \
 --exclude '*.jar' \
 --exclude '*.sh' \
 --exclude 'build.xml' \
 --exclude 'build.version' \
 --exclude 'deploy' \
 --exclude 'doc' \
 --exclude 'lib' \
 --exclude '.svnignore' \
 --exclude '.project' \
 --exclude '.classpath' \
 $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
