/*
##############################################################################
#                                                                            #
#                       Open Babel file: elementtable.h                         #
#                                                                            #
#  Some portions Copyright (c) 2001-2009 Geoffrey R. Hutchison               #
#  Part of the Open Babel package, under the GNU General Public License (GPL)#
#                                                                            #
#  Created from the Blue Obelisk Cheminformatics Data Repository             #
#  Direct Source: http://www.blueobelisk.org/                                #
#       http://www.blueobelisk.org/repos/blueobelisk/elements.xml            #
#  (includes further bibliographic citation information)                     #
#                                                                            #
#  Allred and Rochow Electronegativity from:                                 #
#  http://www.hull.ac.uk/chemistry/electroneg.php?type=Allred-Rochow         #
#                                                                            #
#  Columns represent:  (used by data.cpp:OBElementTable and OBElement)       #
#   - atomic number (used as an index to the vector as well)                 #
#   - elemental symbol                                                       #
#   - Allred and Rochow electronegativity  0.0 if unknown                    #
#   - covalent radii (in Angstrom)         1.6 if unknown                    #
#       from https://doi.org/10.1039/b801115j                              #
#   - "bond order" radii -- ignored, but included for compatibility          #
#   - van der Waals radii (in Angstrom)    2.0 if unknown                    #
#       from https://doi.org/10.1021/jp8111556                             #
#   - maximum bond valence                   6 if unknown                    #
#   - IUPAC recommended atomic masses (in amu)                               #
#   - Pauling electronegativity            0.0 if unknown                    #
#   - ionization potential (in eV)         0.0 if unknown                    #
#   - electron affinity (in eV)            0.0 if unknown                    #
#   - RGB values (defaults for visualization)                                #
#   - element name (in English)                                              #
#                                                                            #
##############################################################################
*/

// Num	Symb	ARENeg	RCov	RBO	RVdW	MaxBnd	Mass	ElNeg.	Ionization	ElAffinity	Red	Green	Blue	Name

ELEMTABLE(  0, *,  0.00, 0.00, 0.00, 0.00,  0,          0, 0.00,       0,          0, 0.07, 0.50, 0.70, Dummy),
ELEMTABLE(  1, H , 2.20, 0.31, 0.31, 1.10,  1,    1.00794, 2.20, 13.5984, 0.75420375, 0.75, 0.75, 0.75, Hydrogen),
ELEMTABLE(  2, He, 0.00, 0.28, 0.28, 1.40,  0,   4.002602, 0.00, 24.5874,          0, 0.85, 1.00, 1.00, Helium),
ELEMTABLE(  3, Li, 0.97, 1.28, 1.28, 1.81,  1,      6.941, 0.98,  5.3917,   0.618049, 0.80, 0.50, 1.00, Lithium),
ELEMTABLE(  4, Be, 1.47, 0.96, 0.96, 1.53,  2,   9.012182, 1.57,  9.3227,          0, 0.76, 1.00, 0.00, Beryllium),
ELEMTABLE(  5, B , 2.01, 0.84, 0.84, 1.92,  4,     10.811, 2.04,   8.298,   0.279723, 1.00, 0.71, 0.71, Boron),
ELEMTABLE(  6, C , 2.50, 0.76, 0.76, 1.70,  4,    12.0107, 2.55, 11.2603,   1.262118, 0.40, 0.40, 0.40, Carbon),
ELEMTABLE(  7, N , 3.07, 0.71, 0.71, 1.55,  4,    14.0067, 3.04, 14.5341,      -0.07, 0.05, 0.05, 1.00, Nitrogen),
ELEMTABLE(  8, O , 3.50, 0.66, 0.66, 1.52,  2,    15.9994, 3.44, 13.6181,   1.461112, 1.00, 0.05, 0.05, Oxygen),
ELEMTABLE(  9, F , 4.10, 0.57, 0.57, 1.47,  1, 18.9984032, 3.98, 17.4228,  3.4011887, 0.50, 0.70, 1.00, Fluorine),
ELEMTABLE( 10, Ne, 0.00, 0.58, 0.58, 1.54,  0,    20.1797, 0.00, 21.5645,          0, 0.70, 0.89, 0.96, Neon),
ELEMTABLE( 11, Na, 1.01, 1.66, 1.66, 2.27,  1,   22.98977, 0.93,  5.1391,   0.547926, 0.67, 0.36, 0.95, Sodium),
ELEMTABLE( 12, Mg, 1.23, 1.41, 1.41, 1.73,  2,    24.3050, 1.31,  7.6462,          0, 0.54, 1.00, 0.00, Magnesium),
ELEMTABLE( 13, Al, 1.47, 1.21, 1.21, 1.84,  6,  26.981538, 1.61,  5.9858,    0.43283, 0.75, 0.65, 0.65, Aluminium),
ELEMTABLE( 14, Si, 1.74, 1.11, 1.11, 2.10,  6,    28.0855, 1.90,  8.1517,   1.389521, 0.50, 0.60, 0.60, Silicon),
ELEMTABLE( 15, P , 2.06, 1.07, 1.07, 1.80,  6,  30.973761, 2.19, 10.4867,     0.7465, 1.00, 0.50, 0.00, Phosphorus),
ELEMTABLE( 16, S , 2.44, 1.05, 1.05, 1.80,  6,     32.065, 2.58,   10.36,  2.0771029, 0.70, 0.70, 0.00, Sulfur),
ELEMTABLE( 17, Cl, 2.83, 1.02, 1.02, 1.75,  1,     35.453, 3.16, 12.9676,   3.612724, 0.12, 0.94, 0.12, Chlorine),
ELEMTABLE( 18, Ar, 0.00, 1.06, 1.06, 1.88,  0,     39.948, 0.00, 15.7596,          0, 0.50, 0.82, 0.89, Argon),
ELEMTABLE( 19, K , 0.91, 2.03, 2.03, 2.75,  1,    39.0983, 0.82,  4.3407,   0.501459, 0.56, 0.25, 0.83, Potassium),
ELEMTABLE( 20, Ca, 1.04, 1.76, 1.76, 2.31,  2,     40.078, 1.00,  6.1132,    0.02455, 0.24, 1.00, 0.00, Calcium),
ELEMTABLE( 21, Sc, 1.20, 1.70, 1.70, 2.30,  6,   44.95591, 1.36,  6.5615,      0.188, 0.90, 0.90, 0.90, Scandium),
ELEMTABLE( 22, Ti, 1.32, 1.60, 1.60, 2.15,  6,     47.867, 1.54,  6.8281,      0.084, 0.75, 0.76, 0.78, Titanium),
ELEMTABLE( 23, V , 1.45, 1.53, 1.53, 2.05,  6,    50.9415, 1.63,  6.7462,      0.525, 0.65, 0.65, 0.67, Vanadium),
ELEMTABLE( 24, Cr, 1.56, 1.39, 1.39, 2.05,  6,    51.9961, 1.66,  6.7665,    0.67584, 0.54, 0.60, 0.78, Chromium),
ELEMTABLE( 25, Mn, 1.60, 1.39, 1.39, 2.05,  8,  54.938049, 1.55,   7.434,          0, 0.61, 0.48, 0.78, Manganese),
ELEMTABLE( 26, Fe, 1.64, 1.32, 1.32, 2.05,  6,     55.845, 1.83,  7.9024,      0.151, 0.88, 0.40, 0.20, Iron),
ELEMTABLE( 27, Co, 1.70, 1.26, 1.26, 2.00,  6,    58.9332, 1.88,   7.881,     0.6633, 0.94, 0.56, 0.63, Cobalt),
ELEMTABLE( 28, Ni, 1.75, 1.24, 1.24, 2.00,  6,    58.6934, 1.91,  7.6398,    1.15716, 0.31, 0.82, 0.31, Nickel),
ELEMTABLE( 29, Cu, 1.75, 1.32, 1.32, 2.00,  6,     63.546, 1.90,  7.7264,    1.23578, 0.78, 0.50, 0.20, Copper),
ELEMTABLE( 30, Zn, 1.66, 1.22, 1.22, 2.10,  6,      65.38, 1.65,  9.3942,          0, 0.49, 0.50, 0.69, Zinc),
ELEMTABLE( 31, Ga, 1.82, 1.22, 1.22, 1.87,  3,     69.723, 1.81,  5.9993,       0.41, 0.76, 0.56, 0.56, Gallium),
ELEMTABLE( 32, Ge, 2.02, 1.20, 1.20, 2.11,  4,      72.64, 2.01,  7.8994,   1.232712, 0.40, 0.56, 0.56, Germanium),
ELEMTABLE( 33, As, 2.20, 1.19, 1.19, 1.85,  3,   74.92160, 2.18,  9.7886,      0.814, 0.74, 0.50, 0.89, Arsenic),
ELEMTABLE( 34, Se, 2.48, 1.20, 1.20, 1.90,  2,      78.96, 2.55,  9.7524,    2.02067, 1.00, 0.63, 0.00, Selenium),
ELEMTABLE( 35, Br, 2.74, 1.20, 1.20, 1.83,  1,     79.904, 2.96, 11.8138,   3.363588, 0.65, 0.16, 0.16, Bromine),
ELEMTABLE( 36, Kr, 0.00, 1.16, 1.16, 2.02,  0,     83.798, 3.00, 13.9996,          0, 0.36, 0.72, 0.82, Krypton),
ELEMTABLE( 37, Rb, 0.89, 2.20, 2.20, 3.03,  1,    85.4678, 0.82,  4.1771,   0.485916, 0.44, 0.18, 0.69, Rubidium),
ELEMTABLE( 38, Sr, 0.99, 1.95, 1.95, 2.49,  2,      87.62, 0.95,  5.6949,    0.05206, 0.00, 1.00, 0.00, Strontium),
ELEMTABLE( 39, Y , 1.11, 1.90, 1.90, 2.40,  6,   88.90585, 1.22,  6.2173,      0.307, 0.58, 1.00, 1.00, Yttrium),
ELEMTABLE( 40, Zr, 1.22, 1.75, 1.75, 2.30,  6,     91.224, 1.33,  6.6339,      0.426, 0.58, 0.88, 0.88, Zirconium),
ELEMTABLE( 41, Nb, 1.23, 1.64, 1.64, 2.15,  6,   92.90638, 1.60,  6.7589,      0.893, 0.45, 0.76, 0.79, Niobium),
ELEMTABLE( 42, Mo, 1.30, 1.54, 1.54, 2.10,  6,      95.96, 2.16,  7.0924,     0.7472, 0.33, 0.71, 0.71, Molybdenum),
ELEMTABLE( 43, Tc, 1.36, 1.47, 1.47, 2.05,  6,         98, 1.90,    7.28,       0.55, 0.23, 0.62, 0.62, Technetium),
ELEMTABLE( 44, Ru, 1.42, 1.46, 1.46, 2.05,  6,     101.07, 2.20,  7.3605,    1.04638, 0.14, 0.56, 0.56, Ruthenium),
ELEMTABLE( 45, Rh, 1.45, 1.42, 1.42, 2.00,  6,  102.90550, 2.28,  7.4589,    1.14289, 0.04, 0.49, 0.55, Rhodium),
ELEMTABLE( 46, Pd, 1.35, 1.39, 1.39, 2.05,  6,     106.42, 2.20,  8.3369,    0.56214, 0.00, 0.41, 0.52, Palladium),
ELEMTABLE( 47, Ag, 1.42, 1.45, 1.45, 2.10,  6,   107.8682, 1.93,  7.5762,    1.30447, 0.88, 0.88, 1.00, Silver),
ELEMTABLE( 48, Cd, 1.46, 1.44, 1.44, 2.20,  6,    112.411, 1.69,  8.9938,          0, 1.00, 0.85, 0.56, Cadmium),
ELEMTABLE( 49, In, 1.49, 1.42, 1.42, 2.20,  3,    114.818, 1.78,  5.7864,      0.404, 0.65, 0.46, 0.45, Indium),
ELEMTABLE( 50, Sn, 1.72, 1.39, 1.39, 1.93,  4,    118.701, 1.96,  7.3439,   1.112066, 0.40, 0.50, 0.50, Tin),
ELEMTABLE( 51, Sb, 1.82, 1.39, 1.39, 2.17,  3,    121.760, 2.05,  8.6084,   1.047401, 0.62, 0.39, 0.71, Antimony),
ELEMTABLE( 52, Te, 2.01, 1.38, 1.38, 2.06,  2,     127.60, 2.10,  9.0096,   1.970875, 0.83, 0.48, 0.00, Tellurium),
ELEMTABLE( 53, I , 2.21, 1.39, 1.39, 1.98,  1,  126.90447, 2.66, 10.4513,   3.059038, 0.58, 0.00, 0.58, Iodine),
ELEMTABLE( 54, Xe, 0.00, 1.40, 1.40, 2.16,  0,    131.293, 2.60, 12.1298,          0, 0.26, 0.62, 0.69, Xenon),
ELEMTABLE( 55, Cs, 0.86, 2.44, 2.44, 3.43,  1,  132.90545, 0.79,  3.8939,   0.471626, 0.34, 0.09, 0.56, Caesium),
ELEMTABLE( 56, Ba, 0.97, 2.15, 2.15, 2.68,  2,    137.327, 0.89,  5.2117,    0.14462, 0.00, 0.79, 0.00, Barium),
ELEMTABLE( 57, La, 1.08, 2.07, 2.07, 2.50, 12,   138.9055, 1.10,  5.5769,       0.47, 0.44, 0.83, 1.00, Lanthanum),
ELEMTABLE( 58, Ce, 0.00, 2.04, 2.04, 2.48,  6,    140.116, 1.12,  5.5387,        0.5, 1.00, 1.00, 0.78, Cerium),
ELEMTABLE( 59, Pr, 0.00, 2.03, 2.03, 2.47,  6,  140.90765, 1.13,   5.473,        0.5, 0.85, 1.00, 0.78, Praseodymium),
ELEMTABLE( 60, Nd, 0.00, 2.01, 2.01, 2.45,  6,     144.24, 1.14,   5.525,        0.5, 0.78, 1.00, 0.78, Neodymium),
ELEMTABLE( 61, Pm, 0.00, 1.99, 1.99, 2.43,  6,        145, 0.00,   5.582,        0.5, 0.64, 1.00, 0.78, Promethium),
ELEMTABLE( 62, Sm, 0.00, 1.98, 1.98, 2.42,  6,     150.36, 1.17,  5.6437,        0.5, 0.56, 1.00, 0.78, Samarium),
ELEMTABLE( 63, Eu, 0.00, 1.98, 1.98, 2.40,  6,    151.964, 0.00,  5.6704,        0.5, 0.38, 1.00, 0.78, Europium),
ELEMTABLE( 64, Gd, 0.00, 1.96, 1.96, 2.38,  6,     157.25, 1.20,  6.1498,        0.5, 0.27, 1.00, 0.78, Gadolinium),
ELEMTABLE( 65, Tb, 0.00, 1.94, 1.94, 2.37,  6,  158.92534, 0.00,  5.8638,        0.5, 0.19, 1.00, 0.78, Terbium),
ELEMTABLE( 66, Dy, 0.00, 1.92, 1.92, 2.35,  6,    162.500, 1.22,  5.9389,        0.5, 0.12, 1.00, 0.78, Dysprosium),
ELEMTABLE( 67, Ho, 0.00, 1.92, 1.92, 2.33,  6,  164.93032, 1.23,  6.0215,        0.5, 0.00, 1.00, 0.61, Holmium),
ELEMTABLE( 68, Er, 0.00, 1.89, 1.89, 2.32,  6,    167.259, 1.24,  6.1077,        0.5, 0.00, 0.90, 0.46, Erbium),
ELEMTABLE( 69, Tm, 0.00, 1.90, 1.90, 2.30,  6,  168.93421, 1.25,  6.1843,        0.5, 0.00, 0.83, 0.32, Thulium),
ELEMTABLE( 70, Yb, 0.00, 1.87, 1.87, 2.28,  6,    173.054, 0.00,  6.2542,        0.5, 0.00, 0.75, 0.22, Ytterbium),
ELEMTABLE( 71, Lu, 0.00, 1.87, 1.87, 2.27,  6,   174.9668, 1.27,  5.4259,        0.5, 0.00, 0.67, 0.14, Lutetium),
ELEMTABLE( 72, Hf, 1.23, 1.75, 1.75, 2.25,  6,     178.49, 1.30,  6.8251,          0, 0.30, 0.76, 1.00, Hafnium),
ELEMTABLE( 73, Ta, 1.33, 1.70, 1.70, 2.20,  6,   180.9479, 1.50,  7.5496,      0.322, 0.30, 0.65, 1.00, Tantalum),
ELEMTABLE( 74, W , 1.40, 1.62, 1.62, 2.10,  6,     183.84, 2.36,   7.864,      0.815, 0.13, 0.58, 0.84, Tungsten),
ELEMTABLE( 75, Re, 1.46, 1.51, 1.51, 2.05,  6,    186.207, 1.90,  7.8335,       0.15, 0.15, 0.49, 0.67, Rhenium),
ELEMTABLE( 76, Os, 1.52, 1.44, 1.44, 2.00,  6,     190.23, 2.20,  8.4382,     1.0778, 0.15, 0.40, 0.59, Osmium),
ELEMTABLE( 77, Ir, 1.55, 1.41, 1.41, 2.00,  6,    192.217, 2.20,   8.967,    1.56436, 0.09, 0.33, 0.53, Iridium),
ELEMTABLE( 78, Pt, 1.44, 1.36, 1.36, 2.05,  6,    195.078, 2.28,  8.9588,     2.1251, 0.90, 0.85, 0.68, Platinum),
ELEMTABLE( 79, Au, 1.42, 1.36, 1.36, 2.10,  6,  196.96655, 2.54,  9.2255,    2.30861, 0.80, 0.82, 0.12, Gold),
ELEMTABLE( 80, Hg, 1.44, 1.32, 1.32, 2.05,  6,     200.59, 2.00, 10.4375,          0, 0.71, 0.71, 0.76, Mercury),
ELEMTABLE( 81, Tl, 1.44, 1.45, 1.45, 1.96,  3,   204.3833, 1.62,  6.1082,      0.377, 0.65, 0.33, 0.30, Thallium),
ELEMTABLE( 82, Pb, 1.55, 1.46, 1.46, 2.02,  4,      207.2, 2.33,  7.4167,      0.364, 0.34, 0.35, 0.38, Lead),
ELEMTABLE( 83, Bi, 1.67, 1.48, 1.48, 2.07,  3,  208.98040, 2.02,  7.2855,   0.942363, 0.62, 0.31, 0.71, Bismuth),
ELEMTABLE( 84, Po, 1.76, 1.40, 1.40, 1.97,  2,        209, 2.00,   8.414,        1.9, 0.67, 0.36, 0.00, Polonium),
ELEMTABLE( 85, At, 1.90, 1.50, 1.50, 2.02,  1,        210, 2.20,       0,        2.8, 0.46, 0.31, 0.27, Astatine),
ELEMTABLE( 86, Rn, 0.00, 1.50, 1.50, 2.20,  0,        222, 0.00, 10.7485,          0, 0.26, 0.51, 0.59, Radon),
ELEMTABLE( 87, Fr, 0.00, 2.60, 2.60, 3.48,  1,        223, 0.70,  4.0727,          0, 0.26, 0.00, 0.40, Francium),
ELEMTABLE( 88, Ra, 0.00, 2.21, 2.21, 2.83,  2,        226, 0.90,  5.2784,          0, 0.00, 0.49, 0.00, Radium),
ELEMTABLE( 89, Ac, 0.00, 2.15, 2.15, 2.00,  6,        227, 1.10,    5.17,          0, 0.44, 0.67, 0.98, Actinium),
ELEMTABLE( 90, Th, 0.00, 2.06, 2.06, 2.40,  6,   232.0381, 1.30,  6.3067,          0, 0.00, 0.73, 1.00, Thorium),
ELEMTABLE( 91, Pa, 0.00, 2.00, 2.00, 2.00,  6,  231.03588, 1.50,    5.89,          0, 0.00, 0.63, 1.00, Protactinium),
ELEMTABLE( 92, U , 0.00, 1.96, 1.96, 2.30,  6,  238.02891, 1.38,  6.1941,          0, 0.00, 0.56, 1.00, Uranium),
ELEMTABLE( 93, Np, 0.00, 1.90, 1.90, 2.00,  6,     237.05, 1.36,  6.2657,          0, 0.00, 0.50, 1.00, Neptunium),
ELEMTABLE( 94, Pu, 0.00, 1.87, 1.87, 2.00,  6,     244.06, 1.28,   6.026,          0, 0.00, 0.42, 1.00, Plutonium),
ELEMTABLE( 95, Am, 0.00, 1.80, 1.80, 2.00,  6,     243.06, 1.30,  5.9738,          0, 0.33, 0.36, 0.95, Americium),
ELEMTABLE( 96, Cm, 0.00, 1.69, 1.69, 2.00,  6,     247.07, 1.30,  5.9914,          0, 0.47, 0.36, 0.89, Curium),
ELEMTABLE( 97, Bk, 0.00, 1.60, 1.60, 2.00,  6,     247.07, 1.30,  6.1979,          0, 0.54, 0.31, 0.89, Berkelium),
ELEMTABLE( 98, Cf, 0.00, 1.60, 1.60, 2.00,  6,     251.08, 1.30,  6.2817,          0, 0.63, 0.21, 0.83, Californium),
ELEMTABLE( 99, Es, 0.00, 1.60, 1.60, 2.00,  6,     252.08, 1.30,    6.42,          0, 0.70, 0.12, 0.83, Einsteinium),
ELEMTABLE(100, Fm, 0.00, 1.60, 1.60, 2.00,  6,     257.10, 1.30,     6.5,          0, 0.70, 0.12, 0.73, Fermium),
ELEMTABLE(101, Md, 0.00, 1.60, 1.60, 2.00,  6,     258.10, 1.30,    6.58,          0, 0.70, 0.05, 0.65, Mendelevium),
ELEMTABLE(102, No, 0.00, 1.60, 1.60, 2.00,  6,     259.10, 1.30,    6.65,          0, 0.74, 0.05, 0.53, Nobelium),
ELEMTABLE(103, Lr, 0.00, 1.60, 1.60, 2.00,  6,     262.11, 0.00,     4.9,          0, 0.78, 0.00, 0.40, Lawrencium),
ELEMTABLE(104, Rf, 0.00, 1.60, 1.60, 2.00,  6,     265.12, 0.00,       6,          0, 0.80, 0.00, 0.35, Rutherfordium),
ELEMTABLE(105, Db, 0.00, 1.60, 1.60, 2.00,  6,     268.13, 0.00,       0,          0, 0.82, 0.00, 0.31, Dubnium),
ELEMTABLE(106, Sg, 0.00, 1.60, 1.60, 2.00,  6,     271.13, 0.00,       0,          0, 0.85, 0.00, 0.27, Seaborgium),
ELEMTABLE(107, Bh, 0.00, 1.60, 1.60, 2.00,  6,        270, 0.00,       0,          0, 0.88, 0.00, 0.22, Bohrium),
ELEMTABLE(108, Hs, 0.00, 1.60, 1.60, 2.00,  6,     277.15, 0.00,       0,          0, 0.90, 0.00, 0.18, Hassium),
ELEMTABLE(109, Mt, 0.00, 1.60, 1.60, 2.00,  6,     276.15, 0.00,       0,          0, 0.92, 0.00, 0.15, Meitnerium),
ELEMTABLE(110, Ds, 0.00, 1.60, 1.60, 2.00,  6,     281.16, 0.00,       0,          0, 0.93, 0.00, 0.14, Darmstadtium),
ELEMTABLE(111, Rg, 0.00, 1.60, 1.60, 2.00,  6,     280.16, 0.00,       0,          0, 0.94, 0.00, 0.13, Roentgenium),
ELEMTABLE(112, Cn, 0.00, 1.60, 1.60, 2.00,  6,     285.17, 0.00,       0,          0, 0.95, 0.00, 0.12, Copernicium),
ELEMTABLE(113, Nh, 0.00, 1.60, 1.60, 2.00,  6,     284.18, 0.00,       0,          0, 0.96, 0.00, 0.11, Nihonium),
ELEMTABLE(114, Fl, 0.00, 1.60, 1.60, 2.00,  6,     289.19, 0.00,       0,          0, 0.97, 0.00, 0.10, Flerovium),
ELEMTABLE(115, Mc, 0.00, 1.60, 1.60, 2.00,  6,     288.19, 0.00,       0,          0, 0.98, 0.00, 0.09, Moscovium),
ELEMTABLE(116, Lv, 0.00, 1.60, 1.60, 2.00,  6,        293, 0.00,       0,          0, 0.99, 0.00, 0.08, Livermorium),
ELEMTABLE(117, Ts, 0.00, 1.60, 1.60, 2.00,  6,        294, 0.00,       0,          0, 0.99, 0.00, 0.07, Tennessine),
ELEMTABLE(118, Og, 0.00, 1.60, 1.60, 2.00,  6,        294, 0.00,       0,          0, 0.99, 0.00, 0.06, Oganesson),
// If you add a new element here, please update:
//     1. NUMELEMENTS in elements.cpp
//     2. Add a new const to the end of elements.h
//     3. Update the switch statement for symbol reading in elements.cpp, GetAtomicNum()
//     4. Ditto for the SMILES parser (which has its own switch statement)
//     5. Update the isotope table in elements.cpp, GetExactMass(). Remember to support the '0' value.
