--
-- acs-core/sql/acs-core-test-harness.sql
--
-- Test harness for ACS Core's PL/SQL API
--
-- @author Michael Yoon (michael@arsdigita.com)
--
-- @creation-date 2000-08-05
--
-- @cvs-id $Id: acs-core.sql,v 1.3 2011/07/07 10:46:02 gustafn Exp $
--



--
-- procedure test_acs_core/0
--
CREATE OR REPLACE FUNCTION test_acs_core(

) RETURNS integer AS $$
DECLARE
 uid     users.user_id%TYPE;
 tname   varchar;
BEGIN
 raise notice 'Calling acs_user.new() to create user 1';

 uid :=
  acs_user__new(1,
                'user',
                now(),
                null,
                '127.0.0.1',                
                'jane.doe@arsdigita.com',
                null,
                'Jane',
                'Doe',
                'janedoerules',
                null,
                null,
                null,
                null,
                't',
                null
                );


 tname := acs_object__name(1);

 raise NOTICE 'Calling acs_object.name to get the name of user: %', tname;

 raise NOTICE 'Calling acs_user.delete to delete user 1';

 -- PERFORM acs_user__delete(1);

 return NULL;

END;
$$ LANGUAGE plpgsql;



--
-- procedure test_del_user/0
--
CREATE OR REPLACE FUNCTION test_del_user(

) RETURNS integer AS $$
DECLARE
BEGIN
  perform acs_user__delete(1);

  return null;

END;
$$ LANGUAGE plpgsql;


select test_acs_core ();
select test_del_user ();

drop function test_acs_core ();
drop function test_del_user ();


