/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#ifndef _afc7b2d7_0869_4fea_9a9b_7fe6228baca9
#define _afc7b2d7_0869_4fea_9a9b_7fe6228baca9

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"
#include "odil/UIDsDictionary.h"

namespace odil
{

namespace registry
{
Tag const CommandGroupLength(0x0000, 0x0000);
Tag const AffectedSOPClassUID(0x0000, 0x0002);
Tag const RequestedSOPClassUID(0x0000, 0x0003);
Tag const CommandField(0x0000, 0x0100);
Tag const MessageID(0x0000, 0x0110);
Tag const MessageIDBeingRespondedTo(0x0000, 0x0120);
Tag const MoveDestination(0x0000, 0x0600);
Tag const Priority(0x0000, 0x0700);
Tag const CommandDataSetType(0x0000, 0x0800);
Tag const Status(0x0000, 0x0900);
Tag const OffendingElement(0x0000, 0x0901);
Tag const ErrorComment(0x0000, 0x0902);
Tag const ErrorID(0x0000, 0x0903);
Tag const AffectedSOPInstanceUID(0x0000, 0x1000);
Tag const RequestedSOPInstanceUID(0x0000, 0x1001);
Tag const EventTypeID(0x0000, 0x1002);
Tag const AttributeIdentifierList(0x0000, 0x1005);
Tag const ActionTypeID(0x0000, 0x1008);
Tag const NumberOfRemainingSuboperations(0x0000, 0x1020);
Tag const NumberOfCompletedSuboperations(0x0000, 0x1021);
Tag const NumberOfFailedSuboperations(0x0000, 0x1022);
Tag const NumberOfWarningSuboperations(0x0000, 0x1023);
Tag const MoveOriginatorApplicationEntityTitle(0x0000, 0x1030);
Tag const MoveOriginatorMessageID(0x0000, 0x1031);
Tag const FileMetaInformationGroupLength(0x0002, 0x0000);
Tag const FileMetaInformationVersion(0x0002, 0x0001);
Tag const MediaStorageSOPClassUID(0x0002, 0x0002);
Tag const MediaStorageSOPInstanceUID(0x0002, 0x0003);
Tag const TransferSyntaxUID(0x0002, 0x0010);
Tag const ImplementationClassUID(0x0002, 0x0012);
Tag const ImplementationVersionName(0x0002, 0x0013);
Tag const SourceApplicationEntityTitle(0x0002, 0x0016);
Tag const SendingApplicationEntityTitle(0x0002, 0x0017);
Tag const ReceivingApplicationEntityTitle(0x0002, 0x0018);
Tag const PrivateInformationCreatorUID(0x0002, 0x0100);
Tag const PrivateInformation(0x0002, 0x0102);
Tag const FileSetID(0x0004, 0x1130);
Tag const FileSetDescriptorFileID(0x0004, 0x1141);
Tag const SpecificCharacterSetOfFileSetDescriptorFile(0x0004, 0x1142);
Tag const OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity(0x0004, 0x1200);
Tag const OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity(0x0004, 0x1202);
Tag const FileSetConsistencyFlag(0x0004, 0x1212);
Tag const DirectoryRecordSequence(0x0004, 0x1220);
Tag const OffsetOfTheNextDirectoryRecord(0x0004, 0x1400);
Tag const RecordInUseFlag(0x0004, 0x1410);
Tag const OffsetOfReferencedLowerLevelDirectoryEntity(0x0004, 0x1420);
Tag const DirectoryRecordType(0x0004, 0x1430);
Tag const PrivateRecordUID(0x0004, 0x1432);
Tag const ReferencedFileID(0x0004, 0x1500);
Tag const MRDRDirectoryRecordOffset(0x0004, 0x1504);
Tag const ReferencedSOPClassUIDInFile(0x0004, 0x1510);
Tag const ReferencedSOPInstanceUIDInFile(0x0004, 0x1511);
Tag const ReferencedTransferSyntaxUIDInFile(0x0004, 0x1512);
Tag const ReferencedRelatedGeneralSOPClassUIDInFile(0x0004, 0x151a);
Tag const NumberOfReferences(0x0004, 0x1600);
Tag const LengthToEnd(0x0008, 0x0001);
Tag const SpecificCharacterSet(0x0008, 0x0005);
Tag const LanguageCodeSequence(0x0008, 0x0006);
Tag const ImageType(0x0008, 0x0008);
Tag const RecognitionCode(0x0008, 0x0010);
Tag const InstanceCreationDate(0x0008, 0x0012);
Tag const InstanceCreationTime(0x0008, 0x0013);
Tag const InstanceCreatorUID(0x0008, 0x0014);
Tag const InstanceCoercionDateTime(0x0008, 0x0015);
Tag const SOPClassUID(0x0008, 0x0016);
Tag const SOPInstanceUID(0x0008, 0x0018);
Tag const RelatedGeneralSOPClassUID(0x0008, 0x001a);
Tag const OriginalSpecializedSOPClassUID(0x0008, 0x001b);
Tag const StudyDate(0x0008, 0x0020);
Tag const SeriesDate(0x0008, 0x0021);
Tag const AcquisitionDate(0x0008, 0x0022);
Tag const ContentDate(0x0008, 0x0023);
Tag const OverlayDate(0x0008, 0x0024);
Tag const CurveDate(0x0008, 0x0025);
Tag const AcquisitionDateTime(0x0008, 0x002a);
Tag const StudyTime(0x0008, 0x0030);
Tag const SeriesTime(0x0008, 0x0031);
Tag const AcquisitionTime(0x0008, 0x0032);
Tag const ContentTime(0x0008, 0x0033);
Tag const OverlayTime(0x0008, 0x0034);
Tag const CurveTime(0x0008, 0x0035);
Tag const DataSetType(0x0008, 0x0040);
Tag const DataSetSubtype(0x0008, 0x0041);
Tag const NuclearMedicineSeriesType(0x0008, 0x0042);
Tag const AccessionNumber(0x0008, 0x0050);
Tag const IssuerOfAccessionNumberSequence(0x0008, 0x0051);
Tag const QueryRetrieveLevel(0x0008, 0x0052);
Tag const QueryRetrieveView(0x0008, 0x0053);
Tag const RetrieveAETitle(0x0008, 0x0054);
Tag const InstanceAvailability(0x0008, 0x0056);
Tag const FailedSOPInstanceUIDList(0x0008, 0x0058);
Tag const Modality(0x0008, 0x0060);
Tag const ModalitiesInStudy(0x0008, 0x0061);
Tag const SOPClassesInStudy(0x0008, 0x0062);
Tag const ConversionType(0x0008, 0x0064);
Tag const PresentationIntentType(0x0008, 0x0068);
Tag const Manufacturer(0x0008, 0x0070);
Tag const InstitutionName(0x0008, 0x0080);
Tag const InstitutionAddress(0x0008, 0x0081);
Tag const InstitutionCodeSequence(0x0008, 0x0082);
Tag const ReferringPhysicianName(0x0008, 0x0090);
Tag const ReferringPhysicianAddress(0x0008, 0x0092);
Tag const ReferringPhysicianTelephoneNumbers(0x0008, 0x0094);
Tag const ReferringPhysicianIdentificationSequence(0x0008, 0x0096);
Tag const ConsultingPhysicianName(0x0008, 0x009c);
Tag const ConsultingPhysicianIdentificationSequence(0x0008, 0x009d);
Tag const CodeValue(0x0008, 0x0100);
Tag const ExtendedCodeValue(0x0008, 0x0101);
Tag const CodingSchemeDesignator(0x0008, 0x0102);
Tag const CodingSchemeVersion(0x0008, 0x0103);
Tag const CodeMeaning(0x0008, 0x0104);
Tag const MappingResource(0x0008, 0x0105);
Tag const ContextGroupVersion(0x0008, 0x0106);
Tag const ContextGroupLocalVersion(0x0008, 0x0107);
Tag const ExtendedCodeMeaning(0x0008, 0x0108);
Tag const ContextGroupExtensionFlag(0x0008, 0x010b);
Tag const CodingSchemeUID(0x0008, 0x010c);
Tag const ContextGroupExtensionCreatorUID(0x0008, 0x010d);
Tag const ContextIdentifier(0x0008, 0x010f);
Tag const CodingSchemeIdentificationSequence(0x0008, 0x0110);
Tag const CodingSchemeRegistry(0x0008, 0x0112);
Tag const CodingSchemeExternalID(0x0008, 0x0114);
Tag const CodingSchemeName(0x0008, 0x0115);
Tag const CodingSchemeResponsibleOrganization(0x0008, 0x0116);
Tag const ContextUID(0x0008, 0x0117);
Tag const MappingResourceUID(0x0008, 0x0118);
Tag const LongCodeValue(0x0008, 0x0119);
Tag const URNCodeValue(0x0008, 0x0120);
Tag const EquivalentCodeSequence(0x0008, 0x0121);
Tag const TimezoneOffsetFromUTC(0x0008, 0x0201);
Tag const PrivateDataElementCharacteristicsSequence(0x0008, 0x0300);
Tag const PrivateGroupReference(0x0008, 0x0301);
Tag const PrivateCreatorReference(0x0008, 0x0302);
Tag const BlockIdentifyingInformationStatus(0x0008, 0x0303);
Tag const NonidentifyingPrivateElements(0x0008, 0x0304);
Tag const IdentifyingPrivateElements(0x0008, 0x0306);
Tag const DeidentificationActionSequence(0x0008, 0x0305);
Tag const DeidentificationAction(0x0008, 0x0307);
Tag const NetworkID(0x0008, 0x1000);
Tag const StationName(0x0008, 0x1010);
Tag const StudyDescription(0x0008, 0x1030);
Tag const ProcedureCodeSequence(0x0008, 0x1032);
Tag const SeriesDescription(0x0008, 0x103e);
Tag const SeriesDescriptionCodeSequence(0x0008, 0x103f);
Tag const InstitutionalDepartmentName(0x0008, 0x1040);
Tag const PhysiciansOfRecord(0x0008, 0x1048);
Tag const PhysiciansOfRecordIdentificationSequence(0x0008, 0x1049);
Tag const PerformingPhysicianName(0x0008, 0x1050);
Tag const PerformingPhysicianIdentificationSequence(0x0008, 0x1052);
Tag const NameOfPhysiciansReadingStudy(0x0008, 0x1060);
Tag const PhysiciansReadingStudyIdentificationSequence(0x0008, 0x1062);
Tag const OperatorsName(0x0008, 0x1070);
Tag const OperatorIdentificationSequence(0x0008, 0x1072);
Tag const AdmittingDiagnosesDescription(0x0008, 0x1080);
Tag const AdmittingDiagnosesCodeSequence(0x0008, 0x1084);
Tag const ManufacturerModelName(0x0008, 0x1090);
Tag const ReferencedResultsSequence(0x0008, 0x1100);
Tag const ReferencedStudySequence(0x0008, 0x1110);
Tag const ReferencedPerformedProcedureStepSequence(0x0008, 0x1111);
Tag const ReferencedSeriesSequence(0x0008, 0x1115);
Tag const ReferencedPatientSequence(0x0008, 0x1120);
Tag const ReferencedVisitSequence(0x0008, 0x1125);
Tag const ReferencedOverlaySequence(0x0008, 0x1130);
Tag const ReferencedStereometricInstanceSequence(0x0008, 0x1134);
Tag const ReferencedWaveformSequence(0x0008, 0x113a);
Tag const ReferencedImageSequence(0x0008, 0x1140);
Tag const ReferencedCurveSequence(0x0008, 0x1145);
Tag const ReferencedInstanceSequence(0x0008, 0x114a);
Tag const ReferencedRealWorldValueMappingInstanceSequence(0x0008, 0x114b);
Tag const ReferencedSOPClassUID(0x0008, 0x1150);
Tag const ReferencedSOPInstanceUID(0x0008, 0x1155);
Tag const SOPClassesSupported(0x0008, 0x115a);
Tag const ReferencedFrameNumber(0x0008, 0x1160);
Tag const SimpleFrameList(0x0008, 0x1161);
Tag const CalculatedFrameList(0x0008, 0x1162);
Tag const TimeRange(0x0008, 0x1163);
Tag const FrameExtractionSequence(0x0008, 0x1164);
Tag const MultiFrameSourceSOPInstanceUID(0x0008, 0x1167);
Tag const RetrieveURL(0x0008, 0x1190);
Tag const TransactionUID(0x0008, 0x1195);
Tag const WarningReason(0x0008, 0x1196);
Tag const FailureReason(0x0008, 0x1197);
Tag const FailedSOPSequence(0x0008, 0x1198);
Tag const ReferencedSOPSequence(0x0008, 0x1199);
Tag const StudiesContainingOtherReferencedInstancesSequence(0x0008, 0x1200);
Tag const RelatedSeriesSequence(0x0008, 0x1250);
Tag const LossyImageCompressionRetired(0x0008, 0x2110);
Tag const DerivationDescription(0x0008, 0x2111);
Tag const SourceImageSequence(0x0008, 0x2112);
Tag const StageName(0x0008, 0x2120);
Tag const StageNumber(0x0008, 0x2122);
Tag const NumberOfStages(0x0008, 0x2124);
Tag const ViewName(0x0008, 0x2127);
Tag const ViewNumber(0x0008, 0x2128);
Tag const NumberOfEventTimers(0x0008, 0x2129);
Tag const NumberOfViewsInStage(0x0008, 0x212a);
Tag const EventElapsedTimes(0x0008, 0x2130);
Tag const EventTimerNames(0x0008, 0x2132);
Tag const EventTimerSequence(0x0008, 0x2133);
Tag const EventTimeOffset(0x0008, 0x2134);
Tag const EventCodeSequence(0x0008, 0x2135);
Tag const StartTrim(0x0008, 0x2142);
Tag const StopTrim(0x0008, 0x2143);
Tag const RecommendedDisplayFrameRate(0x0008, 0x2144);
Tag const TransducerPosition(0x0008, 0x2200);
Tag const TransducerOrientation(0x0008, 0x2204);
Tag const AnatomicStructure(0x0008, 0x2208);
Tag const AnatomicRegionSequence(0x0008, 0x2218);
Tag const AnatomicRegionModifierSequence(0x0008, 0x2220);
Tag const PrimaryAnatomicStructureSequence(0x0008, 0x2228);
Tag const AnatomicStructureSpaceOrRegionSequence(0x0008, 0x2229);
Tag const PrimaryAnatomicStructureModifierSequence(0x0008, 0x2230);
Tag const TransducerPositionSequence(0x0008, 0x2240);
Tag const TransducerPositionModifierSequence(0x0008, 0x2242);
Tag const TransducerOrientationSequence(0x0008, 0x2244);
Tag const TransducerOrientationModifierSequence(0x0008, 0x2246);
Tag const AnatomicStructureSpaceOrRegionCodeSequenceTrial(0x0008, 0x2251);
Tag const AnatomicPortalOfEntranceCodeSequenceTrial(0x0008, 0x2253);
Tag const AnatomicApproachDirectionCodeSequenceTrial(0x0008, 0x2255);
Tag const AnatomicPerspectiveDescriptionTrial(0x0008, 0x2256);
Tag const AnatomicPerspectiveCodeSequenceTrial(0x0008, 0x2257);
Tag const AnatomicLocationOfExaminingInstrumentDescriptionTrial(0x0008, 0x2258);
Tag const AnatomicLocationOfExaminingInstrumentCodeSequenceTrial(0x0008, 0x2259);
Tag const AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial(0x0008, 0x225a);
Tag const OnAxisBackgroundAnatomicStructureCodeSequenceTrial(0x0008, 0x225c);
Tag const AlternateRepresentationSequence(0x0008, 0x3001);
Tag const IrradiationEventUID(0x0008, 0x3010);
Tag const SourceIrradiationEventSequence(0x0008, 0x3011);
Tag const RadiopharmaceuticalAdministrationEventUID(0x0008, 0x3012);
Tag const IdentifyingComments(0x0008, 0x4000);
Tag const FrameType(0x0008, 0x9007);
Tag const ReferencedImageEvidenceSequence(0x0008, 0x9092);
Tag const ReferencedRawDataSequence(0x0008, 0x9121);
Tag const CreatorVersionUID(0x0008, 0x9123);
Tag const DerivationImageSequence(0x0008, 0x9124);
Tag const SourceImageEvidenceSequence(0x0008, 0x9154);
Tag const PixelPresentation(0x0008, 0x9205);
Tag const VolumetricProperties(0x0008, 0x9206);
Tag const VolumeBasedCalculationTechnique(0x0008, 0x9207);
Tag const ComplexImageComponent(0x0008, 0x9208);
Tag const AcquisitionContrast(0x0008, 0x9209);
Tag const DerivationCodeSequence(0x0008, 0x9215);
Tag const ReferencedPresentationStateSequence(0x0008, 0x9237);
Tag const ReferencedOtherPlaneSequence(0x0008, 0x9410);
Tag const FrameDisplaySequence(0x0008, 0x9458);
Tag const RecommendedDisplayFrameRateInFloat(0x0008, 0x9459);
Tag const SkipFrameRangeFlag(0x0008, 0x9460);
Tag const PatientName(0x0010, 0x0010);
Tag const PatientID(0x0010, 0x0020);
Tag const IssuerOfPatientID(0x0010, 0x0021);
Tag const TypeOfPatientID(0x0010, 0x0022);
Tag const IssuerOfPatientIDQualifiersSequence(0x0010, 0x0024);
Tag const PatientBirthDate(0x0010, 0x0030);
Tag const PatientBirthTime(0x0010, 0x0032);
Tag const PatientSex(0x0010, 0x0040);
Tag const PatientInsurancePlanCodeSequence(0x0010, 0x0050);
Tag const PatientPrimaryLanguageCodeSequence(0x0010, 0x0101);
Tag const PatientPrimaryLanguageModifierCodeSequence(0x0010, 0x0102);
Tag const QualityControlSubject(0x0010, 0x0200);
Tag const QualityControlSubjectTypeCodeSequence(0x0010, 0x0201);
Tag const OtherPatientIDs(0x0010, 0x1000);
Tag const OtherPatientNames(0x0010, 0x1001);
Tag const OtherPatientIDsSequence(0x0010, 0x1002);
Tag const PatientBirthName(0x0010, 0x1005);
Tag const PatientAge(0x0010, 0x1010);
Tag const PatientSize(0x0010, 0x1020);
Tag const PatientSizeCodeSequence(0x0010, 0x1021);
Tag const PatientWeight(0x0010, 0x1030);
Tag const PatientAddress(0x0010, 0x1040);
Tag const InsurancePlanIdentification(0x0010, 0x1050);
Tag const PatientMotherBirthName(0x0010, 0x1060);
Tag const MilitaryRank(0x0010, 0x1080);
Tag const BranchOfService(0x0010, 0x1081);
Tag const MedicalRecordLocator(0x0010, 0x1090);
Tag const ReferencedPatientPhotoSequence(0x0010, 0x1100);
Tag const MedicalAlerts(0x0010, 0x2000);
Tag const Allergies(0x0010, 0x2110);
Tag const CountryOfResidence(0x0010, 0x2150);
Tag const RegionOfResidence(0x0010, 0x2152);
Tag const PatientTelephoneNumbers(0x0010, 0x2154);
Tag const PatientTelecomInformation(0x0010, 0x2155);
Tag const EthnicGroup(0x0010, 0x2160);
Tag const Occupation(0x0010, 0x2180);
Tag const SmokingStatus(0x0010, 0x21a0);
Tag const AdditionalPatientHistory(0x0010, 0x21b0);
Tag const PregnancyStatus(0x0010, 0x21c0);
Tag const LastMenstrualDate(0x0010, 0x21d0);
Tag const PatientReligiousPreference(0x0010, 0x21f0);
Tag const PatientSpeciesDescription(0x0010, 0x2201);
Tag const PatientSpeciesCodeSequence(0x0010, 0x2202);
Tag const PatientSexNeutered(0x0010, 0x2203);
Tag const AnatomicalOrientationType(0x0010, 0x2210);
Tag const PatientBreedDescription(0x0010, 0x2292);
Tag const PatientBreedCodeSequence(0x0010, 0x2293);
Tag const BreedRegistrationSequence(0x0010, 0x2294);
Tag const BreedRegistrationNumber(0x0010, 0x2295);
Tag const BreedRegistryCodeSequence(0x0010, 0x2296);
Tag const ResponsiblePerson(0x0010, 0x2297);
Tag const ResponsiblePersonRole(0x0010, 0x2298);
Tag const ResponsibleOrganization(0x0010, 0x2299);
Tag const PatientComments(0x0010, 0x4000);
Tag const ExaminedBodyThickness(0x0010, 0x9431);
Tag const ClinicalTrialSponsorName(0x0012, 0x0010);
Tag const ClinicalTrialProtocolID(0x0012, 0x0020);
Tag const ClinicalTrialProtocolName(0x0012, 0x0021);
Tag const ClinicalTrialSiteID(0x0012, 0x0030);
Tag const ClinicalTrialSiteName(0x0012, 0x0031);
Tag const ClinicalTrialSubjectID(0x0012, 0x0040);
Tag const ClinicalTrialSubjectReadingID(0x0012, 0x0042);
Tag const ClinicalTrialTimePointID(0x0012, 0x0050);
Tag const ClinicalTrialTimePointDescription(0x0012, 0x0051);
Tag const ClinicalTrialCoordinatingCenterName(0x0012, 0x0060);
Tag const PatientIdentityRemoved(0x0012, 0x0062);
Tag const DeidentificationMethod(0x0012, 0x0063);
Tag const DeidentificationMethodCodeSequence(0x0012, 0x0064);
Tag const ClinicalTrialSeriesID(0x0012, 0x0071);
Tag const ClinicalTrialSeriesDescription(0x0012, 0x0072);
Tag const ClinicalTrialProtocolEthicsCommitteeName(0x0012, 0x0081);
Tag const ClinicalTrialProtocolEthicsCommitteeApprovalNumber(0x0012, 0x0082);
Tag const ConsentForClinicalTrialUseSequence(0x0012, 0x0083);
Tag const DistributionType(0x0012, 0x0084);
Tag const ConsentForDistributionFlag(0x0012, 0x0085);
Tag const CADFileFormat(0x0014, 0x0023);
Tag const ComponentReferenceSystem(0x0014, 0x0024);
Tag const ComponentManufacturingProcedure(0x0014, 0x0025);
Tag const ComponentManufacturer(0x0014, 0x0028);
Tag const MaterialThickness(0x0014, 0x0030);
Tag const MaterialPipeDiameter(0x0014, 0x0032);
Tag const MaterialIsolationDiameter(0x0014, 0x0034);
Tag const MaterialGrade(0x0014, 0x0042);
Tag const MaterialPropertiesDescription(0x0014, 0x0044);
Tag const MaterialPropertiesFileFormatRetired(0x0014, 0x0045);
Tag const MaterialNotes(0x0014, 0x0046);
Tag const ComponentShape(0x0014, 0x0050);
Tag const CurvatureType(0x0014, 0x0052);
Tag const OuterDiameter(0x0014, 0x0054);
Tag const InnerDiameter(0x0014, 0x0056);
Tag const ActualEnvironmentalConditions(0x0014, 0x1010);
Tag const ExpiryDate(0x0014, 0x1020);
Tag const EnvironmentalConditions(0x0014, 0x1040);
Tag const EvaluatorSequence(0x0014, 0x2002);
Tag const EvaluatorNumber(0x0014, 0x2004);
Tag const EvaluatorName(0x0014, 0x2006);
Tag const EvaluationAttempt(0x0014, 0x2008);
Tag const IndicationSequence(0x0014, 0x2012);
Tag const IndicationNumber(0x0014, 0x2014);
Tag const IndicationLabel(0x0014, 0x2016);
Tag const IndicationDescription(0x0014, 0x2018);
Tag const IndicationType(0x0014, 0x201a);
Tag const IndicationDisposition(0x0014, 0x201c);
Tag const IndicationROISequence(0x0014, 0x201e);
Tag const IndicationPhysicalPropertySequence(0x0014, 0x2030);
Tag const PropertyLabel(0x0014, 0x2032);
Tag const CoordinateSystemNumberOfAxes(0x0014, 0x2202);
Tag const CoordinateSystemAxesSequence(0x0014, 0x2204);
Tag const CoordinateSystemAxisDescription(0x0014, 0x2206);
Tag const CoordinateSystemDataSetMapping(0x0014, 0x2208);
Tag const CoordinateSystemAxisNumber(0x0014, 0x220a);
Tag const CoordinateSystemAxisType(0x0014, 0x220c);
Tag const CoordinateSystemAxisUnits(0x0014, 0x220e);
Tag const CoordinateSystemAxisValues(0x0014, 0x2210);
Tag const CoordinateSystemTransformSequence(0x0014, 0x2220);
Tag const TransformDescription(0x0014, 0x2222);
Tag const TransformNumberOfAxes(0x0014, 0x2224);
Tag const TransformOrderOfAxes(0x0014, 0x2226);
Tag const TransformedAxisUnits(0x0014, 0x2228);
Tag const CoordinateSystemTransformRotationAndScaleMatrix(0x0014, 0x222a);
Tag const CoordinateSystemTransformTranslationMatrix(0x0014, 0x222c);
Tag const InternalDetectorFrameTime(0x0014, 0x3011);
Tag const NumberOfFramesIntegrated(0x0014, 0x3012);
Tag const DetectorTemperatureSequence(0x0014, 0x3020);
Tag const SensorName(0x0014, 0x3022);
Tag const HorizontalOffsetOfSensor(0x0014, 0x3024);
Tag const VerticalOffsetOfSensor(0x0014, 0x3026);
Tag const SensorTemperature(0x0014, 0x3028);
Tag const DarkCurrentSequence(0x0014, 0x3040);
Tag const DarkCurrentCounts(0x0014, 0x3050);
Tag const GainCorrectionReferenceSequence(0x0014, 0x3060);
Tag const AirCounts(0x0014, 0x3070);
Tag const KVUsedInGainCalibration(0x0014, 0x3071);
Tag const MAUsedInGainCalibration(0x0014, 0x3072);
Tag const NumberOfFramesUsedForIntegration(0x0014, 0x3073);
Tag const FilterMaterialUsedInGainCalibration(0x0014, 0x3074);
Tag const FilterThicknessUsedInGainCalibration(0x0014, 0x3075);
Tag const DateOfGainCalibration(0x0014, 0x3076);
Tag const TimeOfGainCalibration(0x0014, 0x3077);
Tag const BadPixelImage(0x0014, 0x3080);
Tag const CalibrationNotes(0x0014, 0x3099);
Tag const PulserEquipmentSequence(0x0014, 0x4002);
Tag const PulserType(0x0014, 0x4004);
Tag const PulserNotes(0x0014, 0x4006);
Tag const ReceiverEquipmentSequence(0x0014, 0x4008);
Tag const AmplifierType(0x0014, 0x400a);
Tag const ReceiverNotes(0x0014, 0x400c);
Tag const PreAmplifierEquipmentSequence(0x0014, 0x400e);
Tag const PreAmplifierNotes(0x0014, 0x400f);
Tag const TransmitTransducerSequence(0x0014, 0x4010);
Tag const ReceiveTransducerSequence(0x0014, 0x4011);
Tag const NumberOfElements(0x0014, 0x4012);
Tag const ElementShape(0x0014, 0x4013);
Tag const ElementDimensionA(0x0014, 0x4014);
Tag const ElementDimensionB(0x0014, 0x4015);
Tag const ElementPitchA(0x0014, 0x4016);
Tag const MeasuredBeamDimensionA(0x0014, 0x4017);
Tag const MeasuredBeamDimensionB(0x0014, 0x4018);
Tag const LocationOfMeasuredBeamDiameter(0x0014, 0x4019);
Tag const NominalFrequency(0x0014, 0x401a);
Tag const MeasuredCenterFrequency(0x0014, 0x401b);
Tag const MeasuredBandwidth(0x0014, 0x401c);
Tag const ElementPitchB(0x0014, 0x401d);
Tag const PulserSettingsSequence(0x0014, 0x4020);
Tag const PulseWidth(0x0014, 0x4022);
Tag const ExcitationFrequency(0x0014, 0x4024);
Tag const ModulationType(0x0014, 0x4026);
Tag const Damping(0x0014, 0x4028);
Tag const ReceiverSettingsSequence(0x0014, 0x4030);
Tag const AcquiredSoundpathLength(0x0014, 0x4031);
Tag const AcquisitionCompressionType(0x0014, 0x4032);
Tag const AcquisitionSampleSize(0x0014, 0x4033);
Tag const RectifierSmoothing(0x0014, 0x4034);
Tag const DACSequence(0x0014, 0x4035);
Tag const DACType(0x0014, 0x4036);
Tag const DACGainPoints(0x0014, 0x4038);
Tag const DACTimePoints(0x0014, 0x403a);
Tag const DACAmplitude(0x0014, 0x403c);
Tag const PreAmplifierSettingsSequence(0x0014, 0x4040);
Tag const TransmitTransducerSettingsSequence(0x0014, 0x4050);
Tag const ReceiveTransducerSettingsSequence(0x0014, 0x4051);
Tag const IncidentAngle(0x0014, 0x4052);
Tag const CouplingTechnique(0x0014, 0x4054);
Tag const CouplingMedium(0x0014, 0x4056);
Tag const CouplingVelocity(0x0014, 0x4057);
Tag const ProbeCenterLocationX(0x0014, 0x4058);
Tag const ProbeCenterLocationZ(0x0014, 0x4059);
Tag const SoundPathLength(0x0014, 0x405a);
Tag const DelayLawIdentifier(0x0014, 0x405c);
Tag const GateSettingsSequence(0x0014, 0x4060);
Tag const GateThreshold(0x0014, 0x4062);
Tag const VelocityOfSound(0x0014, 0x4064);
Tag const CalibrationSettingsSequence(0x0014, 0x4070);
Tag const CalibrationProcedure(0x0014, 0x4072);
Tag const ProcedureVersion(0x0014, 0x4074);
Tag const ProcedureCreationDate(0x0014, 0x4076);
Tag const ProcedureExpirationDate(0x0014, 0x4078);
Tag const ProcedureLastModifiedDate(0x0014, 0x407a);
Tag const CalibrationTime(0x0014, 0x407c);
Tag const CalibrationDate(0x0014, 0x407e);
Tag const ProbeDriveEquipmentSequence(0x0014, 0x4080);
Tag const DriveType(0x0014, 0x4081);
Tag const ProbeDriveNotes(0x0014, 0x4082);
Tag const DriveProbeSequence(0x0014, 0x4083);
Tag const ProbeInductance(0x0014, 0x4084);
Tag const ProbeResistance(0x0014, 0x4085);
Tag const ReceiveProbeSequence(0x0014, 0x4086);
Tag const ProbeDriveSettingsSequence(0x0014, 0x4087);
Tag const BridgeResistors(0x0014, 0x4088);
Tag const ProbeOrientationAngle(0x0014, 0x4089);
Tag const UserSelectedGainY(0x0014, 0x408b);
Tag const UserSelectedPhase(0x0014, 0x408c);
Tag const UserSelectedOffsetX(0x0014, 0x408d);
Tag const UserSelectedOffsetY(0x0014, 0x408e);
Tag const ChannelSettingsSequence(0x0014, 0x4091);
Tag const ChannelThreshold(0x0014, 0x4092);
Tag const ScannerSettingsSequence(0x0014, 0x409a);
Tag const ScanProcedure(0x0014, 0x409b);
Tag const TranslationRateX(0x0014, 0x409c);
Tag const TranslationRateY(0x0014, 0x409d);
Tag const ChannelOverlap(0x0014, 0x409f);
Tag const ImageQualityIndicatorType(0x0014, 0x40a0);
Tag const ImageQualityIndicatorMaterial(0x0014, 0x40a1);
Tag const ImageQualityIndicatorSize(0x0014, 0x40a2);
Tag const LINACEnergy(0x0014, 0x5002);
Tag const LINACOutput(0x0014, 0x5004);
Tag const ActiveAperture(0x0014, 0x5100);
Tag const TotalAperture(0x0014, 0x5101);
Tag const ApertureElevation(0x0014, 0x5102);
Tag const MainLobeAngle(0x0014, 0x5103);
Tag const MainRoofAngle(0x0014, 0x5104);
Tag const ConnectorType(0x0014, 0x5105);
Tag const WedgeModelNumber(0x0014, 0x5106);
Tag const WedgeAngleFloat(0x0014, 0x5107);
Tag const WedgeRoofAngle(0x0014, 0x5108);
Tag const WedgeElement1Position(0x0014, 0x5109);
Tag const WedgeMaterialVelocity(0x0014, 0x510a);
Tag const WedgeMaterial(0x0014, 0x510b);
Tag const WedgeOffsetZ(0x0014, 0x510c);
Tag const WedgeOriginOffsetX(0x0014, 0x510d);
Tag const WedgeTimeDelay(0x0014, 0x510e);
Tag const WedgeName(0x0014, 0x510f);
Tag const WedgeManufacturerName(0x0014, 0x5110);
Tag const WedgeDescription(0x0014, 0x5111);
Tag const NominalBeamAngle(0x0014, 0x5112);
Tag const WedgeOffsetX(0x0014, 0x5113);
Tag const WedgeOffsetY(0x0014, 0x5114);
Tag const WedgeTotalLength(0x0014, 0x5115);
Tag const WedgeInContactLength(0x0014, 0x5116);
Tag const WedgeFrontGap(0x0014, 0x5117);
Tag const WedgeTotalHeight(0x0014, 0x5118);
Tag const WedgeFrontHeight(0x0014, 0x5119);
Tag const WedgeRearHeight(0x0014, 0x511a);
Tag const WedgeTotalWidth(0x0014, 0x511b);
Tag const WedgeInContactWidth(0x0014, 0x511c);
Tag const WedgeChamferHeight(0x0014, 0x511d);
Tag const WedgeCurve(0x0014, 0x511e);
Tag const RadiusAlongWedge(0x0014, 0x511f);
Tag const ContrastBolusAgent(0x0018, 0x0010);
Tag const ContrastBolusAgentSequence(0x0018, 0x0012);
Tag const ContrastBolusT1Relaxivity(0x0018, 0x0013);
Tag const ContrastBolusAdministrationRouteSequence(0x0018, 0x0014);
Tag const BodyPartExamined(0x0018, 0x0015);
Tag const ScanningSequence(0x0018, 0x0020);
Tag const SequenceVariant(0x0018, 0x0021);
Tag const ScanOptions(0x0018, 0x0022);
Tag const MRAcquisitionType(0x0018, 0x0023);
Tag const SequenceName(0x0018, 0x0024);
Tag const AngioFlag(0x0018, 0x0025);
Tag const InterventionDrugInformationSequence(0x0018, 0x0026);
Tag const InterventionDrugStopTime(0x0018, 0x0027);
Tag const InterventionDrugDose(0x0018, 0x0028);
Tag const InterventionDrugCodeSequence(0x0018, 0x0029);
Tag const AdditionalDrugSequence(0x0018, 0x002a);
Tag const Radionuclide(0x0018, 0x0030);
Tag const Radiopharmaceutical(0x0018, 0x0031);
Tag const EnergyWindowCenterline(0x0018, 0x0032);
Tag const EnergyWindowTotalWidth(0x0018, 0x0033);
Tag const InterventionDrugName(0x0018, 0x0034);
Tag const InterventionDrugStartTime(0x0018, 0x0035);
Tag const InterventionSequence(0x0018, 0x0036);
Tag const TherapyType(0x0018, 0x0037);
Tag const InterventionStatus(0x0018, 0x0038);
Tag const TherapyDescription(0x0018, 0x0039);
Tag const InterventionDescription(0x0018, 0x003a);
Tag const CineRate(0x0018, 0x0040);
Tag const InitialCineRunState(0x0018, 0x0042);
Tag const SliceThickness(0x0018, 0x0050);
Tag const KVP(0x0018, 0x0060);
Tag const CountsAccumulated(0x0018, 0x0070);
Tag const AcquisitionTerminationCondition(0x0018, 0x0071);
Tag const EffectiveDuration(0x0018, 0x0072);
Tag const AcquisitionStartCondition(0x0018, 0x0073);
Tag const AcquisitionStartConditionData(0x0018, 0x0074);
Tag const AcquisitionTerminationConditionData(0x0018, 0x0075);
Tag const RepetitionTime(0x0018, 0x0080);
Tag const EchoTime(0x0018, 0x0081);
Tag const InversionTime(0x0018, 0x0082);
Tag const NumberOfAverages(0x0018, 0x0083);
Tag const ImagingFrequency(0x0018, 0x0084);
Tag const ImagedNucleus(0x0018, 0x0085);
Tag const EchoNumbers(0x0018, 0x0086);
Tag const MagneticFieldStrength(0x0018, 0x0087);
Tag const SpacingBetweenSlices(0x0018, 0x0088);
Tag const NumberOfPhaseEncodingSteps(0x0018, 0x0089);
Tag const DataCollectionDiameter(0x0018, 0x0090);
Tag const EchoTrainLength(0x0018, 0x0091);
Tag const PercentSampling(0x0018, 0x0093);
Tag const PercentPhaseFieldOfView(0x0018, 0x0094);
Tag const PixelBandwidth(0x0018, 0x0095);
Tag const DeviceSerialNumber(0x0018, 0x1000);
Tag const DeviceUID(0x0018, 0x1002);
Tag const DeviceID(0x0018, 0x1003);
Tag const PlateID(0x0018, 0x1004);
Tag const GeneratorID(0x0018, 0x1005);
Tag const GridID(0x0018, 0x1006);
Tag const CassetteID(0x0018, 0x1007);
Tag const GantryID(0x0018, 0x1008);
Tag const SecondaryCaptureDeviceID(0x0018, 0x1010);
Tag const HardcopyCreationDeviceID(0x0018, 0x1011);
Tag const DateOfSecondaryCapture(0x0018, 0x1012);
Tag const TimeOfSecondaryCapture(0x0018, 0x1014);
Tag const SecondaryCaptureDeviceManufacturer(0x0018, 0x1016);
Tag const HardcopyDeviceManufacturer(0x0018, 0x1017);
Tag const SecondaryCaptureDeviceManufacturerModelName(0x0018, 0x1018);
Tag const SecondaryCaptureDeviceSoftwareVersions(0x0018, 0x1019);
Tag const HardcopyDeviceSoftwareVersion(0x0018, 0x101a);
Tag const HardcopyDeviceManufacturerModelName(0x0018, 0x101b);
Tag const SoftwareVersions(0x0018, 0x1020);
Tag const VideoImageFormatAcquired(0x0018, 0x1022);
Tag const DigitalImageFormatAcquired(0x0018, 0x1023);
Tag const ProtocolName(0x0018, 0x1030);
Tag const ContrastBolusRoute(0x0018, 0x1040);
Tag const ContrastBolusVolume(0x0018, 0x1041);
Tag const ContrastBolusStartTime(0x0018, 0x1042);
Tag const ContrastBolusStopTime(0x0018, 0x1043);
Tag const ContrastBolusTotalDose(0x0018, 0x1044);
Tag const SyringeCounts(0x0018, 0x1045);
Tag const ContrastFlowRate(0x0018, 0x1046);
Tag const ContrastFlowDuration(0x0018, 0x1047);
Tag const ContrastBolusIngredient(0x0018, 0x1048);
Tag const ContrastBolusIngredientConcentration(0x0018, 0x1049);
Tag const SpatialResolution(0x0018, 0x1050);
Tag const TriggerTime(0x0018, 0x1060);
Tag const TriggerSourceOrType(0x0018, 0x1061);
Tag const NominalInterval(0x0018, 0x1062);
Tag const FrameTime(0x0018, 0x1063);
Tag const CardiacFramingType(0x0018, 0x1064);
Tag const FrameTimeVector(0x0018, 0x1065);
Tag const FrameDelay(0x0018, 0x1066);
Tag const ImageTriggerDelay(0x0018, 0x1067);
Tag const MultiplexGroupTimeOffset(0x0018, 0x1068);
Tag const TriggerTimeOffset(0x0018, 0x1069);
Tag const SynchronizationTrigger(0x0018, 0x106a);
Tag const SynchronizationChannel(0x0018, 0x106c);
Tag const TriggerSamplePosition(0x0018, 0x106e);
Tag const RadiopharmaceuticalRoute(0x0018, 0x1070);
Tag const RadiopharmaceuticalVolume(0x0018, 0x1071);
Tag const RadiopharmaceuticalStartTime(0x0018, 0x1072);
Tag const RadiopharmaceuticalStopTime(0x0018, 0x1073);
Tag const RadionuclideTotalDose(0x0018, 0x1074);
Tag const RadionuclideHalfLife(0x0018, 0x1075);
Tag const RadionuclidePositronFraction(0x0018, 0x1076);
Tag const RadiopharmaceuticalSpecificActivity(0x0018, 0x1077);
Tag const RadiopharmaceuticalStartDateTime(0x0018, 0x1078);
Tag const RadiopharmaceuticalStopDateTime(0x0018, 0x1079);
Tag const BeatRejectionFlag(0x0018, 0x1080);
Tag const LowRRValue(0x0018, 0x1081);
Tag const HighRRValue(0x0018, 0x1082);
Tag const IntervalsAcquired(0x0018, 0x1083);
Tag const IntervalsRejected(0x0018, 0x1084);
Tag const PVCRejection(0x0018, 0x1085);
Tag const SkipBeats(0x0018, 0x1086);
Tag const HeartRate(0x0018, 0x1088);
Tag const CardiacNumberOfImages(0x0018, 0x1090);
Tag const TriggerWindow(0x0018, 0x1094);
Tag const ReconstructionDiameter(0x0018, 0x1100);
Tag const DistanceSourceToDetector(0x0018, 0x1110);
Tag const DistanceSourceToPatient(0x0018, 0x1111);
Tag const EstimatedRadiographicMagnificationFactor(0x0018, 0x1114);
Tag const GantryDetectorTilt(0x0018, 0x1120);
Tag const GantryDetectorSlew(0x0018, 0x1121);
Tag const TableHeight(0x0018, 0x1130);
Tag const TableTraverse(0x0018, 0x1131);
Tag const TableMotion(0x0018, 0x1134);
Tag const TableVerticalIncrement(0x0018, 0x1135);
Tag const TableLateralIncrement(0x0018, 0x1136);
Tag const TableLongitudinalIncrement(0x0018, 0x1137);
Tag const TableAngle(0x0018, 0x1138);
Tag const TableType(0x0018, 0x113a);
Tag const RotationDirection(0x0018, 0x1140);
Tag const AngularPosition(0x0018, 0x1141);
Tag const RadialPosition(0x0018, 0x1142);
Tag const ScanArc(0x0018, 0x1143);
Tag const AngularStep(0x0018, 0x1144);
Tag const CenterOfRotationOffset(0x0018, 0x1145);
Tag const RotationOffset(0x0018, 0x1146);
Tag const FieldOfViewShape(0x0018, 0x1147);
Tag const FieldOfViewDimensions(0x0018, 0x1149);
Tag const ExposureTime(0x0018, 0x1150);
Tag const XRayTubeCurrent(0x0018, 0x1151);
Tag const Exposure(0x0018, 0x1152);
Tag const ExposureInuAs(0x0018, 0x1153);
Tag const AveragePulseWidth(0x0018, 0x1154);
Tag const RadiationSetting(0x0018, 0x1155);
Tag const RectificationType(0x0018, 0x1156);
Tag const RadiationMode(0x0018, 0x115a);
Tag const ImageAndFluoroscopyAreaDoseProduct(0x0018, 0x115e);
Tag const FilterType(0x0018, 0x1160);
Tag const TypeOfFilters(0x0018, 0x1161);
Tag const IntensifierSize(0x0018, 0x1162);
Tag const ImagerPixelSpacing(0x0018, 0x1164);
Tag const Grid(0x0018, 0x1166);
Tag const GeneratorPower(0x0018, 0x1170);
Tag const CollimatorGridName(0x0018, 0x1180);
Tag const CollimatorType(0x0018, 0x1181);
Tag const FocalDistance(0x0018, 0x1182);
Tag const XFocusCenter(0x0018, 0x1183);
Tag const YFocusCenter(0x0018, 0x1184);
Tag const FocalSpots(0x0018, 0x1190);
Tag const AnodeTargetMaterial(0x0018, 0x1191);
Tag const BodyPartThickness(0x0018, 0x11a0);
Tag const CompressionForce(0x0018, 0x11a2);
Tag const PaddleDescription(0x0018, 0x11a4);
Tag const DateOfLastCalibration(0x0018, 0x1200);
Tag const TimeOfLastCalibration(0x0018, 0x1201);
Tag const DateTimeOfLastCalibration(0x0018, 0x1202);
Tag const ConvolutionKernel(0x0018, 0x1210);
Tag const UpperLowerPixelValues(0x0018, 0x1240);
Tag const ActualFrameDuration(0x0018, 0x1242);
Tag const CountRate(0x0018, 0x1243);
Tag const PreferredPlaybackSequencing(0x0018, 0x1244);
Tag const ReceiveCoilName(0x0018, 0x1250);
Tag const TransmitCoilName(0x0018, 0x1251);
Tag const PlateType(0x0018, 0x1260);
Tag const PhosphorType(0x0018, 0x1261);
Tag const ScanVelocity(0x0018, 0x1300);
Tag const WholeBodyTechnique(0x0018, 0x1301);
Tag const ScanLength(0x0018, 0x1302);
Tag const AcquisitionMatrix(0x0018, 0x1310);
Tag const InPlanePhaseEncodingDirection(0x0018, 0x1312);
Tag const FlipAngle(0x0018, 0x1314);
Tag const VariableFlipAngleFlag(0x0018, 0x1315);
Tag const SAR(0x0018, 0x1316);
Tag const dBdt(0x0018, 0x1318);
Tag const AcquisitionDeviceProcessingDescription(0x0018, 0x1400);
Tag const AcquisitionDeviceProcessingCode(0x0018, 0x1401);
Tag const CassetteOrientation(0x0018, 0x1402);
Tag const CassetteSize(0x0018, 0x1403);
Tag const ExposuresOnPlate(0x0018, 0x1404);
Tag const RelativeXRayExposure(0x0018, 0x1405);
Tag const ExposureIndex(0x0018, 0x1411);
Tag const TargetExposureIndex(0x0018, 0x1412);
Tag const DeviationIndex(0x0018, 0x1413);
Tag const ColumnAngulation(0x0018, 0x1450);
Tag const TomoLayerHeight(0x0018, 0x1460);
Tag const TomoAngle(0x0018, 0x1470);
Tag const TomoTime(0x0018, 0x1480);
Tag const TomoType(0x0018, 0x1490);
Tag const TomoClass(0x0018, 0x1491);
Tag const NumberOfTomosynthesisSourceImages(0x0018, 0x1495);
Tag const PositionerMotion(0x0018, 0x1500);
Tag const PositionerType(0x0018, 0x1508);
Tag const PositionerPrimaryAngle(0x0018, 0x1510);
Tag const PositionerSecondaryAngle(0x0018, 0x1511);
Tag const PositionerPrimaryAngleIncrement(0x0018, 0x1520);
Tag const PositionerSecondaryAngleIncrement(0x0018, 0x1521);
Tag const DetectorPrimaryAngle(0x0018, 0x1530);
Tag const DetectorSecondaryAngle(0x0018, 0x1531);
Tag const ShutterShape(0x0018, 0x1600);
Tag const ShutterLeftVerticalEdge(0x0018, 0x1602);
Tag const ShutterRightVerticalEdge(0x0018, 0x1604);
Tag const ShutterUpperHorizontalEdge(0x0018, 0x1606);
Tag const ShutterLowerHorizontalEdge(0x0018, 0x1608);
Tag const CenterOfCircularShutter(0x0018, 0x1610);
Tag const RadiusOfCircularShutter(0x0018, 0x1612);
Tag const VerticesOfThePolygonalShutter(0x0018, 0x1620);
Tag const ShutterPresentationValue(0x0018, 0x1622);
Tag const ShutterOverlayGroup(0x0018, 0x1623);
Tag const ShutterPresentationColorCIELabValue(0x0018, 0x1624);
Tag const CollimatorShape(0x0018, 0x1700);
Tag const CollimatorLeftVerticalEdge(0x0018, 0x1702);
Tag const CollimatorRightVerticalEdge(0x0018, 0x1704);
Tag const CollimatorUpperHorizontalEdge(0x0018, 0x1706);
Tag const CollimatorLowerHorizontalEdge(0x0018, 0x1708);
Tag const CenterOfCircularCollimator(0x0018, 0x1710);
Tag const RadiusOfCircularCollimator(0x0018, 0x1712);
Tag const VerticesOfThePolygonalCollimator(0x0018, 0x1720);
Tag const AcquisitionTimeSynchronized(0x0018, 0x1800);
Tag const TimeSource(0x0018, 0x1801);
Tag const TimeDistributionProtocol(0x0018, 0x1802);
Tag const NTPSourceAddress(0x0018, 0x1803);
Tag const PageNumberVector(0x0018, 0x2001);
Tag const FrameLabelVector(0x0018, 0x2002);
Tag const FramePrimaryAngleVector(0x0018, 0x2003);
Tag const FrameSecondaryAngleVector(0x0018, 0x2004);
Tag const SliceLocationVector(0x0018, 0x2005);
Tag const DisplayWindowLabelVector(0x0018, 0x2006);
Tag const NominalScannedPixelSpacing(0x0018, 0x2010);
Tag const DigitizingDeviceTransportDirection(0x0018, 0x2020);
Tag const RotationOfScannedFilm(0x0018, 0x2030);
Tag const BiopsyTargetSequence(0x0018, 0x2041);
Tag const TargetUID(0x0018, 0x2042);
Tag const LocalizingCursorPosition(0x0018, 0x2043);
Tag const CalculatedTargetPosition(0x0018, 0x2044);
Tag const TargetLabel(0x0018, 0x2045);
Tag const DisplayedZValue(0x0018, 0x2046);
Tag const IVUSAcquisition(0x0018, 0x3100);
Tag const IVUSPullbackRate(0x0018, 0x3101);
Tag const IVUSGatedRate(0x0018, 0x3102);
Tag const IVUSPullbackStartFrameNumber(0x0018, 0x3103);
Tag const IVUSPullbackStopFrameNumber(0x0018, 0x3104);
Tag const LesionNumber(0x0018, 0x3105);
Tag const AcquisitionComments(0x0018, 0x4000);
Tag const OutputPower(0x0018, 0x5000);
Tag const TransducerData(0x0018, 0x5010);
Tag const FocusDepth(0x0018, 0x5012);
Tag const ProcessingFunction(0x0018, 0x5020);
Tag const PostprocessingFunction(0x0018, 0x5021);
Tag const MechanicalIndex(0x0018, 0x5022);
Tag const BoneThermalIndex(0x0018, 0x5024);
Tag const CranialThermalIndex(0x0018, 0x5026);
Tag const SoftTissueThermalIndex(0x0018, 0x5027);
Tag const SoftTissueFocusThermalIndex(0x0018, 0x5028);
Tag const SoftTissueSurfaceThermalIndex(0x0018, 0x5029);
Tag const DynamicRange(0x0018, 0x5030);
Tag const TotalGain(0x0018, 0x5040);
Tag const DepthOfScanField(0x0018, 0x5050);
Tag const PatientPosition(0x0018, 0x5100);
Tag const ViewPosition(0x0018, 0x5101);
Tag const ProjectionEponymousNameCodeSequence(0x0018, 0x5104);
Tag const ImageTransformationMatrix(0x0018, 0x5210);
Tag const ImageTranslationVector(0x0018, 0x5212);
Tag const Sensitivity(0x0018, 0x6000);
Tag const SequenceOfUltrasoundRegions(0x0018, 0x6011);
Tag const RegionSpatialFormat(0x0018, 0x6012);
Tag const RegionDataType(0x0018, 0x6014);
Tag const RegionFlags(0x0018, 0x6016);
Tag const RegionLocationMinX0(0x0018, 0x6018);
Tag const RegionLocationMinY0(0x0018, 0x601a);
Tag const RegionLocationMaxX1(0x0018, 0x601c);
Tag const RegionLocationMaxY1(0x0018, 0x601e);
Tag const ReferencePixelX0(0x0018, 0x6020);
Tag const ReferencePixelY0(0x0018, 0x6022);
Tag const PhysicalUnitsXDirection(0x0018, 0x6024);
Tag const PhysicalUnitsYDirection(0x0018, 0x6026);
Tag const ReferencePixelPhysicalValueX(0x0018, 0x6028);
Tag const ReferencePixelPhysicalValueY(0x0018, 0x602a);
Tag const PhysicalDeltaX(0x0018, 0x602c);
Tag const PhysicalDeltaY(0x0018, 0x602e);
Tag const TransducerFrequency(0x0018, 0x6030);
Tag const TransducerType(0x0018, 0x6031);
Tag const PulseRepetitionFrequency(0x0018, 0x6032);
Tag const DopplerCorrectionAngle(0x0018, 0x6034);
Tag const SteeringAngle(0x0018, 0x6036);
Tag const DopplerSampleVolumeXPositionRetired(0x0018, 0x6038);
Tag const DopplerSampleVolumeXPosition(0x0018, 0x6039);
Tag const DopplerSampleVolumeYPositionRetired(0x0018, 0x603a);
Tag const DopplerSampleVolumeYPosition(0x0018, 0x603b);
Tag const TMLinePositionX0Retired(0x0018, 0x603c);
Tag const TMLinePositionX0(0x0018, 0x603d);
Tag const TMLinePositionY0Retired(0x0018, 0x603e);
Tag const TMLinePositionY0(0x0018, 0x603f);
Tag const TMLinePositionX1Retired(0x0018, 0x6040);
Tag const TMLinePositionX1(0x0018, 0x6041);
Tag const TMLinePositionY1Retired(0x0018, 0x6042);
Tag const TMLinePositionY1(0x0018, 0x6043);
Tag const PixelComponentOrganization(0x0018, 0x6044);
Tag const PixelComponentMask(0x0018, 0x6046);
Tag const PixelComponentRangeStart(0x0018, 0x6048);
Tag const PixelComponentRangeStop(0x0018, 0x604a);
Tag const PixelComponentPhysicalUnits(0x0018, 0x604c);
Tag const PixelComponentDataType(0x0018, 0x604e);
Tag const NumberOfTableBreakPoints(0x0018, 0x6050);
Tag const TableOfXBreakPoints(0x0018, 0x6052);
Tag const TableOfYBreakPoints(0x0018, 0x6054);
Tag const NumberOfTableEntries(0x0018, 0x6056);
Tag const TableOfPixelValues(0x0018, 0x6058);
Tag const TableOfParameterValues(0x0018, 0x605a);
Tag const RWaveTimeVector(0x0018, 0x6060);
Tag const DetectorConditionsNominalFlag(0x0018, 0x7000);
Tag const DetectorTemperature(0x0018, 0x7001);
Tag const DetectorType(0x0018, 0x7004);
Tag const DetectorConfiguration(0x0018, 0x7005);
Tag const DetectorDescription(0x0018, 0x7006);
Tag const DetectorMode(0x0018, 0x7008);
Tag const DetectorID(0x0018, 0x700a);
Tag const DateOfLastDetectorCalibration(0x0018, 0x700c);
Tag const TimeOfLastDetectorCalibration(0x0018, 0x700e);
Tag const ExposuresOnDetectorSinceLastCalibration(0x0018, 0x7010);
Tag const ExposuresOnDetectorSinceManufactured(0x0018, 0x7011);
Tag const DetectorTimeSinceLastExposure(0x0018, 0x7012);
Tag const DetectorActiveTime(0x0018, 0x7014);
Tag const DetectorActivationOffsetFromExposure(0x0018, 0x7016);
Tag const DetectorBinning(0x0018, 0x701a);
Tag const DetectorElementPhysicalSize(0x0018, 0x7020);
Tag const DetectorElementSpacing(0x0018, 0x7022);
Tag const DetectorActiveShape(0x0018, 0x7024);
Tag const DetectorActiveDimensions(0x0018, 0x7026);
Tag const DetectorActiveOrigin(0x0018, 0x7028);
Tag const DetectorManufacturerName(0x0018, 0x702a);
Tag const DetectorManufacturerModelName(0x0018, 0x702b);
Tag const FieldOfViewOrigin(0x0018, 0x7030);
Tag const FieldOfViewRotation(0x0018, 0x7032);
Tag const FieldOfViewHorizontalFlip(0x0018, 0x7034);
Tag const PixelDataAreaOriginRelativeToFOV(0x0018, 0x7036);
Tag const PixelDataAreaRotationAngleRelativeToFOV(0x0018, 0x7038);
Tag const GridAbsorbingMaterial(0x0018, 0x7040);
Tag const GridSpacingMaterial(0x0018, 0x7041);
Tag const GridThickness(0x0018, 0x7042);
Tag const GridPitch(0x0018, 0x7044);
Tag const GridAspectRatio(0x0018, 0x7046);
Tag const GridPeriod(0x0018, 0x7048);
Tag const GridFocalDistance(0x0018, 0x704c);
Tag const FilterMaterial(0x0018, 0x7050);
Tag const FilterThicknessMinimum(0x0018, 0x7052);
Tag const FilterThicknessMaximum(0x0018, 0x7054);
Tag const FilterBeamPathLengthMinimum(0x0018, 0x7056);
Tag const FilterBeamPathLengthMaximum(0x0018, 0x7058);
Tag const ExposureControlMode(0x0018, 0x7060);
Tag const ExposureControlModeDescription(0x0018, 0x7062);
Tag const ExposureStatus(0x0018, 0x7064);
Tag const PhototimerSetting(0x0018, 0x7065);
Tag const ExposureTimeInuS(0x0018, 0x8150);
Tag const XRayTubeCurrentInuA(0x0018, 0x8151);
Tag const ContentQualification(0x0018, 0x9004);
Tag const PulseSequenceName(0x0018, 0x9005);
Tag const MRImagingModifierSequence(0x0018, 0x9006);
Tag const EchoPulseSequence(0x0018, 0x9008);
Tag const InversionRecovery(0x0018, 0x9009);
Tag const FlowCompensation(0x0018, 0x9010);
Tag const MultipleSpinEcho(0x0018, 0x9011);
Tag const MultiPlanarExcitation(0x0018, 0x9012);
Tag const PhaseContrast(0x0018, 0x9014);
Tag const TimeOfFlightContrast(0x0018, 0x9015);
Tag const Spoiling(0x0018, 0x9016);
Tag const SteadyStatePulseSequence(0x0018, 0x9017);
Tag const EchoPlanarPulseSequence(0x0018, 0x9018);
Tag const TagAngleFirstAxis(0x0018, 0x9019);
Tag const MagnetizationTransfer(0x0018, 0x9020);
Tag const T2Preparation(0x0018, 0x9021);
Tag const BloodSignalNulling(0x0018, 0x9022);
Tag const SaturationRecovery(0x0018, 0x9024);
Tag const SpectrallySelectedSuppression(0x0018, 0x9025);
Tag const SpectrallySelectedExcitation(0x0018, 0x9026);
Tag const SpatialPresaturation(0x0018, 0x9027);
Tag const Tagging(0x0018, 0x9028);
Tag const OversamplingPhase(0x0018, 0x9029);
Tag const TagSpacingFirstDimension(0x0018, 0x9030);
Tag const GeometryOfKSpaceTraversal(0x0018, 0x9032);
Tag const SegmentedKSpaceTraversal(0x0018, 0x9033);
Tag const RectilinearPhaseEncodeReordering(0x0018, 0x9034);
Tag const TagThickness(0x0018, 0x9035);
Tag const PartialFourierDirection(0x0018, 0x9036);
Tag const CardiacSynchronizationTechnique(0x0018, 0x9037);
Tag const ReceiveCoilManufacturerName(0x0018, 0x9041);
Tag const MRReceiveCoilSequence(0x0018, 0x9042);
Tag const ReceiveCoilType(0x0018, 0x9043);
Tag const QuadratureReceiveCoil(0x0018, 0x9044);
Tag const MultiCoilDefinitionSequence(0x0018, 0x9045);
Tag const MultiCoilConfiguration(0x0018, 0x9046);
Tag const MultiCoilElementName(0x0018, 0x9047);
Tag const MultiCoilElementUsed(0x0018, 0x9048);
Tag const MRTransmitCoilSequence(0x0018, 0x9049);
Tag const TransmitCoilManufacturerName(0x0018, 0x9050);
Tag const TransmitCoilType(0x0018, 0x9051);
Tag const SpectralWidth(0x0018, 0x9052);
Tag const ChemicalShiftReference(0x0018, 0x9053);
Tag const VolumeLocalizationTechnique(0x0018, 0x9054);
Tag const MRAcquisitionFrequencyEncodingSteps(0x0018, 0x9058);
Tag const Decoupling(0x0018, 0x9059);
Tag const DecoupledNucleus(0x0018, 0x9060);
Tag const DecouplingFrequency(0x0018, 0x9061);
Tag const DecouplingMethod(0x0018, 0x9062);
Tag const DecouplingChemicalShiftReference(0x0018, 0x9063);
Tag const KSpaceFiltering(0x0018, 0x9064);
Tag const TimeDomainFiltering(0x0018, 0x9065);
Tag const NumberOfZeroFills(0x0018, 0x9066);
Tag const BaselineCorrection(0x0018, 0x9067);
Tag const ParallelReductionFactorInPlane(0x0018, 0x9069);
Tag const CardiacRRIntervalSpecified(0x0018, 0x9070);
Tag const AcquisitionDuration(0x0018, 0x9073);
Tag const FrameAcquisitionDateTime(0x0018, 0x9074);
Tag const DiffusionDirectionality(0x0018, 0x9075);
Tag const DiffusionGradientDirectionSequence(0x0018, 0x9076);
Tag const ParallelAcquisition(0x0018, 0x9077);
Tag const ParallelAcquisitionTechnique(0x0018, 0x9078);
Tag const InversionTimes(0x0018, 0x9079);
Tag const MetaboliteMapDescription(0x0018, 0x9080);
Tag const PartialFourier(0x0018, 0x9081);
Tag const EffectiveEchoTime(0x0018, 0x9082);
Tag const MetaboliteMapCodeSequence(0x0018, 0x9083);
Tag const ChemicalShiftSequence(0x0018, 0x9084);
Tag const CardiacSignalSource(0x0018, 0x9085);
Tag const DiffusionBValue(0x0018, 0x9087);
Tag const DiffusionGradientOrientation(0x0018, 0x9089);
Tag const VelocityEncodingDirection(0x0018, 0x9090);
Tag const VelocityEncodingMinimumValue(0x0018, 0x9091);
Tag const VelocityEncodingAcquisitionSequence(0x0018, 0x9092);
Tag const NumberOfKSpaceTrajectories(0x0018, 0x9093);
Tag const CoverageOfKSpace(0x0018, 0x9094);
Tag const SpectroscopyAcquisitionPhaseRows(0x0018, 0x9095);
Tag const ParallelReductionFactorInPlaneRetired(0x0018, 0x9096);
Tag const TransmitterFrequency(0x0018, 0x9098);
Tag const ResonantNucleus(0x0018, 0x9100);
Tag const FrequencyCorrection(0x0018, 0x9101);
Tag const MRSpectroscopyFOVGeometrySequence(0x0018, 0x9103);
Tag const SlabThickness(0x0018, 0x9104);
Tag const SlabOrientation(0x0018, 0x9105);
Tag const MidSlabPosition(0x0018, 0x9106);
Tag const MRSpatialSaturationSequence(0x0018, 0x9107);
Tag const MRTimingAndRelatedParametersSequence(0x0018, 0x9112);
Tag const MREchoSequence(0x0018, 0x9114);
Tag const MRModifierSequence(0x0018, 0x9115);
Tag const MRDiffusionSequence(0x0018, 0x9117);
Tag const CardiacSynchronizationSequence(0x0018, 0x9118);
Tag const MRAveragesSequence(0x0018, 0x9119);
Tag const MRFOVGeometrySequence(0x0018, 0x9125);
Tag const VolumeLocalizationSequence(0x0018, 0x9126);
Tag const SpectroscopyAcquisitionDataColumns(0x0018, 0x9127);
Tag const DiffusionAnisotropyType(0x0018, 0x9147);
Tag const FrameReferenceDateTime(0x0018, 0x9151);
Tag const MRMetaboliteMapSequence(0x0018, 0x9152);
Tag const ParallelReductionFactorOutOfPlane(0x0018, 0x9155);
Tag const SpectroscopyAcquisitionOutOfPlanePhaseSteps(0x0018, 0x9159);
Tag const BulkMotionStatus(0x0018, 0x9166);
Tag const ParallelReductionFactorSecondInPlane(0x0018, 0x9168);
Tag const CardiacBeatRejectionTechnique(0x0018, 0x9169);
Tag const RespiratoryMotionCompensationTechnique(0x0018, 0x9170);
Tag const RespiratorySignalSource(0x0018, 0x9171);
Tag const BulkMotionCompensationTechnique(0x0018, 0x9172);
Tag const BulkMotionSignalSource(0x0018, 0x9173);
Tag const ApplicableSafetyStandardAgency(0x0018, 0x9174);
Tag const ApplicableSafetyStandardDescription(0x0018, 0x9175);
Tag const OperatingModeSequence(0x0018, 0x9176);
Tag const OperatingModeType(0x0018, 0x9177);
Tag const OperatingMode(0x0018, 0x9178);
Tag const SpecificAbsorptionRateDefinition(0x0018, 0x9179);
Tag const GradientOutputType(0x0018, 0x9180);
Tag const SpecificAbsorptionRateValue(0x0018, 0x9181);
Tag const GradientOutput(0x0018, 0x9182);
Tag const FlowCompensationDirection(0x0018, 0x9183);
Tag const TaggingDelay(0x0018, 0x9184);
Tag const RespiratoryMotionCompensationTechniqueDescription(0x0018, 0x9185);
Tag const RespiratorySignalSourceID(0x0018, 0x9186);
Tag const ChemicalShiftMinimumIntegrationLimitInHz(0x0018, 0x9195);
Tag const ChemicalShiftMaximumIntegrationLimitInHz(0x0018, 0x9196);
Tag const MRVelocityEncodingSequence(0x0018, 0x9197);
Tag const FirstOrderPhaseCorrection(0x0018, 0x9198);
Tag const WaterReferencedPhaseCorrection(0x0018, 0x9199);
Tag const MRSpectroscopyAcquisitionType(0x0018, 0x9200);
Tag const RespiratoryCyclePosition(0x0018, 0x9214);
Tag const VelocityEncodingMaximumValue(0x0018, 0x9217);
Tag const TagSpacingSecondDimension(0x0018, 0x9218);
Tag const TagAngleSecondAxis(0x0018, 0x9219);
Tag const FrameAcquisitionDuration(0x0018, 0x9220);
Tag const MRImageFrameTypeSequence(0x0018, 0x9226);
Tag const MRSpectroscopyFrameTypeSequence(0x0018, 0x9227);
Tag const MRAcquisitionPhaseEncodingStepsInPlane(0x0018, 0x9231);
Tag const MRAcquisitionPhaseEncodingStepsOutOfPlane(0x0018, 0x9232);
Tag const SpectroscopyAcquisitionPhaseColumns(0x0018, 0x9234);
Tag const CardiacCyclePosition(0x0018, 0x9236);
Tag const SpecificAbsorptionRateSequence(0x0018, 0x9239);
Tag const RFEchoTrainLength(0x0018, 0x9240);
Tag const GradientEchoTrainLength(0x0018, 0x9241);
Tag const ArterialSpinLabelingContrast(0x0018, 0x9250);
Tag const MRArterialSpinLabelingSequence(0x0018, 0x9251);
Tag const ASLTechniqueDescription(0x0018, 0x9252);
Tag const ASLSlabNumber(0x0018, 0x9253);
Tag const ASLSlabThickness(0x0018, 0x9254);
Tag const ASLSlabOrientation(0x0018, 0x9255);
Tag const ASLMidSlabPosition(0x0018, 0x9256);
Tag const ASLContext(0x0018, 0x9257);
Tag const ASLPulseTrainDuration(0x0018, 0x9258);
Tag const ASLCrusherFlag(0x0018, 0x9259);
Tag const ASLCrusherFlowLimit(0x0018, 0x925a);
Tag const ASLCrusherDescription(0x0018, 0x925b);
Tag const ASLBolusCutoffFlag(0x0018, 0x925c);
Tag const ASLBolusCutoffTimingSequence(0x0018, 0x925d);
Tag const ASLBolusCutoffTechnique(0x0018, 0x925e);
Tag const ASLBolusCutoffDelayTime(0x0018, 0x925f);
Tag const ASLSlabSequence(0x0018, 0x9260);
Tag const ChemicalShiftMinimumIntegrationLimitInppm(0x0018, 0x9295);
Tag const ChemicalShiftMaximumIntegrationLimitInppm(0x0018, 0x9296);
Tag const WaterReferenceAcquisition(0x0018, 0x9297);
Tag const EchoPeakPosition(0x0018, 0x9298);
Tag const CTAcquisitionTypeSequence(0x0018, 0x9301);
Tag const AcquisitionType(0x0018, 0x9302);
Tag const TubeAngle(0x0018, 0x9303);
Tag const CTAcquisitionDetailsSequence(0x0018, 0x9304);
Tag const RevolutionTime(0x0018, 0x9305);
Tag const SingleCollimationWidth(0x0018, 0x9306);
Tag const TotalCollimationWidth(0x0018, 0x9307);
Tag const CTTableDynamicsSequence(0x0018, 0x9308);
Tag const TableSpeed(0x0018, 0x9309);
Tag const TableFeedPerRotation(0x0018, 0x9310);
Tag const SpiralPitchFactor(0x0018, 0x9311);
Tag const CTGeometrySequence(0x0018, 0x9312);
Tag const DataCollectionCenterPatient(0x0018, 0x9313);
Tag const CTReconstructionSequence(0x0018, 0x9314);
Tag const ReconstructionAlgorithm(0x0018, 0x9315);
Tag const ConvolutionKernelGroup(0x0018, 0x9316);
Tag const ReconstructionFieldOfView(0x0018, 0x9317);
Tag const ReconstructionTargetCenterPatient(0x0018, 0x9318);
Tag const ReconstructionAngle(0x0018, 0x9319);
Tag const ImageFilter(0x0018, 0x9320);
Tag const CTExposureSequence(0x0018, 0x9321);
Tag const ReconstructionPixelSpacing(0x0018, 0x9322);
Tag const ExposureModulationType(0x0018, 0x9323);
Tag const EstimatedDoseSaving(0x0018, 0x9324);
Tag const CTXRayDetailsSequence(0x0018, 0x9325);
Tag const CTPositionSequence(0x0018, 0x9326);
Tag const TablePosition(0x0018, 0x9327);
Tag const ExposureTimeInms(0x0018, 0x9328);
Tag const CTImageFrameTypeSequence(0x0018, 0x9329);
Tag const XRayTubeCurrentInmA(0x0018, 0x9330);
Tag const ExposureInmAs(0x0018, 0x9332);
Tag const ConstantVolumeFlag(0x0018, 0x9333);
Tag const FluoroscopyFlag(0x0018, 0x9334);
Tag const DistanceSourceToDataCollectionCenter(0x0018, 0x9335);
Tag const ContrastBolusAgentNumber(0x0018, 0x9337);
Tag const ContrastBolusIngredientCodeSequence(0x0018, 0x9338);
Tag const ContrastAdministrationProfileSequence(0x0018, 0x9340);
Tag const ContrastBolusUsageSequence(0x0018, 0x9341);
Tag const ContrastBolusAgentAdministered(0x0018, 0x9342);
Tag const ContrastBolusAgentDetected(0x0018, 0x9343);
Tag const ContrastBolusAgentPhase(0x0018, 0x9344);
Tag const CTDIvol(0x0018, 0x9345);
Tag const CTDIPhantomTypeCodeSequence(0x0018, 0x9346);
Tag const CalciumScoringMassFactorPatient(0x0018, 0x9351);
Tag const CalciumScoringMassFactorDevice(0x0018, 0x9352);
Tag const EnergyWeightingFactor(0x0018, 0x9353);
Tag const CTAdditionalXRaySourceSequence(0x0018, 0x9360);
Tag const ProjectionPixelCalibrationSequence(0x0018, 0x9401);
Tag const DistanceSourceToIsocenter(0x0018, 0x9402);
Tag const DistanceObjectToTableTop(0x0018, 0x9403);
Tag const ObjectPixelSpacingInCenterOfBeam(0x0018, 0x9404);
Tag const PositionerPositionSequence(0x0018, 0x9405);
Tag const TablePositionSequence(0x0018, 0x9406);
Tag const CollimatorShapeSequence(0x0018, 0x9407);
Tag const PlanesInAcquisition(0x0018, 0x9410);
Tag const XAXRFFrameCharacteristicsSequence(0x0018, 0x9412);
Tag const FrameAcquisitionSequence(0x0018, 0x9417);
Tag const XRayReceptorType(0x0018, 0x9420);
Tag const AcquisitionProtocolName(0x0018, 0x9423);
Tag const AcquisitionProtocolDescription(0x0018, 0x9424);
Tag const ContrastBolusIngredientOpaque(0x0018, 0x9425);
Tag const DistanceReceptorPlaneToDetectorHousing(0x0018, 0x9426);
Tag const IntensifierActiveShape(0x0018, 0x9427);
Tag const IntensifierActiveDimensions(0x0018, 0x9428);
Tag const PhysicalDetectorSize(0x0018, 0x9429);
Tag const PositionOfIsocenterProjection(0x0018, 0x9430);
Tag const FieldOfViewSequence(0x0018, 0x9432);
Tag const FieldOfViewDescription(0x0018, 0x9433);
Tag const ExposureControlSensingRegionsSequence(0x0018, 0x9434);
Tag const ExposureControlSensingRegionShape(0x0018, 0x9435);
Tag const ExposureControlSensingRegionLeftVerticalEdge(0x0018, 0x9436);
Tag const ExposureControlSensingRegionRightVerticalEdge(0x0018, 0x9437);
Tag const ExposureControlSensingRegionUpperHorizontalEdge(0x0018, 0x9438);
Tag const ExposureControlSensingRegionLowerHorizontalEdge(0x0018, 0x9439);
Tag const CenterOfCircularExposureControlSensingRegion(0x0018, 0x9440);
Tag const RadiusOfCircularExposureControlSensingRegion(0x0018, 0x9441);
Tag const VerticesOfThePolygonalExposureControlSensingRegion(0x0018, 0x9442);
Tag const ColumnAngulationPatient(0x0018, 0x9447);
Tag const BeamAngle(0x0018, 0x9449);
Tag const FrameDetectorParametersSequence(0x0018, 0x9451);
Tag const CalculatedAnatomyThickness(0x0018, 0x9452);
Tag const CalibrationSequence(0x0018, 0x9455);
Tag const ObjectThicknessSequence(0x0018, 0x9456);
Tag const PlaneIdentification(0x0018, 0x9457);
Tag const FieldOfViewDimensionsInFloat(0x0018, 0x9461);
Tag const IsocenterReferenceSystemSequence(0x0018, 0x9462);
Tag const PositionerIsocenterPrimaryAngle(0x0018, 0x9463);
Tag const PositionerIsocenterSecondaryAngle(0x0018, 0x9464);
Tag const PositionerIsocenterDetectorRotationAngle(0x0018, 0x9465);
Tag const TableXPositionToIsocenter(0x0018, 0x9466);
Tag const TableYPositionToIsocenter(0x0018, 0x9467);
Tag const TableZPositionToIsocenter(0x0018, 0x9468);
Tag const TableHorizontalRotationAngle(0x0018, 0x9469);
Tag const TableHeadTiltAngle(0x0018, 0x9470);
Tag const TableCradleTiltAngle(0x0018, 0x9471);
Tag const FrameDisplayShutterSequence(0x0018, 0x9472);
Tag const AcquiredImageAreaDoseProduct(0x0018, 0x9473);
Tag const CArmPositionerTabletopRelationship(0x0018, 0x9474);
Tag const XRayGeometrySequence(0x0018, 0x9476);
Tag const IrradiationEventIdentificationSequence(0x0018, 0x9477);
Tag const XRay3DFrameTypeSequence(0x0018, 0x9504);
Tag const ContributingSourcesSequence(0x0018, 0x9506);
Tag const XRay3DAcquisitionSequence(0x0018, 0x9507);
Tag const PrimaryPositionerScanArc(0x0018, 0x9508);
Tag const SecondaryPositionerScanArc(0x0018, 0x9509);
Tag const PrimaryPositionerScanStartAngle(0x0018, 0x9510);
Tag const SecondaryPositionerScanStartAngle(0x0018, 0x9511);
Tag const PrimaryPositionerIncrement(0x0018, 0x9514);
Tag const SecondaryPositionerIncrement(0x0018, 0x9515);
Tag const StartAcquisitionDateTime(0x0018, 0x9516);
Tag const EndAcquisitionDateTime(0x0018, 0x9517);
Tag const PrimaryPositionerIncrementSign(0x0018, 0x9518);
Tag const SecondaryPositionerIncrementSign(0x0018, 0x9519);
Tag const ApplicationName(0x0018, 0x9524);
Tag const ApplicationVersion(0x0018, 0x9525);
Tag const ApplicationManufacturer(0x0018, 0x9526);
Tag const AlgorithmType(0x0018, 0x9527);
Tag const AlgorithmDescription(0x0018, 0x9528);
Tag const XRay3DReconstructionSequence(0x0018, 0x9530);
Tag const ReconstructionDescription(0x0018, 0x9531);
Tag const PerProjectionAcquisitionSequence(0x0018, 0x9538);
Tag const DetectorPositionSequence(0x0018, 0x9541);
Tag const XRayAcquisitionDoseSequence(0x0018, 0x9542);
Tag const XRaySourceIsocenterPrimaryAngle(0x0018, 0x9543);
Tag const XRaySourceIsocenterSecondaryAngle(0x0018, 0x9544);
Tag const BreastSupportIsocenterPrimaryAngle(0x0018, 0x9545);
Tag const BreastSupportIsocenterSecondaryAngle(0x0018, 0x9546);
Tag const BreastSupportXPositionToIsocenter(0x0018, 0x9547);
Tag const BreastSupportYPositionToIsocenter(0x0018, 0x9548);
Tag const BreastSupportZPositionToIsocenter(0x0018, 0x9549);
Tag const DetectorIsocenterPrimaryAngle(0x0018, 0x9550);
Tag const DetectorIsocenterSecondaryAngle(0x0018, 0x9551);
Tag const DetectorXPositionToIsocenter(0x0018, 0x9552);
Tag const DetectorYPositionToIsocenter(0x0018, 0x9553);
Tag const DetectorZPositionToIsocenter(0x0018, 0x9554);
Tag const XRayGridSequence(0x0018, 0x9555);
Tag const XRayFilterSequence(0x0018, 0x9556);
Tag const DetectorActiveAreaTLHCPosition(0x0018, 0x9557);
Tag const DetectorActiveAreaOrientation(0x0018, 0x9558);
Tag const PositionerPrimaryAngleDirection(0x0018, 0x9559);
Tag const DiffusionBMatrixSequence(0x0018, 0x9601);
Tag const DiffusionBValueXX(0x0018, 0x9602);
Tag const DiffusionBValueXY(0x0018, 0x9603);
Tag const DiffusionBValueXZ(0x0018, 0x9604);
Tag const DiffusionBValueYY(0x0018, 0x9605);
Tag const DiffusionBValueYZ(0x0018, 0x9606);
Tag const DiffusionBValueZZ(0x0018, 0x9607);
Tag const DecayCorrectionDateTime(0x0018, 0x9701);
Tag const StartDensityThreshold(0x0018, 0x9715);
Tag const StartRelativeDensityDifferenceThreshold(0x0018, 0x9716);
Tag const StartCardiacTriggerCountThreshold(0x0018, 0x9717);
Tag const StartRespiratoryTriggerCountThreshold(0x0018, 0x9718);
Tag const TerminationCountsThreshold(0x0018, 0x9719);
Tag const TerminationDensityThreshold(0x0018, 0x9720);
Tag const TerminationRelativeDensityThreshold(0x0018, 0x9721);
Tag const TerminationTimeThreshold(0x0018, 0x9722);
Tag const TerminationCardiacTriggerCountThreshold(0x0018, 0x9723);
Tag const TerminationRespiratoryTriggerCountThreshold(0x0018, 0x9724);
Tag const DetectorGeometry(0x0018, 0x9725);
Tag const TransverseDetectorSeparation(0x0018, 0x9726);
Tag const AxialDetectorDimension(0x0018, 0x9727);
Tag const RadiopharmaceuticalAgentNumber(0x0018, 0x9729);
Tag const PETFrameAcquisitionSequence(0x0018, 0x9732);
Tag const PETDetectorMotionDetailsSequence(0x0018, 0x9733);
Tag const PETTableDynamicsSequence(0x0018, 0x9734);
Tag const PETPositionSequence(0x0018, 0x9735);
Tag const PETFrameCorrectionFactorsSequence(0x0018, 0x9736);
Tag const RadiopharmaceuticalUsageSequence(0x0018, 0x9737);
Tag const AttenuationCorrectionSource(0x0018, 0x9738);
Tag const NumberOfIterations(0x0018, 0x9739);
Tag const NumberOfSubsets(0x0018, 0x9740);
Tag const PETReconstructionSequence(0x0018, 0x9749);
Tag const PETFrameTypeSequence(0x0018, 0x9751);
Tag const TimeOfFlightInformationUsed(0x0018, 0x9755);
Tag const ReconstructionType(0x0018, 0x9756);
Tag const DecayCorrected(0x0018, 0x9758);
Tag const AttenuationCorrected(0x0018, 0x9759);
Tag const ScatterCorrected(0x0018, 0x9760);
Tag const DeadTimeCorrected(0x0018, 0x9761);
Tag const GantryMotionCorrected(0x0018, 0x9762);
Tag const PatientMotionCorrected(0x0018, 0x9763);
Tag const CountLossNormalizationCorrected(0x0018, 0x9764);
Tag const RandomsCorrected(0x0018, 0x9765);
Tag const NonUniformRadialSamplingCorrected(0x0018, 0x9766);
Tag const SensitivityCalibrated(0x0018, 0x9767);
Tag const DetectorNormalizationCorrection(0x0018, 0x9768);
Tag const IterativeReconstructionMethod(0x0018, 0x9769);
Tag const AttenuationCorrectionTemporalRelationship(0x0018, 0x9770);
Tag const PatientPhysiologicalStateSequence(0x0018, 0x9771);
Tag const PatientPhysiologicalStateCodeSequence(0x0018, 0x9772);
Tag const DepthsOfFocus(0x0018, 0x9801);
Tag const ExcludedIntervalsSequence(0x0018, 0x9803);
Tag const ExclusionStartDateTime(0x0018, 0x9804);
Tag const ExclusionDuration(0x0018, 0x9805);
Tag const USImageDescriptionSequence(0x0018, 0x9806);
Tag const ImageDataTypeSequence(0x0018, 0x9807);
Tag const DataType(0x0018, 0x9808);
Tag const TransducerScanPatternCodeSequence(0x0018, 0x9809);
Tag const AliasedDataType(0x0018, 0x980b);
Tag const PositionMeasuringDeviceUsed(0x0018, 0x980c);
Tag const TransducerGeometryCodeSequence(0x0018, 0x980d);
Tag const TransducerBeamSteeringCodeSequence(0x0018, 0x980e);
Tag const TransducerApplicationCodeSequence(0x0018, 0x980f);
Tag const ZeroVelocityPixelValue(0x0018, 0x9810);
Tag const ContributingEquipmentSequence(0x0018, 0xa001);
Tag const ContributionDateTime(0x0018, 0xa002);
Tag const ContributionDescription(0x0018, 0xa003);
Tag const StudyInstanceUID(0x0020, 0x000d);
Tag const SeriesInstanceUID(0x0020, 0x000e);
Tag const StudyID(0x0020, 0x0010);
Tag const SeriesNumber(0x0020, 0x0011);
Tag const AcquisitionNumber(0x0020, 0x0012);
Tag const InstanceNumber(0x0020, 0x0013);
Tag const IsotopeNumber(0x0020, 0x0014);
Tag const PhaseNumber(0x0020, 0x0015);
Tag const IntervalNumber(0x0020, 0x0016);
Tag const TimeSlotNumber(0x0020, 0x0017);
Tag const AngleNumber(0x0020, 0x0018);
Tag const ItemNumber(0x0020, 0x0019);
Tag const PatientOrientation(0x0020, 0x0020);
Tag const OverlayNumber(0x0020, 0x0022);
Tag const CurveNumber(0x0020, 0x0024);
Tag const LUTNumber(0x0020, 0x0026);
Tag const ImagePosition(0x0020, 0x0030);
Tag const ImagePositionPatient(0x0020, 0x0032);
Tag const ImageOrientation(0x0020, 0x0035);
Tag const ImageOrientationPatient(0x0020, 0x0037);
Tag const Location(0x0020, 0x0050);
Tag const FrameOfReferenceUID(0x0020, 0x0052);
Tag const Laterality(0x0020, 0x0060);
Tag const ImageLaterality(0x0020, 0x0062);
Tag const ImageGeometryType(0x0020, 0x0070);
Tag const MaskingImage(0x0020, 0x0080);
Tag const ReportNumber(0x0020, 0x00aa);
Tag const TemporalPositionIdentifier(0x0020, 0x0100);
Tag const NumberOfTemporalPositions(0x0020, 0x0105);
Tag const TemporalResolution(0x0020, 0x0110);
Tag const SynchronizationFrameOfReferenceUID(0x0020, 0x0200);
Tag const SOPInstanceUIDOfConcatenationSource(0x0020, 0x0242);
Tag const SeriesInStudy(0x0020, 0x1000);
Tag const AcquisitionsInSeries(0x0020, 0x1001);
Tag const ImagesInAcquisition(0x0020, 0x1002);
Tag const ImagesInSeries(0x0020, 0x1003);
Tag const AcquisitionsInStudy(0x0020, 0x1004);
Tag const ImagesInStudy(0x0020, 0x1005);
Tag const Reference(0x0020, 0x1020);
Tag const PositionReferenceIndicator(0x0020, 0x1040);
Tag const SliceLocation(0x0020, 0x1041);
Tag const OtherStudyNumbers(0x0020, 0x1070);
Tag const NumberOfPatientRelatedStudies(0x0020, 0x1200);
Tag const NumberOfPatientRelatedSeries(0x0020, 0x1202);
Tag const NumberOfPatientRelatedInstances(0x0020, 0x1204);
Tag const NumberOfStudyRelatedSeries(0x0020, 0x1206);
Tag const NumberOfStudyRelatedInstances(0x0020, 0x1208);
Tag const NumberOfSeriesRelatedInstances(0x0020, 0x1209);
Tag const ModifyingDeviceID(0x0020, 0x3401);
Tag const ModifiedImageID(0x0020, 0x3402);
Tag const ModifiedImageDate(0x0020, 0x3403);
Tag const ModifyingDeviceManufacturer(0x0020, 0x3404);
Tag const ModifiedImageTime(0x0020, 0x3405);
Tag const ModifiedImageDescription(0x0020, 0x3406);
Tag const ImageComments(0x0020, 0x4000);
Tag const OriginalImageIdentification(0x0020, 0x5000);
Tag const OriginalImageIdentificationNomenclature(0x0020, 0x5002);
Tag const StackID(0x0020, 0x9056);
Tag const InStackPositionNumber(0x0020, 0x9057);
Tag const FrameAnatomySequence(0x0020, 0x9071);
Tag const FrameLaterality(0x0020, 0x9072);
Tag const FrameContentSequence(0x0020, 0x9111);
Tag const PlanePositionSequence(0x0020, 0x9113);
Tag const PlaneOrientationSequence(0x0020, 0x9116);
Tag const TemporalPositionIndex(0x0020, 0x9128);
Tag const NominalCardiacTriggerDelayTime(0x0020, 0x9153);
Tag const NominalCardiacTriggerTimePriorToRPeak(0x0020, 0x9154);
Tag const ActualCardiacTriggerTimePriorToRPeak(0x0020, 0x9155);
Tag const FrameAcquisitionNumber(0x0020, 0x9156);
Tag const DimensionIndexValues(0x0020, 0x9157);
Tag const FrameComments(0x0020, 0x9158);
Tag const ConcatenationUID(0x0020, 0x9161);
Tag const InConcatenationNumber(0x0020, 0x9162);
Tag const InConcatenationTotalNumber(0x0020, 0x9163);
Tag const DimensionOrganizationUID(0x0020, 0x9164);
Tag const DimensionIndexPointer(0x0020, 0x9165);
Tag const FunctionalGroupPointer(0x0020, 0x9167);
Tag const UnassignedSharedConvertedAttributesSequence(0x0020, 0x9170);
Tag const UnassignedPerFrameConvertedAttributesSequence(0x0020, 0x9171);
Tag const ConversionSourceAttributesSequence(0x0020, 0x9172);
Tag const DimensionIndexPrivateCreator(0x0020, 0x9213);
Tag const DimensionOrganizationSequence(0x0020, 0x9221);
Tag const DimensionIndexSequence(0x0020, 0x9222);
Tag const ConcatenationFrameOffsetNumber(0x0020, 0x9228);
Tag const FunctionalGroupPrivateCreator(0x0020, 0x9238);
Tag const NominalPercentageOfCardiacPhase(0x0020, 0x9241);
Tag const NominalPercentageOfRespiratoryPhase(0x0020, 0x9245);
Tag const StartingRespiratoryAmplitude(0x0020, 0x9246);
Tag const StartingRespiratoryPhase(0x0020, 0x9247);
Tag const EndingRespiratoryAmplitude(0x0020, 0x9248);
Tag const EndingRespiratoryPhase(0x0020, 0x9249);
Tag const RespiratoryTriggerType(0x0020, 0x9250);
Tag const RRIntervalTimeNominal(0x0020, 0x9251);
Tag const ActualCardiacTriggerDelayTime(0x0020, 0x9252);
Tag const RespiratorySynchronizationSequence(0x0020, 0x9253);
Tag const RespiratoryIntervalTime(0x0020, 0x9254);
Tag const NominalRespiratoryTriggerDelayTime(0x0020, 0x9255);
Tag const RespiratoryTriggerDelayThreshold(0x0020, 0x9256);
Tag const ActualRespiratoryTriggerDelayTime(0x0020, 0x9257);
Tag const ImagePositionVolume(0x0020, 0x9301);
Tag const ImageOrientationVolume(0x0020, 0x9302);
Tag const UltrasoundAcquisitionGeometry(0x0020, 0x9307);
Tag const ApexPosition(0x0020, 0x9308);
Tag const VolumeToTransducerMappingMatrix(0x0020, 0x9309);
Tag const VolumeToTableMappingMatrix(0x0020, 0x930a);
Tag const VolumeToTransducerRelationship(0x0020, 0x930b);
Tag const PatientFrameOfReferenceSource(0x0020, 0x930c);
Tag const TemporalPositionTimeOffset(0x0020, 0x930d);
Tag const PlanePositionVolumeSequence(0x0020, 0x930e);
Tag const PlaneOrientationVolumeSequence(0x0020, 0x930f);
Tag const TemporalPositionSequence(0x0020, 0x9310);
Tag const DimensionOrganizationType(0x0020, 0x9311);
Tag const VolumeFrameOfReferenceUID(0x0020, 0x9312);
Tag const TableFrameOfReferenceUID(0x0020, 0x9313);
Tag const DimensionDescriptionLabel(0x0020, 0x9421);
Tag const PatientOrientationInFrameSequence(0x0020, 0x9450);
Tag const FrameLabel(0x0020, 0x9453);
Tag const AcquisitionIndex(0x0020, 0x9518);
Tag const ContributingSOPInstancesReferenceSequence(0x0020, 0x9529);
Tag const ReconstructionIndex(0x0020, 0x9536);
Tag const LightPathFilterPassThroughWavelength(0x0022, 0x0001);
Tag const LightPathFilterPassBand(0x0022, 0x0002);
Tag const ImagePathFilterPassThroughWavelength(0x0022, 0x0003);
Tag const ImagePathFilterPassBand(0x0022, 0x0004);
Tag const PatientEyeMovementCommanded(0x0022, 0x0005);
Tag const PatientEyeMovementCommandCodeSequence(0x0022, 0x0006);
Tag const SphericalLensPower(0x0022, 0x0007);
Tag const CylinderLensPower(0x0022, 0x0008);
Tag const CylinderAxis(0x0022, 0x0009);
Tag const EmmetropicMagnification(0x0022, 0x000a);
Tag const IntraOcularPressure(0x0022, 0x000b);
Tag const HorizontalFieldOfView(0x0022, 0x000c);
Tag const PupilDilated(0x0022, 0x000d);
Tag const DegreeOfDilation(0x0022, 0x000e);
Tag const StereoBaselineAngle(0x0022, 0x0010);
Tag const StereoBaselineDisplacement(0x0022, 0x0011);
Tag const StereoHorizontalPixelOffset(0x0022, 0x0012);
Tag const StereoVerticalPixelOffset(0x0022, 0x0013);
Tag const StereoRotation(0x0022, 0x0014);
Tag const AcquisitionDeviceTypeCodeSequence(0x0022, 0x0015);
Tag const IlluminationTypeCodeSequence(0x0022, 0x0016);
Tag const LightPathFilterTypeStackCodeSequence(0x0022, 0x0017);
Tag const ImagePathFilterTypeStackCodeSequence(0x0022, 0x0018);
Tag const LensesCodeSequence(0x0022, 0x0019);
Tag const ChannelDescriptionCodeSequence(0x0022, 0x001a);
Tag const RefractiveStateSequence(0x0022, 0x001b);
Tag const MydriaticAgentCodeSequence(0x0022, 0x001c);
Tag const RelativeImagePositionCodeSequence(0x0022, 0x001d);
Tag const CameraAngleOfView(0x0022, 0x001e);
Tag const StereoPairsSequence(0x0022, 0x0020);
Tag const LeftImageSequence(0x0022, 0x0021);
Tag const RightImageSequence(0x0022, 0x0022);
Tag const StereoPairsPresent(0x0022, 0x0028);
Tag const AxialLengthOfTheEye(0x0022, 0x0030);
Tag const OphthalmicFrameLocationSequence(0x0022, 0x0031);
Tag const ReferenceCoordinates(0x0022, 0x0032);
Tag const DepthSpatialResolution(0x0022, 0x0035);
Tag const MaximumDepthDistortion(0x0022, 0x0036);
Tag const AlongScanSpatialResolution(0x0022, 0x0037);
Tag const MaximumAlongScanDistortion(0x0022, 0x0038);
Tag const OphthalmicImageOrientation(0x0022, 0x0039);
Tag const DepthOfTransverseImage(0x0022, 0x0041);
Tag const MydriaticAgentConcentrationUnitsSequence(0x0022, 0x0042);
Tag const AcrossScanSpatialResolution(0x0022, 0x0048);
Tag const MaximumAcrossScanDistortion(0x0022, 0x0049);
Tag const MydriaticAgentConcentration(0x0022, 0x004e);
Tag const IlluminationWaveLength(0x0022, 0x0055);
Tag const IlluminationPower(0x0022, 0x0056);
Tag const IlluminationBandwidth(0x0022, 0x0057);
Tag const MydriaticAgentSequence(0x0022, 0x0058);
Tag const OphthalmicAxialMeasurementsRightEyeSequence(0x0022, 0x1007);
Tag const OphthalmicAxialMeasurementsLeftEyeSequence(0x0022, 0x1008);
Tag const OphthalmicAxialMeasurementsDeviceType(0x0022, 0x1009);
Tag const OphthalmicAxialLengthMeasurementsType(0x0022, 0x1010);
Tag const OphthalmicAxialLengthSequence(0x0022, 0x1012);
Tag const OphthalmicAxialLength(0x0022, 0x1019);
Tag const LensStatusCodeSequence(0x0022, 0x1024);
Tag const VitreousStatusCodeSequence(0x0022, 0x1025);
Tag const IOLFormulaCodeSequence(0x0022, 0x1028);
Tag const IOLFormulaDetail(0x0022, 0x1029);
Tag const KeratometerIndex(0x0022, 0x1033);
Tag const SourceOfOphthalmicAxialLengthCodeSequence(0x0022, 0x1035);
Tag const TargetRefraction(0x0022, 0x1037);
Tag const RefractiveProcedureOccurred(0x0022, 0x1039);
Tag const RefractiveSurgeryTypeCodeSequence(0x0022, 0x1040);
Tag const OphthalmicUltrasoundMethodCodeSequence(0x0022, 0x1044);
Tag const OphthalmicAxialLengthMeasurementsSequence(0x0022, 0x1050);
Tag const IOLPower(0x0022, 0x1053);
Tag const PredictedRefractiveError(0x0022, 0x1054);
Tag const OphthalmicAxialLengthVelocity(0x0022, 0x1059);
Tag const LensStatusDescription(0x0022, 0x1065);
Tag const VitreousStatusDescription(0x0022, 0x1066);
Tag const IOLPowerSequence(0x0022, 0x1090);
Tag const LensConstantSequence(0x0022, 0x1092);
Tag const IOLManufacturer(0x0022, 0x1093);
Tag const LensConstantDescription(0x0022, 0x1094);
Tag const ImplantName(0x0022, 0x1095);
Tag const KeratometryMeasurementTypeCodeSequence(0x0022, 0x1096);
Tag const ImplantPartNumber(0x0022, 0x1097);
Tag const ReferencedOphthalmicAxialMeasurementsSequence(0x0022, 0x1100);
Tag const OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence(0x0022, 0x1101);
Tag const RefractiveErrorBeforeRefractiveSurgeryCodeSequence(0x0022, 0x1103);
Tag const IOLPowerForExactEmmetropia(0x0022, 0x1121);
Tag const IOLPowerForExactTargetRefraction(0x0022, 0x1122);
Tag const AnteriorChamberDepthDefinitionCodeSequence(0x0022, 0x1125);
Tag const LensThicknessSequence(0x0022, 0x1127);
Tag const AnteriorChamberDepthSequence(0x0022, 0x1128);
Tag const LensThickness(0x0022, 0x1130);
Tag const AnteriorChamberDepth(0x0022, 0x1131);
Tag const SourceOfLensThicknessDataCodeSequence(0x0022, 0x1132);
Tag const SourceOfAnteriorChamberDepthDataCodeSequence(0x0022, 0x1133);
Tag const SourceOfRefractiveMeasurementsSequence(0x0022, 0x1134);
Tag const SourceOfRefractiveMeasurementsCodeSequence(0x0022, 0x1135);
Tag const OphthalmicAxialLengthMeasurementModified(0x0022, 0x1140);
Tag const OphthalmicAxialLengthDataSourceCodeSequence(0x0022, 0x1150);
Tag const OphthalmicAxialLengthAcquisitionMethodCodeSequence(0x0022, 0x1153);
Tag const SignalToNoiseRatio(0x0022, 0x1155);
Tag const OphthalmicAxialLengthDataSourceDescription(0x0022, 0x1159);
Tag const OphthalmicAxialLengthMeasurementsTotalLengthSequence(0x0022, 0x1210);
Tag const OphthalmicAxialLengthMeasurementsSegmentalLengthSequence(0x0022, 0x1211);
Tag const OphthalmicAxialLengthMeasurementsLengthSummationSequence(0x0022, 0x1212);
Tag const UltrasoundOphthalmicAxialLengthMeasurementsSequence(0x0022, 0x1220);
Tag const OpticalOphthalmicAxialLengthMeasurementsSequence(0x0022, 0x1225);
Tag const UltrasoundSelectedOphthalmicAxialLengthSequence(0x0022, 0x1230);
Tag const OphthalmicAxialLengthSelectionMethodCodeSequence(0x0022, 0x1250);
Tag const OpticalSelectedOphthalmicAxialLengthSequence(0x0022, 0x1255);
Tag const SelectedSegmentalOphthalmicAxialLengthSequence(0x0022, 0x1257);
Tag const SelectedTotalOphthalmicAxialLengthSequence(0x0022, 0x1260);
Tag const OphthalmicAxialLengthQualityMetricSequence(0x0022, 0x1262);
Tag const OphthalmicAxialLengthQualityMetricTypeCodeSequence(0x0022, 0x1265);
Tag const OphthalmicAxialLengthQualityMetricTypeDescription(0x0022, 0x1273);
Tag const IntraocularLensCalculationsRightEyeSequence(0x0022, 0x1300);
Tag const IntraocularLensCalculationsLeftEyeSequence(0x0022, 0x1310);
Tag const ReferencedOphthalmicAxialLengthMeasurementQCImageSequence(0x0022, 0x1330);
Tag const OphthalmicMappingDeviceType(0x0022, 0x1415);
Tag const AcquisitionMethodCodeSequence(0x0022, 0x1420);
Tag const AcquisitionMethodAlgorithmSequence(0x0022, 0x1423);
Tag const OphthalmicThicknessMapTypeCodeSequence(0x0022, 0x1436);
Tag const OphthalmicThicknessMappingNormalsSequence(0x0022, 0x1443);
Tag const RetinalThicknessDefinitionCodeSequence(0x0022, 0x1445);
Tag const PixelValueMappingToCodedConceptSequence(0x0022, 0x1450);
Tag const MappedPixelValue(0x0022, 0x1452);
Tag const PixelValueMappingExplanation(0x0022, 0x1454);
Tag const OphthalmicThicknessMapQualityThresholdSequence(0x0022, 0x1458);
Tag const OphthalmicThicknessMapThresholdQualityRating(0x0022, 0x1460);
Tag const AnatomicStructureReferencePoint(0x0022, 0x1463);
Tag const RegistrationToLocalizerSequence(0x0022, 0x1465);
Tag const RegisteredLocalizerUnits(0x0022, 0x1466);
Tag const RegisteredLocalizerTopLeftHandCorner(0x0022, 0x1467);
Tag const RegisteredLocalizerBottomRightHandCorner(0x0022, 0x1468);
Tag const OphthalmicThicknessMapQualityRatingSequence(0x0022, 0x1470);
Tag const RelevantOPTAttributesSequence(0x0022, 0x1472);
Tag const TransformationMethodCodeSequence(0x0022, 0x1512);
Tag const TransformationAlgorithmSequence(0x0022, 0x1513);
Tag const OphthalmicAxialLengthMethod(0x0022, 0x1515);
Tag const OphthalmicFOV(0x0022, 0x1517);
Tag const TwoDimensionalToThreeDimensionalMapSequence(0x0022, 0x1518);
Tag const WideFieldOphthalmicPhotographyQualityRatingSequence(0x0022, 0x1525);
Tag const WideFieldOphthalmicPhotographyQualityThresholdSequence(0x0022, 0x1526);
Tag const WideFieldOphthalmicPhotographyThresholdQualityRating(0x0022, 0x1527);
Tag const XCoordinatesCenterPixelViewAngle(0x0022, 0x1528);
Tag const YCoordinatesCenterPixelViewAngle(0x0022, 0x1529);
Tag const NumberOfMapPoints(0x0022, 0x1530);
Tag const TwoDimensionalToThreeDimensionalMapData(0x0022, 0x1531);
Tag const VisualFieldHorizontalExtent(0x0024, 0x0010);
Tag const VisualFieldVerticalExtent(0x0024, 0x0011);
Tag const VisualFieldShape(0x0024, 0x0012);
Tag const ScreeningTestModeCodeSequence(0x0024, 0x0016);
Tag const MaximumStimulusLuminance(0x0024, 0x0018);
Tag const BackgroundLuminance(0x0024, 0x0020);
Tag const StimulusColorCodeSequence(0x0024, 0x0021);
Tag const BackgroundIlluminationColorCodeSequence(0x0024, 0x0024);
Tag const StimulusArea(0x0024, 0x0025);
Tag const StimulusPresentationTime(0x0024, 0x0028);
Tag const FixationSequence(0x0024, 0x0032);
Tag const FixationMonitoringCodeSequence(0x0024, 0x0033);
Tag const VisualFieldCatchTrialSequence(0x0024, 0x0034);
Tag const FixationCheckedQuantity(0x0024, 0x0035);
Tag const PatientNotProperlyFixatedQuantity(0x0024, 0x0036);
Tag const PresentedVisualStimuliDataFlag(0x0024, 0x0037);
Tag const NumberOfVisualStimuli(0x0024, 0x0038);
Tag const ExcessiveFixationLossesDataFlag(0x0024, 0x0039);
Tag const ExcessiveFixationLosses(0x0024, 0x0040);
Tag const StimuliRetestingQuantity(0x0024, 0x0042);
Tag const CommentsOnPatientPerformanceOfVisualField(0x0024, 0x0044);
Tag const FalseNegativesEstimateFlag(0x0024, 0x0045);
Tag const FalseNegativesEstimate(0x0024, 0x0046);
Tag const NegativeCatchTrialsQuantity(0x0024, 0x0048);
Tag const FalseNegativesQuantity(0x0024, 0x0050);
Tag const ExcessiveFalseNegativesDataFlag(0x0024, 0x0051);
Tag const ExcessiveFalseNegatives(0x0024, 0x0052);
Tag const FalsePositivesEstimateFlag(0x0024, 0x0053);
Tag const FalsePositivesEstimate(0x0024, 0x0054);
Tag const CatchTrialsDataFlag(0x0024, 0x0055);
Tag const PositiveCatchTrialsQuantity(0x0024, 0x0056);
Tag const TestPointNormalsDataFlag(0x0024, 0x0057);
Tag const TestPointNormalsSequence(0x0024, 0x0058);
Tag const GlobalDeviationProbabilityNormalsFlag(0x0024, 0x0059);
Tag const FalsePositivesQuantity(0x0024, 0x0060);
Tag const ExcessiveFalsePositivesDataFlag(0x0024, 0x0061);
Tag const ExcessiveFalsePositives(0x0024, 0x0062);
Tag const VisualFieldTestNormalsFlag(0x0024, 0x0063);
Tag const ResultsNormalsSequence(0x0024, 0x0064);
Tag const AgeCorrectedSensitivityDeviationAlgorithmSequence(0x0024, 0x0065);
Tag const GlobalDeviationFromNormal(0x0024, 0x0066);
Tag const GeneralizedDefectSensitivityDeviationAlgorithmSequence(0x0024, 0x0067);
Tag const LocalizedDeviationFromNormal(0x0024, 0x0068);
Tag const PatientReliabilityIndicator(0x0024, 0x0069);
Tag const VisualFieldMeanSensitivity(0x0024, 0x0070);
Tag const GlobalDeviationProbability(0x0024, 0x0071);
Tag const LocalDeviationProbabilityNormalsFlag(0x0024, 0x0072);
Tag const LocalizedDeviationProbability(0x0024, 0x0073);
Tag const ShortTermFluctuationCalculated(0x0024, 0x0074);
Tag const ShortTermFluctuation(0x0024, 0x0075);
Tag const ShortTermFluctuationProbabilityCalculated(0x0024, 0x0076);
Tag const ShortTermFluctuationProbability(0x0024, 0x0077);
Tag const CorrectedLocalizedDeviationFromNormalCalculated(0x0024, 0x0078);
Tag const CorrectedLocalizedDeviationFromNormal(0x0024, 0x0079);
Tag const CorrectedLocalizedDeviationFromNormalProbabilityCalculated(0x0024, 0x0080);
Tag const CorrectedLocalizedDeviationFromNormalProbability(0x0024, 0x0081);
Tag const GlobalDeviationProbabilitySequence(0x0024, 0x0083);
Tag const LocalizedDeviationProbabilitySequence(0x0024, 0x0085);
Tag const FovealSensitivityMeasured(0x0024, 0x0086);
Tag const FovealSensitivity(0x0024, 0x0087);
Tag const VisualFieldTestDuration(0x0024, 0x0088);
Tag const VisualFieldTestPointSequence(0x0024, 0x0089);
Tag const VisualFieldTestPointXCoordinate(0x0024, 0x0090);
Tag const VisualFieldTestPointYCoordinate(0x0024, 0x0091);
Tag const AgeCorrectedSensitivityDeviationValue(0x0024, 0x0092);
Tag const StimulusResults(0x0024, 0x0093);
Tag const SensitivityValue(0x0024, 0x0094);
Tag const RetestStimulusSeen(0x0024, 0x0095);
Tag const RetestSensitivityValue(0x0024, 0x0096);
Tag const VisualFieldTestPointNormalsSequence(0x0024, 0x0097);
Tag const QuantifiedDefect(0x0024, 0x0098);
Tag const AgeCorrectedSensitivityDeviationProbabilityValue(0x0024, 0x0100);
Tag const GeneralizedDefectCorrectedSensitivityDeviationFlag(0x0024, 0x0102);
Tag const GeneralizedDefectCorrectedSensitivityDeviationValue(0x0024, 0x0103);
Tag const GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue(0x0024, 0x0104);
Tag const MinimumSensitivityValue(0x0024, 0x0105);
Tag const BlindSpotLocalized(0x0024, 0x0106);
Tag const BlindSpotXCoordinate(0x0024, 0x0107);
Tag const BlindSpotYCoordinate(0x0024, 0x0108);
Tag const VisualAcuityMeasurementSequence(0x0024, 0x0110);
Tag const RefractiveParametersUsedOnPatientSequence(0x0024, 0x0112);
Tag const MeasurementLaterality(0x0024, 0x0113);
Tag const OphthalmicPatientClinicalInformationLeftEyeSequence(0x0024, 0x0114);
Tag const OphthalmicPatientClinicalInformationRightEyeSequence(0x0024, 0x0115);
Tag const FovealPointNormativeDataFlag(0x0024, 0x0117);
Tag const FovealPointProbabilityValue(0x0024, 0x0118);
Tag const ScreeningBaselineMeasured(0x0024, 0x0120);
Tag const ScreeningBaselineMeasuredSequence(0x0024, 0x0122);
Tag const ScreeningBaselineType(0x0024, 0x0124);
Tag const ScreeningBaselineValue(0x0024, 0x0126);
Tag const AlgorithmSource(0x0024, 0x0202);
Tag const DataSetName(0x0024, 0x0306);
Tag const DataSetVersion(0x0024, 0x0307);
Tag const DataSetSource(0x0024, 0x0308);
Tag const DataSetDescription(0x0024, 0x0309);
Tag const VisualFieldTestReliabilityGlobalIndexSequence(0x0024, 0x0317);
Tag const VisualFieldGlobalResultsIndexSequence(0x0024, 0x0320);
Tag const DataObservationSequence(0x0024, 0x0325);
Tag const IndexNormalsFlag(0x0024, 0x0338);
Tag const IndexProbability(0x0024, 0x0341);
Tag const IndexProbabilitySequence(0x0024, 0x0344);
Tag const SamplesPerPixel(0x0028, 0x0002);
Tag const SamplesPerPixelUsed(0x0028, 0x0003);
Tag const PhotometricInterpretation(0x0028, 0x0004);
Tag const ImageDimensions(0x0028, 0x0005);
Tag const PlanarConfiguration(0x0028, 0x0006);
Tag const NumberOfFrames(0x0028, 0x0008);
Tag const FrameIncrementPointer(0x0028, 0x0009);
Tag const FrameDimensionPointer(0x0028, 0x000a);
Tag const Rows(0x0028, 0x0010);
Tag const Columns(0x0028, 0x0011);
Tag const Planes(0x0028, 0x0012);
Tag const UltrasoundColorDataPresent(0x0028, 0x0014);
Tag const PixelSpacing(0x0028, 0x0030);
Tag const ZoomFactor(0x0028, 0x0031);
Tag const ZoomCenter(0x0028, 0x0032);
Tag const PixelAspectRatio(0x0028, 0x0034);
Tag const ImageFormat(0x0028, 0x0040);
Tag const ManipulatedImage(0x0028, 0x0050);
Tag const CorrectedImage(0x0028, 0x0051);
Tag const CompressionRecognitionCode(0x0028, 0x005f);
Tag const CompressionCode(0x0028, 0x0060);
Tag const CompressionOriginator(0x0028, 0x0061);
Tag const CompressionLabel(0x0028, 0x0062);
Tag const CompressionDescription(0x0028, 0x0063);
Tag const CompressionSequence(0x0028, 0x0065);
Tag const CompressionStepPointers(0x0028, 0x0066);
Tag const RepeatInterval(0x0028, 0x0068);
Tag const BitsGrouped(0x0028, 0x0069);
Tag const PerimeterTable(0x0028, 0x0070);
Tag const PerimeterValue(0x0028, 0x0071);
Tag const PredictorRows(0x0028, 0x0080);
Tag const PredictorColumns(0x0028, 0x0081);
Tag const PredictorConstants(0x0028, 0x0082);
Tag const BlockedPixels(0x0028, 0x0090);
Tag const BlockRows(0x0028, 0x0091);
Tag const BlockColumns(0x0028, 0x0092);
Tag const RowOverlap(0x0028, 0x0093);
Tag const ColumnOverlap(0x0028, 0x0094);
Tag const BitsAllocated(0x0028, 0x0100);
Tag const BitsStored(0x0028, 0x0101);
Tag const HighBit(0x0028, 0x0102);
Tag const PixelRepresentation(0x0028, 0x0103);
Tag const SmallestValidPixelValue(0x0028, 0x0104);
Tag const LargestValidPixelValue(0x0028, 0x0105);
Tag const SmallestImagePixelValue(0x0028, 0x0106);
Tag const LargestImagePixelValue(0x0028, 0x0107);
Tag const SmallestPixelValueInSeries(0x0028, 0x0108);
Tag const LargestPixelValueInSeries(0x0028, 0x0109);
Tag const SmallestImagePixelValueInPlane(0x0028, 0x0110);
Tag const LargestImagePixelValueInPlane(0x0028, 0x0111);
Tag const PixelPaddingValue(0x0028, 0x0120);
Tag const PixelPaddingRangeLimit(0x0028, 0x0121);
Tag const FloatPixelPaddingValue(0x0028, 0x0122);
Tag const DoubleFloatPixelPaddingValue(0x0028, 0x0123);
Tag const FloatPixelPaddingRangeLimit(0x0028, 0x0124);
Tag const DoubleFloatPixelPaddingRangeLimit(0x0028, 0x0125);
Tag const ImageLocation(0x0028, 0x0200);
Tag const QualityControlImage(0x0028, 0x0300);
Tag const BurnedInAnnotation(0x0028, 0x0301);
Tag const RecognizableVisualFeatures(0x0028, 0x0302);
Tag const LongitudinalTemporalInformationModified(0x0028, 0x0303);
Tag const ReferencedColorPaletteInstanceUID(0x0028, 0x0304);
Tag const TransformLabel(0x0028, 0x0400);
Tag const TransformVersionNumber(0x0028, 0x0401);
Tag const NumberOfTransformSteps(0x0028, 0x0402);
Tag const SequenceOfCompressedData(0x0028, 0x0403);
Tag const DetailsOfCoefficients(0x0028, 0x0404);
Tag const DCTLabel(0x0028, 0x0700);
Tag const DataBlockDescription(0x0028, 0x0701);
Tag const DataBlock(0x0028, 0x0702);
Tag const NormalizationFactorFormat(0x0028, 0x0710);
Tag const ZonalMapNumberFormat(0x0028, 0x0720);
Tag const ZonalMapLocation(0x0028, 0x0721);
Tag const ZonalMapFormat(0x0028, 0x0722);
Tag const AdaptiveMapFormat(0x0028, 0x0730);
Tag const CodeNumberFormat(0x0028, 0x0740);
Tag const PixelSpacingCalibrationType(0x0028, 0x0a02);
Tag const PixelSpacingCalibrationDescription(0x0028, 0x0a04);
Tag const PixelIntensityRelationship(0x0028, 0x1040);
Tag const PixelIntensityRelationshipSign(0x0028, 0x1041);
Tag const WindowCenter(0x0028, 0x1050);
Tag const WindowWidth(0x0028, 0x1051);
Tag const RescaleIntercept(0x0028, 0x1052);
Tag const RescaleSlope(0x0028, 0x1053);
Tag const RescaleType(0x0028, 0x1054);
Tag const WindowCenterWidthExplanation(0x0028, 0x1055);
Tag const VOILUTFunction(0x0028, 0x1056);
Tag const GrayScale(0x0028, 0x1080);
Tag const RecommendedViewingMode(0x0028, 0x1090);
Tag const GrayLookupTableDescriptor(0x0028, 0x1100);
Tag const RedPaletteColorLookupTableDescriptor(0x0028, 0x1101);
Tag const GreenPaletteColorLookupTableDescriptor(0x0028, 0x1102);
Tag const BluePaletteColorLookupTableDescriptor(0x0028, 0x1103);
Tag const AlphaPaletteColorLookupTableDescriptor(0x0028, 0x1104);
Tag const LargeRedPaletteColorLookupTableDescriptor(0x0028, 0x1111);
Tag const LargeGreenPaletteColorLookupTableDescriptor(0x0028, 0x1112);
Tag const LargeBluePaletteColorLookupTableDescriptor(0x0028, 0x1113);
Tag const PaletteColorLookupTableUID(0x0028, 0x1199);
Tag const GrayLookupTableData(0x0028, 0x1200);
Tag const RedPaletteColorLookupTableData(0x0028, 0x1201);
Tag const GreenPaletteColorLookupTableData(0x0028, 0x1202);
Tag const BluePaletteColorLookupTableData(0x0028, 0x1203);
Tag const AlphaPaletteColorLookupTableData(0x0028, 0x1204);
Tag const LargeRedPaletteColorLookupTableData(0x0028, 0x1211);
Tag const LargeGreenPaletteColorLookupTableData(0x0028, 0x1212);
Tag const LargeBluePaletteColorLookupTableData(0x0028, 0x1213);
Tag const LargePaletteColorLookupTableUID(0x0028, 0x1214);
Tag const SegmentedRedPaletteColorLookupTableData(0x0028, 0x1221);
Tag const SegmentedGreenPaletteColorLookupTableData(0x0028, 0x1222);
Tag const SegmentedBluePaletteColorLookupTableData(0x0028, 0x1223);
Tag const BreastImplantPresent(0x0028, 0x1300);
Tag const PartialView(0x0028, 0x1350);
Tag const PartialViewDescription(0x0028, 0x1351);
Tag const PartialViewCodeSequence(0x0028, 0x1352);
Tag const SpatialLocationsPreserved(0x0028, 0x135a);
Tag const DataFrameAssignmentSequence(0x0028, 0x1401);
Tag const DataPathAssignment(0x0028, 0x1402);
Tag const BitsMappedToColorLookupTable(0x0028, 0x1403);
Tag const BlendingLUT1Sequence(0x0028, 0x1404);
Tag const BlendingLUT1TransferFunction(0x0028, 0x1405);
Tag const BlendingWeightConstant(0x0028, 0x1406);
Tag const BlendingLookupTableDescriptor(0x0028, 0x1407);
Tag const BlendingLookupTableData(0x0028, 0x1408);
Tag const EnhancedPaletteColorLookupTableSequence(0x0028, 0x140b);
Tag const BlendingLUT2Sequence(0x0028, 0x140c);
Tag const BlendingLUT2TransferFunction(0x0028, 0x140d);
Tag const DataPathID(0x0028, 0x140e);
Tag const RGBLUTTransferFunction(0x0028, 0x140f);
Tag const AlphaLUTTransferFunction(0x0028, 0x1410);
Tag const ICCProfile(0x0028, 0x2000);
Tag const LossyImageCompression(0x0028, 0x2110);
Tag const LossyImageCompressionRatio(0x0028, 0x2112);
Tag const LossyImageCompressionMethod(0x0028, 0x2114);
Tag const ModalityLUTSequence(0x0028, 0x3000);
Tag const LUTDescriptor(0x0028, 0x3002);
Tag const LUTExplanation(0x0028, 0x3003);
Tag const ModalityLUTType(0x0028, 0x3004);
Tag const LUTData(0x0028, 0x3006);
Tag const VOILUTSequence(0x0028, 0x3010);
Tag const SoftcopyVOILUTSequence(0x0028, 0x3110);
Tag const ImagePresentationComments(0x0028, 0x4000);
Tag const BiPlaneAcquisitionSequence(0x0028, 0x5000);
Tag const RepresentativeFrameNumber(0x0028, 0x6010);
Tag const FrameNumbersOfInterest(0x0028, 0x6020);
Tag const FrameOfInterestDescription(0x0028, 0x6022);
Tag const FrameOfInterestType(0x0028, 0x6023);
Tag const MaskPointers(0x0028, 0x6030);
Tag const RWavePointer(0x0028, 0x6040);
Tag const MaskSubtractionSequence(0x0028, 0x6100);
Tag const MaskOperation(0x0028, 0x6101);
Tag const ApplicableFrameRange(0x0028, 0x6102);
Tag const MaskFrameNumbers(0x0028, 0x6110);
Tag const ContrastFrameAveraging(0x0028, 0x6112);
Tag const MaskSubPixelShift(0x0028, 0x6114);
Tag const TIDOffset(0x0028, 0x6120);
Tag const MaskOperationExplanation(0x0028, 0x6190);
Tag const EquipmentAdministratorSequence(0x0028, 0x7000);
Tag const NumberOfDisplaySubsystems(0x0028, 0x7001);
Tag const CurrentConfigurationID(0x0028, 0x7002);
Tag const DisplaySubsystemID(0x0028, 0x7003);
Tag const DisplaySubsystemName(0x0028, 0x7004);
Tag const DisplaySubsystemDescription(0x0028, 0x7005);
Tag const SystemStatus(0x0028, 0x7006);
Tag const SystemStatusComment(0x0028, 0x7007);
Tag const TargetLuminanceCharacteristicsSequence(0x0028, 0x7008);
Tag const LuminanceCharacteristicsID(0x0028, 0x7009);
Tag const DisplaySubsystemConfigurationSequence(0x0028, 0x700a);
Tag const ConfigurationID(0x0028, 0x700b);
Tag const ConfigurationName(0x0028, 0x700c);
Tag const ConfigurationDescription(0x0028, 0x700d);
Tag const ReferencedTargetLuminanceCharacteristicsID(0x0028, 0x700e);
Tag const QAResultsSequence(0x0028, 0x700f);
Tag const DisplaySubsystemQAResultsSequence(0x0028, 0x7010);
Tag const ConfigurationQAResultsSequence(0x0028, 0x7011);
Tag const MeasurementEquipmentSequence(0x0028, 0x7012);
Tag const MeasurementFunctions(0x0028, 0x7013);
Tag const MeasurementEquipmentType(0x0028, 0x7014);
Tag const VisualEvaluationResultSequence(0x0028, 0x7015);
Tag const DisplayCalibrationResultSequence(0x0028, 0x7016);
Tag const DDLValue(0x0028, 0x7017);
Tag const CIExyWhitePoint(0x0028, 0x7018);
Tag const DisplayFunctionType(0x0028, 0x7019);
Tag const GammaValue(0x0028, 0x701a);
Tag const NumberOfLuminancePoints(0x0028, 0x701b);
Tag const LuminanceResponseSequence(0x0028, 0x701c);
Tag const TargetMinimumLuminance(0x0028, 0x701d);
Tag const TargetMaximumLuminance(0x0028, 0x701e);
Tag const LuminanceValue(0x0028, 0x701f);
Tag const LuminanceResponseDescription(0x0028, 0x7020);
Tag const WhitePointFlag(0x0028, 0x7021);
Tag const DisplayDeviceTypeCodeSequence(0x0028, 0x7022);
Tag const DisplaySubsystemSequence(0x0028, 0x7023);
Tag const LuminanceResultSequence(0x0028, 0x7024);
Tag const AmbientLightValueSource(0x0028, 0x7025);
Tag const MeasuredCharacteristics(0x0028, 0x7026);
Tag const LuminanceUniformityResultSequence(0x0028, 0x7027);
Tag const VisualEvaluationTestSequence(0x0028, 0x7028);
Tag const TestResult(0x0028, 0x7029);
Tag const TestResultComment(0x0028, 0x702a);
Tag const TestImageValidation(0x0028, 0x702b);
Tag const TestPatternCodeSequence(0x0028, 0x702c);
Tag const MeasurementPatternCodeSequence(0x0028, 0x702d);
Tag const VisualEvaluationMethodCodeSequence(0x0028, 0x702e);
Tag const PixelDataProviderURL(0x0028, 0x7fe0);
Tag const DataPointRows(0x0028, 0x9001);
Tag const DataPointColumns(0x0028, 0x9002);
Tag const SignalDomainColumns(0x0028, 0x9003);
Tag const LargestMonochromePixelValue(0x0028, 0x9099);
Tag const DataRepresentation(0x0028, 0x9108);
Tag const PixelMeasuresSequence(0x0028, 0x9110);
Tag const FrameVOILUTSequence(0x0028, 0x9132);
Tag const PixelValueTransformationSequence(0x0028, 0x9145);
Tag const SignalDomainRows(0x0028, 0x9235);
Tag const DisplayFilterPercentage(0x0028, 0x9411);
Tag const FramePixelShiftSequence(0x0028, 0x9415);
Tag const SubtractionItemID(0x0028, 0x9416);
Tag const PixelIntensityRelationshipLUTSequence(0x0028, 0x9422);
Tag const FramePixelDataPropertiesSequence(0x0028, 0x9443);
Tag const GeometricalProperties(0x0028, 0x9444);
Tag const GeometricMaximumDistortion(0x0028, 0x9445);
Tag const ImageProcessingApplied(0x0028, 0x9446);
Tag const MaskSelectionMode(0x0028, 0x9454);
Tag const LUTFunction(0x0028, 0x9474);
Tag const MaskVisibilityPercentage(0x0028, 0x9478);
Tag const PixelShiftSequence(0x0028, 0x9501);
Tag const RegionPixelShiftSequence(0x0028, 0x9502);
Tag const VerticesOfTheRegion(0x0028, 0x9503);
Tag const MultiFramePresentationSequence(0x0028, 0x9505);
Tag const PixelShiftFrameRange(0x0028, 0x9506);
Tag const LUTFrameRange(0x0028, 0x9507);
Tag const ImageToEquipmentMappingMatrix(0x0028, 0x9520);
Tag const EquipmentCoordinateSystemIdentification(0x0028, 0x9537);
Tag const StudyStatusID(0x0032, 0x000a);
Tag const StudyPriorityID(0x0032, 0x000c);
Tag const StudyIDIssuer(0x0032, 0x0012);
Tag const StudyVerifiedDate(0x0032, 0x0032);
Tag const StudyVerifiedTime(0x0032, 0x0033);
Tag const StudyReadDate(0x0032, 0x0034);
Tag const StudyReadTime(0x0032, 0x0035);
Tag const ScheduledStudyStartDate(0x0032, 0x1000);
Tag const ScheduledStudyStartTime(0x0032, 0x1001);
Tag const ScheduledStudyStopDate(0x0032, 0x1010);
Tag const ScheduledStudyStopTime(0x0032, 0x1011);
Tag const ScheduledStudyLocation(0x0032, 0x1020);
Tag const ScheduledStudyLocationAETitle(0x0032, 0x1021);
Tag const ReasonForStudy(0x0032, 0x1030);
Tag const RequestingPhysicianIdentificationSequence(0x0032, 0x1031);
Tag const RequestingPhysician(0x0032, 0x1032);
Tag const RequestingService(0x0032, 0x1033);
Tag const RequestingServiceCodeSequence(0x0032, 0x1034);
Tag const StudyArrivalDate(0x0032, 0x1040);
Tag const StudyArrivalTime(0x0032, 0x1041);
Tag const StudyCompletionDate(0x0032, 0x1050);
Tag const StudyCompletionTime(0x0032, 0x1051);
Tag const StudyComponentStatusID(0x0032, 0x1055);
Tag const RequestedProcedureDescription(0x0032, 0x1060);
Tag const RequestedProcedureCodeSequence(0x0032, 0x1064);
Tag const RequestedContrastAgent(0x0032, 0x1070);
Tag const StudyComments(0x0032, 0x4000);
Tag const ReferencedPatientAliasSequence(0x0038, 0x0004);
Tag const VisitStatusID(0x0038, 0x0008);
Tag const AdmissionID(0x0038, 0x0010);
Tag const IssuerOfAdmissionID(0x0038, 0x0011);
Tag const IssuerOfAdmissionIDSequence(0x0038, 0x0014);
Tag const RouteOfAdmissions(0x0038, 0x0016);
Tag const ScheduledAdmissionDate(0x0038, 0x001a);
Tag const ScheduledAdmissionTime(0x0038, 0x001b);
Tag const ScheduledDischargeDate(0x0038, 0x001c);
Tag const ScheduledDischargeTime(0x0038, 0x001d);
Tag const ScheduledPatientInstitutionResidence(0x0038, 0x001e);
Tag const AdmittingDate(0x0038, 0x0020);
Tag const AdmittingTime(0x0038, 0x0021);
Tag const DischargeDate(0x0038, 0x0030);
Tag const DischargeTime(0x0038, 0x0032);
Tag const DischargeDiagnosisDescription(0x0038, 0x0040);
Tag const DischargeDiagnosisCodeSequence(0x0038, 0x0044);
Tag const SpecialNeeds(0x0038, 0x0050);
Tag const ServiceEpisodeID(0x0038, 0x0060);
Tag const IssuerOfServiceEpisodeID(0x0038, 0x0061);
Tag const ServiceEpisodeDescription(0x0038, 0x0062);
Tag const IssuerOfServiceEpisodeIDSequence(0x0038, 0x0064);
Tag const PertinentDocumentsSequence(0x0038, 0x0100);
Tag const PertinentResourcesSequence(0x0038, 0x0101);
Tag const ResourceDescription(0x0038, 0x0102);
Tag const CurrentPatientLocation(0x0038, 0x0300);
Tag const PatientInstitutionResidence(0x0038, 0x0400);
Tag const PatientState(0x0038, 0x0500);
Tag const PatientClinicalTrialParticipationSequence(0x0038, 0x0502);
Tag const VisitComments(0x0038, 0x4000);
Tag const WaveformOriginality(0x003a, 0x0004);
Tag const NumberOfWaveformChannels(0x003a, 0x0005);
Tag const NumberOfWaveformSamples(0x003a, 0x0010);
Tag const SamplingFrequency(0x003a, 0x001a);
Tag const MultiplexGroupLabel(0x003a, 0x0020);
Tag const ChannelDefinitionSequence(0x003a, 0x0200);
Tag const WaveformChannelNumber(0x003a, 0x0202);
Tag const ChannelLabel(0x003a, 0x0203);
Tag const ChannelStatus(0x003a, 0x0205);
Tag const ChannelSourceSequence(0x003a, 0x0208);
Tag const ChannelSourceModifiersSequence(0x003a, 0x0209);
Tag const SourceWaveformSequence(0x003a, 0x020a);
Tag const ChannelDerivationDescription(0x003a, 0x020c);
Tag const ChannelSensitivity(0x003a, 0x0210);
Tag const ChannelSensitivityUnitsSequence(0x003a, 0x0211);
Tag const ChannelSensitivityCorrectionFactor(0x003a, 0x0212);
Tag const ChannelBaseline(0x003a, 0x0213);
Tag const ChannelTimeSkew(0x003a, 0x0214);
Tag const ChannelSampleSkew(0x003a, 0x0215);
Tag const ChannelOffset(0x003a, 0x0218);
Tag const WaveformBitsStored(0x003a, 0x021a);
Tag const FilterLowFrequency(0x003a, 0x0220);
Tag const FilterHighFrequency(0x003a, 0x0221);
Tag const NotchFilterFrequency(0x003a, 0x0222);
Tag const NotchFilterBandwidth(0x003a, 0x0223);
Tag const WaveformDataDisplayScale(0x003a, 0x0230);
Tag const WaveformDisplayBackgroundCIELabValue(0x003a, 0x0231);
Tag const WaveformPresentationGroupSequence(0x003a, 0x0240);
Tag const PresentationGroupNumber(0x003a, 0x0241);
Tag const ChannelDisplaySequence(0x003a, 0x0242);
Tag const ChannelRecommendedDisplayCIELabValue(0x003a, 0x0244);
Tag const ChannelPosition(0x003a, 0x0245);
Tag const DisplayShadingFlag(0x003a, 0x0246);
Tag const FractionalChannelDisplayScale(0x003a, 0x0247);
Tag const AbsoluteChannelDisplayScale(0x003a, 0x0248);
Tag const MultiplexedAudioChannelsDescriptionCodeSequence(0x003a, 0x0300);
Tag const ChannelIdentificationCode(0x003a, 0x0301);
Tag const ChannelMode(0x003a, 0x0302);
Tag const ScheduledStationAETitle(0x0040, 0x0001);
Tag const ScheduledProcedureStepStartDate(0x0040, 0x0002);
Tag const ScheduledProcedureStepStartTime(0x0040, 0x0003);
Tag const ScheduledProcedureStepEndDate(0x0040, 0x0004);
Tag const ScheduledProcedureStepEndTime(0x0040, 0x0005);
Tag const ScheduledPerformingPhysicianName(0x0040, 0x0006);
Tag const ScheduledProcedureStepDescription(0x0040, 0x0007);
Tag const ScheduledProtocolCodeSequence(0x0040, 0x0008);
Tag const ScheduledProcedureStepID(0x0040, 0x0009);
Tag const StageCodeSequence(0x0040, 0x000a);
Tag const ScheduledPerformingPhysicianIdentificationSequence(0x0040, 0x000b);
Tag const ScheduledStationName(0x0040, 0x0010);
Tag const ScheduledProcedureStepLocation(0x0040, 0x0011);
Tag const PreMedication(0x0040, 0x0012);
Tag const ScheduledProcedureStepStatus(0x0040, 0x0020);
Tag const OrderPlacerIdentifierSequence(0x0040, 0x0026);
Tag const OrderFillerIdentifierSequence(0x0040, 0x0027);
Tag const LocalNamespaceEntityID(0x0040, 0x0031);
Tag const UniversalEntityID(0x0040, 0x0032);
Tag const UniversalEntityIDType(0x0040, 0x0033);
Tag const IdentifierTypeCode(0x0040, 0x0035);
Tag const AssigningFacilitySequence(0x0040, 0x0036);
Tag const AssigningJurisdictionCodeSequence(0x0040, 0x0039);
Tag const AssigningAgencyOrDepartmentCodeSequence(0x0040, 0x003a);
Tag const ScheduledProcedureStepSequence(0x0040, 0x0100);
Tag const ReferencedNonImageCompositeSOPInstanceSequence(0x0040, 0x0220);
Tag const PerformedStationAETitle(0x0040, 0x0241);
Tag const PerformedStationName(0x0040, 0x0242);
Tag const PerformedLocation(0x0040, 0x0243);
Tag const PerformedProcedureStepStartDate(0x0040, 0x0244);
Tag const PerformedProcedureStepStartTime(0x0040, 0x0245);
Tag const PerformedProcedureStepEndDate(0x0040, 0x0250);
Tag const PerformedProcedureStepEndTime(0x0040, 0x0251);
Tag const PerformedProcedureStepStatus(0x0040, 0x0252);
Tag const PerformedProcedureStepID(0x0040, 0x0253);
Tag const PerformedProcedureStepDescription(0x0040, 0x0254);
Tag const PerformedProcedureTypeDescription(0x0040, 0x0255);
Tag const PerformedProtocolCodeSequence(0x0040, 0x0260);
Tag const PerformedProtocolType(0x0040, 0x0261);
Tag const ScheduledStepAttributesSequence(0x0040, 0x0270);
Tag const RequestAttributesSequence(0x0040, 0x0275);
Tag const CommentsOnThePerformedProcedureStep(0x0040, 0x0280);
Tag const PerformedProcedureStepDiscontinuationReasonCodeSequence(0x0040, 0x0281);
Tag const QuantitySequence(0x0040, 0x0293);
Tag const Quantity(0x0040, 0x0294);
Tag const MeasuringUnitsSequence(0x0040, 0x0295);
Tag const BillingItemSequence(0x0040, 0x0296);
Tag const TotalTimeOfFluoroscopy(0x0040, 0x0300);
Tag const TotalNumberOfExposures(0x0040, 0x0301);
Tag const EntranceDose(0x0040, 0x0302);
Tag const ExposedArea(0x0040, 0x0303);
Tag const DistanceSourceToEntrance(0x0040, 0x0306);
Tag const DistanceSourceToSupport(0x0040, 0x0307);
Tag const ExposureDoseSequence(0x0040, 0x030e);
Tag const CommentsOnRadiationDose(0x0040, 0x0310);
Tag const XRayOutput(0x0040, 0x0312);
Tag const HalfValueLayer(0x0040, 0x0314);
Tag const OrganDose(0x0040, 0x0316);
Tag const OrganExposed(0x0040, 0x0318);
Tag const BillingProcedureStepSequence(0x0040, 0x0320);
Tag const FilmConsumptionSequence(0x0040, 0x0321);
Tag const BillingSuppliesAndDevicesSequence(0x0040, 0x0324);
Tag const ReferencedProcedureStepSequence(0x0040, 0x0330);
Tag const PerformedSeriesSequence(0x0040, 0x0340);
Tag const CommentsOnTheScheduledProcedureStep(0x0040, 0x0400);
Tag const ProtocolContextSequence(0x0040, 0x0440);
Tag const ContentItemModifierSequence(0x0040, 0x0441);
Tag const ScheduledSpecimenSequence(0x0040, 0x0500);
Tag const SpecimenAccessionNumber(0x0040, 0x050a);
Tag const ContainerIdentifier(0x0040, 0x0512);
Tag const IssuerOfTheContainerIdentifierSequence(0x0040, 0x0513);
Tag const AlternateContainerIdentifierSequence(0x0040, 0x0515);
Tag const ContainerTypeCodeSequence(0x0040, 0x0518);
Tag const ContainerDescription(0x0040, 0x051a);
Tag const ContainerComponentSequence(0x0040, 0x0520);
Tag const SpecimenSequence(0x0040, 0x0550);
Tag const SpecimenIdentifier(0x0040, 0x0551);
Tag const SpecimenDescriptionSequenceTrial(0x0040, 0x0552);
Tag const SpecimenDescriptionTrial(0x0040, 0x0553);
Tag const SpecimenUID(0x0040, 0x0554);
Tag const AcquisitionContextSequence(0x0040, 0x0555);
Tag const AcquisitionContextDescription(0x0040, 0x0556);
Tag const SpecimenTypeCodeSequence(0x0040, 0x059a);
Tag const SpecimenDescriptionSequence(0x0040, 0x0560);
Tag const IssuerOfTheSpecimenIdentifierSequence(0x0040, 0x0562);
Tag const SpecimenShortDescription(0x0040, 0x0600);
Tag const SpecimenDetailedDescription(0x0040, 0x0602);
Tag const SpecimenPreparationSequence(0x0040, 0x0610);
Tag const SpecimenPreparationStepContentItemSequence(0x0040, 0x0612);
Tag const SpecimenLocalizationContentItemSequence(0x0040, 0x0620);
Tag const SlideIdentifier(0x0040, 0x06fa);
Tag const ImageCenterPointCoordinatesSequence(0x0040, 0x071a);
Tag const XOffsetInSlideCoordinateSystem(0x0040, 0x072a);
Tag const YOffsetInSlideCoordinateSystem(0x0040, 0x073a);
Tag const ZOffsetInSlideCoordinateSystem(0x0040, 0x074a);
Tag const PixelSpacingSequence(0x0040, 0x08d8);
Tag const CoordinateSystemAxisCodeSequence(0x0040, 0x08da);
Tag const MeasurementUnitsCodeSequence(0x0040, 0x08ea);
Tag const VitalStainCodeSequenceTrial(0x0040, 0x09f8);
Tag const RequestedProcedureID(0x0040, 0x1001);
Tag const ReasonForTheRequestedProcedure(0x0040, 0x1002);
Tag const RequestedProcedurePriority(0x0040, 0x1003);
Tag const PatientTransportArrangements(0x0040, 0x1004);
Tag const RequestedProcedureLocation(0x0040, 0x1005);
Tag const PlacerOrderNumberProcedure(0x0040, 0x1006);
Tag const FillerOrderNumberProcedure(0x0040, 0x1007);
Tag const ConfidentialityCode(0x0040, 0x1008);
Tag const ReportingPriority(0x0040, 0x1009);
Tag const ReasonForRequestedProcedureCodeSequence(0x0040, 0x100a);
Tag const NamesOfIntendedRecipientsOfResults(0x0040, 0x1010);
Tag const IntendedRecipientsOfResultsIdentificationSequence(0x0040, 0x1011);
Tag const ReasonForPerformedProcedureCodeSequence(0x0040, 0x1012);
Tag const RequestedProcedureDescriptionTrial(0x0040, 0x1060);
Tag const PersonIdentificationCodeSequence(0x0040, 0x1101);
Tag const PersonAddress(0x0040, 0x1102);
Tag const PersonTelephoneNumbers(0x0040, 0x1103);
Tag const PersonTelecomInformation(0x0040, 0x1104);
Tag const RequestedProcedureComments(0x0040, 0x1400);
Tag const ReasonForTheImagingServiceRequest(0x0040, 0x2001);
Tag const IssueDateOfImagingServiceRequest(0x0040, 0x2004);
Tag const IssueTimeOfImagingServiceRequest(0x0040, 0x2005);
Tag const PlacerOrderNumberImagingServiceRequestRetired(0x0040, 0x2006);
Tag const FillerOrderNumberImagingServiceRequestRetired(0x0040, 0x2007);
Tag const OrderEnteredBy(0x0040, 0x2008);
Tag const OrderEntererLocation(0x0040, 0x2009);
Tag const OrderCallbackPhoneNumber(0x0040, 0x2010);
Tag const OrderCallbackTelecomInformation(0x0040, 0x2011);
Tag const PlacerOrderNumberImagingServiceRequest(0x0040, 0x2016);
Tag const FillerOrderNumberImagingServiceRequest(0x0040, 0x2017);
Tag const ImagingServiceRequestComments(0x0040, 0x2400);
Tag const ConfidentialityConstraintOnPatientDataDescription(0x0040, 0x3001);
Tag const GeneralPurposeScheduledProcedureStepStatus(0x0040, 0x4001);
Tag const GeneralPurposePerformedProcedureStepStatus(0x0040, 0x4002);
Tag const GeneralPurposeScheduledProcedureStepPriority(0x0040, 0x4003);
Tag const ScheduledProcessingApplicationsCodeSequence(0x0040, 0x4004);
Tag const ScheduledProcedureStepStartDateTime(0x0040, 0x4005);
Tag const MultipleCopiesFlag(0x0040, 0x4006);
Tag const PerformedProcessingApplicationsCodeSequence(0x0040, 0x4007);
Tag const HumanPerformerCodeSequence(0x0040, 0x4009);
Tag const ScheduledProcedureStepModificationDateTime(0x0040, 0x4010);
Tag const ExpectedCompletionDateTime(0x0040, 0x4011);
Tag const ResultingGeneralPurposePerformedProcedureStepsSequence(0x0040, 0x4015);
Tag const ReferencedGeneralPurposeScheduledProcedureStepSequence(0x0040, 0x4016);
Tag const ScheduledWorkitemCodeSequence(0x0040, 0x4018);
Tag const PerformedWorkitemCodeSequence(0x0040, 0x4019);
Tag const InputAvailabilityFlag(0x0040, 0x4020);
Tag const InputInformationSequence(0x0040, 0x4021);
Tag const RelevantInformationSequence(0x0040, 0x4022);
Tag const ReferencedGeneralPurposeScheduledProcedureStepTransactionUID(0x0040, 0x4023);
Tag const ScheduledStationNameCodeSequence(0x0040, 0x4025);
Tag const ScheduledStationClassCodeSequence(0x0040, 0x4026);
Tag const ScheduledStationGeographicLocationCodeSequence(0x0040, 0x4027);
Tag const PerformedStationNameCodeSequence(0x0040, 0x4028);
Tag const PerformedStationClassCodeSequence(0x0040, 0x4029);
Tag const PerformedStationGeographicLocationCodeSequence(0x0040, 0x4030);
Tag const RequestedSubsequentWorkitemCodeSequence(0x0040, 0x4031);
Tag const NonDICOMOutputCodeSequence(0x0040, 0x4032);
Tag const OutputInformationSequence(0x0040, 0x4033);
Tag const ScheduledHumanPerformersSequence(0x0040, 0x4034);
Tag const ActualHumanPerformersSequence(0x0040, 0x4035);
Tag const HumanPerformerOrganization(0x0040, 0x4036);
Tag const HumanPerformerName(0x0040, 0x4037);
Tag const RawDataHandling(0x0040, 0x4040);
Tag const InputReadinessState(0x0040, 0x4041);
Tag const PerformedProcedureStepStartDateTime(0x0040, 0x4050);
Tag const PerformedProcedureStepEndDateTime(0x0040, 0x4051);
Tag const ProcedureStepCancellationDateTime(0x0040, 0x4052);
Tag const EntranceDoseInmGy(0x0040, 0x8302);
Tag const ParametricMapFrameTypeSequence(0x0040, 0x9092);
Tag const ReferencedImageRealWorldValueMappingSequence(0x0040, 0x9094);
Tag const RealWorldValueMappingSequence(0x0040, 0x9096);
Tag const PixelValueMappingCodeSequence(0x0040, 0x9098);
Tag const LUTLabel(0x0040, 0x9210);
Tag const RealWorldValueLastValueMapped(0x0040, 0x9211);
Tag const RealWorldValueLUTData(0x0040, 0x9212);
Tag const RealWorldValueFirstValueMapped(0x0040, 0x9216);
Tag const QuantityDefinitionSequence(0x0040, 0x9220);
Tag const RealWorldValueIntercept(0x0040, 0x9224);
Tag const RealWorldValueSlope(0x0040, 0x9225);
Tag const FindingsFlagTrial(0x0040, 0xa007);
Tag const RelationshipType(0x0040, 0xa010);
Tag const FindingsSequenceTrial(0x0040, 0xa020);
Tag const FindingsGroupUIDTrial(0x0040, 0xa021);
Tag const ReferencedFindingsGroupUIDTrial(0x0040, 0xa022);
Tag const FindingsGroupRecordingDateTrial(0x0040, 0xa023);
Tag const FindingsGroupRecordingTimeTrial(0x0040, 0xa024);
Tag const FindingsSourceCategoryCodeSequenceTrial(0x0040, 0xa026);
Tag const VerifyingOrganization(0x0040, 0xa027);
Tag const DocumentingOrganizationIdentifierCodeSequenceTrial(0x0040, 0xa028);
Tag const VerificationDateTime(0x0040, 0xa030);
Tag const ObservationDateTime(0x0040, 0xa032);
Tag const ValueType(0x0040, 0xa040);
Tag const ConceptNameCodeSequence(0x0040, 0xa043);
Tag const MeasurementPrecisionDescriptionTrial(0x0040, 0xa047);
Tag const ContinuityOfContent(0x0040, 0xa050);
Tag const UrgencyOrPriorityAlertsTrial(0x0040, 0xa057);
Tag const SequencingIndicatorTrial(0x0040, 0xa060);
Tag const DocumentIdentifierCodeSequenceTrial(0x0040, 0xa066);
Tag const DocumentAuthorTrial(0x0040, 0xa067);
Tag const DocumentAuthorIdentifierCodeSequenceTrial(0x0040, 0xa068);
Tag const IdentifierCodeSequenceTrial(0x0040, 0xa070);
Tag const VerifyingObserverSequence(0x0040, 0xa073);
Tag const ObjectBinaryIdentifierTrial(0x0040, 0xa074);
Tag const VerifyingObserverName(0x0040, 0xa075);
Tag const DocumentingObserverIdentifierCodeSequenceTrial(0x0040, 0xa076);
Tag const AuthorObserverSequence(0x0040, 0xa078);
Tag const ParticipantSequence(0x0040, 0xa07a);
Tag const CustodialOrganizationSequence(0x0040, 0xa07c);
Tag const ParticipationType(0x0040, 0xa080);
Tag const ParticipationDateTime(0x0040, 0xa082);
Tag const ObserverType(0x0040, 0xa084);
Tag const ProcedureIdentifierCodeSequenceTrial(0x0040, 0xa085);
Tag const VerifyingObserverIdentificationCodeSequence(0x0040, 0xa088);
Tag const ObjectDirectoryBinaryIdentifierTrial(0x0040, 0xa089);
Tag const EquivalentCDADocumentSequence(0x0040, 0xa090);
Tag const ReferencedWaveformChannels(0x0040, 0xa0b0);
Tag const DateOfDocumentOrVerbalTransactionTrial(0x0040, 0xa110);
Tag const TimeOfDocumentCreationOrVerbalTransactionTrial(0x0040, 0xa112);
Tag const DateTime(0x0040, 0xa120);
Tag const Date(0x0040, 0xa121);
Tag const Time(0x0040, 0xa122);
Tag const PersonName(0x0040, 0xa123);
Tag const UID(0x0040, 0xa124);
Tag const ReportStatusIDTrial(0x0040, 0xa125);
Tag const TemporalRangeType(0x0040, 0xa130);
Tag const ReferencedSamplePositions(0x0040, 0xa132);
Tag const ReferencedFrameNumbers(0x0040, 0xa136);
Tag const ReferencedTimeOffsets(0x0040, 0xa138);
Tag const ReferencedDateTime(0x0040, 0xa13a);
Tag const TextValue(0x0040, 0xa160);
Tag const FloatingPointValue(0x0040, 0xa161);
Tag const RationalNumeratorValue(0x0040, 0xa162);
Tag const RationalDenominatorValue(0x0040, 0xa163);
Tag const ObservationCategoryCodeSequenceTrial(0x0040, 0xa167);
Tag const ConceptCodeSequence(0x0040, 0xa168);
Tag const BibliographicCitationTrial(0x0040, 0xa16a);
Tag const PurposeOfReferenceCodeSequence(0x0040, 0xa170);
Tag const ObservationUID(0x0040, 0xa171);
Tag const ReferencedObservationUIDTrial(0x0040, 0xa172);
Tag const ReferencedObservationClassTrial(0x0040, 0xa173);
Tag const ReferencedObjectObservationClassTrial(0x0040, 0xa174);
Tag const AnnotationGroupNumber(0x0040, 0xa180);
Tag const ObservationDateTrial(0x0040, 0xa192);
Tag const ObservationTimeTrial(0x0040, 0xa193);
Tag const MeasurementAutomationTrial(0x0040, 0xa194);
Tag const ModifierCodeSequence(0x0040, 0xa195);
Tag const IdentificationDescriptionTrial(0x0040, 0xa224);
Tag const CoordinatesSetGeometricTypeTrial(0x0040, 0xa290);
Tag const AlgorithmCodeSequenceTrial(0x0040, 0xa296);
Tag const AlgorithmDescriptionTrial(0x0040, 0xa297);
Tag const PixelCoordinatesSetTrial(0x0040, 0xa29a);
Tag const MeasuredValueSequence(0x0040, 0xa300);
Tag const NumericValueQualifierCodeSequence(0x0040, 0xa301);
Tag const CurrentObserverTrial(0x0040, 0xa307);
Tag const NumericValue(0x0040, 0xa30a);
Tag const ReferencedAccessionSequenceTrial(0x0040, 0xa313);
Tag const ReportStatusCommentTrial(0x0040, 0xa33a);
Tag const ProcedureContextSequenceTrial(0x0040, 0xa340);
Tag const VerbalSourceTrial(0x0040, 0xa352);
Tag const AddressTrial(0x0040, 0xa353);
Tag const TelephoneNumberTrial(0x0040, 0xa354);
Tag const VerbalSourceIdentifierCodeSequenceTrial(0x0040, 0xa358);
Tag const PredecessorDocumentsSequence(0x0040, 0xa360);
Tag const ReferencedRequestSequence(0x0040, 0xa370);
Tag const PerformedProcedureCodeSequence(0x0040, 0xa372);
Tag const CurrentRequestedProcedureEvidenceSequence(0x0040, 0xa375);
Tag const ReportDetailSequenceTrial(0x0040, 0xa380);
Tag const PertinentOtherEvidenceSequence(0x0040, 0xa385);
Tag const HL7StructuredDocumentReferenceSequence(0x0040, 0xa390);
Tag const ObservationSubjectUIDTrial(0x0040, 0xa402);
Tag const ObservationSubjectClassTrial(0x0040, 0xa403);
Tag const ObservationSubjectTypeCodeSequenceTrial(0x0040, 0xa404);
Tag const CompletionFlag(0x0040, 0xa491);
Tag const CompletionFlagDescription(0x0040, 0xa492);
Tag const VerificationFlag(0x0040, 0xa493);
Tag const ArchiveRequested(0x0040, 0xa494);
Tag const PreliminaryFlag(0x0040, 0xa496);
Tag const ContentTemplateSequence(0x0040, 0xa504);
Tag const IdenticalDocumentsSequence(0x0040, 0xa525);
Tag const ObservationSubjectContextFlagTrial(0x0040, 0xa600);
Tag const ObserverContextFlagTrial(0x0040, 0xa601);
Tag const ProcedureContextFlagTrial(0x0040, 0xa603);
Tag const ContentSequence(0x0040, 0xa730);
Tag const RelationshipSequenceTrial(0x0040, 0xa731);
Tag const RelationshipTypeCodeSequenceTrial(0x0040, 0xa732);
Tag const LanguageCodeSequenceTrial(0x0040, 0xa744);
Tag const UniformResourceLocatorTrial(0x0040, 0xa992);
Tag const WaveformAnnotationSequence(0x0040, 0xb020);
Tag const TemplateIdentifier(0x0040, 0xdb00);
Tag const TemplateVersion(0x0040, 0xdb06);
Tag const TemplateLocalVersion(0x0040, 0xdb07);
Tag const TemplateExtensionFlag(0x0040, 0xdb0b);
Tag const TemplateExtensionOrganizationUID(0x0040, 0xdb0c);
Tag const TemplateExtensionCreatorUID(0x0040, 0xdb0d);
Tag const ReferencedContentItemIdentifier(0x0040, 0xdb73);
Tag const HL7InstanceIdentifier(0x0040, 0xe001);
Tag const HL7DocumentEffectiveTime(0x0040, 0xe004);
Tag const HL7DocumentTypeCodeSequence(0x0040, 0xe006);
Tag const DocumentClassCodeSequence(0x0040, 0xe008);
Tag const RetrieveURI(0x0040, 0xe010);
Tag const RetrieveLocationUID(0x0040, 0xe011);
Tag const TypeOfInstances(0x0040, 0xe020);
Tag const DICOMRetrievalSequence(0x0040, 0xe021);
Tag const DICOMMediaRetrievalSequence(0x0040, 0xe022);
Tag const WADORetrievalSequence(0x0040, 0xe023);
Tag const XDSRetrievalSequence(0x0040, 0xe024);
Tag const WADORSRetrievalSequence(0x0040, 0xe025);
Tag const RepositoryUniqueID(0x0040, 0xe030);
Tag const HomeCommunityID(0x0040, 0xe031);
Tag const DocumentTitle(0x0042, 0x0010);
Tag const EncapsulatedDocument(0x0042, 0x0011);
Tag const MIMETypeOfEncapsulatedDocument(0x0042, 0x0012);
Tag const SourceInstanceSequence(0x0042, 0x0013);
Tag const ListOfMIMETypes(0x0042, 0x0014);
Tag const ProductPackageIdentifier(0x0044, 0x0001);
Tag const SubstanceAdministrationApproval(0x0044, 0x0002);
Tag const ApprovalStatusFurtherDescription(0x0044, 0x0003);
Tag const ApprovalStatusDateTime(0x0044, 0x0004);
Tag const ProductTypeCodeSequence(0x0044, 0x0007);
Tag const ProductName(0x0044, 0x0008);
Tag const ProductDescription(0x0044, 0x0009);
Tag const ProductLotIdentifier(0x0044, 0x000a);
Tag const ProductExpirationDateTime(0x0044, 0x000b);
Tag const SubstanceAdministrationDateTime(0x0044, 0x0010);
Tag const SubstanceAdministrationNotes(0x0044, 0x0011);
Tag const SubstanceAdministrationDeviceID(0x0044, 0x0012);
Tag const ProductParameterSequence(0x0044, 0x0013);
Tag const SubstanceAdministrationParameterSequence(0x0044, 0x0019);
Tag const LensDescription(0x0046, 0x0012);
Tag const RightLensSequence(0x0046, 0x0014);
Tag const LeftLensSequence(0x0046, 0x0015);
Tag const UnspecifiedLateralityLensSequence(0x0046, 0x0016);
Tag const CylinderSequence(0x0046, 0x0018);
Tag const PrismSequence(0x0046, 0x0028);
Tag const HorizontalPrismPower(0x0046, 0x0030);
Tag const HorizontalPrismBase(0x0046, 0x0032);
Tag const VerticalPrismPower(0x0046, 0x0034);
Tag const VerticalPrismBase(0x0046, 0x0036);
Tag const LensSegmentType(0x0046, 0x0038);
Tag const OpticalTransmittance(0x0046, 0x0040);
Tag const ChannelWidth(0x0046, 0x0042);
Tag const PupilSize(0x0046, 0x0044);
Tag const CornealSize(0x0046, 0x0046);
Tag const AutorefractionRightEyeSequence(0x0046, 0x0050);
Tag const AutorefractionLeftEyeSequence(0x0046, 0x0052);
Tag const DistancePupillaryDistance(0x0046, 0x0060);
Tag const NearPupillaryDistance(0x0046, 0x0062);
Tag const IntermediatePupillaryDistance(0x0046, 0x0063);
Tag const OtherPupillaryDistance(0x0046, 0x0064);
Tag const KeratometryRightEyeSequence(0x0046, 0x0070);
Tag const KeratometryLeftEyeSequence(0x0046, 0x0071);
Tag const SteepKeratometricAxisSequence(0x0046, 0x0074);
Tag const RadiusOfCurvature(0x0046, 0x0075);
Tag const KeratometricPower(0x0046, 0x0076);
Tag const KeratometricAxis(0x0046, 0x0077);
Tag const FlatKeratometricAxisSequence(0x0046, 0x0080);
Tag const BackgroundColor(0x0046, 0x0092);
Tag const Optotype(0x0046, 0x0094);
Tag const OptotypePresentation(0x0046, 0x0095);
Tag const SubjectiveRefractionRightEyeSequence(0x0046, 0x0097);
Tag const SubjectiveRefractionLeftEyeSequence(0x0046, 0x0098);
Tag const AddNearSequence(0x0046, 0x0100);
Tag const AddIntermediateSequence(0x0046, 0x0101);
Tag const AddOtherSequence(0x0046, 0x0102);
Tag const AddPower(0x0046, 0x0104);
Tag const ViewingDistance(0x0046, 0x0106);
Tag const VisualAcuityTypeCodeSequence(0x0046, 0x0121);
Tag const VisualAcuityRightEyeSequence(0x0046, 0x0122);
Tag const VisualAcuityLeftEyeSequence(0x0046, 0x0123);
Tag const VisualAcuityBothEyesOpenSequence(0x0046, 0x0124);
Tag const ViewingDistanceType(0x0046, 0x0125);
Tag const VisualAcuityModifiers(0x0046, 0x0135);
Tag const DecimalVisualAcuity(0x0046, 0x0137);
Tag const OptotypeDetailedDefinition(0x0046, 0x0139);
Tag const ReferencedRefractiveMeasurementsSequence(0x0046, 0x0145);
Tag const SpherePower(0x0046, 0x0146);
Tag const CylinderPower(0x0046, 0x0147);
Tag const CornealTopographySurface(0x0046, 0x0201);
Tag const CornealVertexLocation(0x0046, 0x0202);
Tag const PupilCentroidXCoordinate(0x0046, 0x0203);
Tag const PupilCentroidYCoordinate(0x0046, 0x0204);
Tag const EquivalentPupilRadius(0x0046, 0x0205);
Tag const CornealTopographyMapTypeCodeSequence(0x0046, 0x0207);
Tag const VerticesOfTheOutlineOfPupil(0x0046, 0x0208);
Tag const CornealTopographyMappingNormalsSequence(0x0046, 0x0210);
Tag const MaximumCornealCurvatureSequence(0x0046, 0x0211);
Tag const MaximumCornealCurvature(0x0046, 0x0212);
Tag const MaximumCornealCurvatureLocation(0x0046, 0x0213);
Tag const MinimumKeratometricSequence(0x0046, 0x0215);
Tag const SimulatedKeratometricCylinderSequence(0x0046, 0x0218);
Tag const AverageCornealPower(0x0046, 0x0220);
Tag const CornealISValue(0x0046, 0x0224);
Tag const AnalyzedArea(0x0046, 0x0227);
Tag const SurfaceRegularityIndex(0x0046, 0x0230);
Tag const SurfaceAsymmetryIndex(0x0046, 0x0232);
Tag const CornealEccentricityIndex(0x0046, 0x0234);
Tag const KeratoconusPredictionIndex(0x0046, 0x0236);
Tag const DecimalPotentialVisualAcuity(0x0046, 0x0238);
Tag const CornealTopographyMapQualityEvaluation(0x0046, 0x0242);
Tag const SourceImageCornealProcessedDataSequence(0x0046, 0x0244);
Tag const CornealPointLocation(0x0046, 0x0247);
Tag const CornealPointEstimated(0x0046, 0x0248);
Tag const AxialPower(0x0046, 0x0249);
Tag const TangentialPower(0x0046, 0x0250);
Tag const RefractivePower(0x0046, 0x0251);
Tag const RelativeElevation(0x0046, 0x0252);
Tag const CornealWavefront(0x0046, 0x0253);
Tag const ImagedVolumeWidth(0x0048, 0x0001);
Tag const ImagedVolumeHeight(0x0048, 0x0002);
Tag const ImagedVolumeDepth(0x0048, 0x0003);
Tag const TotalPixelMatrixColumns(0x0048, 0x0006);
Tag const TotalPixelMatrixRows(0x0048, 0x0007);
Tag const TotalPixelMatrixOriginSequence(0x0048, 0x0008);
Tag const SpecimenLabelInImage(0x0048, 0x0010);
Tag const FocusMethod(0x0048, 0x0011);
Tag const ExtendedDepthOfField(0x0048, 0x0012);
Tag const NumberOfFocalPlanes(0x0048, 0x0013);
Tag const DistanceBetweenFocalPlanes(0x0048, 0x0014);
Tag const RecommendedAbsentPixelCIELabValue(0x0048, 0x0015);
Tag const IlluminatorTypeCodeSequence(0x0048, 0x0100);
Tag const ImageOrientationSlide(0x0048, 0x0102);
Tag const OpticalPathSequence(0x0048, 0x0105);
Tag const OpticalPathIdentifier(0x0048, 0x0106);
Tag const OpticalPathDescription(0x0048, 0x0107);
Tag const IlluminationColorCodeSequence(0x0048, 0x0108);
Tag const SpecimenReferenceSequence(0x0048, 0x0110);
Tag const CondenserLensPower(0x0048, 0x0111);
Tag const ObjectiveLensPower(0x0048, 0x0112);
Tag const ObjectiveLensNumericalAperture(0x0048, 0x0113);
Tag const PaletteColorLookupTableSequence(0x0048, 0x0120);
Tag const ReferencedImageNavigationSequence(0x0048, 0x0200);
Tag const TopLeftHandCornerOfLocalizerArea(0x0048, 0x0201);
Tag const BottomRightHandCornerOfLocalizerArea(0x0048, 0x0202);
Tag const OpticalPathIdentificationSequence(0x0048, 0x0207);
Tag const PlanePositionSlideSequence(0x0048, 0x021a);
Tag const ColumnPositionInTotalImagePixelMatrix(0x0048, 0x021e);
Tag const RowPositionInTotalImagePixelMatrix(0x0048, 0x021f);
Tag const PixelOriginInterpretation(0x0048, 0x0301);
Tag const CalibrationImage(0x0050, 0x0004);
Tag const DeviceSequence(0x0050, 0x0010);
Tag const ContainerComponentTypeCodeSequence(0x0050, 0x0012);
Tag const ContainerComponentThickness(0x0050, 0x0013);
Tag const DeviceLength(0x0050, 0x0014);
Tag const ContainerComponentWidth(0x0050, 0x0015);
Tag const DeviceDiameter(0x0050, 0x0016);
Tag const DeviceDiameterUnits(0x0050, 0x0017);
Tag const DeviceVolume(0x0050, 0x0018);
Tag const InterMarkerDistance(0x0050, 0x0019);
Tag const ContainerComponentMaterial(0x0050, 0x001a);
Tag const ContainerComponentID(0x0050, 0x001b);
Tag const ContainerComponentLength(0x0050, 0x001c);
Tag const ContainerComponentDiameter(0x0050, 0x001d);
Tag const ContainerComponentDescription(0x0050, 0x001e);
Tag const DeviceDescription(0x0050, 0x0020);
Tag const ContrastBolusIngredientPercentByVolume(0x0052, 0x0001);
Tag const OCTFocalDistance(0x0052, 0x0002);
Tag const BeamSpotSize(0x0052, 0x0003);
Tag const EffectiveRefractiveIndex(0x0052, 0x0004);
Tag const OCTAcquisitionDomain(0x0052, 0x0006);
Tag const OCTOpticalCenterWavelength(0x0052, 0x0007);
Tag const AxialResolution(0x0052, 0x0008);
Tag const RangingDepth(0x0052, 0x0009);
Tag const ALineRate(0x0052, 0x0011);
Tag const ALinesPerFrame(0x0052, 0x0012);
Tag const CatheterRotationalRate(0x0052, 0x0013);
Tag const ALinePixelSpacing(0x0052, 0x0014);
Tag const ModeOfPercutaneousAccessSequence(0x0052, 0x0016);
Tag const IntravascularOCTFrameTypeSequence(0x0052, 0x0025);
Tag const OCTZOffsetApplied(0x0052, 0x0026);
Tag const IntravascularFrameContentSequence(0x0052, 0x0027);
Tag const IntravascularLongitudinalDistance(0x0052, 0x0028);
Tag const IntravascularOCTFrameContentSequence(0x0052, 0x0029);
Tag const OCTZOffsetCorrection(0x0052, 0x0030);
Tag const CatheterDirectionOfRotation(0x0052, 0x0031);
Tag const SeamLineLocation(0x0052, 0x0033);
Tag const FirstALineLocation(0x0052, 0x0034);
Tag const SeamLineIndex(0x0052, 0x0036);
Tag const NumberOfPaddedALines(0x0052, 0x0038);
Tag const InterpolationType(0x0052, 0x0039);
Tag const RefractiveIndexApplied(0x0052, 0x003a);
Tag const EnergyWindowVector(0x0054, 0x0010);
Tag const NumberOfEnergyWindows(0x0054, 0x0011);
Tag const EnergyWindowInformationSequence(0x0054, 0x0012);
Tag const EnergyWindowRangeSequence(0x0054, 0x0013);
Tag const EnergyWindowLowerLimit(0x0054, 0x0014);
Tag const EnergyWindowUpperLimit(0x0054, 0x0015);
Tag const RadiopharmaceuticalInformationSequence(0x0054, 0x0016);
Tag const ResidualSyringeCounts(0x0054, 0x0017);
Tag const EnergyWindowName(0x0054, 0x0018);
Tag const DetectorVector(0x0054, 0x0020);
Tag const NumberOfDetectors(0x0054, 0x0021);
Tag const DetectorInformationSequence(0x0054, 0x0022);
Tag const PhaseVector(0x0054, 0x0030);
Tag const NumberOfPhases(0x0054, 0x0031);
Tag const PhaseInformationSequence(0x0054, 0x0032);
Tag const NumberOfFramesInPhase(0x0054, 0x0033);
Tag const PhaseDelay(0x0054, 0x0036);
Tag const PauseBetweenFrames(0x0054, 0x0038);
Tag const PhaseDescription(0x0054, 0x0039);
Tag const RotationVector(0x0054, 0x0050);
Tag const NumberOfRotations(0x0054, 0x0051);
Tag const RotationInformationSequence(0x0054, 0x0052);
Tag const NumberOfFramesInRotation(0x0054, 0x0053);
Tag const RRIntervalVector(0x0054, 0x0060);
Tag const NumberOfRRIntervals(0x0054, 0x0061);
Tag const GatedInformationSequence(0x0054, 0x0062);
Tag const DataInformationSequence(0x0054, 0x0063);
Tag const TimeSlotVector(0x0054, 0x0070);
Tag const NumberOfTimeSlots(0x0054, 0x0071);
Tag const TimeSlotInformationSequence(0x0054, 0x0072);
Tag const TimeSlotTime(0x0054, 0x0073);
Tag const SliceVector(0x0054, 0x0080);
Tag const NumberOfSlices(0x0054, 0x0081);
Tag const AngularViewVector(0x0054, 0x0090);
Tag const TimeSliceVector(0x0054, 0x0100);
Tag const NumberOfTimeSlices(0x0054, 0x0101);
Tag const StartAngle(0x0054, 0x0200);
Tag const TypeOfDetectorMotion(0x0054, 0x0202);
Tag const TriggerVector(0x0054, 0x0210);
Tag const NumberOfTriggersInPhase(0x0054, 0x0211);
Tag const ViewCodeSequence(0x0054, 0x0220);
Tag const ViewModifierCodeSequence(0x0054, 0x0222);
Tag const RadionuclideCodeSequence(0x0054, 0x0300);
Tag const AdministrationRouteCodeSequence(0x0054, 0x0302);
Tag const RadiopharmaceuticalCodeSequence(0x0054, 0x0304);
Tag const CalibrationDataSequence(0x0054, 0x0306);
Tag const EnergyWindowNumber(0x0054, 0x0308);
Tag const ImageID(0x0054, 0x0400);
Tag const PatientOrientationCodeSequence(0x0054, 0x0410);
Tag const PatientOrientationModifierCodeSequence(0x0054, 0x0412);
Tag const PatientGantryRelationshipCodeSequence(0x0054, 0x0414);
Tag const SliceProgressionDirection(0x0054, 0x0500);
Tag const ScanProgressionDirection(0x0054, 0x0501);
Tag const SeriesType(0x0054, 0x1000);
Tag const Units(0x0054, 0x1001);
Tag const CountsSource(0x0054, 0x1002);
Tag const ReprojectionMethod(0x0054, 0x1004);
Tag const SUVType(0x0054, 0x1006);
Tag const RandomsCorrectionMethod(0x0054, 0x1100);
Tag const AttenuationCorrectionMethod(0x0054, 0x1101);
Tag const DecayCorrection(0x0054, 0x1102);
Tag const ReconstructionMethod(0x0054, 0x1103);
Tag const DetectorLinesOfResponseUsed(0x0054, 0x1104);
Tag const ScatterCorrectionMethod(0x0054, 0x1105);
Tag const AxialAcceptance(0x0054, 0x1200);
Tag const AxialMash(0x0054, 0x1201);
Tag const TransverseMash(0x0054, 0x1202);
Tag const DetectorElementSize(0x0054, 0x1203);
Tag const CoincidenceWindowWidth(0x0054, 0x1210);
Tag const SecondaryCountsType(0x0054, 0x1220);
Tag const FrameReferenceTime(0x0054, 0x1300);
Tag const PrimaryPromptsCountsAccumulated(0x0054, 0x1310);
Tag const SecondaryCountsAccumulated(0x0054, 0x1311);
Tag const SliceSensitivityFactor(0x0054, 0x1320);
Tag const DecayFactor(0x0054, 0x1321);
Tag const DoseCalibrationFactor(0x0054, 0x1322);
Tag const ScatterFractionFactor(0x0054, 0x1323);
Tag const DeadTimeFactor(0x0054, 0x1324);
Tag const ImageIndex(0x0054, 0x1330);
Tag const CountsIncluded(0x0054, 0x1400);
Tag const DeadTimeCorrectionFlag(0x0054, 0x1401);
Tag const HistogramSequence(0x0060, 0x3000);
Tag const HistogramNumberOfBins(0x0060, 0x3002);
Tag const HistogramFirstBinValue(0x0060, 0x3004);
Tag const HistogramLastBinValue(0x0060, 0x3006);
Tag const HistogramBinWidth(0x0060, 0x3008);
Tag const HistogramExplanation(0x0060, 0x3010);
Tag const HistogramData(0x0060, 0x3020);
Tag const SegmentationType(0x0062, 0x0001);
Tag const SegmentSequence(0x0062, 0x0002);
Tag const SegmentedPropertyCategoryCodeSequence(0x0062, 0x0003);
Tag const SegmentNumber(0x0062, 0x0004);
Tag const SegmentLabel(0x0062, 0x0005);
Tag const SegmentDescription(0x0062, 0x0006);
Tag const SegmentAlgorithmType(0x0062, 0x0008);
Tag const SegmentAlgorithmName(0x0062, 0x0009);
Tag const SegmentIdentificationSequence(0x0062, 0x000a);
Tag const ReferencedSegmentNumber(0x0062, 0x000b);
Tag const RecommendedDisplayGrayscaleValue(0x0062, 0x000c);
Tag const RecommendedDisplayCIELabValue(0x0062, 0x000d);
Tag const MaximumFractionalValue(0x0062, 0x000e);
Tag const SegmentedPropertyTypeCodeSequence(0x0062, 0x000f);
Tag const SegmentationFractionalType(0x0062, 0x0010);
Tag const SegmentedPropertyTypeModifierCodeSequence(0x0062, 0x0011);
Tag const UsedSegmentsSequence(0x0062, 0x0012);
Tag const DeformableRegistrationSequence(0x0064, 0x0002);
Tag const SourceFrameOfReferenceUID(0x0064, 0x0003);
Tag const DeformableRegistrationGridSequence(0x0064, 0x0005);
Tag const GridDimensions(0x0064, 0x0007);
Tag const GridResolution(0x0064, 0x0008);
Tag const VectorGridData(0x0064, 0x0009);
Tag const PreDeformationMatrixRegistrationSequence(0x0064, 0x000f);
Tag const PostDeformationMatrixRegistrationSequence(0x0064, 0x0010);
Tag const NumberOfSurfaces(0x0066, 0x0001);
Tag const SurfaceSequence(0x0066, 0x0002);
Tag const SurfaceNumber(0x0066, 0x0003);
Tag const SurfaceComments(0x0066, 0x0004);
Tag const SurfaceProcessing(0x0066, 0x0009);
Tag const SurfaceProcessingRatio(0x0066, 0x000a);
Tag const SurfaceProcessingDescription(0x0066, 0x000b);
Tag const RecommendedPresentationOpacity(0x0066, 0x000c);
Tag const RecommendedPresentationType(0x0066, 0x000d);
Tag const FiniteVolume(0x0066, 0x000e);
Tag const Manifold(0x0066, 0x0010);
Tag const SurfacePointsSequence(0x0066, 0x0011);
Tag const SurfacePointsNormalsSequence(0x0066, 0x0012);
Tag const SurfaceMeshPrimitivesSequence(0x0066, 0x0013);
Tag const NumberOfSurfacePoints(0x0066, 0x0015);
Tag const PointCoordinatesData(0x0066, 0x0016);
Tag const PointPositionAccuracy(0x0066, 0x0017);
Tag const MeanPointDistance(0x0066, 0x0018);
Tag const MaximumPointDistance(0x0066, 0x0019);
Tag const PointsBoundingBoxCoordinates(0x0066, 0x001a);
Tag const AxisOfRotation(0x0066, 0x001b);
Tag const CenterOfRotation(0x0066, 0x001c);
Tag const NumberOfVectors(0x0066, 0x001e);
Tag const VectorDimensionality(0x0066, 0x001f);
Tag const VectorAccuracy(0x0066, 0x0020);
Tag const VectorCoordinateData(0x0066, 0x0021);
Tag const TrianglePointIndexList(0x0066, 0x0023);
Tag const EdgePointIndexList(0x0066, 0x0024);
Tag const VertexPointIndexList(0x0066, 0x0025);
Tag const TriangleStripSequence(0x0066, 0x0026);
Tag const TriangleFanSequence(0x0066, 0x0027);
Tag const LineSequence(0x0066, 0x0028);
Tag const PrimitivePointIndexList(0x0066, 0x0029);
Tag const SurfaceCount(0x0066, 0x002a);
Tag const ReferencedSurfaceSequence(0x0066, 0x002b);
Tag const ReferencedSurfaceNumber(0x0066, 0x002c);
Tag const SegmentSurfaceGenerationAlgorithmIdentificationSequence(0x0066, 0x002d);
Tag const SegmentSurfaceSourceInstanceSequence(0x0066, 0x002e);
Tag const AlgorithmFamilyCodeSequence(0x0066, 0x002f);
Tag const AlgorithmNameCodeSequence(0x0066, 0x0030);
Tag const AlgorithmVersion(0x0066, 0x0031);
Tag const AlgorithmParameters(0x0066, 0x0032);
Tag const FacetSequence(0x0066, 0x0034);
Tag const SurfaceProcessingAlgorithmIdentificationSequence(0x0066, 0x0035);
Tag const AlgorithmName(0x0066, 0x0036);
Tag const RecommendedPointRadius(0x0066, 0x0037);
Tag const RecommendedLineThickness(0x0066, 0x0038);
Tag const LongPrimitivePointIndexList(0x0066, 0x0040);
Tag const LongTrianglePointIndexList(0x0066, 0x0041);
Tag const LongEdgePointIndexList(0x0066, 0x0042);
Tag const LongVertexPointIndexList(0x0066, 0x0043);
Tag const ImplantSize(0x0068, 0x6210);
Tag const ImplantTemplateVersion(0x0068, 0x6221);
Tag const ReplacedImplantTemplateSequence(0x0068, 0x6222);
Tag const ImplantType(0x0068, 0x6223);
Tag const DerivationImplantTemplateSequence(0x0068, 0x6224);
Tag const OriginalImplantTemplateSequence(0x0068, 0x6225);
Tag const EffectiveDateTime(0x0068, 0x6226);
Tag const ImplantTargetAnatomySequence(0x0068, 0x6230);
Tag const InformationFromManufacturerSequence(0x0068, 0x6260);
Tag const NotificationFromManufacturerSequence(0x0068, 0x6265);
Tag const InformationIssueDateTime(0x0068, 0x6270);
Tag const InformationSummary(0x0068, 0x6280);
Tag const ImplantRegulatoryDisapprovalCodeSequence(0x0068, 0x62a0);
Tag const OverallTemplateSpatialTolerance(0x0068, 0x62a5);
Tag const HPGLDocumentSequence(0x0068, 0x62c0);
Tag const HPGLDocumentID(0x0068, 0x62d0);
Tag const HPGLDocumentLabel(0x0068, 0x62d5);
Tag const ViewOrientationCodeSequence(0x0068, 0x62e0);
Tag const ViewOrientationModifier(0x0068, 0x62f0);
Tag const HPGLDocumentScaling(0x0068, 0x62f2);
Tag const HPGLDocument(0x0068, 0x6300);
Tag const HPGLContourPenNumber(0x0068, 0x6310);
Tag const HPGLPenSequence(0x0068, 0x6320);
Tag const HPGLPenNumber(0x0068, 0x6330);
Tag const HPGLPenLabel(0x0068, 0x6340);
Tag const HPGLPenDescription(0x0068, 0x6345);
Tag const RecommendedRotationPoint(0x0068, 0x6346);
Tag const BoundingRectangle(0x0068, 0x6347);
Tag const ImplantTemplate3DModelSurfaceNumber(0x0068, 0x6350);
Tag const SurfaceModelDescriptionSequence(0x0068, 0x6360);
Tag const SurfaceModelLabel(0x0068, 0x6380);
Tag const SurfaceModelScalingFactor(0x0068, 0x6390);
Tag const MaterialsCodeSequence(0x0068, 0x63a0);
Tag const CoatingMaterialsCodeSequence(0x0068, 0x63a4);
Tag const ImplantTypeCodeSequence(0x0068, 0x63a8);
Tag const FixationMethodCodeSequence(0x0068, 0x63ac);
Tag const MatingFeatureSetsSequence(0x0068, 0x63b0);
Tag const MatingFeatureSetID(0x0068, 0x63c0);
Tag const MatingFeatureSetLabel(0x0068, 0x63d0);
Tag const MatingFeatureSequence(0x0068, 0x63e0);
Tag const MatingFeatureID(0x0068, 0x63f0);
Tag const MatingFeatureDegreeOfFreedomSequence(0x0068, 0x6400);
Tag const DegreeOfFreedomID(0x0068, 0x6410);
Tag const DegreeOfFreedomType(0x0068, 0x6420);
Tag const TwoDMatingFeatureCoordinatesSequence(0x0068, 0x6430);
Tag const ReferencedHPGLDocumentID(0x0068, 0x6440);
Tag const TwoDMatingPoint(0x0068, 0x6450);
Tag const TwoDMatingAxes(0x0068, 0x6460);
Tag const TwoDDegreeOfFreedomSequence(0x0068, 0x6470);
Tag const ThreeDDegreeOfFreedomAxis(0x0068, 0x6490);
Tag const RangeOfFreedom(0x0068, 0x64a0);
Tag const ThreeDMatingPoint(0x0068, 0x64c0);
Tag const ThreeDMatingAxes(0x0068, 0x64d0);
Tag const TwoDDegreeOfFreedomAxis(0x0068, 0x64f0);
Tag const PlanningLandmarkPointSequence(0x0068, 0x6500);
Tag const PlanningLandmarkLineSequence(0x0068, 0x6510);
Tag const PlanningLandmarkPlaneSequence(0x0068, 0x6520);
Tag const PlanningLandmarkID(0x0068, 0x6530);
Tag const PlanningLandmarkDescription(0x0068, 0x6540);
Tag const PlanningLandmarkIdentificationCodeSequence(0x0068, 0x6545);
Tag const TwoDPointCoordinatesSequence(0x0068, 0x6550);
Tag const TwoDPointCoordinates(0x0068, 0x6560);
Tag const ThreeDPointCoordinates(0x0068, 0x6590);
Tag const TwoDLineCoordinatesSequence(0x0068, 0x65a0);
Tag const TwoDLineCoordinates(0x0068, 0x65b0);
Tag const ThreeDLineCoordinates(0x0068, 0x65d0);
Tag const TwoDPlaneCoordinatesSequence(0x0068, 0x65e0);
Tag const TwoDPlaneIntersection(0x0068, 0x65f0);
Tag const ThreeDPlaneOrigin(0x0068, 0x6610);
Tag const ThreeDPlaneNormal(0x0068, 0x6620);
Tag const GraphicAnnotationSequence(0x0070, 0x0001);
Tag const GraphicLayer(0x0070, 0x0002);
Tag const BoundingBoxAnnotationUnits(0x0070, 0x0003);
Tag const AnchorPointAnnotationUnits(0x0070, 0x0004);
Tag const GraphicAnnotationUnits(0x0070, 0x0005);
Tag const UnformattedTextValue(0x0070, 0x0006);
Tag const TextObjectSequence(0x0070, 0x0008);
Tag const GraphicObjectSequence(0x0070, 0x0009);
Tag const BoundingBoxTopLeftHandCorner(0x0070, 0x0010);
Tag const BoundingBoxBottomRightHandCorner(0x0070, 0x0011);
Tag const BoundingBoxTextHorizontalJustification(0x0070, 0x0012);
Tag const AnchorPoint(0x0070, 0x0014);
Tag const AnchorPointVisibility(0x0070, 0x0015);
Tag const GraphicDimensions(0x0070, 0x0020);
Tag const NumberOfGraphicPoints(0x0070, 0x0021);
Tag const GraphicData(0x0070, 0x0022);
Tag const GraphicType(0x0070, 0x0023);
Tag const GraphicFilled(0x0070, 0x0024);
Tag const ImageRotationRetired(0x0070, 0x0040);
Tag const ImageHorizontalFlip(0x0070, 0x0041);
Tag const ImageRotation(0x0070, 0x0042);
Tag const DisplayedAreaTopLeftHandCornerTrial(0x0070, 0x0050);
Tag const DisplayedAreaBottomRightHandCornerTrial(0x0070, 0x0051);
Tag const DisplayedAreaTopLeftHandCorner(0x0070, 0x0052);
Tag const DisplayedAreaBottomRightHandCorner(0x0070, 0x0053);
Tag const DisplayedAreaSelectionSequence(0x0070, 0x005a);
Tag const GraphicLayerSequence(0x0070, 0x0060);
Tag const GraphicLayerOrder(0x0070, 0x0062);
Tag const GraphicLayerRecommendedDisplayGrayscaleValue(0x0070, 0x0066);
Tag const GraphicLayerRecommendedDisplayRGBValue(0x0070, 0x0067);
Tag const GraphicLayerDescription(0x0070, 0x0068);
Tag const ContentLabel(0x0070, 0x0080);
Tag const ContentDescription(0x0070, 0x0081);
Tag const PresentationCreationDate(0x0070, 0x0082);
Tag const PresentationCreationTime(0x0070, 0x0083);
Tag const ContentCreatorName(0x0070, 0x0084);
Tag const ContentCreatorIdentificationCodeSequence(0x0070, 0x0086);
Tag const AlternateContentDescriptionSequence(0x0070, 0x0087);
Tag const PresentationSizeMode(0x0070, 0x0100);
Tag const PresentationPixelSpacing(0x0070, 0x0101);
Tag const PresentationPixelAspectRatio(0x0070, 0x0102);
Tag const PresentationPixelMagnificationRatio(0x0070, 0x0103);
Tag const GraphicGroupLabel(0x0070, 0x0207);
Tag const GraphicGroupDescription(0x0070, 0x0208);
Tag const CompoundGraphicSequence(0x0070, 0x0209);
Tag const CompoundGraphicInstanceID(0x0070, 0x0226);
Tag const FontName(0x0070, 0x0227);
Tag const FontNameType(0x0070, 0x0228);
Tag const CSSFontName(0x0070, 0x0229);
Tag const RotationAngle(0x0070, 0x0230);
Tag const TextStyleSequence(0x0070, 0x0231);
Tag const LineStyleSequence(0x0070, 0x0232);
Tag const FillStyleSequence(0x0070, 0x0233);
Tag const GraphicGroupSequence(0x0070, 0x0234);
Tag const TextColorCIELabValue(0x0070, 0x0241);
Tag const HorizontalAlignment(0x0070, 0x0242);
Tag const VerticalAlignment(0x0070, 0x0243);
Tag const ShadowStyle(0x0070, 0x0244);
Tag const ShadowOffsetX(0x0070, 0x0245);
Tag const ShadowOffsetY(0x0070, 0x0246);
Tag const ShadowColorCIELabValue(0x0070, 0x0247);
Tag const Underlined(0x0070, 0x0248);
Tag const Bold(0x0070, 0x0249);
Tag const Italic(0x0070, 0x0250);
Tag const PatternOnColorCIELabValue(0x0070, 0x0251);
Tag const PatternOffColorCIELabValue(0x0070, 0x0252);
Tag const LineThickness(0x0070, 0x0253);
Tag const LineDashingStyle(0x0070, 0x0254);
Tag const LinePattern(0x0070, 0x0255);
Tag const FillPattern(0x0070, 0x0256);
Tag const FillMode(0x0070, 0x0257);
Tag const ShadowOpacity(0x0070, 0x0258);
Tag const GapLength(0x0070, 0x0261);
Tag const DiameterOfVisibility(0x0070, 0x0262);
Tag const RotationPoint(0x0070, 0x0273);
Tag const TickAlignment(0x0070, 0x0274);
Tag const ShowTickLabel(0x0070, 0x0278);
Tag const TickLabelAlignment(0x0070, 0x0279);
Tag const CompoundGraphicUnits(0x0070, 0x0282);
Tag const PatternOnOpacity(0x0070, 0x0284);
Tag const PatternOffOpacity(0x0070, 0x0285);
Tag const MajorTicksSequence(0x0070, 0x0287);
Tag const TickPosition(0x0070, 0x0288);
Tag const TickLabel(0x0070, 0x0289);
Tag const CompoundGraphicType(0x0070, 0x0294);
Tag const GraphicGroupID(0x0070, 0x0295);
Tag const ShapeType(0x0070, 0x0306);
Tag const RegistrationSequence(0x0070, 0x0308);
Tag const MatrixRegistrationSequence(0x0070, 0x0309);
Tag const MatrixSequence(0x0070, 0x030a);
Tag const FrameOfReferenceTransformationMatrixType(0x0070, 0x030c);
Tag const RegistrationTypeCodeSequence(0x0070, 0x030d);
Tag const FiducialDescription(0x0070, 0x030f);
Tag const FiducialIdentifier(0x0070, 0x0310);
Tag const FiducialIdentifierCodeSequence(0x0070, 0x0311);
Tag const ContourUncertaintyRadius(0x0070, 0x0312);
Tag const UsedFiducialsSequence(0x0070, 0x0314);
Tag const GraphicCoordinatesDataSequence(0x0070, 0x0318);
Tag const FiducialUID(0x0070, 0x031a);
Tag const FiducialSetSequence(0x0070, 0x031c);
Tag const FiducialSequence(0x0070, 0x031e);
Tag const GraphicLayerRecommendedDisplayCIELabValue(0x0070, 0x0401);
Tag const BlendingSequence(0x0070, 0x0402);
Tag const RelativeOpacity(0x0070, 0x0403);
Tag const ReferencedSpatialRegistrationSequence(0x0070, 0x0404);
Tag const BlendingPosition(0x0070, 0x0405);
Tag const HangingProtocolName(0x0072, 0x0002);
Tag const HangingProtocolDescription(0x0072, 0x0004);
Tag const HangingProtocolLevel(0x0072, 0x0006);
Tag const HangingProtocolCreator(0x0072, 0x0008);
Tag const HangingProtocolCreationDateTime(0x0072, 0x000a);
Tag const HangingProtocolDefinitionSequence(0x0072, 0x000c);
Tag const HangingProtocolUserIdentificationCodeSequence(0x0072, 0x000e);
Tag const HangingProtocolUserGroupName(0x0072, 0x0010);
Tag const SourceHangingProtocolSequence(0x0072, 0x0012);
Tag const NumberOfPriorsReferenced(0x0072, 0x0014);
Tag const ImageSetsSequence(0x0072, 0x0020);
Tag const ImageSetSelectorSequence(0x0072, 0x0022);
Tag const ImageSetSelectorUsageFlag(0x0072, 0x0024);
Tag const SelectorAttribute(0x0072, 0x0026);
Tag const SelectorValueNumber(0x0072, 0x0028);
Tag const TimeBasedImageSetsSequence(0x0072, 0x0030);
Tag const ImageSetNumber(0x0072, 0x0032);
Tag const ImageSetSelectorCategory(0x0072, 0x0034);
Tag const RelativeTime(0x0072, 0x0038);
Tag const RelativeTimeUnits(0x0072, 0x003a);
Tag const AbstractPriorValue(0x0072, 0x003c);
Tag const AbstractPriorCodeSequence(0x0072, 0x003e);
Tag const ImageSetLabel(0x0072, 0x0040);
Tag const SelectorAttributeVR(0x0072, 0x0050);
Tag const SelectorSequencePointer(0x0072, 0x0052);
Tag const SelectorSequencePointerPrivateCreator(0x0072, 0x0054);
Tag const SelectorAttributePrivateCreator(0x0072, 0x0056);
Tag const SelectorATValue(0x0072, 0x0060);
Tag const SelectorCSValue(0x0072, 0x0062);
Tag const SelectorISValue(0x0072, 0x0064);
Tag const SelectorLOValue(0x0072, 0x0066);
Tag const SelectorLTValue(0x0072, 0x0068);
Tag const SelectorPNValue(0x0072, 0x006a);
Tag const SelectorSHValue(0x0072, 0x006c);
Tag const SelectorSTValue(0x0072, 0x006e);
Tag const SelectorUTValue(0x0072, 0x0070);
Tag const SelectorDSValue(0x0072, 0x0072);
Tag const SelectorFDValue(0x0072, 0x0074);
Tag const SelectorFLValue(0x0072, 0x0076);
Tag const SelectorULValue(0x0072, 0x0078);
Tag const SelectorUSValue(0x0072, 0x007a);
Tag const SelectorSLValue(0x0072, 0x007c);
Tag const SelectorSSValue(0x0072, 0x007e);
Tag const SelectorUIValue(0x0072, 0x007f);
Tag const SelectorCodeSequenceValue(0x0072, 0x0080);
Tag const NumberOfScreens(0x0072, 0x0100);
Tag const NominalScreenDefinitionSequence(0x0072, 0x0102);
Tag const NumberOfVerticalPixels(0x0072, 0x0104);
Tag const NumberOfHorizontalPixels(0x0072, 0x0106);
Tag const DisplayEnvironmentSpatialPosition(0x0072, 0x0108);
Tag const ScreenMinimumGrayscaleBitDepth(0x0072, 0x010a);
Tag const ScreenMinimumColorBitDepth(0x0072, 0x010c);
Tag const ApplicationMaximumRepaintTime(0x0072, 0x010e);
Tag const DisplaySetsSequence(0x0072, 0x0200);
Tag const DisplaySetNumber(0x0072, 0x0202);
Tag const DisplaySetLabel(0x0072, 0x0203);
Tag const DisplaySetPresentationGroup(0x0072, 0x0204);
Tag const DisplaySetPresentationGroupDescription(0x0072, 0x0206);
Tag const PartialDataDisplayHandling(0x0072, 0x0208);
Tag const SynchronizedScrollingSequence(0x0072, 0x0210);
Tag const DisplaySetScrollingGroup(0x0072, 0x0212);
Tag const NavigationIndicatorSequence(0x0072, 0x0214);
Tag const NavigationDisplaySet(0x0072, 0x0216);
Tag const ReferenceDisplaySets(0x0072, 0x0218);
Tag const ImageBoxesSequence(0x0072, 0x0300);
Tag const ImageBoxNumber(0x0072, 0x0302);
Tag const ImageBoxLayoutType(0x0072, 0x0304);
Tag const ImageBoxTileHorizontalDimension(0x0072, 0x0306);
Tag const ImageBoxTileVerticalDimension(0x0072, 0x0308);
Tag const ImageBoxScrollDirection(0x0072, 0x0310);
Tag const ImageBoxSmallScrollType(0x0072, 0x0312);
Tag const ImageBoxSmallScrollAmount(0x0072, 0x0314);
Tag const ImageBoxLargeScrollType(0x0072, 0x0316);
Tag const ImageBoxLargeScrollAmount(0x0072, 0x0318);
Tag const ImageBoxOverlapPriority(0x0072, 0x0320);
Tag const CineRelativeToRealTime(0x0072, 0x0330);
Tag const FilterOperationsSequence(0x0072, 0x0400);
Tag const FilterByCategory(0x0072, 0x0402);
Tag const FilterByAttributePresence(0x0072, 0x0404);
Tag const FilterByOperator(0x0072, 0x0406);
Tag const StructuredDisplayBackgroundCIELabValue(0x0072, 0x0420);
Tag const EmptyImageBoxCIELabValue(0x0072, 0x0421);
Tag const StructuredDisplayImageBoxSequence(0x0072, 0x0422);
Tag const StructuredDisplayTextBoxSequence(0x0072, 0x0424);
Tag const ReferencedFirstFrameSequence(0x0072, 0x0427);
Tag const ImageBoxSynchronizationSequence(0x0072, 0x0430);
Tag const SynchronizedImageBoxList(0x0072, 0x0432);
Tag const TypeOfSynchronization(0x0072, 0x0434);
Tag const BlendingOperationType(0x0072, 0x0500);
Tag const ReformattingOperationType(0x0072, 0x0510);
Tag const ReformattingThickness(0x0072, 0x0512);
Tag const ReformattingInterval(0x0072, 0x0514);
Tag const ReformattingOperationInitialViewDirection(0x0072, 0x0516);
Tag const ThreeDRenderingType(0x0072, 0x0520);
Tag const SortingOperationsSequence(0x0072, 0x0600);
Tag const SortByCategory(0x0072, 0x0602);
Tag const SortingDirection(0x0072, 0x0604);
Tag const DisplaySetPatientOrientation(0x0072, 0x0700);
Tag const VOIType(0x0072, 0x0702);
Tag const PseudoColorType(0x0072, 0x0704);
Tag const PseudoColorPaletteInstanceReferenceSequence(0x0072, 0x0705);
Tag const ShowGrayscaleInverted(0x0072, 0x0706);
Tag const ShowImageTrueSizeFlag(0x0072, 0x0710);
Tag const ShowGraphicAnnotationFlag(0x0072, 0x0712);
Tag const ShowPatientDemographicsFlag(0x0072, 0x0714);
Tag const ShowAcquisitionTechniquesFlag(0x0072, 0x0716);
Tag const DisplaySetHorizontalJustification(0x0072, 0x0717);
Tag const DisplaySetVerticalJustification(0x0072, 0x0718);
Tag const ContinuationStartMeterset(0x0074, 0x0120);
Tag const ContinuationEndMeterset(0x0074, 0x0121);
Tag const ProcedureStepState(0x0074, 0x1000);
Tag const ProcedureStepProgressInformationSequence(0x0074, 0x1002);
Tag const ProcedureStepProgress(0x0074, 0x1004);
Tag const ProcedureStepProgressDescription(0x0074, 0x1006);
Tag const ProcedureStepCommunicationsURISequence(0x0074, 0x1008);
Tag const ContactURI(0x0074, 0x100a);
Tag const ContactDisplayName(0x0074, 0x100c);
Tag const ProcedureStepDiscontinuationReasonCodeSequence(0x0074, 0x100e);
Tag const BeamTaskSequence(0x0074, 0x1020);
Tag const BeamTaskType(0x0074, 0x1022);
Tag const BeamOrderIndexTrial(0x0074, 0x1024);
Tag const AutosequenceFlag(0x0074, 0x1025);
Tag const TableTopVerticalAdjustedPosition(0x0074, 0x1026);
Tag const TableTopLongitudinalAdjustedPosition(0x0074, 0x1027);
Tag const TableTopLateralAdjustedPosition(0x0074, 0x1028);
Tag const PatientSupportAdjustedAngle(0x0074, 0x102a);
Tag const TableTopEccentricAdjustedAngle(0x0074, 0x102b);
Tag const TableTopPitchAdjustedAngle(0x0074, 0x102c);
Tag const TableTopRollAdjustedAngle(0x0074, 0x102d);
Tag const DeliveryVerificationImageSequence(0x0074, 0x1030);
Tag const VerificationImageTiming(0x0074, 0x1032);
Tag const DoubleExposureFlag(0x0074, 0x1034);
Tag const DoubleExposureOrdering(0x0074, 0x1036);
Tag const DoubleExposureMetersetTrial(0x0074, 0x1038);
Tag const DoubleExposureFieldDeltaTrial(0x0074, 0x103a);
Tag const RelatedReferenceRTImageSequence(0x0074, 0x1040);
Tag const GeneralMachineVerificationSequence(0x0074, 0x1042);
Tag const ConventionalMachineVerificationSequence(0x0074, 0x1044);
Tag const IonMachineVerificationSequence(0x0074, 0x1046);
Tag const FailedAttributesSequence(0x0074, 0x1048);
Tag const OverriddenAttributesSequence(0x0074, 0x104a);
Tag const ConventionalControlPointVerificationSequence(0x0074, 0x104c);
Tag const IonControlPointVerificationSequence(0x0074, 0x104e);
Tag const AttributeOccurrenceSequence(0x0074, 0x1050);
Tag const AttributeOccurrencePointer(0x0074, 0x1052);
Tag const AttributeItemSelector(0x0074, 0x1054);
Tag const AttributeOccurrencePrivateCreator(0x0074, 0x1056);
Tag const SelectorSequencePointerItems(0x0074, 0x1057);
Tag const ScheduledProcedureStepPriority(0x0074, 0x1200);
Tag const WorklistLabel(0x0074, 0x1202);
Tag const ProcedureStepLabel(0x0074, 0x1204);
Tag const ScheduledProcessingParametersSequence(0x0074, 0x1210);
Tag const PerformedProcessingParametersSequence(0x0074, 0x1212);
Tag const UnifiedProcedureStepPerformedProcedureSequence(0x0074, 0x1216);
Tag const RelatedProcedureStepSequence(0x0074, 0x1220);
Tag const ProcedureStepRelationshipType(0x0074, 0x1222);
Tag const ReplacedProcedureStepSequence(0x0074, 0x1224);
Tag const DeletionLock(0x0074, 0x1230);
Tag const ReceivingAE(0x0074, 0x1234);
Tag const RequestingAE(0x0074, 0x1236);
Tag const ReasonForCancellation(0x0074, 0x1238);
Tag const SCPStatus(0x0074, 0x1242);
Tag const SubscriptionListStatus(0x0074, 0x1244);
Tag const UnifiedProcedureStepListStatus(0x0074, 0x1246);
Tag const BeamOrderIndex(0x0074, 0x1324);
Tag const DoubleExposureMeterset(0x0074, 0x1338);
Tag const DoubleExposureFieldDelta(0x0074, 0x133a);
Tag const ImplantAssemblyTemplateName(0x0076, 0x0001);
Tag const ImplantAssemblyTemplateIssuer(0x0076, 0x0003);
Tag const ImplantAssemblyTemplateVersion(0x0076, 0x0006);
Tag const ReplacedImplantAssemblyTemplateSequence(0x0076, 0x0008);
Tag const ImplantAssemblyTemplateType(0x0076, 0x000a);
Tag const OriginalImplantAssemblyTemplateSequence(0x0076, 0x000c);
Tag const DerivationImplantAssemblyTemplateSequence(0x0076, 0x000e);
Tag const ImplantAssemblyTemplateTargetAnatomySequence(0x0076, 0x0010);
Tag const ProcedureTypeCodeSequence(0x0076, 0x0020);
Tag const SurgicalTechnique(0x0076, 0x0030);
Tag const ComponentTypesSequence(0x0076, 0x0032);
Tag const ComponentTypeCodeSequence(0x0076, 0x0034);
Tag const ExclusiveComponentType(0x0076, 0x0036);
Tag const MandatoryComponentType(0x0076, 0x0038);
Tag const ComponentSequence(0x0076, 0x0040);
Tag const ComponentID(0x0076, 0x0055);
Tag const ComponentAssemblySequence(0x0076, 0x0060);
Tag const Component1ReferencedID(0x0076, 0x0070);
Tag const Component1ReferencedMatingFeatureSetID(0x0076, 0x0080);
Tag const Component1ReferencedMatingFeatureID(0x0076, 0x0090);
Tag const Component2ReferencedID(0x0076, 0x00a0);
Tag const Component2ReferencedMatingFeatureSetID(0x0076, 0x00b0);
Tag const Component2ReferencedMatingFeatureID(0x0076, 0x00c0);
Tag const ImplantTemplateGroupName(0x0078, 0x0001);
Tag const ImplantTemplateGroupDescription(0x0078, 0x0010);
Tag const ImplantTemplateGroupIssuer(0x0078, 0x0020);
Tag const ImplantTemplateGroupVersion(0x0078, 0x0024);
Tag const ReplacedImplantTemplateGroupSequence(0x0078, 0x0026);
Tag const ImplantTemplateGroupTargetAnatomySequence(0x0078, 0x0028);
Tag const ImplantTemplateGroupMembersSequence(0x0078, 0x002a);
Tag const ImplantTemplateGroupMemberID(0x0078, 0x002e);
Tag const ThreeDImplantTemplateGroupMemberMatchingPoint(0x0078, 0x0050);
Tag const ThreeDImplantTemplateGroupMemberMatchingAxes(0x0078, 0x0060);
Tag const ImplantTemplateGroupMemberMatching2DCoordinatesSequence(0x0078, 0x0070);
Tag const TwoDImplantTemplateGroupMemberMatchingPoint(0x0078, 0x0090);
Tag const TwoDImplantTemplateGroupMemberMatchingAxes(0x0078, 0x00a0);
Tag const ImplantTemplateGroupVariationDimensionSequence(0x0078, 0x00b0);
Tag const ImplantTemplateGroupVariationDimensionName(0x0078, 0x00b2);
Tag const ImplantTemplateGroupVariationDimensionRankSequence(0x0078, 0x00b4);
Tag const ReferencedImplantTemplateGroupMemberID(0x0078, 0x00b6);
Tag const ImplantTemplateGroupVariationDimensionRank(0x0078, 0x00b8);
Tag const SurfaceScanAcquisitionTypeCodeSequence(0x0080, 0x0001);
Tag const SurfaceScanModeCodeSequence(0x0080, 0x0002);
Tag const RegistrationMethodCodeSequence(0x0080, 0x0003);
Tag const ShotDurationTime(0x0080, 0x0004);
Tag const ShotOffsetTime(0x0080, 0x0005);
Tag const SurfacePointPresentationValueData(0x0080, 0x0006);
Tag const SurfacePointColorCIELabValueData(0x0080, 0x0007);
Tag const UVMappingSequence(0x0080, 0x0008);
Tag const TextureLabel(0x0080, 0x0009);
Tag const UValueData(0x0080, 0x0010);
Tag const VValueData(0x0080, 0x0011);
Tag const ReferencedTextureSequence(0x0080, 0x0012);
Tag const ReferencedSurfaceDataSequence(0x0080, 0x0013);
Tag const StorageMediaFileSetID(0x0088, 0x0130);
Tag const StorageMediaFileSetUID(0x0088, 0x0140);
Tag const IconImageSequence(0x0088, 0x0200);
Tag const TopicTitle(0x0088, 0x0904);
Tag const TopicSubject(0x0088, 0x0906);
Tag const TopicAuthor(0x0088, 0x0910);
Tag const TopicKeywords(0x0088, 0x0912);
Tag const SOPInstanceStatus(0x0100, 0x0410);
Tag const SOPAuthorizationDateTime(0x0100, 0x0420);
Tag const SOPAuthorizationComment(0x0100, 0x0424);
Tag const AuthorizationEquipmentCertificationNumber(0x0100, 0x0426);
Tag const MACIDNumber(0x0400, 0x0005);
Tag const MACCalculationTransferSyntaxUID(0x0400, 0x0010);
Tag const MACAlgorithm(0x0400, 0x0015);
Tag const DataElementsSigned(0x0400, 0x0020);
Tag const DigitalSignatureUID(0x0400, 0x0100);
Tag const DigitalSignatureDateTime(0x0400, 0x0105);
Tag const CertificateType(0x0400, 0x0110);
Tag const CertificateOfSigner(0x0400, 0x0115);
Tag const Signature(0x0400, 0x0120);
Tag const CertifiedTimestampType(0x0400, 0x0305);
Tag const CertifiedTimestamp(0x0400, 0x0310);
Tag const DigitalSignaturePurposeCodeSequence(0x0400, 0x0401);
Tag const ReferencedDigitalSignatureSequence(0x0400, 0x0402);
Tag const ReferencedSOPInstanceMACSequence(0x0400, 0x0403);
Tag const MAC(0x0400, 0x0404);
Tag const EncryptedAttributesSequence(0x0400, 0x0500);
Tag const EncryptedContentTransferSyntaxUID(0x0400, 0x0510);
Tag const EncryptedContent(0x0400, 0x0520);
Tag const ModifiedAttributesSequence(0x0400, 0x0550);
Tag const OriginalAttributesSequence(0x0400, 0x0561);
Tag const AttributeModificationDateTime(0x0400, 0x0562);
Tag const ModifyingSystem(0x0400, 0x0563);
Tag const SourceOfPreviousValues(0x0400, 0x0564);
Tag const ReasonForTheAttributeModification(0x0400, 0x0565);
Tag const NumberOfCopies(0x2000, 0x0010);
Tag const PrinterConfigurationSequence(0x2000, 0x001e);
Tag const PrintPriority(0x2000, 0x0020);
Tag const MediumType(0x2000, 0x0030);
Tag const FilmDestination(0x2000, 0x0040);
Tag const FilmSessionLabel(0x2000, 0x0050);
Tag const MemoryAllocation(0x2000, 0x0060);
Tag const MaximumMemoryAllocation(0x2000, 0x0061);
Tag const ColorImagePrintingFlag(0x2000, 0x0062);
Tag const CollationFlag(0x2000, 0x0063);
Tag const AnnotationFlag(0x2000, 0x0065);
Tag const ImageOverlayFlag(0x2000, 0x0067);
Tag const PresentationLUTFlag(0x2000, 0x0069);
Tag const ImageBoxPresentationLUTFlag(0x2000, 0x006a);
Tag const MemoryBitDepth(0x2000, 0x00a0);
Tag const PrintingBitDepth(0x2000, 0x00a1);
Tag const MediaInstalledSequence(0x2000, 0x00a2);
Tag const OtherMediaAvailableSequence(0x2000, 0x00a4);
Tag const SupportedImageDisplayFormatsSequence(0x2000, 0x00a8);
Tag const ReferencedFilmBoxSequence(0x2000, 0x0500);
Tag const ReferencedStoredPrintSequence(0x2000, 0x0510);
Tag const ImageDisplayFormat(0x2010, 0x0010);
Tag const AnnotationDisplayFormatID(0x2010, 0x0030);
Tag const FilmOrientation(0x2010, 0x0040);
Tag const FilmSizeID(0x2010, 0x0050);
Tag const PrinterResolutionID(0x2010, 0x0052);
Tag const DefaultPrinterResolutionID(0x2010, 0x0054);
Tag const MagnificationType(0x2010, 0x0060);
Tag const SmoothingType(0x2010, 0x0080);
Tag const DefaultMagnificationType(0x2010, 0x00a6);
Tag const OtherMagnificationTypesAvailable(0x2010, 0x00a7);
Tag const DefaultSmoothingType(0x2010, 0x00a8);
Tag const OtherSmoothingTypesAvailable(0x2010, 0x00a9);
Tag const BorderDensity(0x2010, 0x0100);
Tag const EmptyImageDensity(0x2010, 0x0110);
Tag const MinDensity(0x2010, 0x0120);
Tag const MaxDensity(0x2010, 0x0130);
Tag const Trim(0x2010, 0x0140);
Tag const ConfigurationInformation(0x2010, 0x0150);
Tag const ConfigurationInformationDescription(0x2010, 0x0152);
Tag const MaximumCollatedFilms(0x2010, 0x0154);
Tag const Illumination(0x2010, 0x015e);
Tag const ReflectedAmbientLight(0x2010, 0x0160);
Tag const PrinterPixelSpacing(0x2010, 0x0376);
Tag const ReferencedFilmSessionSequence(0x2010, 0x0500);
Tag const ReferencedImageBoxSequence(0x2010, 0x0510);
Tag const ReferencedBasicAnnotationBoxSequence(0x2010, 0x0520);
Tag const ImageBoxPosition(0x2020, 0x0010);
Tag const Polarity(0x2020, 0x0020);
Tag const RequestedImageSize(0x2020, 0x0030);
Tag const RequestedDecimateCropBehavior(0x2020, 0x0040);
Tag const RequestedResolutionID(0x2020, 0x0050);
Tag const RequestedImageSizeFlag(0x2020, 0x00a0);
Tag const DecimateCropResult(0x2020, 0x00a2);
Tag const BasicGrayscaleImageSequence(0x2020, 0x0110);
Tag const BasicColorImageSequence(0x2020, 0x0111);
Tag const ReferencedImageOverlayBoxSequence(0x2020, 0x0130);
Tag const ReferencedVOILUTBoxSequence(0x2020, 0x0140);
Tag const AnnotationPosition(0x2030, 0x0010);
Tag const TextString(0x2030, 0x0020);
Tag const ReferencedOverlayPlaneSequence(0x2040, 0x0010);
Tag const ReferencedOverlayPlaneGroups(0x2040, 0x0011);
Tag const OverlayPixelDataSequence(0x2040, 0x0020);
Tag const OverlayMagnificationType(0x2040, 0x0060);
Tag const OverlaySmoothingType(0x2040, 0x0070);
Tag const OverlayOrImageMagnification(0x2040, 0x0072);
Tag const MagnifyToNumberOfColumns(0x2040, 0x0074);
Tag const OverlayForegroundDensity(0x2040, 0x0080);
Tag const OverlayBackgroundDensity(0x2040, 0x0082);
Tag const OverlayMode(0x2040, 0x0090);
Tag const ThresholdDensity(0x2040, 0x0100);
Tag const ReferencedImageBoxSequenceRetired(0x2040, 0x0500);
Tag const PresentationLUTSequence(0x2050, 0x0010);
Tag const PresentationLUTShape(0x2050, 0x0020);
Tag const ReferencedPresentationLUTSequence(0x2050, 0x0500);
Tag const PrintJobID(0x2100, 0x0010);
Tag const ExecutionStatus(0x2100, 0x0020);
Tag const ExecutionStatusInfo(0x2100, 0x0030);
Tag const CreationDate(0x2100, 0x0040);
Tag const CreationTime(0x2100, 0x0050);
Tag const Originator(0x2100, 0x0070);
Tag const DestinationAE(0x2100, 0x0140);
Tag const OwnerID(0x2100, 0x0160);
Tag const NumberOfFilms(0x2100, 0x0170);
Tag const ReferencedPrintJobSequencePullStoredPrint(0x2100, 0x0500);
Tag const PrinterStatus(0x2110, 0x0010);
Tag const PrinterStatusInfo(0x2110, 0x0020);
Tag const PrinterName(0x2110, 0x0030);
Tag const PrintQueueID(0x2110, 0x0099);
Tag const QueueStatus(0x2120, 0x0010);
Tag const PrintJobDescriptionSequence(0x2120, 0x0050);
Tag const ReferencedPrintJobSequence(0x2120, 0x0070);
Tag const PrintManagementCapabilitiesSequence(0x2130, 0x0010);
Tag const PrinterCharacteristicsSequence(0x2130, 0x0015);
Tag const FilmBoxContentSequence(0x2130, 0x0030);
Tag const ImageBoxContentSequence(0x2130, 0x0040);
Tag const AnnotationContentSequence(0x2130, 0x0050);
Tag const ImageOverlayBoxContentSequence(0x2130, 0x0060);
Tag const PresentationLUTContentSequence(0x2130, 0x0080);
Tag const ProposedStudySequence(0x2130, 0x00a0);
Tag const OriginalImageSequence(0x2130, 0x00c0);
Tag const LabelUsingInformationExtractedFromInstances(0x2200, 0x0001);
Tag const LabelText(0x2200, 0x0002);
Tag const LabelStyleSelection(0x2200, 0x0003);
Tag const MediaDisposition(0x2200, 0x0004);
Tag const BarcodeValue(0x2200, 0x0005);
Tag const BarcodeSymbology(0x2200, 0x0006);
Tag const AllowMediaSplitting(0x2200, 0x0007);
Tag const IncludeNonDICOMObjects(0x2200, 0x0008);
Tag const IncludeDisplayApplication(0x2200, 0x0009);
Tag const PreserveCompositeInstancesAfterMediaCreation(0x2200, 0x000a);
Tag const TotalNumberOfPiecesOfMediaCreated(0x2200, 0x000b);
Tag const RequestedMediaApplicationProfile(0x2200, 0x000c);
Tag const ReferencedStorageMediaSequence(0x2200, 0x000d);
Tag const FailureAttributes(0x2200, 0x000e);
Tag const AllowLossyCompression(0x2200, 0x000f);
Tag const RequestPriority(0x2200, 0x0020);
Tag const RTImageLabel(0x3002, 0x0002);
Tag const RTImageName(0x3002, 0x0003);
Tag const RTImageDescription(0x3002, 0x0004);
Tag const ReportedValuesOrigin(0x3002, 0x000a);
Tag const RTImagePlane(0x3002, 0x000c);
Tag const XRayImageReceptorTranslation(0x3002, 0x000d);
Tag const XRayImageReceptorAngle(0x3002, 0x000e);
Tag const RTImageOrientation(0x3002, 0x0010);
Tag const ImagePlanePixelSpacing(0x3002, 0x0011);
Tag const RTImagePosition(0x3002, 0x0012);
Tag const RadiationMachineName(0x3002, 0x0020);
Tag const RadiationMachineSAD(0x3002, 0x0022);
Tag const RadiationMachineSSD(0x3002, 0x0024);
Tag const RTImageSID(0x3002, 0x0026);
Tag const SourceToReferenceObjectDistance(0x3002, 0x0028);
Tag const FractionNumber(0x3002, 0x0029);
Tag const ExposureSequence(0x3002, 0x0030);
Tag const MetersetExposure(0x3002, 0x0032);
Tag const DiaphragmPosition(0x3002, 0x0034);
Tag const FluenceMapSequence(0x3002, 0x0040);
Tag const FluenceDataSource(0x3002, 0x0041);
Tag const FluenceDataScale(0x3002, 0x0042);
Tag const PrimaryFluenceModeSequence(0x3002, 0x0050);
Tag const FluenceMode(0x3002, 0x0051);
Tag const FluenceModeID(0x3002, 0x0052);
Tag const DVHType(0x3004, 0x0001);
Tag const DoseUnits(0x3004, 0x0002);
Tag const DoseType(0x3004, 0x0004);
Tag const SpatialTransformOfDose(0x3004, 0x0005);
Tag const DoseComment(0x3004, 0x0006);
Tag const NormalizationPoint(0x3004, 0x0008);
Tag const DoseSummationType(0x3004, 0x000a);
Tag const GridFrameOffsetVector(0x3004, 0x000c);
Tag const DoseGridScaling(0x3004, 0x000e);
Tag const RTDoseROISequence(0x3004, 0x0010);
Tag const DoseValue(0x3004, 0x0012);
Tag const TissueHeterogeneityCorrection(0x3004, 0x0014);
Tag const DVHNormalizationPoint(0x3004, 0x0040);
Tag const DVHNormalizationDoseValue(0x3004, 0x0042);
Tag const DVHSequence(0x3004, 0x0050);
Tag const DVHDoseScaling(0x3004, 0x0052);
Tag const DVHVolumeUnits(0x3004, 0x0054);
Tag const DVHNumberOfBins(0x3004, 0x0056);
Tag const DVHData(0x3004, 0x0058);
Tag const DVHReferencedROISequence(0x3004, 0x0060);
Tag const DVHROIContributionType(0x3004, 0x0062);
Tag const DVHMinimumDose(0x3004, 0x0070);
Tag const DVHMaximumDose(0x3004, 0x0072);
Tag const DVHMeanDose(0x3004, 0x0074);
Tag const StructureSetLabel(0x3006, 0x0002);
Tag const StructureSetName(0x3006, 0x0004);
Tag const StructureSetDescription(0x3006, 0x0006);
Tag const StructureSetDate(0x3006, 0x0008);
Tag const StructureSetTime(0x3006, 0x0009);
Tag const ReferencedFrameOfReferenceSequence(0x3006, 0x0010);
Tag const RTReferencedStudySequence(0x3006, 0x0012);
Tag const RTReferencedSeriesSequence(0x3006, 0x0014);
Tag const ContourImageSequence(0x3006, 0x0016);
Tag const PredecessorStructureSetSequence(0x3006, 0x0018);
Tag const StructureSetROISequence(0x3006, 0x0020);
Tag const ROINumber(0x3006, 0x0022);
Tag const ReferencedFrameOfReferenceUID(0x3006, 0x0024);
Tag const ROIName(0x3006, 0x0026);
Tag const ROIDescription(0x3006, 0x0028);
Tag const ROIDisplayColor(0x3006, 0x002a);
Tag const ROIVolume(0x3006, 0x002c);
Tag const RTRelatedROISequence(0x3006, 0x0030);
Tag const RTROIRelationship(0x3006, 0x0033);
Tag const ROIGenerationAlgorithm(0x3006, 0x0036);
Tag const ROIGenerationDescription(0x3006, 0x0038);
Tag const ROIContourSequence(0x3006, 0x0039);
Tag const ContourSequence(0x3006, 0x0040);
Tag const ContourGeometricType(0x3006, 0x0042);
Tag const ContourSlabThickness(0x3006, 0x0044);
Tag const ContourOffsetVector(0x3006, 0x0045);
Tag const NumberOfContourPoints(0x3006, 0x0046);
Tag const ContourNumber(0x3006, 0x0048);
Tag const AttachedContours(0x3006, 0x0049);
Tag const ContourData(0x3006, 0x0050);
Tag const RTROIObservationsSequence(0x3006, 0x0080);
Tag const ObservationNumber(0x3006, 0x0082);
Tag const ReferencedROINumber(0x3006, 0x0084);
Tag const ROIObservationLabel(0x3006, 0x0085);
Tag const RTROIIdentificationCodeSequence(0x3006, 0x0086);
Tag const ROIObservationDescription(0x3006, 0x0088);
Tag const RelatedRTROIObservationsSequence(0x3006, 0x00a0);
Tag const RTROIInterpretedType(0x3006, 0x00a4);
Tag const ROIInterpreter(0x3006, 0x00a6);
Tag const ROIPhysicalPropertiesSequence(0x3006, 0x00b0);
Tag const ROIPhysicalProperty(0x3006, 0x00b2);
Tag const ROIPhysicalPropertyValue(0x3006, 0x00b4);
Tag const ROIElementalCompositionSequence(0x3006, 0x00b6);
Tag const ROIElementalCompositionAtomicNumber(0x3006, 0x00b7);
Tag const ROIElementalCompositionAtomicMassFraction(0x3006, 0x00b8);
Tag const AdditionalRTROIIdentificationCodeSequence(0x3006, 0x00b9);
Tag const FrameOfReferenceRelationshipSequence(0x3006, 0x00c0);
Tag const RelatedFrameOfReferenceUID(0x3006, 0x00c2);
Tag const FrameOfReferenceTransformationType(0x3006, 0x00c4);
Tag const FrameOfReferenceTransformationMatrix(0x3006, 0x00c6);
Tag const FrameOfReferenceTransformationComment(0x3006, 0x00c8);
Tag const MeasuredDoseReferenceSequence(0x3008, 0x0010);
Tag const MeasuredDoseDescription(0x3008, 0x0012);
Tag const MeasuredDoseType(0x3008, 0x0014);
Tag const MeasuredDoseValue(0x3008, 0x0016);
Tag const TreatmentSessionBeamSequence(0x3008, 0x0020);
Tag const TreatmentSessionIonBeamSequence(0x3008, 0x0021);
Tag const CurrentFractionNumber(0x3008, 0x0022);
Tag const TreatmentControlPointDate(0x3008, 0x0024);
Tag const TreatmentControlPointTime(0x3008, 0x0025);
Tag const TreatmentTerminationStatus(0x3008, 0x002a);
Tag const TreatmentTerminationCode(0x3008, 0x002b);
Tag const TreatmentVerificationStatus(0x3008, 0x002c);
Tag const ReferencedTreatmentRecordSequence(0x3008, 0x0030);
Tag const SpecifiedPrimaryMeterset(0x3008, 0x0032);
Tag const SpecifiedSecondaryMeterset(0x3008, 0x0033);
Tag const DeliveredPrimaryMeterset(0x3008, 0x0036);
Tag const DeliveredSecondaryMeterset(0x3008, 0x0037);
Tag const SpecifiedTreatmentTime(0x3008, 0x003a);
Tag const DeliveredTreatmentTime(0x3008, 0x003b);
Tag const ControlPointDeliverySequence(0x3008, 0x0040);
Tag const IonControlPointDeliverySequence(0x3008, 0x0041);
Tag const SpecifiedMeterset(0x3008, 0x0042);
Tag const DeliveredMeterset(0x3008, 0x0044);
Tag const MetersetRateSet(0x3008, 0x0045);
Tag const MetersetRateDelivered(0x3008, 0x0046);
Tag const ScanSpotMetersetsDelivered(0x3008, 0x0047);
Tag const DoseRateDelivered(0x3008, 0x0048);
Tag const TreatmentSummaryCalculatedDoseReferenceSequence(0x3008, 0x0050);
Tag const CumulativeDoseToDoseReference(0x3008, 0x0052);
Tag const FirstTreatmentDate(0x3008, 0x0054);
Tag const MostRecentTreatmentDate(0x3008, 0x0056);
Tag const NumberOfFractionsDelivered(0x3008, 0x005a);
Tag const OverrideSequence(0x3008, 0x0060);
Tag const ParameterSequencePointer(0x3008, 0x0061);
Tag const OverrideParameterPointer(0x3008, 0x0062);
Tag const ParameterItemIndex(0x3008, 0x0063);
Tag const MeasuredDoseReferenceNumber(0x3008, 0x0064);
Tag const ParameterPointer(0x3008, 0x0065);
Tag const OverrideReason(0x3008, 0x0066);
Tag const CorrectedParameterSequence(0x3008, 0x0068);
Tag const CorrectionValue(0x3008, 0x006a);
Tag const CalculatedDoseReferenceSequence(0x3008, 0x0070);
Tag const CalculatedDoseReferenceNumber(0x3008, 0x0072);
Tag const CalculatedDoseReferenceDescription(0x3008, 0x0074);
Tag const CalculatedDoseReferenceDoseValue(0x3008, 0x0076);
Tag const StartMeterset(0x3008, 0x0078);
Tag const EndMeterset(0x3008, 0x007a);
Tag const ReferencedMeasuredDoseReferenceSequence(0x3008, 0x0080);
Tag const ReferencedMeasuredDoseReferenceNumber(0x3008, 0x0082);
Tag const ReferencedCalculatedDoseReferenceSequence(0x3008, 0x0090);
Tag const ReferencedCalculatedDoseReferenceNumber(0x3008, 0x0092);
Tag const BeamLimitingDeviceLeafPairsSequence(0x3008, 0x00a0);
Tag const RecordedWedgeSequence(0x3008, 0x00b0);
Tag const RecordedCompensatorSequence(0x3008, 0x00c0);
Tag const RecordedBlockSequence(0x3008, 0x00d0);
Tag const TreatmentSummaryMeasuredDoseReferenceSequence(0x3008, 0x00e0);
Tag const RecordedSnoutSequence(0x3008, 0x00f0);
Tag const RecordedRangeShifterSequence(0x3008, 0x00f2);
Tag const RecordedLateralSpreadingDeviceSequence(0x3008, 0x00f4);
Tag const RecordedRangeModulatorSequence(0x3008, 0x00f6);
Tag const RecordedSourceSequence(0x3008, 0x0100);
Tag const SourceSerialNumber(0x3008, 0x0105);
Tag const TreatmentSessionApplicationSetupSequence(0x3008, 0x0110);
Tag const ApplicationSetupCheck(0x3008, 0x0116);
Tag const RecordedBrachyAccessoryDeviceSequence(0x3008, 0x0120);
Tag const ReferencedBrachyAccessoryDeviceNumber(0x3008, 0x0122);
Tag const RecordedChannelSequence(0x3008, 0x0130);
Tag const SpecifiedChannelTotalTime(0x3008, 0x0132);
Tag const DeliveredChannelTotalTime(0x3008, 0x0134);
Tag const SpecifiedNumberOfPulses(0x3008, 0x0136);
Tag const DeliveredNumberOfPulses(0x3008, 0x0138);
Tag const SpecifiedPulseRepetitionInterval(0x3008, 0x013a);
Tag const DeliveredPulseRepetitionInterval(0x3008, 0x013c);
Tag const RecordedSourceApplicatorSequence(0x3008, 0x0140);
Tag const ReferencedSourceApplicatorNumber(0x3008, 0x0142);
Tag const RecordedChannelShieldSequence(0x3008, 0x0150);
Tag const ReferencedChannelShieldNumber(0x3008, 0x0152);
Tag const BrachyControlPointDeliveredSequence(0x3008, 0x0160);
Tag const SafePositionExitDate(0x3008, 0x0162);
Tag const SafePositionExitTime(0x3008, 0x0164);
Tag const SafePositionReturnDate(0x3008, 0x0166);
Tag const SafePositionReturnTime(0x3008, 0x0168);
Tag const PulseSpecificBrachyControlPointDeliveredSequence(0x3008, 0x0171);
Tag const PulseNumber(0x3008, 0x0172);
Tag const BrachyPulseControlPointDeliveredSequence(0x3008, 0x0173);
Tag const CurrentTreatmentStatus(0x3008, 0x0200);
Tag const TreatmentStatusComment(0x3008, 0x0202);
Tag const FractionGroupSummarySequence(0x3008, 0x0220);
Tag const ReferencedFractionNumber(0x3008, 0x0223);
Tag const FractionGroupType(0x3008, 0x0224);
Tag const BeamStopperPosition(0x3008, 0x0230);
Tag const FractionStatusSummarySequence(0x3008, 0x0240);
Tag const TreatmentDate(0x3008, 0x0250);
Tag const TreatmentTime(0x3008, 0x0251);
Tag const RTPlanLabel(0x300a, 0x0002);
Tag const RTPlanName(0x300a, 0x0003);
Tag const RTPlanDescription(0x300a, 0x0004);
Tag const RTPlanDate(0x300a, 0x0006);
Tag const RTPlanTime(0x300a, 0x0007);
Tag const TreatmentProtocols(0x300a, 0x0009);
Tag const PlanIntent(0x300a, 0x000a);
Tag const TreatmentSites(0x300a, 0x000b);
Tag const RTPlanGeometry(0x300a, 0x000c);
Tag const PrescriptionDescription(0x300a, 0x000e);
Tag const DoseReferenceSequence(0x300a, 0x0010);
Tag const DoseReferenceNumber(0x300a, 0x0012);
Tag const DoseReferenceUID(0x300a, 0x0013);
Tag const DoseReferenceStructureType(0x300a, 0x0014);
Tag const NominalBeamEnergyUnit(0x300a, 0x0015);
Tag const DoseReferenceDescription(0x300a, 0x0016);
Tag const DoseReferencePointCoordinates(0x300a, 0x0018);
Tag const NominalPriorDose(0x300a, 0x001a);
Tag const DoseReferenceType(0x300a, 0x0020);
Tag const ConstraintWeight(0x300a, 0x0021);
Tag const DeliveryWarningDose(0x300a, 0x0022);
Tag const DeliveryMaximumDose(0x300a, 0x0023);
Tag const TargetMinimumDose(0x300a, 0x0025);
Tag const TargetPrescriptionDose(0x300a, 0x0026);
Tag const TargetMaximumDose(0x300a, 0x0027);
Tag const TargetUnderdoseVolumeFraction(0x300a, 0x0028);
Tag const OrganAtRiskFullVolumeDose(0x300a, 0x002a);
Tag const OrganAtRiskLimitDose(0x300a, 0x002b);
Tag const OrganAtRiskMaximumDose(0x300a, 0x002c);
Tag const OrganAtRiskOverdoseVolumeFraction(0x300a, 0x002d);
Tag const ToleranceTableSequence(0x300a, 0x0040);
Tag const ToleranceTableNumber(0x300a, 0x0042);
Tag const ToleranceTableLabel(0x300a, 0x0043);
Tag const GantryAngleTolerance(0x300a, 0x0044);
Tag const BeamLimitingDeviceAngleTolerance(0x300a, 0x0046);
Tag const BeamLimitingDeviceToleranceSequence(0x300a, 0x0048);
Tag const BeamLimitingDevicePositionTolerance(0x300a, 0x004a);
Tag const SnoutPositionTolerance(0x300a, 0x004b);
Tag const PatientSupportAngleTolerance(0x300a, 0x004c);
Tag const TableTopEccentricAngleTolerance(0x300a, 0x004e);
Tag const TableTopPitchAngleTolerance(0x300a, 0x004f);
Tag const TableTopRollAngleTolerance(0x300a, 0x0050);
Tag const TableTopVerticalPositionTolerance(0x300a, 0x0051);
Tag const TableTopLongitudinalPositionTolerance(0x300a, 0x0052);
Tag const TableTopLateralPositionTolerance(0x300a, 0x0053);
Tag const RTPlanRelationship(0x300a, 0x0055);
Tag const FractionGroupSequence(0x300a, 0x0070);
Tag const FractionGroupNumber(0x300a, 0x0071);
Tag const FractionGroupDescription(0x300a, 0x0072);
Tag const NumberOfFractionsPlanned(0x300a, 0x0078);
Tag const NumberOfFractionPatternDigitsPerDay(0x300a, 0x0079);
Tag const RepeatFractionCycleLength(0x300a, 0x007a);
Tag const FractionPattern(0x300a, 0x007b);
Tag const NumberOfBeams(0x300a, 0x0080);
Tag const BeamDoseSpecificationPoint(0x300a, 0x0082);
Tag const BeamDose(0x300a, 0x0084);
Tag const BeamMeterset(0x300a, 0x0086);
Tag const BeamDosePointDepth(0x300a, 0x0088);
Tag const BeamDosePointEquivalentDepth(0x300a, 0x0089);
Tag const BeamDosePointSSD(0x300a, 0x008a);
Tag const BeamDoseMeaning(0x300a, 0x008b);
Tag const BeamDoseVerificationControlPointSequence(0x300a, 0x008c);
Tag const AverageBeamDosePointDepth(0x300a, 0x008d);
Tag const AverageBeamDosePointEquivalentDepth(0x300a, 0x008e);
Tag const AverageBeamDosePointSSD(0x300a, 0x008f);
Tag const NumberOfBrachyApplicationSetups(0x300a, 0x00a0);
Tag const BrachyApplicationSetupDoseSpecificationPoint(0x300a, 0x00a2);
Tag const BrachyApplicationSetupDose(0x300a, 0x00a4);
Tag const BeamSequence(0x300a, 0x00b0);
Tag const TreatmentMachineName(0x300a, 0x00b2);
Tag const PrimaryDosimeterUnit(0x300a, 0x00b3);
Tag const SourceAxisDistance(0x300a, 0x00b4);
Tag const BeamLimitingDeviceSequence(0x300a, 0x00b6);
Tag const RTBeamLimitingDeviceType(0x300a, 0x00b8);
Tag const SourceToBeamLimitingDeviceDistance(0x300a, 0x00ba);
Tag const IsocenterToBeamLimitingDeviceDistance(0x300a, 0x00bb);
Tag const NumberOfLeafJawPairs(0x300a, 0x00bc);
Tag const LeafPositionBoundaries(0x300a, 0x00be);
Tag const BeamNumber(0x300a, 0x00c0);
Tag const BeamName(0x300a, 0x00c2);
Tag const BeamDescription(0x300a, 0x00c3);
Tag const BeamType(0x300a, 0x00c4);
Tag const BeamDeliveryDurationLimit(0x300a, 0x00c5);
Tag const RadiationType(0x300a, 0x00c6);
Tag const HighDoseTechniqueType(0x300a, 0x00c7);
Tag const ReferenceImageNumber(0x300a, 0x00c8);
Tag const PlannedVerificationImageSequence(0x300a, 0x00ca);
Tag const ImagingDeviceSpecificAcquisitionParameters(0x300a, 0x00cc);
Tag const TreatmentDeliveryType(0x300a, 0x00ce);
Tag const NumberOfWedges(0x300a, 0x00d0);
Tag const WedgeSequence(0x300a, 0x00d1);
Tag const WedgeNumber(0x300a, 0x00d2);
Tag const WedgeType(0x300a, 0x00d3);
Tag const WedgeID(0x300a, 0x00d4);
Tag const WedgeAngle(0x300a, 0x00d5);
Tag const WedgeFactor(0x300a, 0x00d6);
Tag const TotalWedgeTrayWaterEquivalentThickness(0x300a, 0x00d7);
Tag const WedgeOrientation(0x300a, 0x00d8);
Tag const IsocenterToWedgeTrayDistance(0x300a, 0x00d9);
Tag const SourceToWedgeTrayDistance(0x300a, 0x00da);
Tag const WedgeThinEdgePosition(0x300a, 0x00db);
Tag const BolusID(0x300a, 0x00dc);
Tag const BolusDescription(0x300a, 0x00dd);
Tag const EffectiveWedgeAngle(0x300a, 0x00de);
Tag const NumberOfCompensators(0x300a, 0x00e0);
Tag const MaterialID(0x300a, 0x00e1);
Tag const TotalCompensatorTrayFactor(0x300a, 0x00e2);
Tag const CompensatorSequence(0x300a, 0x00e3);
Tag const CompensatorNumber(0x300a, 0x00e4);
Tag const CompensatorID(0x300a, 0x00e5);
Tag const SourceToCompensatorTrayDistance(0x300a, 0x00e6);
Tag const CompensatorRows(0x300a, 0x00e7);
Tag const CompensatorColumns(0x300a, 0x00e8);
Tag const CompensatorPixelSpacing(0x300a, 0x00e9);
Tag const CompensatorPosition(0x300a, 0x00ea);
Tag const CompensatorTransmissionData(0x300a, 0x00eb);
Tag const CompensatorThicknessData(0x300a, 0x00ec);
Tag const NumberOfBoli(0x300a, 0x00ed);
Tag const CompensatorType(0x300a, 0x00ee);
Tag const CompensatorTrayID(0x300a, 0x00ef);
Tag const NumberOfBlocks(0x300a, 0x00f0);
Tag const TotalBlockTrayFactor(0x300a, 0x00f2);
Tag const TotalBlockTrayWaterEquivalentThickness(0x300a, 0x00f3);
Tag const BlockSequence(0x300a, 0x00f4);
Tag const BlockTrayID(0x300a, 0x00f5);
Tag const SourceToBlockTrayDistance(0x300a, 0x00f6);
Tag const IsocenterToBlockTrayDistance(0x300a, 0x00f7);
Tag const BlockType(0x300a, 0x00f8);
Tag const AccessoryCode(0x300a, 0x00f9);
Tag const BlockDivergence(0x300a, 0x00fa);
Tag const BlockMountingPosition(0x300a, 0x00fb);
Tag const BlockNumber(0x300a, 0x00fc);
Tag const BlockName(0x300a, 0x00fe);
Tag const BlockThickness(0x300a, 0x0100);
Tag const BlockTransmission(0x300a, 0x0102);
Tag const BlockNumberOfPoints(0x300a, 0x0104);
Tag const BlockData(0x300a, 0x0106);
Tag const ApplicatorSequence(0x300a, 0x0107);
Tag const ApplicatorID(0x300a, 0x0108);
Tag const ApplicatorType(0x300a, 0x0109);
Tag const ApplicatorDescription(0x300a, 0x010a);
Tag const CumulativeDoseReferenceCoefficient(0x300a, 0x010c);
Tag const FinalCumulativeMetersetWeight(0x300a, 0x010e);
Tag const NumberOfControlPoints(0x300a, 0x0110);
Tag const ControlPointSequence(0x300a, 0x0111);
Tag const ControlPointIndex(0x300a, 0x0112);
Tag const NominalBeamEnergy(0x300a, 0x0114);
Tag const DoseRateSet(0x300a, 0x0115);
Tag const WedgePositionSequence(0x300a, 0x0116);
Tag const WedgePosition(0x300a, 0x0118);
Tag const BeamLimitingDevicePositionSequence(0x300a, 0x011a);
Tag const LeafJawPositions(0x300a, 0x011c);
Tag const GantryAngle(0x300a, 0x011e);
Tag const GantryRotationDirection(0x300a, 0x011f);
Tag const BeamLimitingDeviceAngle(0x300a, 0x0120);
Tag const BeamLimitingDeviceRotationDirection(0x300a, 0x0121);
Tag const PatientSupportAngle(0x300a, 0x0122);
Tag const PatientSupportRotationDirection(0x300a, 0x0123);
Tag const TableTopEccentricAxisDistance(0x300a, 0x0124);
Tag const TableTopEccentricAngle(0x300a, 0x0125);
Tag const TableTopEccentricRotationDirection(0x300a, 0x0126);
Tag const TableTopVerticalPosition(0x300a, 0x0128);
Tag const TableTopLongitudinalPosition(0x300a, 0x0129);
Tag const TableTopLateralPosition(0x300a, 0x012a);
Tag const IsocenterPosition(0x300a, 0x012c);
Tag const SurfaceEntryPoint(0x300a, 0x012e);
Tag const SourceToSurfaceDistance(0x300a, 0x0130);
Tag const AverageBeamDosePointSourceToExternalContourSurfaceDistance(0x300a, 0x0131);
Tag const SourceToExternalContourDistance(0x300a, 0x0132);
Tag const ExternalContourEntryPoint(0x300a, 0x0133);
Tag const CumulativeMetersetWeight(0x300a, 0x0134);
Tag const TableTopPitchAngle(0x300a, 0x0140);
Tag const TableTopPitchRotationDirection(0x300a, 0x0142);
Tag const TableTopRollAngle(0x300a, 0x0144);
Tag const TableTopRollRotationDirection(0x300a, 0x0146);
Tag const HeadFixationAngle(0x300a, 0x0148);
Tag const GantryPitchAngle(0x300a, 0x014a);
Tag const GantryPitchRotationDirection(0x300a, 0x014c);
Tag const GantryPitchAngleTolerance(0x300a, 0x014e);
Tag const PatientSetupSequence(0x300a, 0x0180);
Tag const PatientSetupNumber(0x300a, 0x0182);
Tag const PatientSetupLabel(0x300a, 0x0183);
Tag const PatientAdditionalPosition(0x300a, 0x0184);
Tag const FixationDeviceSequence(0x300a, 0x0190);
Tag const FixationDeviceType(0x300a, 0x0192);
Tag const FixationDeviceLabel(0x300a, 0x0194);
Tag const FixationDeviceDescription(0x300a, 0x0196);
Tag const FixationDevicePosition(0x300a, 0x0198);
Tag const FixationDevicePitchAngle(0x300a, 0x0199);
Tag const FixationDeviceRollAngle(0x300a, 0x019a);
Tag const ShieldingDeviceSequence(0x300a, 0x01a0);
Tag const ShieldingDeviceType(0x300a, 0x01a2);
Tag const ShieldingDeviceLabel(0x300a, 0x01a4);
Tag const ShieldingDeviceDescription(0x300a, 0x01a6);
Tag const ShieldingDevicePosition(0x300a, 0x01a8);
Tag const SetupTechnique(0x300a, 0x01b0);
Tag const SetupTechniqueDescription(0x300a, 0x01b2);
Tag const SetupDeviceSequence(0x300a, 0x01b4);
Tag const SetupDeviceType(0x300a, 0x01b6);
Tag const SetupDeviceLabel(0x300a, 0x01b8);
Tag const SetupDeviceDescription(0x300a, 0x01ba);
Tag const SetupDeviceParameter(0x300a, 0x01bc);
Tag const SetupReferenceDescription(0x300a, 0x01d0);
Tag const TableTopVerticalSetupDisplacement(0x300a, 0x01d2);
Tag const TableTopLongitudinalSetupDisplacement(0x300a, 0x01d4);
Tag const TableTopLateralSetupDisplacement(0x300a, 0x01d6);
Tag const BrachyTreatmentTechnique(0x300a, 0x0200);
Tag const BrachyTreatmentType(0x300a, 0x0202);
Tag const TreatmentMachineSequence(0x300a, 0x0206);
Tag const SourceSequence(0x300a, 0x0210);
Tag const SourceNumber(0x300a, 0x0212);
Tag const SourceType(0x300a, 0x0214);
Tag const SourceManufacturer(0x300a, 0x0216);
Tag const ActiveSourceDiameter(0x300a, 0x0218);
Tag const ActiveSourceLength(0x300a, 0x021a);
Tag const SourceModelID(0x300a, 0x021b);
Tag const SourceDescription(0x300a, 0x021c);
Tag const SourceEncapsulationNominalThickness(0x300a, 0x0222);
Tag const SourceEncapsulationNominalTransmission(0x300a, 0x0224);
Tag const SourceIsotopeName(0x300a, 0x0226);
Tag const SourceIsotopeHalfLife(0x300a, 0x0228);
Tag const SourceStrengthUnits(0x300a, 0x0229);
Tag const ReferenceAirKermaRate(0x300a, 0x022a);
Tag const SourceStrength(0x300a, 0x022b);
Tag const SourceStrengthReferenceDate(0x300a, 0x022c);
Tag const SourceStrengthReferenceTime(0x300a, 0x022e);
Tag const ApplicationSetupSequence(0x300a, 0x0230);
Tag const ApplicationSetupType(0x300a, 0x0232);
Tag const ApplicationSetupNumber(0x300a, 0x0234);
Tag const ApplicationSetupName(0x300a, 0x0236);
Tag const ApplicationSetupManufacturer(0x300a, 0x0238);
Tag const TemplateNumber(0x300a, 0x0240);
Tag const TemplateType(0x300a, 0x0242);
Tag const TemplateName(0x300a, 0x0244);
Tag const TotalReferenceAirKerma(0x300a, 0x0250);
Tag const BrachyAccessoryDeviceSequence(0x300a, 0x0260);
Tag const BrachyAccessoryDeviceNumber(0x300a, 0x0262);
Tag const BrachyAccessoryDeviceID(0x300a, 0x0263);
Tag const BrachyAccessoryDeviceType(0x300a, 0x0264);
Tag const BrachyAccessoryDeviceName(0x300a, 0x0266);
Tag const BrachyAccessoryDeviceNominalThickness(0x300a, 0x026a);
Tag const BrachyAccessoryDeviceNominalTransmission(0x300a, 0x026c);
Tag const ChannelSequence(0x300a, 0x0280);
Tag const ChannelNumber(0x300a, 0x0282);
Tag const ChannelLength(0x300a, 0x0284);
Tag const ChannelTotalTime(0x300a, 0x0286);
Tag const SourceMovementType(0x300a, 0x0288);
Tag const NumberOfPulses(0x300a, 0x028a);
Tag const PulseRepetitionInterval(0x300a, 0x028c);
Tag const SourceApplicatorNumber(0x300a, 0x0290);
Tag const SourceApplicatorID(0x300a, 0x0291);
Tag const SourceApplicatorType(0x300a, 0x0292);
Tag const SourceApplicatorName(0x300a, 0x0294);
Tag const SourceApplicatorLength(0x300a, 0x0296);
Tag const SourceApplicatorManufacturer(0x300a, 0x0298);
Tag const SourceApplicatorWallNominalThickness(0x300a, 0x029c);
Tag const SourceApplicatorWallNominalTransmission(0x300a, 0x029e);
Tag const SourceApplicatorStepSize(0x300a, 0x02a0);
Tag const TransferTubeNumber(0x300a, 0x02a2);
Tag const TransferTubeLength(0x300a, 0x02a4);
Tag const ChannelShieldSequence(0x300a, 0x02b0);
Tag const ChannelShieldNumber(0x300a, 0x02b2);
Tag const ChannelShieldID(0x300a, 0x02b3);
Tag const ChannelShieldName(0x300a, 0x02b4);
Tag const ChannelShieldNominalThickness(0x300a, 0x02b8);
Tag const ChannelShieldNominalTransmission(0x300a, 0x02ba);
Tag const FinalCumulativeTimeWeight(0x300a, 0x02c8);
Tag const BrachyControlPointSequence(0x300a, 0x02d0);
Tag const ControlPointRelativePosition(0x300a, 0x02d2);
Tag const ControlPoint3DPosition(0x300a, 0x02d4);
Tag const CumulativeTimeWeight(0x300a, 0x02d6);
Tag const CompensatorDivergence(0x300a, 0x02e0);
Tag const CompensatorMountingPosition(0x300a, 0x02e1);
Tag const SourceToCompensatorDistance(0x300a, 0x02e2);
Tag const TotalCompensatorTrayWaterEquivalentThickness(0x300a, 0x02e3);
Tag const IsocenterToCompensatorTrayDistance(0x300a, 0x02e4);
Tag const CompensatorColumnOffset(0x300a, 0x02e5);
Tag const IsocenterToCompensatorDistances(0x300a, 0x02e6);
Tag const CompensatorRelativeStoppingPowerRatio(0x300a, 0x02e7);
Tag const CompensatorMillingToolDiameter(0x300a, 0x02e8);
Tag const IonRangeCompensatorSequence(0x300a, 0x02ea);
Tag const CompensatorDescription(0x300a, 0x02eb);
Tag const RadiationMassNumber(0x300a, 0x0302);
Tag const RadiationAtomicNumber(0x300a, 0x0304);
Tag const RadiationChargeState(0x300a, 0x0306);
Tag const ScanMode(0x300a, 0x0308);
Tag const VirtualSourceAxisDistances(0x300a, 0x030a);
Tag const SnoutSequence(0x300a, 0x030c);
Tag const SnoutPosition(0x300a, 0x030d);
Tag const SnoutID(0x300a, 0x030f);
Tag const NumberOfRangeShifters(0x300a, 0x0312);
Tag const RangeShifterSequence(0x300a, 0x0314);
Tag const RangeShifterNumber(0x300a, 0x0316);
Tag const RangeShifterID(0x300a, 0x0318);
Tag const RangeShifterType(0x300a, 0x0320);
Tag const RangeShifterDescription(0x300a, 0x0322);
Tag const NumberOfLateralSpreadingDevices(0x300a, 0x0330);
Tag const LateralSpreadingDeviceSequence(0x300a, 0x0332);
Tag const LateralSpreadingDeviceNumber(0x300a, 0x0334);
Tag const LateralSpreadingDeviceID(0x300a, 0x0336);
Tag const LateralSpreadingDeviceType(0x300a, 0x0338);
Tag const LateralSpreadingDeviceDescription(0x300a, 0x033a);
Tag const LateralSpreadingDeviceWaterEquivalentThickness(0x300a, 0x033c);
Tag const NumberOfRangeModulators(0x300a, 0x0340);
Tag const RangeModulatorSequence(0x300a, 0x0342);
Tag const RangeModulatorNumber(0x300a, 0x0344);
Tag const RangeModulatorID(0x300a, 0x0346);
Tag const RangeModulatorType(0x300a, 0x0348);
Tag const RangeModulatorDescription(0x300a, 0x034a);
Tag const BeamCurrentModulationID(0x300a, 0x034c);
Tag const PatientSupportType(0x300a, 0x0350);
Tag const PatientSupportID(0x300a, 0x0352);
Tag const PatientSupportAccessoryCode(0x300a, 0x0354);
Tag const FixationLightAzimuthalAngle(0x300a, 0x0356);
Tag const FixationLightPolarAngle(0x300a, 0x0358);
Tag const MetersetRate(0x300a, 0x035a);
Tag const RangeShifterSettingsSequence(0x300a, 0x0360);
Tag const RangeShifterSetting(0x300a, 0x0362);
Tag const IsocenterToRangeShifterDistance(0x300a, 0x0364);
Tag const RangeShifterWaterEquivalentThickness(0x300a, 0x0366);
Tag const LateralSpreadingDeviceSettingsSequence(0x300a, 0x0370);
Tag const LateralSpreadingDeviceSetting(0x300a, 0x0372);
Tag const IsocenterToLateralSpreadingDeviceDistance(0x300a, 0x0374);
Tag const RangeModulatorSettingsSequence(0x300a, 0x0380);
Tag const RangeModulatorGatingStartValue(0x300a, 0x0382);
Tag const RangeModulatorGatingStopValue(0x300a, 0x0384);
Tag const RangeModulatorGatingStartWaterEquivalentThickness(0x300a, 0x0386);
Tag const RangeModulatorGatingStopWaterEquivalentThickness(0x300a, 0x0388);
Tag const IsocenterToRangeModulatorDistance(0x300a, 0x038a);
Tag const ScanSpotTuneID(0x300a, 0x0390);
Tag const NumberOfScanSpotPositions(0x300a, 0x0392);
Tag const ScanSpotPositionMap(0x300a, 0x0394);
Tag const ScanSpotMetersetWeights(0x300a, 0x0396);
Tag const ScanningSpotSize(0x300a, 0x0398);
Tag const NumberOfPaintings(0x300a, 0x039a);
Tag const IonToleranceTableSequence(0x300a, 0x03a0);
Tag const IonBeamSequence(0x300a, 0x03a2);
Tag const IonBeamLimitingDeviceSequence(0x300a, 0x03a4);
Tag const IonBlockSequence(0x300a, 0x03a6);
Tag const IonControlPointSequence(0x300a, 0x03a8);
Tag const IonWedgeSequence(0x300a, 0x03aa);
Tag const IonWedgePositionSequence(0x300a, 0x03ac);
Tag const ReferencedSetupImageSequence(0x300a, 0x0401);
Tag const SetupImageComment(0x300a, 0x0402);
Tag const MotionSynchronizationSequence(0x300a, 0x0410);
Tag const ControlPointOrientation(0x300a, 0x0412);
Tag const GeneralAccessorySequence(0x300a, 0x0420);
Tag const GeneralAccessoryID(0x300a, 0x0421);
Tag const GeneralAccessoryDescription(0x300a, 0x0422);
Tag const GeneralAccessoryType(0x300a, 0x0423);
Tag const GeneralAccessoryNumber(0x300a, 0x0424);
Tag const SourceToGeneralAccessoryDistance(0x300a, 0x0425);
Tag const ApplicatorGeometrySequence(0x300a, 0x0431);
Tag const ApplicatorApertureShape(0x300a, 0x0432);
Tag const ApplicatorOpening(0x300a, 0x0433);
Tag const ApplicatorOpeningX(0x300a, 0x0434);
Tag const ApplicatorOpeningY(0x300a, 0x0435);
Tag const SourceToApplicatorMountingPositionDistance(0x300a, 0x0436);
Tag const NumberOfBlockSlabItems(0x300a, 0x0440);
Tag const BlockSlabSequence(0x300a, 0x0441);
Tag const BlockSlabThickness(0x300a, 0x0442);
Tag const BlockSlabNumber(0x300a, 0x0443);
Tag const DeviceMotionControlSequence(0x300a, 0x0450);
Tag const DeviceMotionExecutionMode(0x300a, 0x0451);
Tag const DeviceMotionObservationMode(0x300a, 0x0452);
Tag const DeviceMotionParameterCodeSequence(0x300a, 0x0453);
Tag const ReferencedRTPlanSequence(0x300c, 0x0002);
Tag const ReferencedBeamSequence(0x300c, 0x0004);
Tag const ReferencedBeamNumber(0x300c, 0x0006);
Tag const ReferencedReferenceImageNumber(0x300c, 0x0007);
Tag const StartCumulativeMetersetWeight(0x300c, 0x0008);
Tag const EndCumulativeMetersetWeight(0x300c, 0x0009);
Tag const ReferencedBrachyApplicationSetupSequence(0x300c, 0x000a);
Tag const ReferencedBrachyApplicationSetupNumber(0x300c, 0x000c);
Tag const ReferencedSourceNumber(0x300c, 0x000e);
Tag const ReferencedFractionGroupSequence(0x300c, 0x0020);
Tag const ReferencedFractionGroupNumber(0x300c, 0x0022);
Tag const ReferencedVerificationImageSequence(0x300c, 0x0040);
Tag const ReferencedReferenceImageSequence(0x300c, 0x0042);
Tag const ReferencedDoseReferenceSequence(0x300c, 0x0050);
Tag const ReferencedDoseReferenceNumber(0x300c, 0x0051);
Tag const BrachyReferencedDoseReferenceSequence(0x300c, 0x0055);
Tag const ReferencedStructureSetSequence(0x300c, 0x0060);
Tag const ReferencedPatientSetupNumber(0x300c, 0x006a);
Tag const ReferencedDoseSequence(0x300c, 0x0080);
Tag const ReferencedToleranceTableNumber(0x300c, 0x00a0);
Tag const ReferencedBolusSequence(0x300c, 0x00b0);
Tag const ReferencedWedgeNumber(0x300c, 0x00c0);
Tag const ReferencedCompensatorNumber(0x300c, 0x00d0);
Tag const ReferencedBlockNumber(0x300c, 0x00e0);
Tag const ReferencedControlPointIndex(0x300c, 0x00f0);
Tag const ReferencedControlPointSequence(0x300c, 0x00f2);
Tag const ReferencedStartControlPointIndex(0x300c, 0x00f4);
Tag const ReferencedStopControlPointIndex(0x300c, 0x00f6);
Tag const ReferencedRangeShifterNumber(0x300c, 0x0100);
Tag const ReferencedLateralSpreadingDeviceNumber(0x300c, 0x0102);
Tag const ReferencedRangeModulatorNumber(0x300c, 0x0104);
Tag const OmittedBeamTaskSequence(0x300c, 0x0111);
Tag const ReasonForOmission(0x300c, 0x0112);
Tag const ReasonForOmissionDescription(0x300c, 0x0113);
Tag const ApprovalStatus(0x300e, 0x0002);
Tag const ReviewDate(0x300e, 0x0004);
Tag const ReviewTime(0x300e, 0x0005);
Tag const ReviewerName(0x300e, 0x0008);
Tag const Arbitrary(0x4000, 0x0010);
Tag const TextComments(0x4000, 0x4000);
Tag const ResultsID(0x4008, 0x0040);
Tag const ResultsIDIssuer(0x4008, 0x0042);
Tag const ReferencedInterpretationSequence(0x4008, 0x0050);
Tag const ReportProductionStatusTrial(0x4008, 0x00ff);
Tag const InterpretationRecordedDate(0x4008, 0x0100);
Tag const InterpretationRecordedTime(0x4008, 0x0101);
Tag const InterpretationRecorder(0x4008, 0x0102);
Tag const ReferenceToRecordedSound(0x4008, 0x0103);
Tag const InterpretationTranscriptionDate(0x4008, 0x0108);
Tag const InterpretationTranscriptionTime(0x4008, 0x0109);
Tag const InterpretationTranscriber(0x4008, 0x010a);
Tag const InterpretationText(0x4008, 0x010b);
Tag const InterpretationAuthor(0x4008, 0x010c);
Tag const InterpretationApproverSequence(0x4008, 0x0111);
Tag const InterpretationApprovalDate(0x4008, 0x0112);
Tag const InterpretationApprovalTime(0x4008, 0x0113);
Tag const PhysicianApprovingInterpretation(0x4008, 0x0114);
Tag const InterpretationDiagnosisDescription(0x4008, 0x0115);
Tag const InterpretationDiagnosisCodeSequence(0x4008, 0x0117);
Tag const ResultsDistributionListSequence(0x4008, 0x0118);
Tag const DistributionName(0x4008, 0x0119);
Tag const DistributionAddress(0x4008, 0x011a);
Tag const InterpretationID(0x4008, 0x0200);
Tag const InterpretationIDIssuer(0x4008, 0x0202);
Tag const InterpretationTypeID(0x4008, 0x0210);
Tag const InterpretationStatusID(0x4008, 0x0212);
Tag const Impressions(0x4008, 0x0300);
Tag const ResultsComments(0x4008, 0x4000);
Tag const LowEnergyDetectors(0x4010, 0x0001);
Tag const HighEnergyDetectors(0x4010, 0x0002);
Tag const DetectorGeometrySequence(0x4010, 0x0004);
Tag const ThreatROIVoxelSequence(0x4010, 0x1001);
Tag const ThreatROIBase(0x4010, 0x1004);
Tag const ThreatROIExtents(0x4010, 0x1005);
Tag const ThreatROIBitmap(0x4010, 0x1006);
Tag const RouteSegmentID(0x4010, 0x1007);
Tag const GantryType(0x4010, 0x1008);
Tag const OOIOwnerType(0x4010, 0x1009);
Tag const RouteSegmentSequence(0x4010, 0x100a);
Tag const PotentialThreatObjectID(0x4010, 0x1010);
Tag const ThreatSequence(0x4010, 0x1011);
Tag const ThreatCategory(0x4010, 0x1012);
Tag const ThreatCategoryDescription(0x4010, 0x1013);
Tag const ATDAbilityAssessment(0x4010, 0x1014);
Tag const ATDAssessmentFlag(0x4010, 0x1015);
Tag const ATDAssessmentProbability(0x4010, 0x1016);
Tag const Mass(0x4010, 0x1017);
Tag const Density(0x4010, 0x1018);
Tag const ZEffective(0x4010, 0x1019);
Tag const BoardingPassID(0x4010, 0x101a);
Tag const CenterOfMass(0x4010, 0x101b);
Tag const CenterOfPTO(0x4010, 0x101c);
Tag const BoundingPolygon(0x4010, 0x101d);
Tag const RouteSegmentStartLocationID(0x4010, 0x101e);
Tag const RouteSegmentEndLocationID(0x4010, 0x101f);
Tag const RouteSegmentLocationIDType(0x4010, 0x1020);
Tag const AbortReason(0x4010, 0x1021);
Tag const VolumeOfPTO(0x4010, 0x1023);
Tag const AbortFlag(0x4010, 0x1024);
Tag const RouteSegmentStartTime(0x4010, 0x1025);
Tag const RouteSegmentEndTime(0x4010, 0x1026);
Tag const TDRType(0x4010, 0x1027);
Tag const InternationalRouteSegment(0x4010, 0x1028);
Tag const ThreatDetectionAlgorithmandVersion(0x4010, 0x1029);
Tag const AssignedLocation(0x4010, 0x102a);
Tag const AlarmDecisionTime(0x4010, 0x102b);
Tag const AlarmDecision(0x4010, 0x1031);
Tag const NumberOfTotalObjects(0x4010, 0x1033);
Tag const NumberOfAlarmObjects(0x4010, 0x1034);
Tag const PTORepresentationSequence(0x4010, 0x1037);
Tag const ATDAssessmentSequence(0x4010, 0x1038);
Tag const TIPType(0x4010, 0x1039);
Tag const DICOSVersion(0x4010, 0x103a);
Tag const OOIOwnerCreationTime(0x4010, 0x1041);
Tag const OOIType(0x4010, 0x1042);
Tag const OOISize(0x4010, 0x1043);
Tag const AcquisitionStatus(0x4010, 0x1044);
Tag const BasisMaterialsCodeSequence(0x4010, 0x1045);
Tag const PhantomType(0x4010, 0x1046);
Tag const OOIOwnerSequence(0x4010, 0x1047);
Tag const ScanType(0x4010, 0x1048);
Tag const ItineraryID(0x4010, 0x1051);
Tag const ItineraryIDType(0x4010, 0x1052);
Tag const ItineraryIDAssigningAuthority(0x4010, 0x1053);
Tag const RouteID(0x4010, 0x1054);
Tag const RouteIDAssigningAuthority(0x4010, 0x1055);
Tag const InboundArrivalType(0x4010, 0x1056);
Tag const CarrierID(0x4010, 0x1058);
Tag const CarrierIDAssigningAuthority(0x4010, 0x1059);
Tag const SourceOrientation(0x4010, 0x1060);
Tag const SourcePosition(0x4010, 0x1061);
Tag const BeltHeight(0x4010, 0x1062);
Tag const AlgorithmRoutingCodeSequence(0x4010, 0x1064);
Tag const TransportClassification(0x4010, 0x1067);
Tag const OOITypeDescriptor(0x4010, 0x1068);
Tag const TotalProcessingTime(0x4010, 0x1069);
Tag const DetectorCalibrationData(0x4010, 0x106c);
Tag const AdditionalScreeningPerformed(0x4010, 0x106d);
Tag const AdditionalInspectionSelectionCriteria(0x4010, 0x106e);
Tag const AdditionalInspectionMethodSequence(0x4010, 0x106f);
Tag const AITDeviceType(0x4010, 0x1070);
Tag const QRMeasurementsSequence(0x4010, 0x1071);
Tag const TargetMaterialSequence(0x4010, 0x1072);
Tag const SNRThreshold(0x4010, 0x1073);
Tag const ImageScaleRepresentation(0x4010, 0x1075);
Tag const ReferencedPTOSequence(0x4010, 0x1076);
Tag const ReferencedTDRInstanceSequence(0x4010, 0x1077);
Tag const PTOLocationDescription(0x4010, 0x1078);
Tag const AnomalyLocatorIndicatorSequence(0x4010, 0x1079);
Tag const AnomalyLocatorIndicator(0x4010, 0x107a);
Tag const PTORegionSequence(0x4010, 0x107b);
Tag const InspectionSelectionCriteria(0x4010, 0x107c);
Tag const SecondaryInspectionMethodSequence(0x4010, 0x107d);
Tag const PRCSToRCSOrientation(0x4010, 0x107e);
Tag const MACParametersSequence(0x4ffe, 0x0001);
Tag const SharedFunctionalGroupsSequence(0x5200, 0x9229);
Tag const PerFrameFunctionalGroupsSequence(0x5200, 0x9230);
Tag const WaveformSequence(0x5400, 0x0100);
Tag const ChannelMinimumValue(0x5400, 0x0110);
Tag const ChannelMaximumValue(0x5400, 0x0112);
Tag const WaveformBitsAllocated(0x5400, 0x1004);
Tag const WaveformSampleInterpretation(0x5400, 0x1006);
Tag const WaveformPaddingValue(0x5400, 0x100a);
Tag const WaveformData(0x5400, 0x1010);
Tag const FirstOrderPhaseCorrectionAngle(0x5600, 0x0010);
Tag const SpectroscopyData(0x5600, 0x0020);
Tag const FloatPixelData(0x7fe0, 0x0008);
Tag const DoubleFloatPixelData(0x7fe0, 0x0009);
Tag const PixelData(0x7fe0, 0x0010);
Tag const CoefficientsSDVN(0x7fe0, 0x0020);
Tag const CoefficientsSDHN(0x7fe0, 0x0030);
Tag const CoefficientsSDDN(0x7fe0, 0x0040);
Tag const DigitalSignaturesSequence(0xfffa, 0xfffa);
Tag const DataSetTrailingPadding(0xfffc, 0xfffc);
Tag const Item(0xfffe, 0xe000);
Tag const ItemDelimitationItem(0xfffe, 0xe00d);
Tag const SequenceDelimitationItem(0xfffe, 0xe0dd);

std::string const VerificationSOPClass("1.2.840.10008.1.1");
std::string const ImplicitVRLittleEndian("1.2.840.10008.1.2");
std::string const ExplicitVRLittleEndian("1.2.840.10008.1.2.1");
std::string const DeflatedExplicitVRLittleEndian("1.2.840.10008.1.2.1.99");
std::string const ExplicitVRBigEndian_Retired("1.2.840.10008.1.2.2");
std::string const JPEGBaselineProcess1("1.2.840.10008.1.2.4.50");
std::string const JPEGExtendedProcess24("1.2.840.10008.1.2.4.51");
std::string const JPEGExtendedProcess35_Retired("1.2.840.10008.1.2.4.52");
std::string const JPEGSpectralSelectionNonHierarchicalProcess68_Retired("1.2.840.10008.1.2.4.53");
std::string const JPEGSpectralSelectionNonHierarchicalProcess79_Retired("1.2.840.10008.1.2.4.54");
std::string const JPEGFullProgressionNonHierarchicalProcess1012_Retired("1.2.840.10008.1.2.4.55");
std::string const JPEGFullProgressionNonHierarchicalProcess1113_Retired("1.2.840.10008.1.2.4.56");
std::string const JPEGLosslessNonHierarchicalProcess14("1.2.840.10008.1.2.4.57");
std::string const JPEGLosslessNonHierarchicalProcess15_Retired("1.2.840.10008.1.2.4.58");
std::string const JPEGExtendedHierarchicalProcess1618_Retired("1.2.840.10008.1.2.4.59");
std::string const JPEGExtendedHierarchicalProcess1719_Retired("1.2.840.10008.1.2.4.60");
std::string const JPEGSpectralSelectionHierarchicalProcess2022_Retired("1.2.840.10008.1.2.4.61");
std::string const JPEGSpectralSelectionHierarchicalProcess2123_Retired("1.2.840.10008.1.2.4.62");
std::string const JPEGFullProgressionHierarchicalProcess2426_Retired("1.2.840.10008.1.2.4.63");
std::string const JPEGFullProgressionHierarchicalProcess2527_Retired("1.2.840.10008.1.2.4.64");
std::string const JPEGLosslessHierarchicalProcess28_Retired("1.2.840.10008.1.2.4.65");
std::string const JPEGLosslessHierarchicalProcess29_Retired("1.2.840.10008.1.2.4.66");
std::string const JPEGLosslessNonHierarchicalFirstOrderPredictionProcess14SelectionValue1("1.2.840.10008.1.2.4.70");
std::string const JPEGLSLosslessImageCompression("1.2.840.10008.1.2.4.80");
std::string const JPEGLSLossyNearLosslessImageCompression("1.2.840.10008.1.2.4.81");
std::string const JPEG2000ImageCompressionLosslessOnly("1.2.840.10008.1.2.4.90");
std::string const JPEG2000ImageCompression("1.2.840.10008.1.2.4.91");
std::string const JPEG2000Part2MulticomponentImageCompressionLosslessOnly("1.2.840.10008.1.2.4.92");
std::string const JPEG2000Part2MulticomponentImageCompression("1.2.840.10008.1.2.4.93");
std::string const JPIPReferenced("1.2.840.10008.1.2.4.94");
std::string const JPIPReferencedDeflate("1.2.840.10008.1.2.4.95");
std::string const MPEG2MainProfileMainLevel("1.2.840.10008.1.2.4.100");
std::string const MPEG2MainProfileHighLevel("1.2.840.10008.1.2.4.101");
std::string const MPEG4AVCH264HighProfileLevel41("1.2.840.10008.1.2.4.102");
std::string const MPEG4AVCH264BDcompatibleHighProfileLevel41("1.2.840.10008.1.2.4.103");
std::string const MPEG4AVCH264HighProfileLevel42For2DVideo("1.2.840.10008.1.2.4.104");
std::string const MPEG4AVCH264HighProfileLevel42For3DVideo("1.2.840.10008.1.2.4.105");
std::string const MPEG4AVCH264StereoHighProfileLevel42("1.2.840.10008.1.2.4.106");
std::string const RLELossless("1.2.840.10008.1.2.5");
std::string const RFC2557MIMEencapsulation("1.2.840.10008.1.2.6.1");
std::string const XMLEncoding("1.2.840.10008.1.2.6.2");
std::string const MediaStorageDirectoryStorage("1.2.840.10008.1.3.10");
std::string const TalairachBrainAtlasFrameofReference("1.2.840.10008.1.4.1.1");
std::string const SPM2T1FrameofReference("1.2.840.10008.1.4.1.2");
std::string const SPM2T2FrameofReference("1.2.840.10008.1.4.1.3");
std::string const SPM2PDFrameofReference("1.2.840.10008.1.4.1.4");
std::string const SPM2EPIFrameofReference("1.2.840.10008.1.4.1.5");
std::string const SPM2FILT1FrameofReference("1.2.840.10008.1.4.1.6");
std::string const SPM2PETFrameofReference("1.2.840.10008.1.4.1.7");
std::string const SPM2TRANSMFrameofReference("1.2.840.10008.1.4.1.8");
std::string const SPM2SPECTFrameofReference("1.2.840.10008.1.4.1.9");
std::string const SPM2GRAYFrameofReference("1.2.840.10008.1.4.1.10");
std::string const SPM2WHITEFrameofReference("1.2.840.10008.1.4.1.11");
std::string const SPM2CSFFrameofReference("1.2.840.10008.1.4.1.12");
std::string const SPM2BRAINMASKFrameofReference("1.2.840.10008.1.4.1.13");
std::string const SPM2AVG305T1FrameofReference("1.2.840.10008.1.4.1.14");
std::string const SPM2AVG152T1FrameofReference("1.2.840.10008.1.4.1.15");
std::string const SPM2AVG152T2FrameofReference("1.2.840.10008.1.4.1.16");
std::string const SPM2AVG152PDFrameofReference("1.2.840.10008.1.4.1.17");
std::string const SPM2SINGLESUBJT1FrameofReference("1.2.840.10008.1.4.1.18");
std::string const ICBM452T1FrameofReference("1.2.840.10008.1.4.2.1");
std::string const ICBMSingleSubjectMRIFrameofReference("1.2.840.10008.1.4.2.2");
std::string const HotIronColorPaletteSOPInstance("1.2.840.10008.1.5.1");
std::string const PETColorPaletteSOPInstance("1.2.840.10008.1.5.2");
std::string const HotMetalBlueColorPaletteSOPInstance("1.2.840.10008.1.5.3");
std::string const PET20StepColorPaletteSOPInstance("1.2.840.10008.1.5.4");
std::string const BasicStudyContentNotificationSOPClass_Retired("1.2.840.10008.1.9");
std::string const StorageCommitmentPushModelSOPClass("1.2.840.10008.1.20.1");
std::string const StorageCommitmentPushModelSOPInstance("1.2.840.10008.1.20.1.1");
std::string const StorageCommitmentPullModelSOPClass_Retired("1.2.840.10008.1.20.2");
std::string const StorageCommitmentPullModelSOPInstance_Retired("1.2.840.10008.1.20.2.1");
std::string const ProceduralEventLoggingSOPClass("1.2.840.10008.1.40");
std::string const ProceduralEventLoggingSOPInstance("1.2.840.10008.1.40.1");
std::string const SubstanceAdministrationLoggingSOPClass("1.2.840.10008.1.42");
std::string const SubstanceAdministrationLoggingSOPInstance("1.2.840.10008.1.42.1");
std::string const DICOMUIDRegistry("1.2.840.10008.2.6.1");
std::string const DICOMControlledTerminology("1.2.840.10008.2.16.4");
std::string const DICOMApplicationContextName("1.2.840.10008.3.1.1.1");
std::string const DetachedPatientManagementSOPClass_Retired("1.2.840.10008.3.1.2.1.1");
std::string const DetachedPatientManagementMetaSOPClass_Retired("1.2.840.10008.3.1.2.1.4");
std::string const DetachedVisitManagementSOPClass_Retired("1.2.840.10008.3.1.2.2.1");
std::string const DetachedStudyManagementSOPClass_Retired("1.2.840.10008.3.1.2.3.1");
std::string const StudyComponentManagementSOPClass_Retired("1.2.840.10008.3.1.2.3.2");
std::string const ModalityPerformedProcedureStepSOPClass("1.2.840.10008.3.1.2.3.3");
std::string const ModalityPerformedProcedureStepRetrieveSOPClass("1.2.840.10008.3.1.2.3.4");
std::string const ModalityPerformedProcedureStepNotificationSOPClass("1.2.840.10008.3.1.2.3.5");
std::string const DetachedResultsManagementSOPClass_Retired("1.2.840.10008.3.1.2.5.1");
std::string const DetachedResultsManagementMetaSOPClass_Retired("1.2.840.10008.3.1.2.5.4");
std::string const DetachedStudyManagementMetaSOPClass_Retired("1.2.840.10008.3.1.2.5.5");
std::string const DetachedInterpretationManagementSOPClass_Retired("1.2.840.10008.3.1.2.6.1");
std::string const StorageServiceClass("1.2.840.10008.4.2");
std::string const BasicFilmSessionSOPClass("1.2.840.10008.5.1.1.1");
std::string const BasicFilmBoxSOPClass("1.2.840.10008.5.1.1.2");
std::string const BasicGrayscaleImageBoxSOPClass("1.2.840.10008.5.1.1.4");
std::string const BasicColorImageBoxSOPClass("1.2.840.10008.5.1.1.4.1");
std::string const ReferencedImageBoxSOPClass_Retired("1.2.840.10008.5.1.1.4.2");
std::string const BasicGrayscalePrintManagementMetaSOPClass("1.2.840.10008.5.1.1.9");
std::string const ReferencedGrayscalePrintManagementMetaSOPClass_Retired("1.2.840.10008.5.1.1.9.1");
std::string const PrintJobSOPClass("1.2.840.10008.5.1.1.14");
std::string const BasicAnnotationBoxSOPClass("1.2.840.10008.5.1.1.15");
std::string const PrinterSOPClass("1.2.840.10008.5.1.1.16");
std::string const PrinterConfigurationRetrievalSOPClass("1.2.840.10008.5.1.1.16.376");
std::string const PrinterSOPInstance("1.2.840.10008.5.1.1.17");
std::string const PrinterConfigurationRetrievalSOPInstance("1.2.840.10008.5.1.1.17.376");
std::string const BasicColorPrintManagementMetaSOPClass("1.2.840.10008.5.1.1.18");
std::string const ReferencedColorPrintManagementMetaSOPClass_Retired("1.2.840.10008.5.1.1.18.1");
std::string const VOILUTBoxSOPClass("1.2.840.10008.5.1.1.22");
std::string const PresentationLUTSOPClass("1.2.840.10008.5.1.1.23");
std::string const ImageOverlayBoxSOPClass_Retired("1.2.840.10008.5.1.1.24");
std::string const BasicPrintImageOverlayBoxSOPClass_Retired("1.2.840.10008.5.1.1.24.1");
std::string const PrintQueueSOPInstance_Retired("1.2.840.10008.5.1.1.25");
std::string const PrintQueueManagementSOPClass_Retired("1.2.840.10008.5.1.1.26");
std::string const StoredPrintStorageSOPClass_Retired("1.2.840.10008.5.1.1.27");
std::string const HardcopyGrayscaleImageStorageSOPClass_Retired("1.2.840.10008.5.1.1.29");
std::string const HardcopyColorImageStorageSOPClass_Retired("1.2.840.10008.5.1.1.30");
std::string const PullPrintRequestSOPClass_Retired("1.2.840.10008.5.1.1.31");
std::string const PullStoredPrintManagementMetaSOPClass_Retired("1.2.840.10008.5.1.1.32");
std::string const MediaCreationManagementSOPClassUID("1.2.840.10008.5.1.1.33");
std::string const DisplaySystemSOPClass("1.2.840.10008.5.1.1.40");
std::string const DisplaySystemSOPInstance("1.2.840.10008.5.1.1.40.1");
std::string const ComputedRadiographyImageStorage("1.2.840.10008.5.1.4.1.1.1");
std::string const DigitalXRayImageStorageForPresentation("1.2.840.10008.5.1.4.1.1.1.1");
std::string const DigitalXRayImageStorageForProcessing("1.2.840.10008.5.1.4.1.1.1.1.1");
std::string const DigitalMammographyXRayImageStorageForPresentation("1.2.840.10008.5.1.4.1.1.1.2");
std::string const DigitalMammographyXRayImageStorageForProcessing("1.2.840.10008.5.1.4.1.1.1.2.1");
std::string const DigitalIntraOralXRayImageStorageForPresentation("1.2.840.10008.5.1.4.1.1.1.3");
std::string const DigitalIntraOralXRayImageStorageForProcessing("1.2.840.10008.5.1.4.1.1.1.3.1");
std::string const CTImageStorage("1.2.840.10008.5.1.4.1.1.2");
std::string const EnhancedCTImageStorage("1.2.840.10008.5.1.4.1.1.2.1");
std::string const LegacyConvertedEnhancedCTImageStorage("1.2.840.10008.5.1.4.1.1.2.2");
std::string const UltrasoundMultiframeImageStorage_Retired("1.2.840.10008.5.1.4.1.1.3");
std::string const UltrasoundMultiframeImageStorage("1.2.840.10008.5.1.4.1.1.3.1");
std::string const MRImageStorage("1.2.840.10008.5.1.4.1.1.4");
std::string const EnhancedMRImageStorage("1.2.840.10008.5.1.4.1.1.4.1");
std::string const MRSpectroscopyStorage("1.2.840.10008.5.1.4.1.1.4.2");
std::string const EnhancedMRColorImageStorage("1.2.840.10008.5.1.4.1.1.4.3");
std::string const LegacyConvertedEnhancedMRImageStorage("1.2.840.10008.5.1.4.1.1.4.4");
std::string const NuclearMedicineImageStorage_Retired("1.2.840.10008.5.1.4.1.1.5");
std::string const UltrasoundImageStorage_Retired("1.2.840.10008.5.1.4.1.1.6");
std::string const UltrasoundImageStorage("1.2.840.10008.5.1.4.1.1.6.1");
std::string const EnhancedUSVolumeStorage("1.2.840.10008.5.1.4.1.1.6.2");
std::string const SecondaryCaptureImageStorage("1.2.840.10008.5.1.4.1.1.7");
std::string const MultiframeSingleBitSecondaryCaptureImageStorage("1.2.840.10008.5.1.4.1.1.7.1");
std::string const MultiframeGrayscaleByteSecondaryCaptureImageStorage("1.2.840.10008.5.1.4.1.1.7.2");
std::string const MultiframeGrayscaleWordSecondaryCaptureImageStorage("1.2.840.10008.5.1.4.1.1.7.3");
std::string const MultiframeTrueColorSecondaryCaptureImageStorage("1.2.840.10008.5.1.4.1.1.7.4");
std::string const StandaloneOverlayStorage_Retired("1.2.840.10008.5.1.4.1.1.8");
std::string const StandaloneCurveStorage_Retired("1.2.840.10008.5.1.4.1.1.9");
std::string const WaveformStorageTrial_Retired("1.2.840.10008.5.1.4.1.1.9.1");
std::string const TwelveleadECGWaveformStorage("1.2.840.10008.5.1.4.1.1.9.1.1");
std::string const GeneralECGWaveformStorage("1.2.840.10008.5.1.4.1.1.9.1.2");
std::string const AmbulatoryECGWaveformStorage("1.2.840.10008.5.1.4.1.1.9.1.3");
std::string const HemodynamicWaveformStorage("1.2.840.10008.5.1.4.1.1.9.2.1");
std::string const CardiacElectrophysiologyWaveformStorage("1.2.840.10008.5.1.4.1.1.9.3.1");
std::string const BasicVoiceAudioWaveformStorage("1.2.840.10008.5.1.4.1.1.9.4.1");
std::string const GeneralAudioWaveformStorage("1.2.840.10008.5.1.4.1.1.9.4.2");
std::string const ArterialPulseWaveformStorage("1.2.840.10008.5.1.4.1.1.9.5.1");
std::string const RespiratoryWaveformStorage("1.2.840.10008.5.1.4.1.1.9.6.1");
std::string const StandaloneModalityLUTStorage_Retired("1.2.840.10008.5.1.4.1.1.10");
std::string const StandaloneVOILUTStorage_Retired("1.2.840.10008.5.1.4.1.1.11");
std::string const GrayscaleSoftcopyPresentationStateStorageSOPClass("1.2.840.10008.5.1.4.1.1.11.1");
std::string const ColorSoftcopyPresentationStateStorageSOPClass("1.2.840.10008.5.1.4.1.1.11.2");
std::string const PseudoColorSoftcopyPresentationStateStorageSOPClass("1.2.840.10008.5.1.4.1.1.11.3");
std::string const BlendingSoftcopyPresentationStateStorageSOPClass("1.2.840.10008.5.1.4.1.1.11.4");
std::string const XAXRFGrayscaleSoftcopyPresentationStateStorage("1.2.840.10008.5.1.4.1.1.11.5");
std::string const XRayAngiographicImageStorage("1.2.840.10008.5.1.4.1.1.12.1");
std::string const EnhancedXAImageStorage("1.2.840.10008.5.1.4.1.1.12.1.1");
std::string const XRayRadiofluoroscopicImageStorage("1.2.840.10008.5.1.4.1.1.12.2");
std::string const EnhancedXRFImageStorage("1.2.840.10008.5.1.4.1.1.12.2.1");
std::string const XRayAngiographicBiPlaneImageStorage_Retired("1.2.840.10008.5.1.4.1.1.12.3");
std::string const XRay3DAngiographicImageStorage("1.2.840.10008.5.1.4.1.1.13.1.1");
std::string const XRay3DCraniofacialImageStorage("1.2.840.10008.5.1.4.1.1.13.1.2");
std::string const BreastTomosynthesisImageStorage("1.2.840.10008.5.1.4.1.1.13.1.3");
std::string const BreastProjectionXRayImageStorageForPresentation("1.2.840.10008.5.1.4.1.1.13.1.4");
std::string const BreastProjectionXRayImageStorageForProcessing("1.2.840.10008.5.1.4.1.1.13.1.5");
std::string const IntravascularOpticalCoherenceTomographyImageStorageForPresentation("1.2.840.10008.5.1.4.1.1.14.1");
std::string const IntravascularOpticalCoherenceTomographyImageStorageForProcessing("1.2.840.10008.5.1.4.1.1.14.2");
std::string const NuclearMedicineImageStorage("1.2.840.10008.5.1.4.1.1.20");
std::string const ParametricMapStorage("1.2.840.10008.5.1.4.1.1.30");
std::string const RawDataStorage("1.2.840.10008.5.1.4.1.1.66");
std::string const SpatialRegistrationStorage("1.2.840.10008.5.1.4.1.1.66.1");
std::string const SpatialFiducialsStorage("1.2.840.10008.5.1.4.1.1.66.2");
std::string const DeformableSpatialRegistrationStorage("1.2.840.10008.5.1.4.1.1.66.3");
std::string const SegmentationStorage("1.2.840.10008.5.1.4.1.1.66.4");
std::string const SurfaceSegmentationStorage("1.2.840.10008.5.1.4.1.1.66.5");
std::string const RealWorldValueMappingStorage("1.2.840.10008.5.1.4.1.1.67");
std::string const SurfaceScanMeshStorage("1.2.840.10008.5.1.4.1.1.68.1");
std::string const SurfaceScanPointCloudStorage("1.2.840.10008.5.1.4.1.1.68.2");
std::string const VLImageStorageTrial_Retired("1.2.840.10008.5.1.4.1.1.77.1");
std::string const VLMultiframeImageStorageTrial_Retired("1.2.840.10008.5.1.4.1.1.77.2");
std::string const VLEndoscopicImageStorage("1.2.840.10008.5.1.4.1.1.77.1.1");
std::string const VideoEndoscopicImageStorage("1.2.840.10008.5.1.4.1.1.77.1.1.1");
std::string const VLMicroscopicImageStorage("1.2.840.10008.5.1.4.1.1.77.1.2");
std::string const VideoMicroscopicImageStorage("1.2.840.10008.5.1.4.1.1.77.1.2.1");
std::string const VLSlideCoordinatesMicroscopicImageStorage("1.2.840.10008.5.1.4.1.1.77.1.3");
std::string const VLPhotographicImageStorage("1.2.840.10008.5.1.4.1.1.77.1.4");
std::string const VideoPhotographicImageStorage("1.2.840.10008.5.1.4.1.1.77.1.4.1");
std::string const OphthalmicPhotography8BitImageStorage("1.2.840.10008.5.1.4.1.1.77.1.5.1");
std::string const OphthalmicPhotography16BitImageStorage("1.2.840.10008.5.1.4.1.1.77.1.5.2");
std::string const StereometricRelationshipStorage("1.2.840.10008.5.1.4.1.1.77.1.5.3");
std::string const OphthalmicTomographyImageStorage("1.2.840.10008.5.1.4.1.1.77.1.5.4");
std::string const WideFieldOphthalmicPhotographyStereographicProjectionImageStorage("1.2.840.10008.5.1.4.1.1.77.1.5.5");
std::string const WideFieldOphthalmicPhotography3DCoordinatesImageStorage("1.2.840.10008.5.1.4.1.1.77.1.5.6");
std::string const VLWholeSlideMicroscopyImageStorage("1.2.840.10008.5.1.4.1.1.77.1.6");
std::string const LensometryMeasurementsStorage("1.2.840.10008.5.1.4.1.1.78.1");
std::string const AutorefractionMeasurementsStorage("1.2.840.10008.5.1.4.1.1.78.2");
std::string const KeratometryMeasurementsStorage("1.2.840.10008.5.1.4.1.1.78.3");
std::string const SubjectiveRefractionMeasurementsStorage("1.2.840.10008.5.1.4.1.1.78.4");
std::string const VisualAcuityMeasurementsStorage("1.2.840.10008.5.1.4.1.1.78.5");
std::string const SpectaclePrescriptionReportStorage("1.2.840.10008.5.1.4.1.1.78.6");
std::string const OphthalmicAxialMeasurementsStorage("1.2.840.10008.5.1.4.1.1.78.7");
std::string const IntraocularLensCalculationsStorage("1.2.840.10008.5.1.4.1.1.78.8");
std::string const MacularGridThicknessandVolumeReportStorage("1.2.840.10008.5.1.4.1.1.79.1");
std::string const OphthalmicVisualFieldStaticPerimetryMeasurementsStorage("1.2.840.10008.5.1.4.1.1.80.1");
std::string const OphthalmicThicknessMapStorage("1.2.840.10008.5.1.4.1.1.81.1");
std::string const CornealTopographyMapStorage("1.2.840.10008.5.1.4.1.1.82.1");
std::string const TextSRStorageTrial_Retired("1.2.840.10008.5.1.4.1.1.88.1");
std::string const AudioSRStorageTrial_Retired("1.2.840.10008.5.1.4.1.1.88.2");
std::string const DetailSRStorageTrial_Retired("1.2.840.10008.5.1.4.1.1.88.3");
std::string const ComprehensiveSRStorageTrial_Retired("1.2.840.10008.5.1.4.1.1.88.4");
std::string const BasicTextSRStorage("1.2.840.10008.5.1.4.1.1.88.11");
std::string const EnhancedSRStorage("1.2.840.10008.5.1.4.1.1.88.22");
std::string const ComprehensiveSRStorage("1.2.840.10008.5.1.4.1.1.88.33");
std::string const Comprehensive3DSRStorage("1.2.840.10008.5.1.4.1.1.88.34");
std::string const ExtensibleSRStorage("1.2.840.10008.5.1.4.1.1.88.35");
std::string const ProcedureLogStorage("1.2.840.10008.5.1.4.1.1.88.40");
std::string const MammographyCADSRStorage("1.2.840.10008.5.1.4.1.1.88.50");
std::string const KeyObjectSelectionDocumentStorage("1.2.840.10008.5.1.4.1.1.88.59");
std::string const ChestCADSRStorage("1.2.840.10008.5.1.4.1.1.88.65");
std::string const XRayRadiationDoseSRStorage("1.2.840.10008.5.1.4.1.1.88.67");
std::string const RadiopharmaceuticalRadiationDoseSRStorage("1.2.840.10008.5.1.4.1.1.88.68");
std::string const ColonCADSRStorage("1.2.840.10008.5.1.4.1.1.88.69");
std::string const ImplantationPlanSRStorage("1.2.840.10008.5.1.4.1.1.88.70");
std::string const EncapsulatedPDFStorage("1.2.840.10008.5.1.4.1.1.104.1");
std::string const EncapsulatedCDAStorage("1.2.840.10008.5.1.4.1.1.104.2");
std::string const PositronEmissionTomographyImageStorage("1.2.840.10008.5.1.4.1.1.128");
std::string const LegacyConvertedEnhancedPETImageStorage("1.2.840.10008.5.1.4.1.1.128.1");
std::string const StandalonePETCurveStorage_Retired("1.2.840.10008.5.1.4.1.1.129");
std::string const EnhancedPETImageStorage("1.2.840.10008.5.1.4.1.1.130");
std::string const BasicStructuredDisplayStorage("1.2.840.10008.5.1.4.1.1.131");
std::string const RTImageStorage("1.2.840.10008.5.1.4.1.1.481.1");
std::string const RTDoseStorage("1.2.840.10008.5.1.4.1.1.481.2");
std::string const RTStructureSetStorage("1.2.840.10008.5.1.4.1.1.481.3");
std::string const RTBeamsTreatmentRecordStorage("1.2.840.10008.5.1.4.1.1.481.4");
std::string const RTPlanStorage("1.2.840.10008.5.1.4.1.1.481.5");
std::string const RTBrachyTreatmentRecordStorage("1.2.840.10008.5.1.4.1.1.481.6");
std::string const RTTreatmentSummaryRecordStorage("1.2.840.10008.5.1.4.1.1.481.7");
std::string const RTIonPlanStorage("1.2.840.10008.5.1.4.1.1.481.8");
std::string const RTIonBeamsTreatmentRecordStorage("1.2.840.10008.5.1.4.1.1.481.9");
std::string const DICOSCTImageStorage("1.2.840.10008.5.1.4.1.1.501.1");
std::string const DICOSDigitalXRayImageStorageForPresentation("1.2.840.10008.5.1.4.1.1.501.2.1");
std::string const DICOSDigitalXRayImageStorageForProcessing("1.2.840.10008.5.1.4.1.1.501.2.2");
std::string const DICOSThreatDetectionReportStorage("1.2.840.10008.5.1.4.1.1.501.3");
std::string const DICOS2DAITStorage("1.2.840.10008.5.1.4.1.1.501.4");
std::string const DICOS3DAITStorage("1.2.840.10008.5.1.4.1.1.501.5");
std::string const DICOSQuadrupoleResonanceQRStorage("1.2.840.10008.5.1.4.1.1.501.6");
std::string const EddyCurrentImageStorage("1.2.840.10008.5.1.4.1.1.601.1");
std::string const EddyCurrentMultiframeImageStorage("1.2.840.10008.5.1.4.1.1.601.2");
std::string const PatientRootQueryRetrieveInformationModelFIND("1.2.840.10008.5.1.4.1.2.1.1");
std::string const PatientRootQueryRetrieveInformationModelMOVE("1.2.840.10008.5.1.4.1.2.1.2");
std::string const PatientRootQueryRetrieveInformationModelGET("1.2.840.10008.5.1.4.1.2.1.3");
std::string const StudyRootQueryRetrieveInformationModelFIND("1.2.840.10008.5.1.4.1.2.2.1");
std::string const StudyRootQueryRetrieveInformationModelMOVE("1.2.840.10008.5.1.4.1.2.2.2");
std::string const StudyRootQueryRetrieveInformationModelGET("1.2.840.10008.5.1.4.1.2.2.3");
std::string const PatientStudyOnlyQueryRetrieveInformationModelFIND_Retired("1.2.840.10008.5.1.4.1.2.3.1");
std::string const PatientStudyOnlyQueryRetrieveInformationModelMOVE_Retired("1.2.840.10008.5.1.4.1.2.3.2");
std::string const PatientStudyOnlyQueryRetrieveInformationModelGET_Retired("1.2.840.10008.5.1.4.1.2.3.3");
std::string const CompositeInstanceRootRetrieveMOVE("1.2.840.10008.5.1.4.1.2.4.2");
std::string const CompositeInstanceRootRetrieveGET("1.2.840.10008.5.1.4.1.2.4.3");
std::string const CompositeInstanceRetrieveWithoutBulkDataGET("1.2.840.10008.5.1.4.1.2.5.3");
std::string const ModalityWorklistInformationModelFIND("1.2.840.10008.5.1.4.31");
std::string const GeneralPurposeWorklistManagementMetaSOPClass_Retired("1.2.840.10008.5.1.4.32");
std::string const GeneralPurposeWorklistInformationModelFIND_Retired("1.2.840.10008.5.1.4.32.1");
std::string const GeneralPurposeScheduledProcedureStepSOPClass_Retired("1.2.840.10008.5.1.4.32.2");
std::string const GeneralPurposePerformedProcedureStepSOPClass_Retired("1.2.840.10008.5.1.4.32.3");
std::string const InstanceAvailabilityNotificationSOPClass("1.2.840.10008.5.1.4.33");
std::string const RTBeamsDeliveryInstructionStorageTrial_Retired("1.2.840.10008.5.1.4.34.1");
std::string const RTConventionalMachineVerificationTrial_Retired("1.2.840.10008.5.1.4.34.2");
std::string const RTIonMachineVerificationTrial_Retired("1.2.840.10008.5.1.4.34.3");
std::string const UnifiedWorklistandProcedureStepServiceClassTrial_Retired("1.2.840.10008.5.1.4.34.4");
std::string const UnifiedProcedureStepPushSOPClassTrial_Retired("1.2.840.10008.5.1.4.34.4.1");
std::string const UnifiedProcedureStepWatchSOPClassTrial_Retired("1.2.840.10008.5.1.4.34.4.2");
std::string const UnifiedProcedureStepPullSOPClassTrial_Retired("1.2.840.10008.5.1.4.34.4.3");
std::string const UnifiedProcedureStepEventSOPClassTrial_Retired("1.2.840.10008.5.1.4.34.4.4");
std::string const UPSGlobalSubscriptionSOPInstance("1.2.840.10008.5.1.4.34.5");
std::string const UPSFilteredGlobalSubscriptionSOPInstance("1.2.840.10008.5.1.4.34.5.1");
std::string const UnifiedWorklistandProcedureStepServiceClass("1.2.840.10008.5.1.4.34.6");
std::string const UnifiedProcedureStepPushSOPClass("1.2.840.10008.5.1.4.34.6.1");
std::string const UnifiedProcedureStepWatchSOPClass("1.2.840.10008.5.1.4.34.6.2");
std::string const UnifiedProcedureStepPullSOPClass("1.2.840.10008.5.1.4.34.6.3");
std::string const UnifiedProcedureStepEventSOPClass("1.2.840.10008.5.1.4.34.6.4");
std::string const RTBeamsDeliveryInstructionStorage("1.2.840.10008.5.1.4.34.7");
std::string const RTConventionalMachineVerification("1.2.840.10008.5.1.4.34.8");
std::string const RTIonMachineVerification("1.2.840.10008.5.1.4.34.9");
std::string const GeneralRelevantPatientInformationQuery("1.2.840.10008.5.1.4.37.1");
std::string const BreastImagingRelevantPatientInformationQuery("1.2.840.10008.5.1.4.37.2");
std::string const CardiacRelevantPatientInformationQuery("1.2.840.10008.5.1.4.37.3");
std::string const HangingProtocolStorage("1.2.840.10008.5.1.4.38.1");
std::string const HangingProtocolInformationModelFIND("1.2.840.10008.5.1.4.38.2");
std::string const HangingProtocolInformationModelMOVE("1.2.840.10008.5.1.4.38.3");
std::string const HangingProtocolInformationModelGET("1.2.840.10008.5.1.4.38.4");
std::string const ColorPaletteStorage("1.2.840.10008.5.1.4.39.1");
std::string const ColorPaletteInformationModelFIND("1.2.840.10008.5.1.4.39.2");
std::string const ColorPaletteInformationModelMOVE("1.2.840.10008.5.1.4.39.3");
std::string const ColorPaletteInformationModelGET("1.2.840.10008.5.1.4.39.4");
std::string const ProductCharacteristicsQuerySOPClass("1.2.840.10008.5.1.4.41");
std::string const SubstanceApprovalQuerySOPClass("1.2.840.10008.5.1.4.42");
std::string const GenericImplantTemplateStorage("1.2.840.10008.5.1.4.43.1");
std::string const GenericImplantTemplateInformationModelFIND("1.2.840.10008.5.1.4.43.2");
std::string const GenericImplantTemplateInformationModelMOVE("1.2.840.10008.5.1.4.43.3");
std::string const GenericImplantTemplateInformationModelGET("1.2.840.10008.5.1.4.43.4");
std::string const ImplantAssemblyTemplateStorage("1.2.840.10008.5.1.4.44.1");
std::string const ImplantAssemblyTemplateInformationModelFIND("1.2.840.10008.5.1.4.44.2");
std::string const ImplantAssemblyTemplateInformationModelMOVE("1.2.840.10008.5.1.4.44.3");
std::string const ImplantAssemblyTemplateInformationModelGET("1.2.840.10008.5.1.4.44.4");
std::string const ImplantTemplateGroupStorage("1.2.840.10008.5.1.4.45.1");
std::string const ImplantTemplateGroupInformationModelFIND("1.2.840.10008.5.1.4.45.2");
std::string const ImplantTemplateGroupInformationModelMOVE("1.2.840.10008.5.1.4.45.3");
std::string const ImplantTemplateGroupInformationModelGET("1.2.840.10008.5.1.4.45.4");
std::string const NativeDICOMModel("1.2.840.10008.7.1.1");
std::string const AbstractMultiDimensionalImageModel("1.2.840.10008.7.1.2");
std::string const DICOMContentMappingResource("1.2.840.10008.8.1.1");
std::string const dicomDeviceName("1.2.840.10008.15.0.3.1");
std::string const dicomDescription("1.2.840.10008.15.0.3.2");
std::string const dicomManufacturer("1.2.840.10008.15.0.3.3");
std::string const dicomManufacturerModelName("1.2.840.10008.15.0.3.4");
std::string const dicomSoftwareVersion("1.2.840.10008.15.0.3.5");
std::string const dicomVendorData("1.2.840.10008.15.0.3.6");
std::string const dicomAETitle("1.2.840.10008.15.0.3.7");
std::string const dicomNetworkConnectionReference("1.2.840.10008.15.0.3.8");
std::string const dicomApplicationCluster("1.2.840.10008.15.0.3.9");
std::string const dicomAssociationInitiator("1.2.840.10008.15.0.3.10");
std::string const dicomAssociationAcceptor("1.2.840.10008.15.0.3.11");
std::string const dicomHostname("1.2.840.10008.15.0.3.12");
std::string const dicomPort("1.2.840.10008.15.0.3.13");
std::string const dicomSOPClass("1.2.840.10008.15.0.3.14");
std::string const dicomTransferRole("1.2.840.10008.15.0.3.15");
std::string const dicomTransferSyntax("1.2.840.10008.15.0.3.16");
std::string const dicomPrimaryDeviceType("1.2.840.10008.15.0.3.17");
std::string const dicomRelatedDeviceReference("1.2.840.10008.15.0.3.18");
std::string const dicomPreferredCalledAETitle("1.2.840.10008.15.0.3.19");
std::string const dicomTLSCyphersuite("1.2.840.10008.15.0.3.20");
std::string const dicomAuthorizedNodeCertificateReference("1.2.840.10008.15.0.3.21");
std::string const dicomThisNodeCertificateReference("1.2.840.10008.15.0.3.22");
std::string const dicomInstalled("1.2.840.10008.15.0.3.23");
std::string const dicomStationName("1.2.840.10008.15.0.3.24");
std::string const dicomDeviceSerialNumber("1.2.840.10008.15.0.3.25");
std::string const dicomInstitutionName("1.2.840.10008.15.0.3.26");
std::string const dicomInstitutionAddress("1.2.840.10008.15.0.3.27");
std::string const dicomInstitutionDepartmentName("1.2.840.10008.15.0.3.28");
std::string const dicomIssuerOfPatientID("1.2.840.10008.15.0.3.29");
std::string const dicomPreferredCallingAETitle("1.2.840.10008.15.0.3.30");
std::string const dicomSupportedCharacterSet("1.2.840.10008.15.0.3.31");
std::string const dicomConfigurationRoot("1.2.840.10008.15.0.4.1");
std::string const dicomDevicesRoot("1.2.840.10008.15.0.4.2");
std::string const dicomUniqueAETitlesRegistryRoot("1.2.840.10008.15.0.4.3");
std::string const dicomDevice("1.2.840.10008.15.0.4.4");
std::string const dicomNetworkAE("1.2.840.10008.15.0.4.5");
std::string const dicomNetworkConnection("1.2.840.10008.15.0.4.6");
std::string const dicomUniqueAETitle("1.2.840.10008.15.0.4.7");
std::string const dicomTransferCapability("1.2.840.10008.15.0.4.8");
std::string const UniversalCoordinatedTime("1.2.840.10008.15.1.1");

extern ElementsDictionary public_dictionary;
extern UIDsDictionary uids_dictionary;
}

}

#endif // _afc7b2d7_0869_4fea_9a9b_7fe6228baca9
