/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.core.Site;
import org.chefproject.core.SitePage;
import org.chefproject.core.ToolConfiguration;
import org.chefproject.core.UsageSession;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.CourierService;
import org.chefproject.service.PortalService;
import org.chefproject.service.PresenceService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.util.Time;

public class Courier
extends Action {
    public void doPerform(RunData data) throws Exception {
        data.setScreenTemplate("courier");
        String address = PortalService.getCurrentClientWindowId();
        Context context = TurbineVelocity.getContext(data);
        List deliveries = CourierService.getDeliveries(address);
        context.put("deliveries", deliveries);
        context.put("refresh", "10");
        String stateKeyRoot = ((JetspeedRunData)data).getPageSessionId();
        UsageSession session = UsageSessionService.getSession();
        if (session != null) {
            String location = PortalService.getCurrentLocationId();
            PresenceService.setPresence(session, location, stateKeyRoot);
            String toolId = PortalService.getCurrentToolId();
            if (toolId == null) {
                try {
                    Site site;
                    block7: {
                        String siteId = PortalService.getCurrentSiteId();
                        site = null;
                        try {
                            site = SiteService.getSite(siteId);
                        }
                        catch (IdUnusedException e) {
                            if (!SiteService.isUserSite(siteId)) break block7;
                            site = SiteService.getSite("~");
                        }
                    }
                    String sitePageId = PortalService.getCurrentSitePageId();
                    SitePage page = site.getPage(sitePageId);
                    Iterator iTools = page.getTools().iterator();
                    while (iTools.hasNext()) {
                        ToolConfiguration tool = (ToolConfiguration)iTools.next();
                        SessionState state = ((JetspeedRunData)data).getPortletSessionState(tool.getId());
                        String floatingTool = (String)state.getAttribute("float");
                        if (floatingTool != null) continue;
                        String toolLocation = location + "/" + tool.getId();
                        PresenceService.setPresence(session, toolLocation, stateKeyRoot);
                    }
                }
                catch (Exception e) {
                    Log.warn("chef", "Courier: site page tools: " + e);
                }
            }
        }
        context.put("message", new Time().toStringLocalFull());
    }
}

