/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMInputSourceImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.DOMWriterImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.DOMInputSource;
import org.w3c.dom.ls.DOMWriter;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    private static final int SIZE = 2;
    private RevalidationHandler[] validators = new RevalidationHandler[2];
    private int freeValidatorIndex = -1;
    private int currentSize = 2;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String string, String string2) {
        boolean bl = string2 == null || string2.length() == 0;
        return string.equalsIgnoreCase("Core") && (bl || string2.equals("1.0") || string2.equals("2.0")) || string.equalsIgnoreCase("XML") && (bl || string2.equals("1.0") || string2.equals("2.0")) || string.equalsIgnoreCase("LS-Load") && (bl || string2.equals("3.0"));
    }

    public DocumentType createDocumentType(String string, String string2, String string3) {
        this.checkQName(string);
        return new DocumentTypeImpl(null, string, string2, string3);
    }

    final void checkQName(String string) {
        int n;
        int n2 = string.indexOf(58);
        int n3 = string.lastIndexOf(58);
        int n4 = string.length();
        if (n2 == 0 || n2 == n4 - 1 || n3 != n2) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, string2);
        }
        int n5 = 0;
        if (n2 > 0) {
            if (!XMLChar.isNCNameStart(string.charAt(n5))) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, string3);
            }
            n = 1;
            while (n < n2) {
                if (!XMLChar.isNCName(string.charAt(n))) {
                    String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                    throw new DOMException(5, string4);
                }
                ++n;
            }
            n5 = n2 + 1;
        }
        if (!XMLChar.isNCNameStart(string.charAt(n5))) {
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string5);
        }
        n = n5 + 1;
        while (n < n4) {
            if (!XMLChar.isNCName(string.charAt(n))) {
                String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, string6);
            }
            ++n;
        }
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        if (documentType != null && documentType.getOwnerDocument() != null) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, string3);
        }
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl(documentType);
        Element element = coreDocumentImpl.createElementNS(string, string2);
        coreDocumentImpl.appendChild(element);
        return coreDocumentImpl;
    }

    public DOMImplementation getInterface(String string) {
        String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
        throw new DOMException(9, string2);
    }

    public DOMBuilder createDOMBuilder(short s, String string) throws DOMException {
        if (s == 2) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string2);
        }
        if (string != null && string.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMBuilderImpl("org.apache.xerces.parsers.DTDConfiguration", string);
        }
        return new DOMBuilderImpl("org.apache.xerces.parsers.StandardParserConfiguration", string);
    }

    public DOMWriter createDOMWriter() {
        return new DOMWriterImpl();
    }

    public DOMInputSource createDOMInputSource() {
        return new DOMInputSourceImpl();
    }

    synchronized RevalidationHandler getValidator(String string) {
        if (this.freeValidatorIndex < 0) {
            return (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.xs.XMLSchemaValidator", ObjectFactory.findClassLoader(), true);
        }
        RevalidationHandler revalidationHandler = this.validators[this.freeValidatorIndex];
        this.validators[this.freeValidatorIndex--] = null;
        return revalidationHandler;
    }

    synchronized void releaseValidator(String string, RevalidationHandler revalidationHandler) {
        ++this.freeValidatorIndex;
        if (this.validators.length == this.freeValidatorIndex) {
            this.currentSize += 2;
            RevalidationHandler[] revalidationHandlerArray = new RevalidationHandler[this.currentSize];
            System.arraycopy(this.validators, 0, revalidationHandlerArray, 0, this.validators.length);
            this.validators = revalidationHandlerArray;
        }
        this.validators[this.freeValidatorIndex] = revalidationHandler;
    }
}

