/*
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Adds a callback to the "next tick queue".
*
* ## Notes
*
* -   The queue is fully drained after the current operation on the JavaScript stack runs to completion and before the event loop is allowed to continue.
*
* @param clbk - callback
* @param args - arguments to supply to the callback upon invocation
*
* @example
* function beep() {
*     console.log( 'boop' );
* }
*
* nextTick( beep );
*/
declare function nextTick( clbk: Function, ...args: Array<any> ): void;


// EXPORTS //

export = nextTick;
