<!-- front-matter
id: task
title: task()
hide_title: true
sidebar_label: task()
-->

# task()

**Reminder**: This API isn't the recommended pattern anymore - [export your tasks][creating-tasks-docs].

Defines a task within the task system. The task can then be accessed from the command line and the `series()`, `parallel()`, and `lastRun()` APIs.

## Usage

Register a named function as a task:
```js
const { task } = require('gulp');

function build(cb) {
  // body omitted
  cb();
}

task(build);
```

Register an anonymous function as a task:
```js
const { task } = require('gulp');

task('build', function(cb) {
  // body omitted
  cb();
});
```

Retrieve a task that has been registered previously:
```js
const { task } = require('gulp');

task('build', function(cb) {
  // body omitted
  cb();
});

const build = task('build');
```

## Signature

```js
task([taskName], taskFunction)
```

### Parameters

If the `taskName` is not provided, the task will be referenced by the `name` property of a named function or a user-defined `displayName` property. The `taskName` parameter must be used for anonymous functions missing a `displayName` property.

Since any registered task can be run from the command line, avoid using spaces in task names.

| parameter | type | note |
|:--------------:|:------:|-------|
| taskName | string | An alias for the task function within the the task system. Not needed when using named functions for `taskFunction`. |
| taskFunction<br>**(required)** | function | A [task function][task-concepts] or composed task - generated by `series()` and `parallel()`. Ideally a named function. [Task metadata][task-metadata-section] can be attached to provide extra information to the command line. |

### Returns

When registering a task, nothing is returned.

When retrieving a task, a wrapped task (not the original function) registered as `taskName` will be returned. The wrapped task has an `unwrap()` method that will return the original function.

### Errors

When registering a task where `taskName` is missing and `taskFunction` is anonymous, will throw an error with the message, "Task name must be specified".

## Task metadata

| property | type | note |
|:--------------:|:------:|-------|
| name | string | A special property of named functions. Used to register the task.<br>**Note:** [`name`][function-name-external] is not writable; it cannot be set or changed. |
| displayName | string | When attached to a `taskFunction` creates an alias for the task. If using characters that aren't allowed in function names, use this property. |
| description | string | When attached to a `taskFunction` provides a description to be printed by the command line when listing tasks. |
| flags | object | When attached to a `taskFunction` provides flags to be printed by the command line when listing tasks. The keys of the object represent the flags and the values are their descriptions. |

```js
const { task } = require('gulp');

const clean = function(cb) {
  // body omitted
  cb();
};
clean.displayName = 'clean:all';

task(clean);

function build(cb) {
  // body omitted
  cb();
}
build.description = 'Build the project';
build.flags = { '-e': 'An example flag' };

task(build);
```

[task-metadata-section]: #task-metadata
[task-concepts]: ../api/concepts.md#tasks
[creating-tasks-docs]: ../getting-started/3-creating-tasks.md
[function-name-external]: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/name
