# bash-match [![NPM version](https://img.shields.io/npm/v/bash-match.svg?style=flat)](https://www.npmjs.com/package/bash-match) [![NPM downloads](https://img.shields.io/npm/dm/bash-match.svg?style=flat)](https://npmjs.org/package/bash-match) [![Build Status](https://img.shields.io/travis/jonschlinkert/bash-match.svg?style=flat)](https://travis-ci.org/jonschlinkert/bash-match)

> Match strings using bash. Does not work on windows, and does not read from the file system. This library requires that Bash 4.3 or higher is installed and is mostly used for checking parity in unit tests.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save bash-match
```

## Usage

```js
var bash-match = require('bash-match');
```

## API

### [bash](index.js#L27)

Returns true if `str` matches the given `pattern`.

**Example**

```js
var bash = require('bash-match');
console.log(bash('foo', 'f*'));
//=> true

console.log(bash('foo', 'b*'));
//=> false
```

**Params**

* `str` **{String}**
* `pattern` **{String}**
* `options` **{Options}**: Set `strictErrors` to true to throw when bash throws an error. Otherwise it just returns false.
* `returns` **{Boolean}**

### [.isMatch](index.js#L75)

Returns true if `str` matches the given `pattern`. Alias for the [main export](#bash).

**Example**

```js
var bash = require('bash-match');
console.log(bash.isMatch('foo', 'f*'));
//=> true

console.log(bash.isMatch('foo', 'b*'));
//=> false
```

**Params**

* `str` **{String}**
* `pattern` **{String}**
* `options` **{Options}**: Set `strictErrors` to true to throw when bash throws an error. Otherwise it just returns false.
* `returns` **{Boolean}**

### [.match](index.js#L96)

Takes a `list` of strings and a glob `pattern`, and returns an array of strings that match the pattern.

**Example**

```js
var bash = require('bash-match');
console.log(bash.match(['foo', 'bar'], 'b*'));
//=> ['bar']
```

**Params**

* `array` **{Array}**: List of strings to match
* `pattern` **{String}**: Glob pattern
* `options` **{Options}**: Set `strictErrors` to true to throw when bash throws an error. Otherwise it just returns false.
* `returns` **{Boolean}**

## About

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for avice on opening issues, pull requests, and coding standards.

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/bash-match/blob/master/LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.1.31, on October 17, 2016._