# Release 0.13 (2009-11-05)

This is primarily a bug fix release. It has some new features:

  - Syntactic sugar for writing nested attribute sets. Instead of
    
        {
          foo = {
            bar = 123;
            xyzzy = true;
          };
          a = { b = { c = "d"; }; };
        }
    
    you can write
    
        {
          foo.bar = 123;
          foo.xyzzy = true;
          a.b.c = "d";
        }
    
    This is useful, for instance, in NixOS configuration files.

  - Support for Nix channels generated by Hydra, the Nix-based
    continuous build system. (Hydra generates NAR archives on the fly,
    so the size and hash of these archives isn’t known in advance.)

  - Support `i686-linux` builds directly on `x86_64-linux` Nix
    installations. This is implemented using the `personality()`
    syscall, which causes `uname` to return `i686` in child processes.

  - Various improvements to the `chroot` support. Building in a `chroot`
    works quite well now.

  - Nix no longer blocks if it tries to build a path and another process
    is already building the same path. Instead it tries to build another
    buildable path first. This improves parallelism.

  - Support for large (\> 4 GiB) files in NAR archives.

  - Various (performance) improvements to the remote build mechanism.

  - New primops: `builtins.addErrorContext` (to add a string to stack
    traces — useful for debugging), `builtins.isBool`,
    `builtins.isString`, `builtins.isInt`, `builtins.intersectAttrs`.

  - OpenSolaris support (Sander van der Burg).

  - Stack traces are no longer displayed unless the `--show-trace`
    option is used.

  - The scoping rules for `inherit
                    (e) ...` in recursive attribute sets have changed. The expression
    *e* can now refer to the attributes defined in the containing set.
