(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     12709,        322]
NotebookOptionsPosition[     12151,        299]
NotebookOutlinePosition[     12506,        315]
CellTagsIndexPosition[     12463,        312]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", " ", 
    RowBox[{"NotebookDirectory", "[", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "PrintVector`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", "128"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$MaxExtraPrecision", " ", "=", " ", "50"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.549634702210814*^9, 3.549634716094729*^9}, {
   3.54963475060507*^9, 3.549634769956131*^9}, {3.549634805330505*^9, 
   3.549634868328092*^9}, {3.549634905979645*^9, 3.5496349213932323`*^9}, {
   3.549635055638236*^9, 3.549635061501844*^9}, {3.549635116950212*^9, 
   3.5496352405796547`*^9}, {3.54963527180147*^9, 3.54963530770439*^9}, {
   3.549635349048678*^9, 3.549635368016275*^9}, {3.549635412664104*^9, 
   3.549635535898756*^9}, {3.549635568570756*^9, 3.54963560611071*^9}, {
   3.549635636838379*^9, 3.549635810721334*^9}, {3.5496358541856203`*^9, 
   3.549635855155631*^9}, {3.549635886792036*^9, 3.549635890046706*^9}, {
   3.5496359305695744`*^9, 3.549635949377698*^9}, {3.549635986789765*^9, 
   3.54963600448437*^9}, {3.54963603618716*^9, 3.549636064981591*^9}, {
   3.549636096181632*^9, 3.549636172106222*^9}, {3.54963620325441*^9, 
   3.549636225437134*^9}, {3.549969382495657*^9, 3.549969383158414*^9}, {
   3.5499694233836393`*^9, 3.54996946084592*^9}, {3.549969535222356*^9, 
   3.549969536789812*^9}, 3.549969635878057*^9, {3.5499696953164377`*^9, 
   3.549969704357205*^9}, {3.549969766807899*^9, 3.5499697717009974`*^9}, {
   3.549973560425764*^9, 3.5499735638642807`*^9}, {3.549973998320407*^9, 
   3.549974006151249*^9}, {3.54997643532631*^9, 3.549976516049933*^9}, {
   3.5499772913823643`*^9, 3.549977293554356*^9}, {3.550336991444936*^9, 
   3.55033699625858*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"B", "-", 
    RowBox[{"Spline", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MyBSpline", "[", "n_", "]"}], "[", "x_", "]"}], ":=", 
   RowBox[{"BSplineBasis", "[", 
    RowBox[{"n", ",", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.550337126179674*^9, 3.5503371353540993`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Expand", " ", "B"}], "-", 
    RowBox[{"Splines", " ", "on", " ", "intervals", " ", 
     RowBox[{"explicitely", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ExpandBSplineExplicit", "[", "n_", "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"y", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CForm", "[", 
          RowBox[{"HornerForm", "[", 
           RowBox[{"ReplaceAll", "[", 
            RowBox[{
             RowBox[{"y", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"x", "\[Rule]", "x"}]}], 
            RowBox[{"(*", 
             RowBox[{"-", 
              RowBox[{"y", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "*)"}], 
            "]"}], 
           RowBox[{"(*", 
            RowBox[{",", 
             RowBox[{"{", "x", "}"}]}], "*)"}], "]"}], "]"}], ",", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Sort", "[", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"y", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"y", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"Interval", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"y", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
                RowBox[{"y", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "5"}], "]"}], "]"}]}], "}"}], "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"PiecewiseExpand", "[", 
           RowBox[{
            RowBox[{"MyBSpline", "[", "n", "]"}], "[", "x", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"Greater", "[", 
          RowBox[{
           RowBox[{"y", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{"x", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}], 
   RowBox[{"(*", 
    RowBox[{"//", "MatrixForm"}], "*)"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.549634702210814*^9, 3.549634716094729*^9}, {
   3.54963475060507*^9, 3.549634769956131*^9}, {3.549634805330505*^9, 
   3.549634868328092*^9}, {3.549634905979645*^9, 3.5496349213932323`*^9}, {
   3.549635055638236*^9, 3.549635061501844*^9}, {3.549635116950212*^9, 
   3.5496352405796547`*^9}, {3.54963527180147*^9, 3.54963530770439*^9}, {
   3.549635349048678*^9, 3.549635368016275*^9}, {3.549635412664104*^9, 
   3.549635535898756*^9}, {3.549635568570756*^9, 3.54963560611071*^9}, {
   3.549635636838379*^9, 3.549635810721334*^9}, {3.5496358541856203`*^9, 
   3.549635855155631*^9}, {3.549635886792036*^9, 3.549635890046706*^9}, {
   3.5496359305695744`*^9, 3.549635949377698*^9}, {3.549635986789765*^9, 
   3.54963600448437*^9}, {3.54963603618716*^9, 3.549636064981591*^9}, {
   3.549636096181632*^9, 3.549636172106222*^9}, {3.54963620325441*^9, 
   3.549636225437134*^9}, {3.549969382495657*^9, 3.549969383158414*^9}, {
   3.5499694233836393`*^9, 3.54996946084592*^9}, {3.549969535222356*^9, 
   3.549969536789812*^9}, 3.549969635878057*^9, {3.5499696953164377`*^9, 
   3.549969704357205*^9}, {3.549969766807899*^9, 3.5499697717009974`*^9}, {
   3.549973560425764*^9, 3.5499735638642807`*^9}, {3.549973998320407*^9, 
   3.549974006151249*^9}, {3.54997643532631*^9, 3.549976516049933*^9}, {
   3.5499772913823643`*^9, 3.549977293554356*^9}, {3.550336991444936*^9, 
   3.550337021979643*^9}, {3.550337055667203*^9, 3.550337059627644*^9}, {
   3.550337148768162*^9, 3.550337189200198*^9}, {3.5503372288506823`*^9, 
   3.550337230260098*^9}}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"j", "=", "0"}], ",", 
   RowBox[{"j", "<", "5"}], ",", 
   RowBox[{"j", "++"}], ",", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"ExpandBSplineExplicit", "[", "j", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.550337210230673*^9, 3.5503372342864513`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Expand", " ", "B"}], "-", 
    RowBox[{
    "Splines", " ", "on", " ", "intervals", " ", "in", " ", "Chebyshev", " ", 
     
     RowBox[{"polynomials", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ChebyshevFourierCoefficients", "[", "f_", "]"}], "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "[", "n_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "=", 
          RowBox[{"N", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"a", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"b", "-", "a"}], "2"], 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"Cos", "[", 
                    FractionBox[
                    RowBox[{"\[Pi]", "*", 
                    RowBox[{"(", 
                    RowBox[{"j", "+", 
                    RowBox[{"1", "/", "2"}]}], ")"}]}], 
                    RowBox[{"n", "+", "1"}]], "]"}]}], ")"}]}]}], "]"}], ",", 
              
              RowBox[{"{", 
               RowBox[{"j", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "p"}], 
           "]"}]}], ",", 
         RowBox[{"F", "=", 
          RowBox[{"N", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               FractionBox[
                RowBox[{"2", "-", 
                 RowBox[{"DiscreteDelta", "[", "i", "]"}]}], "2"], 
               RowBox[{"Cos", "[", 
                FractionBox[
                 RowBox[{"\[Pi]", "*", 
                  RowBox[{"(", "i", ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"j", "+", 
                    RowBox[{"1", "/", "2"}]}], ")"}]}], 
                 RowBox[{"n", "+", "1"}]], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "0", ",", "n"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "p"}], 
           "]"}]}]}], "}"}], ",", 
       RowBox[{"Return", "[", 
        RowBox[{
         FractionBox["2", 
          RowBox[{"n", "+", "1"}]], 
         RowBox[{"F", ".", "x"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ExpandBSplineChebyshev", "[", "n_", "]"}], ":=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ChebyshevFourierCoefficients", "[", 
         RowBox[{"MyBSpline", "[", "n", "]"}], "]"}], "[", 
        RowBox[{"j", ",", 
         RowBox[{"j", "+", "1"}]}], "]"}], "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "n"}], "}"}]}], "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.549969102845145*^9, 3.549969299396895*^9}, {
  3.549969337126582*^9, 3.549969337321589*^9}, {3.5499697204613237`*^9, 
  3.549969758459947*^9}, {3.5499698097967663`*^9, 3.549969809916649*^9}, {
  3.5499699610904818`*^9, 3.549969963081028*^9}, {3.549990305049838*^9, 
  3.549990412459839*^9}, {3.549990458456641*^9, 3.5499905121793623`*^9}, {
  3.5499905534586554`*^9, 3.549990564757566*^9}, {3.549990623396491*^9, 
  3.5499906590553226`*^9}, {3.5503370884412127`*^9, 3.5503370999831448`*^9}, {
  3.5503372238964148`*^9, 3.5503372246457357`*^9}}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"j", "=", "0"}], ",", 
   RowBox[{"j", "<", "5"}], ",", 
   RowBox[{"j", "++"}], ",", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"ExpandBSplineChebyshev", "[", "j", "]"}]}], ";", 
    RowBox[{"Print", "[", 
     RowBox[{"FormatVector", "[", 
      RowBox[{
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", "x", "]"}], ",", "64"}], "]"}], ",", 
       RowBox[{"\"\<b\>\"", " ", "<>", 
        RowBox[{"ToString", "[", "j", "]"}], "<>", "\"\<c\>\""}]}], "]"}], 
     "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5499693142565327`*^9, 3.54996935018155*^9}, {
  3.549969392511298*^9, 3.549969407882599*^9}, {3.549969446089657*^9, 
  3.5499694521128674`*^9}, {3.549969483055113*^9, 3.549969489614726*^9}, {
  3.549969643697307*^9, 3.549969689799439*^9}, {3.5499697912941427`*^9, 
  3.54996989447081*^9}, {3.5499699248576*^9, 3.549969954769314*^9}, {
  3.54997044702771*^9, 3.549970603834189*^9}, {3.5499706342271633`*^9, 
  3.549970653825315*^9}, {3.549970689790515*^9, 3.54997076888761*^9}, {
  3.5499730705908957`*^9, 3.549973156825615*^9}, {3.5499772633931713`*^9, 
  3.549977266001943*^9}, {3.549990667840763*^9, 3.5499906681502943`*^9}, {
  3.5503372454872007`*^9, 3.5503372457827473`*^9}}]
},
WindowSize->{1440, 765},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 6, \
2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1822, 31, 73, "Input",
 InitializationCell->True],
Cell[2382, 53, 485, 14, 43, "Input",
 InitializationCell->True],
Cell[2870, 69, 4065, 93, 58, "Input",
 InitializationCell->True],
Cell[6938, 164, 402, 11, 27, "Input"],
Cell[7343, 177, 3505, 91, 94, "Input",
 InitializationCell->True],
Cell[10851, 270, 1296, 27, 27, "Input"]
}
]
*)

(* End of internal cache information *)
