/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundSystem {
    private static final int EXTERNAL_BUFFER_SIZE = 64000;

    public static void playSound(String string) {
        File file = new File(string);
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(file);
        }
        catch (Exception exception) {
            ErrorDialog.show("play-sound", "Unsupported audio file");
            return;
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        SourceDataLine sourceDataLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(audioFormat);
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println("Sound data line not available");
            return;
        }
        catch (Exception exception) {
            ErrorDialog.show("play-sound", "Could nor open sound data line");
            return;
        }
        sourceDataLine.start();
        int n = 0;
        byte[] byArray = new byte[64000];
        while (n != -1) {
            try {
                n = audioInputStream.read(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                ErrorDialog.show("play-sound", "Could not read audio file");
            }
            if (n < 0) continue;
            int n2 = sourceDataLine.write(byArray, 0, n);
        }
        sourceDataLine.drain();
        sourceDataLine.close();
        sourceDataLine = null;
    }
}

