#ifndef _PDU_IGMP_H
#define _PDU_IGMP_H 1

/* pdu-igmp.h
 
   Function prototypes and variables used by the builder of IGMP PDUs.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect (nexp)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

struct igmp {
  uint8_t igmp_type;	    /* IGMP type */
  uint8_t igmp_code;	    /* routing code */
  uint16_t igmp_cksum;	    /* checksum */
  ip_addr_t igmp_group;	    /* group address */
};

#define IGMP_MINLEN			8

/*
 * Message types, including version number.
 */
#define IGMP_MEMBERSHIP_QUERY	    0x11    /* membership query         */
#define IGMP_V1_MEMBERSHIP_REPORT   0x12    /* Ver. 1 membership report */
#define IGMP_V2_MEMBERSHIP_REPORT   0x16    /* Ver. 2 membership report */
#define IGMP_V2_LEAVE_GROUP	    0x17    /* Leave-group message	    */

#define IGMP_DVMRP		    0x13    /* DVMRP routing message    */
#define IGMP_PIM		    0x14    /* PIM routing message      */
#define IGMP_TRACE		    0x15

#define IGMP_MTRACE_RESP	    0x1e    /* traceroute resp.(to sender)*/
#define IGMP_MTRACE		    0x1f    /* mcast traceroute messages  */

#define IGMP_MAX_HOST_REPORT_DELAY  10	/* max delay for response to     */
					/*  query (in seconds) according */
					/*  to RFC1112                   */
#define IGMP_TIMER_SCALE	    10	/* denotes that the igmp code field */
					/* specifies time in 10th of seconds*/

/*
 * States for the IGMP v2 state table.
 */
#define IGMP_DELAYING_MEMBER	1
#define IGMP_IDLE_MEMBER	2
#define IGMP_LAZY_MEMBER	3
#define IGMP_SLEEPING_MEMBER	4
#define IGMP_AWAKENING_MEMBER	5

/*
 * States for IGMP router version cache.
 */
#define IGMP_v1_ROUTER		1
#define IGMP_v2_ROUTER		2

/*
 * The following four defininitions are for backwards compatibility.
 * They should be removed as soon as all applications are updated to
 * use the new constant names.
 */
#define IGMP_HOST_MEMBERSHIP_QUERY	IGMP_MEMBERSHIP_QUERY
#define IGMP_HOST_MEMBERSHIP_REPORT	IGMP_V1_MEMBERSHIP_REPORT
#define IGMP_HOST_NEW_MEMBERSHIP_REPORT	IGMP_V2_MEMBERSHIP_REPORT
#define IGMP_HOST_LEAVE_MESSAGE		IGMP_V2_LEAVE_GROUP

#endif /* _PDU_IGMP_H */
