/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2009 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.javacard.project.customizer;

import com.sun.javacard.AID;
import org.netbeans.spi.project.ui.support.ProjectCustomizer.Category;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.HelpCtx;

public final class PackagingCustomizer extends javax.swing.JPanel implements ChangeListener {
    private final Category category;
    private final ClassicAppletProjectProperties uiProps;

    public PackagingCustomizer(ClassicAppletProjectProperties uiProps, Category category) {
        this.uiProps = uiProps;
        this.category = category;
        initComponents();
        AID aid = uiProps.getPackageAID();
        if (aid != null) {
            aIDPanel1.setAID(aid);
        }
        aIDPanel1.addChangeListener(this);

        proxyCheckBox.setSelected(uiProps.isUseMyProxies());
        proxyCheckBox.addChangeListener(this);

        stateChanged(null);
        HelpCtx.setHelpIDString(this, "org.netbeans.modules.javacard.ClassicAppletEditAppletAID"); //NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        aIDPanel1 = new org.netbeans.modules.javacard.common.AIDPanel();
        jLabel1 = new javax.swing.JLabel();
        proxyCheckBox = new javax.swing.JCheckBox();

        aIDPanel1.setToolTipText(org.openide.util.NbBundle.getMessage(PackagingCustomizer.class, "PackagingCustomizer.aIDPanel1.toolTipText")); // NOI18N
        aIDPanel1.setTitle(org.openide.util.NbBundle.getMessage(PackagingCustomizer.class, "PackagingCustomizer.aIDPanel1.title")); // NOI18N

        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | java.awt.Font.BOLD));
        jLabel1.setText(org.openide.util.NbBundle.getMessage(PackagingCustomizer.class, "PackagingCustomizer.jLabel1.text")); // NOI18N

        proxyCheckBox.setText(org.openide.util.NbBundle.getMessage(PackagingCustomizer.class, "PackagingCustomizer.proxyCheckBox.text")); // NOI18N
        proxyCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(PackagingCustomizer.class, "PackagingCustomizer.proxyCheckBox.toolTipText")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(proxyCheckBox)
                    .addComponent(aIDPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(aIDPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(proxyCheckBox)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.netbeans.modules.javacard.common.AIDPanel aIDPanel1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox proxyCheckBox;
    // End of variables declaration//GEN-END:variables

    public void stateChanged(ChangeEvent e) {
        aIDPanel1.getAID();
        String problem = aIDPanel1.getProblem();
        category.setValid(problem == null);
        category.setErrorMessage(problem);
        if (problem == null) {
            uiProps.setPackageAID(aIDPanel1.getAID());
        }
        uiProps.setUseMyProxies(proxyCheckBox.isSelected());
    }

}
