/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2014 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2014 Sun Microsystems, Inc.
 */

package org.netbeans.modules.derby.ui;

import org.openide.util.RequestProcessor;

/**
 *
 * @author jhavlin
 */
public abstract class SecurityManagerBugPanel extends javax.swing.JPanel {

    private static final RequestProcessor RP
            = new RequestProcessor(SecurityManagerBugPanel.class);

    /**
     * Creates new form SecurityManagerBugPanel
     */
    public SecurityManagerBugPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        disableSecurityManagerButton = new javax.swing.JButton();
        info1Label = new javax.swing.JLabel();
        info2Label = new javax.swing.JLabel();
        doNotShowAgainButton = new javax.swing.JButton();

        setOpaque(false);

        org.openide.awt.Mnemonics.setLocalizedText(disableSecurityManagerButton, org.openide.util.NbBundle.getMessage(SecurityManagerBugPanel.class, "SecurityManagerBugPanel.disableSecurityManagerButton.text")); // NOI18N
        disableSecurityManagerButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        disableSecurityManagerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                disableSecurityManagerButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(info1Label, org.openide.util.NbBundle.getMessage(SecurityManagerBugPanel.class, "SecurityManagerBugPanel.info1Label.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(info2Label, org.openide.util.NbBundle.getMessage(SecurityManagerBugPanel.class, "SecurityManagerBugPanel.info2Label.text")); // NOI18N
        info2Label.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        info2Label.setMaximumSize(new java.awt.Dimension(2147483647, 100));

        org.openide.awt.Mnemonics.setLocalizedText(doNotShowAgainButton, org.openide.util.NbBundle.getMessage(SecurityManagerBugPanel.class, "SecurityManagerBugPanel.doNotShowAgainButton.text")); // NOI18N
        doNotShowAgainButton.setBorder(null);
        doNotShowAgainButton.setBorderPainted(false);
        doNotShowAgainButton.setContentAreaFilled(false);
        doNotShowAgainButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        doNotShowAgainButton.setOpaque(false);
        doNotShowAgainButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                doNotShowAgainButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(info2Label, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addComponent(info1Label, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(disableSecurityManagerButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(doNotShowAgainButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(info1Label)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(info2Label, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(doNotShowAgainButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(disableSecurityManagerButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void disableSecurityManagerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disableSecurityManagerButtonActionPerformed
        RP.post(new Runnable() {

            @Override
            public void run() {
                disableSecurityManagerClicked();
            }
        });
        disableSecurityManagerButton.setEnabled(false);
        doNotShowAgainButton.setEnabled(false);
    }//GEN-LAST:event_disableSecurityManagerButtonActionPerformed

    private void doNotShowAgainButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doNotShowAgainButtonActionPerformed
        RP.post(new Runnable() {

            @Override
            public void run() {
                doNotShowAgainClicked();
            }
        });
    }//GEN-LAST:event_doNotShowAgainButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton disableSecurityManagerButton;
    private javax.swing.JButton doNotShowAgainButton;
    private javax.swing.JLabel info1Label;
    private javax.swing.JLabel info2Label;
    // End of variables declaration//GEN-END:variables

    public abstract void disableSecurityManagerClicked();

    public abstract void doNotShowAgainClicked();
}
