/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

package org.netbeans.modules.vmd.midpnb.components.svg.form;

import java.util.Arrays;
import java.util.List;

import org.netbeans.modules.vmd.api.codegen.CodeSetterPresenter;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.properties.DefaultPropertiesPresenter;
import org.netbeans.modules.vmd.midp.codegen.MidpCodePresenterSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.codegen.MidpSetter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpVersionDescriptor;
import org.netbeans.modules.vmd.midp.components.MidpVersionable;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertiesCategories;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorNumber;
import org.netbeans.modules.vmd.midpnb.codegen.MidpCustomCodePresenterSupport;
import org.openide.util.NbBundle;

/**
 *
 * @author avk
 */
public class SVGSliderCD extends ComponentDescriptor{

    public static final TypeID TYPEID = new TypeID (TypeID.Kind.COMPONENT, "org.netbeans.microedition.svg.SVGSlider"); // NOI18N
    
    public static final String PROP_MIN = "min";    // NOI18N
    
    public static final String PROP_MAX = "max";    // NOI18N
    
    public static final String PROP_VALUE = "value";// NOI18N

    public TypeDescriptor getTypeDescriptor () {
        return new TypeDescriptor (SVGComponentCD.TYPEID, TYPEID, true, false);
    }
    
    static {
        SVGComponentCD.addPairType( TYPEID, SVGSliderEventSourceCD.TYPEID );
    }

    @Override
    public VersionDescriptor getVersionDescriptor() {
        return MidpVersionDescriptor.MIDP_2;
    }
    
    @Override
    public List<PropertyDescriptor> getDeclaredPropertyDescriptors() {
        return Arrays.asList (
                new PropertyDescriptor( PROP_MIN, 
                        MidpTypes.TYPEID_INT, 
                        MidpTypes.createIntegerValue(0), false, true, 
                        MidpVersionable.MIDP_2),
                new PropertyDescriptor( PROP_MAX, 
                                MidpTypes.TYPEID_INT, 
                                MidpTypes.createIntegerValue(10), false, true, 
                                MidpVersionable.MIDP_2),
                new PropertyDescriptor( PROP_VALUE, 
                                        MidpTypes.TYPEID_INT, 
                                        MidpTypes.createIntegerValue(0), false, true, 
                                        MidpVersionable.MIDP_2));

    }
    
    private static DefaultPropertiesPresenter createPropertiesPresenter() {
        return new DefaultPropertiesPresenter()
            .addPropertiesCategory(MidpPropertiesCategories.CATEGORY_PROPERTIES).
                addProperty(NbBundle.getMessage(SVGSliderCD.class, 
                        "DISP_SVGSliderMin"), 
                        PropertyEditorNumber.createIntegerInstance( false,
                                NbBundle.getMessage(SVGSliderCD.class, 
                                "LBL_SVGCheckBox_Min")), PROP_MIN).
                       addProperty(NbBundle.getMessage(SVGSliderCD.class, 
                                "DISP_SVGSliderMax"), 
                                PropertyEditorNumber.createIntegerInstance( false,
                                        NbBundle.getMessage(SVGSliderCD.class, 
                                        "LBL_SVGCheckBox_Max")), PROP_MAX).
                               addProperty(NbBundle.getMessage(SVGSliderCD.class, 
                                        "DISP_SVGSliderValue"), 
                                        PropertyEditorNumber.createIntegerInstance( false,
                                                NbBundle.getMessage(SVGSliderCD.class, 
                                                "LBL_SVGSlider_Value")), PROP_VALUE);// NOI18N
                
    }
    
    private Presenter createSetterPresenter () {
        return new CodeSetterPresenter ().
                addParameters(MidpParameter.create(PROP_MIN, PROP_MAX, 
                        PROP_VALUE)).
                addSetters(MidpSetter.createSetter("setMin", 
                        MidpVersionable.MIDP_2).addParameters(PROP_MIN)).
                 addSetters(MidpSetter.createSetter("setMax", 
                       MidpVersionable.MIDP_2).addParameters( PROP_MAX)).
                 addSetters(MidpSetter.createSetter("setValue", 
                       MidpVersionable.MIDP_2).addParameters( PROP_VALUE)); // NOI18N
    }
    
    protected List<? extends Presenter> createPresenters () {
        return Arrays.asList(
                // properties
                createPropertiesPresenter(),
                //code
                createSetterPresenter(),
                MidpCustomCodePresenterSupport.createSVGComponentCodePresenter(TYPEID),
                MidpCodePresenterSupport.createAddImportPresenter()
                //new SVGCodeFooter( SVGSliderEventSourceCD.TYPEID )
        );
    }

}
