/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */
package org.netbeans.modules.dlight.visualizers.util;

import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilterFactory;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.UIThread;

/**
 *
 * @author mt154047
 */
public final class TimeIntervalPanel extends javax.swing.JPanel implements DataFilterListener {

    private DataFilterManager manager;
    private final ChangeListener startTimeChangeListener = new StartTimeSpinnerListener();
    private final ChangeListener endTimeChangeListener = new EndTimeSpinnerListener();
    private final UILock uiLock = new UILock();

    /** Creates new form TimeIntervalPanel */
    public TimeIntervalPanel(DataFilterManager manager) {
        initComponents();
        this.manager = manager;
        if (manager != null) {
            this.manager.addDataFilterListener(this);
            update(manager.getDataFilter(TimeIntervalDataFilter.class));
        }

        startTimeSpinner.addChangeListener(startTimeChangeListener);
        endTimeSpinner.addChangeListener(endTimeChangeListener);
    }

    public void update(DataFilterManager manager) {
        if (this.manager != null) {
            this.manager.removeDataFilterListener(this);
        }

        this.manager = manager;

        if (this.manager != null) {
            this.manager.addDataFilterListener(this);
        }
        update(manager == null ? null : manager.getDataFilter(TimeIntervalDataFilter.class));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        startTimeSpinner = new javax.swing.JSpinner();
        endTimeSpinner = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | java.awt.Font.BOLD));
        jLabel1.setText(org.openide.util.NbBundle.getMessage(TimeIntervalPanel.class, "TimeIntervalPanel.jLabel1.text")); // NOI18N

        startTimeSpinner.setModel(new SpinnerTimeModel());
        startTimeSpinner.setEditor(new SpinnerTimeEditor(startTimeSpinner));

        endTimeSpinner.setModel(new SpinnerTimeModel());
        endTimeSpinner.setEditor(new SpinnerTimeEditor(endTimeSpinner));
        endTimeSpinner.setValue(Long.MAX_VALUE);

        jLabel2.setText(org.openide.util.NbBundle.getMessage(TimeIntervalPanel.class, "TimeIntervalPanel.jLabel2.text")); // NOI18N

        jLabel3.setText(org.openide.util.NbBundle.getMessage(TimeIntervalPanel.class, "TimeIntervalPanel.jLabel3.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(18, 18, 18)
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(startTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(endTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(13, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel3)
                    .addComponent(jLabel2)
                    .addComponent(endTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(startTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSpinner endTimeSpinner;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JSpinner startTimeSpinner;
    // End of variables declaration//GEN-END:variables

    public Range<Long> getSelectedInterval() {
        return new Range<Long>((Long) startTimeSpinner.getValue(), (Long) endTimeSpinner.getValue());
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        UIThread.invoke(new Runnable() {

            public void run() {
                update(manager.getDataFilter(TimeIntervalDataFilter.class));
            }
        });
    }

    private final void update(Collection<TimeIntervalDataFilter> filters) {
        TimeIntervalDataFilter filter = null;
        if (filters != null && !filters.isEmpty()) {
            filter = filters.iterator().next();
        }
        synchronized (uiLock) {
            startTimeSpinner.removeChangeListener(startTimeChangeListener);
            endTimeSpinner.removeChangeListener(endTimeChangeListener);
            startTimeSpinner.setValue(filter == null ? 0L : filter.getInterval().getStart());
            endTimeSpinner.setValue(filter == null ? Long.MAX_VALUE : filter.getInterval().getEnd());
            startTimeSpinner.addChangeListener(startTimeChangeListener);
            endTimeSpinner.addChangeListener(endTimeChangeListener);
        }
    }

    private void applyFilter() {
        if (manager != null) {
            manager.addDataFilter(TimeIntervalDataFilterFactory.create(
                    new Range<Long>((Long) startTimeSpinner.getValue(), (Long) endTimeSpinner.getValue())), false);
        }
    }

    private final class StartTimeSpinnerListener implements ChangeListener {

        public void stateChanged(ChangeEvent e) {
            //if start time after end, then re-set end
            if (((Long) startTimeSpinner.getValue()) >= (Long) endTimeSpinner.getValue()) {
                endTimeSpinner.setValue((Long) startTimeSpinner.getValue() + 1);
            }
            applyFilter();
        }
    }

    private final class EndTimeSpinnerListener implements ChangeListener {

        public void stateChanged(ChangeEvent e) {
            //if end time before start, then start re-set start
            if (((Long) startTimeSpinner.getValue()) >= (Long) endTimeSpinner.getValue()) {
                startTimeSpinner.setValue((Long) endTimeSpinner.getValue() - 1);
            }
            applyFilter();
        }
    }

    private final static class UILock {
    }
}
