/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * NBLoginPanel.java
 *
 * Created on Jan 22, 2010, 11:02:27 AM
 */

package org.netbeans.modules.bugzilla;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser.URLDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Stupka
 */
public class NBLoginPanel extends javax.swing.JPanel implements DocumentListener {

    private JButton login = new JButton(NbBundle.getMessage(NBLoginPanel.class, "LBL_Login"));      // NOI18N
    private JButton cancel = new JButton(NbBundle.getMessage(NBLoginPanel.class, "LBL_Cancel"));    // NOI18N

    /** Creates new form NBLoginPanel */
    public NBLoginPanel() {
        initComponents();
        errorLabel.setVisible(false);

        login.getAccessibleContext().setAccessibleDescription(login.getText());
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        usernameTextField.getDocument().addDocumentListener(this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        usernameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jButton1 = new LinkButton(new NBRegisterAction());
        passwordField = new javax.swing.JPasswordField();
        errorLabel = new javax.swing.JLabel();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.jLabel1.text")); // NOI18N

        usernameTextField.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.usernameTextField.text")); // NOI18N

        jLabel2.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.jLabel2.text")); // NOI18N

        jLabel3.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.jLabel3.text")); // NOI18N

        jLabel4.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.jLabel4.text")); // NOI18N

        jButton1.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.jButton1.text")); // NOI18N

        passwordField.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.passwordField.text")); // NOI18N

        errorLabel.setForeground(new java.awt.Color(153, 0, 0));
        errorLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/bugzilla/resources/error.gif"))); // NOI18N
        errorLabel.setText(org.openide.util.NbBundle.getMessage(NBLoginPanel.class, "NBLoginPanel.errorLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel2)
                            .add(jLabel3))
                        .add(18, 18, 18)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(passwordField)
                            .add(usernameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 141, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(errorLabel)
                    .add(layout.createSequentialGroup()
                        .add(jLabel4)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jButton1)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(usernameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(passwordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(errorLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel4)
                    .add(jButton1))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel errorLabel;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPasswordField passwordField;
    private javax.swing.JTextField usernameTextField;
    // End of variables declaration//GEN-END:variables

    private class NBRegisterAction extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                URLDisplayer.getDefault().showURL(new URL(NBRepositorySupport.URL_NB_ORG_SIGNUP)); // NOI18N
            } catch (MalformedURLException ex) {
                Bugzilla.LOG.log(Level.SEVERE, NAME, ex);
            }
        }
    }

    static boolean show(final BugzillaRepository repo, String errorMsg) {
        final NBLoginPanel panel = new NBLoginPanel();
        panel.usernameTextField.setText(repo.getUsername());
        panel.passwordField.setText(repo.getPassword());
        panel.validateFields();
        panel.updateErrorMessage(errorMsg);
        if(panel.showLogin()) {   // NOI18N
            repo.setCredentials(panel.usernameTextField.getText(), new String(panel.passwordField.getPassword()), null, null );
            return true;
        }
        return false;
    }

    private boolean showLogin() {
        DialogDescriptor descriptor = new DialogDescriptor (
                this,
                NbBundle.getMessage(ReportNBIssueAction.class, "LBL_LOGIN_2_NBORG"),    // NOI18N
                true,
                new Object[] {login, cancel},
                login,
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(NBLoginPanel.class),
                null);
        return DialogDisplayer.getDefault().notify(descriptor) == login;
    }

    public void insertUpdate(DocumentEvent e) {
        validateFields();
    }

    public void removeUpdate(DocumentEvent e) {
        validateFields();
    }

    public void changedUpdate(DocumentEvent e) {
        validateFields();
    }

    private void validateFields() {
        if(usernameTextField.getText().trim().equals("")) {                     // NOI18N
            login.setEnabled(false);
            updateErrorMessage(NbBundle.getMessage(ReportNBIssueAction.class, "MSG_MISSING_USERNAME_PASSWORD"));    // NOI18N
        } else {
            login.setEnabled(true);
            updateErrorMessage(null);
        }
    }

    private void updateErrorMessage(String errorMsg) {
        if (errorMsg != null) {
            errorLabel.setVisible(true);
            errorLabel.setText(errorMsg);
        } else {
            errorLabel.setVisible(false);
            errorLabel.setText("");                                             // NOI18N
        }
    }
}
