/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.helios.jmx.client.ConnectionException;
import org.helios.jmx.client.ConstructionException;
import org.helios.jmx.client.HeliosJMXClient;
import org.helios.jmx.client.StartableClient;

public class HeliosJMXClientFactory {
    public static final Class[] CTOR_PARAMS = new Class[]{Properties.class};

    public static HeliosJMXClient getInstance(Properties env) throws ConstructionException, ConnectionException {
        HeliosJMXClient client = null;
        String className = env.getProperty("org.helios.client.factoryname", "org.helios.client.local.LocalMBeanServerClient");
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getConstructor(CTOR_PARAMS);
            client = (HeliosJMXClient)ctor.newInstance(env);
            if (client instanceof StartableClient) {
                ((StartableClient)((Object)client)).start();
            }
            return client;
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Failed to locate class [" + className + "]", e);
        }
        catch (SecurityException e) {
            throw new ConstructionException("Security Exception on CTOR of class [" + className + "]", e);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructionException("CTOR not found for class [" + className + "]", e);
        }
        catch (IllegalArgumentException e) {
            throw new ConstructionException("Illegal Argument to CTOR for class [" + className + "]", e);
        }
        catch (InstantiationException e) {
            throw new ConstructionException("Instantiation Exception on CTOR for class [" + className + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("Illegal Access to CTOR for class [" + className + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new ConstructionException("CTOR Invocation Exception for class [" + className + "]", e);
        }
        catch (Exception e) {
            throw new ConstructionException("Unexpected Exception Creating Client for class [" + className + "]", e);
        }
    }
}

