#!/usr/bin/python
# mythnettv mythnetgui.py
# Copyright (C) 2008, Thomas Mashos <tgm4883@gmail.com>
# This provides all the GUI features of mythnettv
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
import sys
import subprocess

try:
	import pygtk
	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
	import gtk.glade
except:
	sys.exit(1)

GUIDIR = "/usr/share/mythnettv-gui/"  
#GUIDIR = "" ## For testing

MYTHNETTVDIR = "/usr/share/mythnettv/"

JOBTIME = "daily"  ## This needs to be the second half of of /etc/cron.*  ie hourly, daily, etc

class MythNetGui():

	if os.getuid() == 0:
		# no privilege escalation required
		pass
	elif os.path.exists('/usr/bin/gksudo'):
		rnroot = 'gksudo'
	elif os.path.exists('/usr/bin/kdesu'):
		rnroot = 'kdesu'
	else:
		rnroot = 'sudo'

	def __init__(self):
	
		#Initialize GUI & Terminal
		self.gladefile = GUIDIR+"mythnettv-gui.glade"
		self.wTree = gtk.glade.XML(self.gladefile, "MainWindow")
		for widget in self.wTree.get_widget_prefix(""):
			setattr(self, widget.get_name(), widget)
			if isinstance(widget, gtk.Label):
				widget.set_property('can-focus', False)
		self.wTree.signal_autoconnect(self)
	
		#Get the Main Window, and connect the "destroy" event
		self.window = self.wTree.get_widget("MainWindow")
		if (self.window):
			self.window.connect("destroy", gtk.main_quit)

		#Initialize dialog & Terminal
		self.xTree = gtk.glade.XML(self.gladefile, "DatadirDialog")
		for widget in self.xTree.get_widget_prefix(""):
			setattr(self, widget.get_name(), widget)
			if isinstance(widget, gtk.Label):
				widget.set_property('can-focus', False)
		self.xTree.signal_autoconnect(self)

		#Get the Dialog Window, and connect the "destroy" event
		self.datadirdialog = self.xTree.get_widget("DatadirDialog")
		if (self.datadirdialog):
			self.datadirdialog.connect("delete-event", self.gtk_widget_hide)

		#Initialize GUI & Terminal
		self.gladefile = GUIDIR+"mythnettv-gui.glade"
		self.yTree = gtk.glade.XML(self.gladefile, "FeedDialog")
		for widget in self.yTree.get_widget_prefix(""):
			setattr(self, widget.get_name(), widget)
			if isinstance(widget, gtk.Label):
				widget.set_property('can-focus', False)
		self.yTree.signal_autoconnect(self)

		#Get the Dialog Window, and connect the "destroy" event
		self.subscriptiondialog = self.yTree.get_widget("FeedDialog")
		if (self.subscriptiondialog):
			self.subscriptiondialog.connect("delete-event", self.gtk_widget_hide)

		#Initialize GUI & Terminal
		self.gladefile = GUIDIR+"mythnettv-gui.glade"
		self.zTree = gtk.glade.XML(self.gladefile, "aboutdialog1")
		for widget in self.zTree.get_widget_prefix(""):
			setattr(self, widget.get_name(), widget)
			if isinstance(widget, gtk.Label):
				widget.set_property('can-focus', False)
		self.zTree.signal_autoconnect(self)

		#Get the Dialog Window, and connect the "destroy" event
		self.aboutdialog1 = self.zTree.get_widget("aboutdialog1")
		if (self.aboutdialog1):
			self.aboutdialog1.connect("delete-event", self.gtk_widget_hide)
			self.aboutdialog1.connect("response", self.gtk_widget_hide)

		#Create our dictionary and connect it
		wdic = {"on_refresh_download_list_activate" : self.refresh_download_list_activate,
			"on_show_subs_activate" : self.show_subs_activate,
			"on_set_download_job_activate" : self.set_download_job_activate,
			"on_show_next_five_activate" : self.next_clicked,
			"on_remove_download_job_activate" : self.remove_download_job_activate,
			"on_set_datadir_menu_button_activate" : self.set_datadir_clicked,
			"on_manage_subscriptions_button_activate" : self.manage_subscriptions,
			"on_quit_menu_button_activate" : gtk.main_quit,
			"on_about_menu_activate" : self.about_button,
			"on_MainWindow_destroy" : gtk.main_quit }
		self.wTree.signal_autoconnect(wdic)

		#Create our dictionary and connect it
		xdic = { "on_datadir_cancel_clicked" : self.close_datadir_dialog,
			"on_datadir_ok_clicked" : self.set_datadir,
			"on_DatadirDialog_destroy" : gtk.main_quit }
		self.xTree.signal_autoconnect(xdic)		

		#Create our dictionary and connect it
		ydic = { "on_subscribe_button_clicked" : self.subscribe_button_clicked,
			"on_unsubscribe_button_clicked" : self.unsubscribe_button_clicked}
		self.yTree.signal_autoconnect(ydic)

		self.infobox = self.wTree.get_widget("infobox")

		self.statusbar = self.wTree.get_widget("statusbar")

		if not os.path.exists("/usr/bin/mythbackend"):
		  self.remove_download_job.set_sensitive(False);
		  self.set_download_job.set_sensitive(False);

		subslist = subprocess.Popen([MYTHNETTVDIR+"mythnettv", "--nopromptforannounce", "list"],stdout=subprocess.PIPE).communicate()[0]
		self.infobox.get_buffer().set_text(subslist)

        def gtk_widget_hide(self, window, data=None):
                window.hide()
                return True

	def show_subs_activate(self, widget):
		sublist = subprocess.Popen([MYTHNETTVDIR+"mythnettv", "list"],stdout=subprocess.PIPE).communicate()[0]
		self.infobox.get_buffer().set_text(sublist)

	def refresh_download_list_activate(self, widget):
		context_id = self.statusbar.get_context_id("update")
		self.statusbar.push(context_id, "Updating.....")
		updatelist = subprocess.Popen([MYTHNETTVDIR+"mythnettv", "update"],stdout=subprocess.PIPE).communicate()[0]
		self.infobox.get_buffer().set_text(updatelist)
		self.statusbar.push(context_id, "Update Finished")

	def subscribe_button_clicked(self, widget):
		urltext = self.url_textbox.get_text()
		titletext = self.title_textbox.get_text()
		os.system(MYTHNETTVDIR+"mythnettv subscribe "+urltext+" "+"'"+titletext+"'")
		context_id = self.statusbar.get_context_id("subscribe")
		self.statusbar.push(context_id, titletext+" subscribed")
		sublist = subprocess.Popen([MYTHNETTVDIR+"mythnettv", "list"],stdout=subprocess.PIPE).communicate()[0]
		self.infobox.get_buffer().set_text(sublist)
		self.FeedDialog.hide()

	def unsubscribe_button_clicked(self, widget):
		urltext = self.url_textbox.get_text()
		titletext = self.title_textbox.get_text()
		os.system(MYTHNETTVDIR+"mythnettv unsubscribe "+urltext+" "+"'"+titletext+"'")
		context_id = self.statusbar.get_context_id("unsubscribe")
		self.statusbar.push(context_id, urltext+" unsubscribed")
		sublist = subprocess.Popen([MYTHNETTVDIR+"mythnettv", "list"],stdout=subprocess.PIPE).communicate()[0]
		self.infobox.get_buffer().set_text(sublist)
		self.FeedDialog.hide()

	def set_download_job_activate(self, widget):
		os.system(self.rnroot+' cp '+GUIDIR+'mythnettv.cron /etc/cron.'+JOBTIME+'/mythnettv')
		context_id = self.statusbar.get_context_id("dailyjob")
		self.statusbar.push(context_id, "Download job added")

	def remove_download_job_activate(self, widget):
		os.system(self.rnroot+' rm /etc/cron.daily/mythnettv')
		os.system(self.rnroot+' rm /etc/cron.hourly/mythnettv')
		context_id = self.statusbar.get_context_id("dailyjob")
		self.statusbar.push(context_id, "Download job removed")

	def next_clicked(self, widget):
		nextlist = subprocess.Popen([MYTHNETTVDIR+"mythnettv", "nextdownload", "5"],stdout=subprocess.PIPE).communicate()[0]
		self.infobox.get_buffer().set_text(nextlist)

	def set_datadir_clicked(self, widget):
		mng.DatadirDialog.show()

	def set_datadir(self, widget):
		datadirtext = self.datadir_textbox.get_text()
		datadiroutput = subprocess.Popen([MYTHNETTVDIR+"mythnettv", "--datadir", datadirtext],stdout=subprocess.PIPE).communicate()[0]
		self.infobox.get_buffer().set_text(datadiroutput)

	def close_datadir_dialog(self, widget):
		self.DatadirDialog.hide()

	def manage_subscriptions(self, widget):
		mng.FeedDialog.show()

	def about_button(self, widget):
		mng.aboutdialog1.show()
		

if __name__ == "__main__": 
	mng = MythNetGui() 
	mng.MainWindow.show()
	gtk.main()
