# -*- coding: utf-8 -*-
#
# «VLCHandler» - VLC Application lirc creator
#
# Copyright (C) 2007, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuLircGenerator.core import ProgramHandler

class VLCHandler(ProgramHandler):
    def __init__(self,lircd, lircrc,repeat,delay):
        application_name="vlc"
        application_dictionary={ \
        "play":"key-play", \
        "pause":"key-pause", \
        "stop":"key-quit", \
        "chan-":"key-prev", \
        "chan+":"key-next", \
        "rewind":"key-slower", \
        "forward":"key-faster", \
        "vol-":"key-vol-down", \
        "vol+":"key-vol-up", \
        "mute":"key-vol-mute", \
        "left":"key-nav-left", \
        "right":"key-nav-right", \
        "down":"key-nav-down", \
        "up":"key-nav-up", \
        "ok":"key-nav-activate", \
        "dvd":"key-disc-menu", \
        "skip":"key-next", \
        "replay":"key-prev" \
        }
        ProgramHandler.__init__(self,application_name,application_dictionary,lircd,lircrc,repeat,delay)
