# Check for ffmpeg C libraries: libavcodec, libavutil, libavformat, libswscale
#  These libs are linked against mrpt-hwdrivers only (in shared libs,
#  in static all user apps will have to link against this)
# ====================================================================
SET(CMAKE_MRPT_HAS_FFMPEG 0)
SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
SET(MRPT_FFMPEG_LIBS_TO_LINK "")

# DISABLE_FFMPEG
# ---------------------
OPTION(DISABLE_FFMPEG "Force not using FFMPEG library" "OFF")
MARK_AS_ADVANCED(DISABLE_FFMPEG)
IF(NOT DISABLE_FFMPEG)

IF(PKG_CONFIG_FOUND)
	PKG_CHECK_MODULES(LIBAVCODEC  ${_QUIET} libavcodec)
	PKG_CHECK_MODULES(LIBAVUTIL   ${_QUIET} libavutil)
	PKG_CHECK_MODULES(LIBAVFORMAT ${_QUIET} libavformat)
	PKG_CHECK_MODULES(LIBSWSCALE  ${_QUIET} libswscale)
	IF(LIBAVCODEC_FOUND AND LIBAVUTIL_FOUND AND LIBAVFORMAT_FOUND AND LIBSWSCALE_FOUND)
		SET(CMAKE_MRPT_HAS_FFMPEG 1)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 1)

		INCLUDE_DIRECTORIES("${LIBAVCODEC_INCLUDEDIR}/")
		INCLUDE_DIRECTORIES("${LIBAVCODEC_INCLUDEDIR}/ffmpeg")
		INCLUDE_DIRECTORIES("${LIBAVCODEC_INCLUDEDIR}/libavcodec")

		INCLUDE_DIRECTORIES("${LIBAVUTIL_INCLUDEDIR}")

		INCLUDE_DIRECTORIES("${LIBAVFORMAT_INCLUDEDIR}")
		INCLUDE_DIRECTORIES("${LIBAVFORMAT_INCLUDEDIR}/ffmpeg")
		INCLUDE_DIRECTORIES("${LIBAVFORMAT_INCLUDEDIR}/libavformat")

		INCLUDE_DIRECTORIES("${LIBSWSCALE_INCLUDEDIR}")
		INCLUDE_DIRECTORIES("${LIBSWSCALE_INCLUDEDIR}/ffmpeg")
		INCLUDE_DIRECTORIES("${LIBSWSCALE_INCLUDEDIR}/libswscale")

		LINK_DIRECTORIES("${LIBAVCODEC_LIBDIR}")
		LINK_DIRECTORIES("${LIBAVUTIL_LIBDIR}")
		LINK_DIRECTORIES("${LIBAVFORMAT_LIBDIR}")
		LINK_DIRECTORIES("${LIBSWSCALE_LIBDIR}")

		SET(MRPT_FFMPEG_LIBS_TO_LINK "${MRPT_FFMPEG_LIBS_TO_LINK}" "${LIBAVCODEC_LIBRARIES}" "${LIBAVFORMAT_LIBRARIES}" "${LIBAVUTIL_LIBRARIES}" "${LIBSWSCALE_LIBRARIES}")

		IF($ENV{VERBOSE})
			MESSAGE(STATUS " ffmpeg libs: ${MRPT_FFMPEG_LIBS_TO_LINK}")
		ENDIF($ENV{VERBOSE})
	ENDIF(LIBAVCODEC_FOUND AND LIBAVUTIL_FOUND AND LIBAVFORMAT_FOUND AND LIBSWSCALE_FOUND)
ENDIF(PKG_CONFIG_FOUND)

IF(MSVC)
	SET( MRPT_HAS_FFMPEG_WIN32 OFF CACHE BOOL "Add support for IP cameras and all FFmpeg-capable video sources")
ENDIF(MSVC)

IF(MRPT_HAS_FFMPEG_WIN32)
	SET( FFMPEG_WIN32_ROOT_DIR "" CACHE PATH "Path to FFmpeg win32 build root directory (See http://ffmpeg.arrozcru.org/builds/)")

	# Set to 1, next check for missing things and set to 0 on any error & report message:
	SET(CMAKE_MRPT_HAS_FFMPEG 1)
	SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 1)

	IF(NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}")
		SET(CMAKE_MRPT_HAS_FFMPEG 0)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
		MESSAGE("The directory 'FFMPEG_WIN32_ROOT_DIR' does not exists. Turn off FFmpeg support or provide the correct path.")
	ENDIF(NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}")

	IF(NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libavcodec" OR NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libavformat" OR NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libavutil" OR NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libswscale")
		SET(CMAKE_MRPT_HAS_FFMPEG 0)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
		MESSAGE("The directory 'FFMPEG_WIN32_ROOT_DIR' does not contain include/{libavcodec,libavformat,libavutil,libswscale}. Turn off FFmpeg support or provide the correct path.")
	ENDIF(NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libavcodec" OR NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libavformat" OR NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libavutil" OR NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/include/libswscale")

	IF(NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/lib")
		SET(CMAKE_MRPT_HAS_FFMPEG 0)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
		MESSAGE("The directory 'FFMPEG_WIN32_ROOT_DIR' does not contain /lib/. Turn off FFmpeg support or provide the correct path.")
	ENDIF(NOT EXISTS "${FFMPEG_WIN32_ROOT_DIR}/lib")

	# We need the .lib files: avcodec-52.lib, avformat-52.lib, avutil-49.lib, swscale-0.lib
	FILE(GLOB FFMPEG_WIN32_AVCODEC_LIB "${FFMPEG_WIN32_ROOT_DIR}/lib/avcodec*.lib")
	FILE(GLOB FFMPEG_WIN32_AVUTIL_LIB "${FFMPEG_WIN32_ROOT_DIR}/lib/avutil*.lib")
	FILE(GLOB FFMPEG_WIN32_AVFORMAT_LIB "${FFMPEG_WIN32_ROOT_DIR}/lib/avformat*.lib")
	FILE(GLOB FFMPEG_WIN32_SWSCALE_LIB "${FFMPEG_WIN32_ROOT_DIR}/lib/swscale*.lib")

	IF (NOT EXISTS ${FFMPEG_WIN32_AVCODEC_LIB})
		SET(CMAKE_MRPT_HAS_FFMPEG 0)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
		MESSAGE("avcodec-XX.lib not found under '${FFMPEG_WIN32_ROOT_DIR}/lib'. Turn off FFmpeg support or provide the correct path.")
	ENDIF (NOT EXISTS ${FFMPEG_WIN32_AVCODEC_LIB})

	IF (NOT EXISTS ${FFMPEG_WIN32_AVUTIL_LIB})
		SET(CMAKE_MRPT_HAS_FFMPEG 0)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
		MESSAGE("avutil-XX.lib not found under '${FFMPEG_WIN32_ROOT_DIR}/lib'. Turn off FFmpeg support or provide the correct path.")
	ENDIF (NOT EXISTS ${FFMPEG_WIN32_AVUTIL_LIB})

	IF (NOT EXISTS ${FFMPEG_WIN32_AVFORMAT_LIB})
		SET(CMAKE_MRPT_HAS_FFMPEG 0)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
		MESSAGE("avformat-XX.lib not found under '${FFMPEG_WIN32_ROOT_DIR}/lib'. Turn off FFmpeg support or provide the correct path.")
	ENDIF (NOT EXISTS ${FFMPEG_WIN32_AVFORMAT_LIB})

	IF (NOT EXISTS ${FFMPEG_WIN32_SWSCALE_LIB})
		SET(CMAKE_MRPT_HAS_FFMPEG 0)
		SET(CMAKE_MRPT_HAS_FFMPEG_SYSTEM 0)
		MESSAGE("swscale-XX.lib not found under '${FFMPEG_WIN32_ROOT_DIR}/lib'. Turn off FFmpeg support or provide the correct path.")
	ENDIF (NOT EXISTS ${FFMPEG_WIN32_SWSCALE_LIB})

	INCLUDE_DIRECTORIES("${FFMPEG_WIN32_ROOT_DIR}/include")
	INCLUDE_DIRECTORIES("${FFMPEG_WIN32_ROOT_DIR}/include/libavcodec")
	INCLUDE_DIRECTORIES("${FFMPEG_WIN32_ROOT_DIR}/include/libavformat")
	#INCLUDE_DIRECTORIES("${FFMPEG_WIN32_ROOT_DIR}/include/libavutil")
	INCLUDE_DIRECTORIES("${FFMPEG_WIN32_ROOT_DIR}/include/libswscale")

	SET(MRPT_FFMPEG_LIBS_TO_LINK ${MRPT_FFMPEG_LIBS_TO_LINK} "${FFMPEG_WIN32_AVCODEC_LIB}" "${FFMPEG_WIN32_AVUTIL_LIB}" "${FFMPEG_WIN32_AVFORMAT_LIB}" "${FFMPEG_WIN32_SWSCALE_LIB}")
ENDIF(MRPT_HAS_FFMPEG_WIN32)

ENDIF(NOT DISABLE_FFMPEG)

