// Chunk.cs
//
// Author:
//   Mike Krüger <mkrueger@novell.com>
//
// Copyright (c) 2007 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
//

using System;
using Mono.TextEditor.Highlighting;

namespace Mono.TextEditor
{
	public class Chunk
	{
		public Chunk Next {
			get;
			set;
		}

		public string Style {
			get;
			set;
		}

		CloneableStack<Span> spanStack;
		static CloneableStack<Span> emptySpan = new CloneableStack<Span> ();
		public CloneableStack<Span> SpanStack {
			get { 
				if (spanStack == null)
					spanStack = emptySpan.Clone ();
				return spanStack; 
			}
			set { spanStack = value; }
		}

		public int Offset {
			get;
			set;
		}

		public int Length {
			get;
			set;
		}

		public int EndOffset {
			get {
				return Offset + Length;
			}
		}

		public Chunk ()
		{
			Next = null;
		}
		
		public Chunk (int offset, int length, string styleName)
		{
			this.Style = styleName;
			this.Offset = offset;
			this.Length = length;
		}

		public static implicit operator TextSegment (Chunk chunk)
		{
			return new TextSegment (chunk.Offset, chunk.Length);
		}
		
		public override string ToString ()
		{
			return string.Format ("[Chunk: Style={0}, Offset={1}, Length={2}]", Style, Offset, Length);
		}
	}
}
