/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;

public class BindingUtils {
    public static IMethodBinding findOverriddenMethodInType(ITypeBinding type, IMethodBinding method) {
        if (type.getName().equals("Object") && method.getName().equals("clone")) {
            return null;
        }
        IMethodBinding[] iMethodBindingArray = type.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding o = iMethodBindingArray[n2];
            IMethodBinding existing = o;
            if (existing.isSubsignature(method) || method.isSubsignature(existing)) {
                return existing;
            }
            ++n2;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInTypeOrSuperclasses(ITypeBinding type, IMethodBinding method) {
        IMethodBinding found = BindingUtils.findOverriddenMethodInType(type, method);
        if (found != null) {
            return found;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null) {
            return BindingUtils.findOverriddenMethodInTypeOrSuperclasses(superClass, method);
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding) {
        return BindingUtils.findOverriddenMethodInHierarchy(type, binding, true);
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding, boolean considerInterfaces) {
        IMethodBinding superClassMethod;
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (superClassMethod = BindingUtils.findOverriddenMethodInHierarchy(superClass, binding)) != null) {
            return superClassMethod;
        }
        IMethodBinding method = BindingUtils.findOverriddenMethodInType(type, binding);
        if (method != null) {
            return method;
        }
        if (considerInterfaces) {
            ITypeBinding[] interfaces = type.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                IMethodBinding interfaceMethod = BindingUtils.findOverriddenMethodInHierarchy(interfaces[i], binding);
                if (interfaceMethod != null) {
                    return interfaceMethod;
                }
                ++i;
            }
        }
        return null;
    }

    public static IMethodBinding findMethodDefininition(IMethodBinding method, AST typeResolver) {
        IMethodBinding def;
        IMethodBinding res;
        if (method == null) {
            return null;
        }
        IMethodBinding definition = null;
        ITypeBinding type = method.getDeclaringClass();
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            IMethodBinding res2 = BindingUtils.findOverriddenMethodInHierarchy(interfaces[i], method);
            if (res2 != null) {
                definition = res2;
                break;
            }
            ++i;
        }
        if (type.getSuperclass() != null) {
            IMethodBinding res3 = BindingUtils.findOverriddenMethodInHierarchy(type.getSuperclass(), method);
            if (res3 != null && !Modifier.isPrivate((int)res3.getModifiers())) {
                definition = res3;
            }
        } else if (type.isInterface() && typeResolver != null && (res = BindingUtils.findOverriddenMethodInHierarchy(typeResolver.resolveWellKnownType("java.lang.Object"), method)) != null) {
            definition = res;
        }
        if ((def = BindingUtils.findMethodDefininition(definition, typeResolver)) != null) {
            return def;
        }
        return definition;
    }

    public static boolean isVisibleInHierarchy(IMethodBinding member, IPackageBinding pack) {
        int otherflags = member.getModifiers();
        ITypeBinding declaringType = member.getDeclaringClass();
        if (Modifier.isPublic((int)otherflags) || Modifier.isProtected((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Modifier.isPrivate((int)otherflags)) {
            return false;
        }
        return pack == declaringType.getPackage();
    }

    public static String qualifiedName(IMethodBinding binding) {
        return String.valueOf(BindingUtils.qualifiedName(binding.getDeclaringClass())) + "." + binding.getName();
    }

    public static String qualifiedSignature(IMethodBinding binding) {
        StringBuffer buf = new StringBuffer();
        buf.append(BindingUtils.qualifiedName(binding.getDeclaringClass())).append(".").append(binding.getName()).append("(");
        ITypeBinding[] parameterTypes = binding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(BindingUtils.qualifiedName(parameterTypes[i]));
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public static String typeMappingKey(ITypeBinding type) {
        ITypeBinding[] typeArguments = type.getTypeArguments();
        if (typeArguments.length == 0) {
            typeArguments = type.getTypeParameters();
        }
        if (typeArguments.length > 0) {
            return String.valueOf(BindingUtils.qualifiedName(type)) + "<" + BindingUtils.repeat(',', typeArguments.length - 1) + ">";
        }
        return BindingUtils.qualifiedName(type);
    }

    private static String repeat(char c, int count) {
        StringBuilder builder = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }

    public static String qualifiedName(ITypeBinding declaringClass) {
        String qn = declaringClass.getTypeDeclaration().getQualifiedName();
        if (qn.length() > 0) {
            return qn;
        }
        return declaringClass.getQualifiedName();
    }

    public static String qualifiedName(IVariableBinding binding) {
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (declaringClass == null) {
            return binding.getName();
        }
        return String.valueOf(BindingUtils.qualifiedName(declaringClass)) + "." + binding.getName();
    }

    public static boolean isStatic(IMethodBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    public static boolean isStatic(IVariableBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    public static boolean isStatic(MethodInvocation invocation) {
        return BindingUtils.isStatic(invocation.resolveMethodBinding());
    }
}

