/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSDocAttributeNode;
import sharpen.core.csharp.ast.CSDocNode;
import sharpen.core.csharp.ast.CSDocTextNode;
import sharpen.core.csharp.ast.CSVisitor;

public class CSDocTagNode
extends CSDocNode {
    private List<CSDocNode> _fragments;
    private List<CSDocAttributeNode> _attributes;
    private String _tagName;

    public CSDocTagNode(String tagName) {
        this._tagName = tagName;
    }

    @Override
    public void accept(CSVisitor visitor) {
        visitor.visit(this);
    }

    public void addFragment(CSDocNode node) {
        if (this._fragments == null) {
            this._fragments = new ArrayList<CSDocNode>();
        }
        this._fragments.add(node);
    }

    public List<CSDocNode> fragments() {
        return this.safeList(this._fragments);
    }

    public void addAttribute(String name, String value) {
        if (this._attributes == null) {
            this._attributes = new ArrayList<CSDocAttributeNode>();
        }
        this._attributes.add(new CSDocAttributeNode(name, value));
    }

    public List<CSDocAttributeNode> attributes() {
        return this.safeList(this._attributes);
    }

    private <T extends CSDocNode> List<T> safeList(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public String tagName() {
        return this._tagName;
    }

    public void addTextFragment(String text) {
        this.addFragment(new CSDocTextNode(text));
    }

    public String getAttribute(String attributeName) {
        for (CSDocAttributeNode attribute : this.attributes()) {
            if (!attribute.name().equals(attributeName)) continue;
            return attribute.value();
        }
        return null;
    }
}

