#!/bin/bash

# This script is used to generate the debian/dkms.in file from the modules
# built from this repository.
#
# To use it, on the target Ubuntu release and kernel:
#
# 1. Build all the modules locally:
#    ./debian/build_all.sh $(uname -r) /lib/modules/$(uname -r)/build/
#
# 2. Run this script that will pick up all generated .ko files in the
#    subdirectories:
#    ./debian/gen-dkms-conf-entries.sh > debian/dkms.in

cat <<EOF
PACKAGE_NAME="%DEB_SOURCE%"
PACKAGE_VERSION="%DEB_VERSION_UPSTREAM%"
CLEAN="echo CLEAN"
MAKE[0]="./build_all.sh \${kernelver} \${kernel_source_dir}"
AUTO_INSTALL="yes"

EOF

i=0
find . -name '*.ko' | sort | while read -r line; do
	line=${line#./}
	base=$(basename "$line")
	built_module_name=${base%.ko}
	built_module_location=$(dirname "$line")
	dest_module_location="/extra"
	echo "BUILT_MODULE_NAME[$i]=\"$built_module_name\""
	echo "BUILT_MODULE_LOCATION[$i]=\"$built_module_location\""
	echo "DEST_MODULE_LOCATION[$i]=\"$dest_module_location\""
	echo
	i=$((i+1))
done
