/*******************************************************************************
* Copyright 2019 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "common_s16.hpp"
#include "jit_generator.hpp"

namespace dnnl {
namespace impl {
namespace cpu {

jit_avx512_core_s16_copy_at_kern::jit_avx512_core_s16_copy_at_kern()
    : jit_generator(nullptr, S16_COPY_KERNEL_CODE_SIZE) {

#ifndef _WIN32
#define M rdi
#define N rsi
#define A rdx
#define LDA rcx
#define ALPHA r8
#define B r9

#define I rax
#define A1 r10
#define A2 r8
#define LDA3 r11

#else

#define M rcx
#define N rdx
#define A r8
#define LDA r9
#define ALPHA rax
#define B rdi

#define I rax
#define A1 rsi
#define A2 r10
#define LDA3 r11

#define ARG_ALPHA 40 + stacksize + rsp
#define ARG_B 48 + stacksize + rsp

#endif

    inLocalLabel();
    {

        Xbyak::Label l103c;
        Xbyak::Label l11dc;
        Xbyak::Label l137c;
        Xbyak::Label l138c;
        Xbyak::Label l1398;
        Xbyak::Label l13b4;
        Xbyak::Label l14e0;
        Xbyak::Label l15ec;
        Xbyak::Label l16c8;
        Xbyak::Label l17a4;
        Xbyak::Label l17b4;
        Xbyak::Label l17c0;
        Xbyak::Label l17dc;
        Xbyak::Label l1878;
        Xbyak::Label l18f4;
        Xbyak::Label l1964;
        Xbyak::Label l19d8;
        Xbyak::Label l19e8;
        Xbyak::Label l19f4;
        Xbyak::Label l1a0c;
        Xbyak::Label l1a7c;
        Xbyak::Label l1ac8;
        Xbyak::Label l1b0c;
        Xbyak::Label l1b50;
        Xbyak::Label l1b60;
        Xbyak::Label l1b6c;
        Xbyak::Label l1b84;
        Xbyak::Label l1bb8;
        Xbyak::Label l1be4;
        Xbyak::Label l1c10;
        Xbyak::Label l1c38;
        Xbyak::Label l1c46;
        Xbyak::Label l1c50;
        Xbyak::Label l1c60;
        Xbyak::Label l1c7c;
        Xbyak::Label l1c9c;
        Xbyak::Label l1cbc;
        Xbyak::Label l1cdc;
        Xbyak::Label l1cf4;
        Xbyak::Label l1d04;
        Xbyak::Label l24;
        Xbyak::Label l3d4;
        Xbyak::Label l40;
        Xbyak::Label l6d4;
        Xbyak::Label l938;
        Xbyak::Label lba4;
        Xbyak::Label lbb4;
        Xbyak::Label lbc0;
        Xbyak::Label lbdc;
        Xbyak::Label le3c;

        preamble();
#ifdef _WIN32
        auto stacksize = get_size_of_abi_save_regs();
        mov(ALPHA, ptr[ARG_ALPHA]);
        mov(B, ptr[ARG_B]);
#endif

        mov(N, qword[N]);
        mov(M, qword[M]);
        mov(LDA, qword[LDA]);
        shl(LDA, 1);
        lea(LDA3, ptr[LDA + LDA * 2]);
        sub(A, -128);
        sub(B, -128);
        cmp(N, 0x30);
        jl(lbb4, T_NEAR);
        align(4);

        L(l24);
        mov(A1, A);
        mov(I, LDA);
        imul(I, I, 0x30);
        add(A, I);
        mov(I, M);
        sar(I, 0x3);
        jle(l3d4, T_NEAR);
        align(4);

        L(l40);
        vmovdqu(xmm0, xword[A1 - 0x80]);
        vmovdqu(xmm1, xword[A1 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A1 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x80], ymm2);
        vmovdqu(yword[B + 0x40], ymm3);
        vmovdqu(yword[B + 0x100], ymm4);
        vmovdqu(yword[B + 0x1c0], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x60], ymm2);
        vmovdqu(yword[B + 0x60], ymm3);
        vmovdqu(yword[B + 0x120], ymm4);
        vmovdqu(yword[B + 0x1e0], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x40], ymm2);
        vmovdqu(yword[B + 0x80], ymm3);
        vmovdqu(yword[B + 0x140], ymm4);
        vmovdqu(yword[B + 0x200], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x20], ymm2);
        vmovdqu(yword[B + 0xa0], ymm3);
        vmovdqu(yword[B + 0x160], ymm4);
        vmovdqu(yword[B + 0x220], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B], ymm2);
        vmovdqu(yword[B + 0xc0], ymm3);
        vmovdqu(yword[B + 0x180], ymm4);
        vmovdqu(yword[B + 0x240], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B + 0x20], ymm2);
        vmovdqu(yword[B + 0xe0], ymm3);
        vmovdqu(yword[B + 0x1a0], ymm4);
        vmovdqu(yword[B + 0x260], ymm5);
        sub(A1, -16);
        sub(B, -768);
        dec(I);
        jg(l40, T_NEAR);
        align(4);

        L(l3d4);
        test(M, 0x4);
        jle(l6d4, T_NEAR);
        vmovq(xmm0, qword[A1 - 0x80]);
        vmovq(xmm1, qword[A1 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A1 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x80], ymm2);
        vmovdqu(yword[B + 0x40], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x60], ymm2);
        vmovdqu(yword[B + 0x60], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x40], ymm2);
        vmovdqu(yword[B + 0x80], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x20], ymm2);
        vmovdqu(yword[B + 0xa0], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B], ymm2);
        vmovdqu(yword[B + 0xc0], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B + 0x20], ymm2);
        vmovdqu(yword[B + 0xe0], ymm3);
        sub(A1, -8);
        sub(B, -384);
        align(4);

        L(l6d4);
        test(M, 0x2);
        jle(l938, T_NEAR);
        vmovd(xmm0, dword[A1 - 0x80]);
        vmovd(xmm1, dword[A1 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A1 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x80], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x60], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x40], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x20], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B + 0x20], ymm0);
        sub(A1, -4);
        sub(B, -192);
        align(4);

        L(l938);
        test(M, 0x1);
        jle(lba4, T_NEAR);
        mov(ax, word[A1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A1 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A1 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A1 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A1 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x80], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x70], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x60], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x50], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x40], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x30], xmm0);
        sub(B, -96);
        align(4);

        L(lba4);
        sub(N, 0x30);
        cmp(N, 0x30);
        jge(l24, T_NEAR);
        align(4);

        L(lbb4);
        cmp(N, 0x20);
        jl(l138c, T_NEAR);
        align(4);

        L(lbc0);
        mov(A1, A);
        mov(I, LDA);
        imul(I, I, 0x20);
        add(A, I);
        mov(I, M);
        sar(I, 0x3);
        jle(le3c, T_NEAR);
        align(4);

        L(lbdc);
        vmovdqu(xmm0, xword[A1 - 0x80]);
        vmovdqu(xmm1, xword[A1 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A1 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x80], ymm2);
        vmovdqu(yword[B], ymm3);
        vmovdqu(yword[B + 0x80], ymm4);
        vmovdqu(yword[B + 0x100], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x60], ymm2);
        vmovdqu(yword[B + 0x20], ymm3);
        vmovdqu(yword[B + 0xa0], ymm4);
        vmovdqu(yword[B + 0x120], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x40], ymm2);
        vmovdqu(yword[B + 0x40], ymm3);
        vmovdqu(yword[B + 0xc0], ymm4);
        vmovdqu(yword[B + 0x140], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x20], ymm2);
        vmovdqu(yword[B + 0x60], ymm3);
        vmovdqu(yword[B + 0xe0], ymm4);
        vmovdqu(yword[B + 0x160], ymm5);
        sub(A1, -16);
        sub(B, -512);
        dec(I);
        jg(lbdc, T_NEAR);
        align(4);

        L(le3c);
        test(M, 0x4);
        jle(l103c, T_NEAR);
        vmovq(xmm0, qword[A1 - 0x80]);
        vmovq(xmm1, qword[A1 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A1 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x80], ymm2);
        vmovdqu(yword[B], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x60], ymm2);
        vmovdqu(yword[B + 0x20], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x40], ymm2);
        vmovdqu(yword[B + 0x40], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x20], ymm2);
        vmovdqu(yword[B + 0x60], ymm3);
        sub(A1, -8);
        sub(B, -256);
        align(4);

        L(l103c);
        test(M, 0x2);
        jle(l11dc, T_NEAR);
        vmovd(xmm0, dword[A1 - 0x80]);
        vmovd(xmm1, dword[A1 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A1 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x80], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x60], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x40], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x20], ymm0);
        sub(A1, -4);
        sub(B, -128);
        align(4);

        L(l11dc);
        test(M, 0x1);
        jle(l137c, T_NEAR);
        mov(ax, word[A1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A1 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A1 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A1 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A1 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x80], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x70], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x60], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        vmovdqu(xword[B - 0x50], xmm0);
        sub(B, -64);
        align(4);

        L(l137c);
        sub(N, 0x20);
        cmp(N, 0x20);
        jge(lbc0, T_NEAR);
        align(4);

        L(l138c);
        cmp(N, 0x10);
        jl(l17b4, T_NEAR);
        align(4);

        L(l1398);
        mov(A1, A);
        mov(I, LDA);
        shl(I, 0x4);
        add(A, I);
        mov(I, M);
        sar(I, 0x3);
        jle(l14e0, T_NEAR);
        align(4);

        L(l13b4);
        vmovdqu(xmm0, xword[A1 - 0x80]);
        vmovdqu(xmm1, xword[A1 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A1 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x80], ymm2);
        vmovdqu(yword[B - 0x40], ymm3);
        vmovdqu(yword[B], ymm4);
        vmovdqu(yword[B + 0x40], ymm5);
        vmovdqu(xmm0, xword[A2 - 0x80]);
        vmovdqu(xmm1, xword[A2 + LDA * 1 - 0x80]);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xmm4, xword[A2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm5, 0x20);
        vmovdqu(xmm4, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm2, ymm2, ymm4, 0x20);
        vmovdqu(xmm5, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm3, ymm3, ymm5, 0x20);
        vunpcklps(ymm4, ymm0, ymm2);
        vunpckhps(ymm5, ymm0, ymm2);
        vunpcklps(ymm0, ymm1, ymm3);
        vunpckhps(ymm1, ymm1, ymm3);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vmovdqu(yword[B - 0x60], ymm2);
        vmovdqu(yword[B - 0x20], ymm3);
        vmovdqu(yword[B + 0x20], ymm4);
        vmovdqu(yword[B + 0x60], ymm5);
        sub(A1, -16);
        sub(B, -256);
        dec(I);
        jg(l13b4, T_NEAR);
        align(4);

        L(l14e0);
        test(M, 0x4);
        jle(l15ec, T_NEAR);
        vmovq(xmm0, qword[A1 - 0x80]);
        vmovq(xmm1, qword[A1 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A1 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x80], ymm2);
        vmovdqu(yword[B - 0x40], ymm3);
        vmovq(xmm0, qword[A2 - 0x80]);
        vmovq(xmm1, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vpunpcklqdq(xmm2, xmm2, xmm4);
        vpunpcklqdq(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vpermilps(ymm0, ymm0, 0xd8);
        vpermilps(ymm1, ymm1, 0xd8);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x60], ymm2);
        vmovdqu(yword[B - 0x20], ymm3);
        sub(A1, -8);
        sub(B, -128);
        align(4);

        L(l15ec);
        test(M, 0x2);
        jle(l16c8, T_NEAR);
        vmovd(xmm0, dword[A1 - 0x80]);
        vmovd(xmm1, dword[A1 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A1 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A1 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A1 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x80], ymm0);
        vmovd(xmm0, dword[A2 - 0x80]);
        vmovd(xmm1, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        lea(A2, ptr[A2 + LDA * 4]);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vperm2f128(ymm0, ymm0, ymm1, 0x20);
        vmovdqu(yword[B - 0x60], ymm0);
        sub(A1, -4);
        sub(B, -64);
        align(4);

        L(l16c8);
        test(M, 0x1);
        jle(l17a4, T_NEAR);
        mov(ax, word[A1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A1 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A1 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A1 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A1 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x80], xmm0);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A2 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x70], xmm0);
        sub(B, -32);
        align(4);

        L(l17a4);
        sub(N, 0x10);
        cmp(N, 0x10);
        jge(l1398, T_NEAR);
        align(4);

        L(l17b4);
        cmp(N, 0x8);
        jl(l19e8, T_NEAR);
        align(4);

        L(l17c0);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        lea(I, ptr[A1 + LDA * 8]);
        mov(A, I);
        mov(I, M);
        sar(I, 0x3);
        jle(l1878, T_NEAR);
        align(4);

        L(l17dc);
        vmovdqu(xmm4, xword[A1 - 0x80]);
        vmovdqu(xmm5, xword[A1 + LDA * 1 - 0x80]);
        vmovdqu(xmm0, xword[A1 + LDA * 2 - 0x80]);
        vmovdqu(xmm1, xword[A1 + LDA3 * 1 - 0x80]);
        sub(A1, -16);
        vmovdqu(xmm2, xword[A2 - 0x80]);
        vperm2f128(ymm4, ymm4, ymm2, 0x20);
        vmovdqu(xmm3, xword[A2 + LDA * 1 - 0x80]);
        vperm2f128(ymm5, ymm5, ymm3, 0x20);
        vmovdqu(xmm2, xword[A2 + LDA * 2 - 0x80]);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vmovdqu(xmm3, xword[A2 + LDA3 * 1 - 0x80]);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        sub(A2, -16);
        vunpcklps(ymm2, ymm4, ymm0);
        vunpckhps(ymm3, ymm4, ymm0);
        vunpcklps(ymm4, ymm5, ymm1);
        vunpckhps(ymm5, ymm5, ymm1);
        vunpcklps(ymm0, ymm2, ymm4);
        vunpckhps(ymm1, ymm2, ymm4);
        vunpcklps(ymm2, ymm3, ymm5);
        vunpckhps(ymm3, ymm3, ymm5);
        vmovdqu(yword[B - 0x80], ymm0);
        vmovdqu(yword[B - 0x60], ymm1);
        vmovdqu(yword[B - 0x40], ymm2);
        vmovdqu(yword[B - 0x20], ymm3);
        sub(B, -128);
        dec(I);
        jg(l17dc, T_NEAR);
        align(4);

        L(l1878);
        test(M, 0x4);
        jle(l18f4, T_NEAR);
        vmovq(xmm0, qword[A1 - 0x80]);
        vmovq(xmm1, qword[A1 + LDA * 1 - 0x80]);
        vmovq(xmm2, qword[A1 + LDA * 2 - 0x80]);
        vmovq(xmm3, qword[A1 + LDA3 * 1 - 0x80]);
        sub(A1, -8);
        vunpcklps(xmm0, xmm0, xmm2);
        vunpcklps(xmm1, xmm1, xmm3);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        vmovq(xmm4, qword[A2 + LDA * 2 - 0x80]);
        vmovq(xmm5, qword[A2 + LDA3 * 1 - 0x80]);
        sub(A2, -8);
        vunpcklps(xmm2, xmm2, xmm4);
        vunpcklps(xmm3, xmm3, xmm5);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vmovdqu(yword[B - 0x80], ymm2);
        vmovdqu(yword[B - 0x60], ymm3);
        sub(B, -64);
        align(4);

        L(l18f4);
        test(M, 0x2);
        jle(l1964, T_NEAR);
        vmovd(xmm0, dword[A1 - 0x80]);
        vmovd(xmm1, dword[A1 + LDA * 1 - 0x80]);
        vmovd(xmm2, dword[A1 + LDA * 2 - 0x80]);
        vmovd(xmm3, dword[A1 + LDA3 * 1 - 0x80]);
        sub(A1, -4);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovd(xmm1, dword[A2 - 0x80]);
        vmovd(xmm2, dword[A2 + LDA * 1 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 2 - 0x80]);
        vmovd(xmm4, dword[A2 + LDA3 * 1 - 0x80]);
        sub(A2, -4);
        vunpcklps(xmm1, xmm1, xmm2);
        vunpcklps(xmm3, xmm3, xmm4);
        vpunpcklqdq(xmm1, xmm1, xmm3);
        vinsertf128(ymm0, ymm0, xmm1, 0x1);
        vmovdqu(yword[B - 0x80], ymm0);
        sub(B, -32);
        align(4);

        L(l1964);
        test(M, 0x1);
        jle(l19d8, T_NEAR);
        mov(ax, word[A1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A1 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A1 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A1 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A1 + LDA * 4]);
        mov(ax, word[A2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x4);
        mov(ax, word[A2 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x5);
        mov(ax, word[A2 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x6);
        mov(ax, word[A2 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x7);
        lea(A2, ptr[A2 + LDA * 4]);
        vmovdqu(xword[B - 0x80], xmm0);
        sub(B, -16);
        align(4);

        L(l19d8);
        sub(N, 0x8);
        cmp(N, 0x8);
        jge(l17c0, T_NEAR);
        align(4);

        L(l19e8);
        cmp(N, 0x4);
        jl(l1b60, T_NEAR);
        align(4);

        L(l19f4);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 2]);
        lea(I, ptr[A1 + LDA * 4]);
        mov(A, I);
        mov(I, M);
        sar(I, 0x3);
        jle(l1a7c, T_NEAR);
        align(4);

        L(l1a0c);
        vmovdqu(xmm0, xword[A1 - 0x80]);
        vmovdqu(xmm1, xword[A1 + LDA * 1 - 0x80]);
        sub(A1, -16);
        vmovdqu(xmm2, xword[A2 - 0x80]);
        vmovdqu(xmm3, xword[A2 + LDA * 1 - 0x80]);
        sub(A2, -16);
        vperm2f128(ymm0, ymm0, ymm2, 0x20);
        vperm2f128(ymm1, ymm1, ymm3, 0x20);
        vunpcklps(ymm2, ymm0, ymm1);
        vunpckhps(ymm3, ymm0, ymm1);
        vperm2f128(ymm0, ymm2, ymm2, 0x1);
        vperm2f128(ymm1, ymm3, ymm3, 0x1);
        vshufpd(ymm0, ymm2, ymm0, 0xc);
        vshufpd(ymm1, ymm3, ymm1, 0xc);
        vpermilpd(ymm0, ymm0, 0x6);
        vpermilpd(ymm1, ymm1, 0x6);
        vmovdqu(yword[B - 0x80], ymm0);
        vmovdqu(yword[B - 0x60], ymm1);
        sub(B, -64);
        dec(I);
        jg(l1a0c, T_NEAR);
        align(4);

        L(l1a7c);
        test(M, 0x4);
        jle(l1ac8, T_NEAR);
        vmovq(xmm0, qword[A1 - 0x80]);
        vmovq(xmm1, qword[A1 + LDA * 1 - 0x80]);
        sub(A1, -8);
        vmovq(xmm2, qword[A2 - 0x80]);
        vmovq(xmm3, qword[A2 + LDA * 1 - 0x80]);
        sub(A2, -8);
        vunpcklps(xmm0, xmm0, xmm2);
        vunpcklps(xmm1, xmm1, xmm3);
        vunpcklps(xmm2, xmm0, xmm1);
        vunpckhps(xmm3, xmm0, xmm1);
        vmovdqu(xword[B - 0x80], xmm2);
        vmovdqu(xword[B - 0x70], xmm3);
        sub(B, -32);
        align(4);

        L(l1ac8);
        test(M, 0x2);
        jle(l1b0c, T_NEAR);
        vmovd(xmm0, dword[A1 - 0x80]);
        vmovd(xmm1, dword[A1 + LDA * 1 - 0x80]);
        sub(A1, -4);
        vmovd(xmm2, dword[A2 - 0x80]);
        vmovd(xmm3, dword[A2 + LDA * 1 - 0x80]);
        sub(A2, -4);
        vunpcklps(xmm0, xmm0, xmm1);
        vunpcklps(xmm2, xmm2, xmm3);
        vpunpcklqdq(xmm0, xmm0, xmm2);
        vmovdqu(xword[B - 0x80], xmm0);
        sub(B, -16);
        align(4);

        L(l1b0c);
        test(M, 0x1);
        jle(l1b50, T_NEAR);
        mov(ax, word[A1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A1 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        mov(ax, word[A1 + LDA * 2 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x2);
        mov(ax, word[A1 + LDA3 * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x3);
        lea(A2, ptr[A1 + LDA * 4]);
        vmovq(qword[B - 0x80], xmm0);
        sub(B, -8);
        align(4);

        L(l1b50);
        sub(N, 0x4);
        cmp(N, 0x4);
        jge(l19f4, T_NEAR);
        align(4);

        L(l1b60);
        cmp(N, 0x2);
        jl(l1c46, T_NEAR);
        align(4);

        L(l1b6c);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 1]);
        lea(I, ptr[A1 + LDA * 2]);
        mov(A, I);
        mov(I, M);
        sar(I, 0x3);
        jle(l1bb8, T_NEAR);
        align(4);

        L(l1b84);
        vmovdqu(xmm0, xword[A1 - 0x80]);
        sub(A1, -16);
        vmovdqu(xmm1, xword[A2 - 0x80]);
        sub(A2, -16);
        vunpcklps(xmm2, xmm0, xmm1);
        vunpckhps(xmm3, xmm0, xmm1);
        vmovdqu(xword[B - 0x80], xmm2);
        vmovdqu(xword[B - 0x70], xmm3);
        sub(B, -32);
        dec(I);
        jg(l1b84, T_NEAR);
        align(4);

        L(l1bb8);
        test(M, 0x4);
        jle(l1be4, T_NEAR);
        vmovq(xmm0, qword[A1 - 0x80]);
        sub(A1, -8);
        vmovq(xmm1, qword[A2 - 0x80]);
        sub(A2, -8);
        vunpcklps(xmm0, xmm0, xmm1);
        vmovdqu(xword[B - 0x80], xmm0);
        sub(B, -16);
        align(4);

        L(l1be4);
        test(M, 0x2);
        jle(l1c10, T_NEAR);
        vmovd(xmm0, dword[A1 - 0x80]);
        sub(A1, -4);
        vmovd(xmm1, dword[A2 - 0x80]);
        sub(A2, -4);
        vunpcklps(xmm0, xmm0, xmm1);
        vmovq(qword[B - 0x80], xmm0);
        sub(B, -8);
        align(4);

        L(l1c10);
        test(M, 0x1);
        jle(l1c38, T_NEAR);
        mov(ax, word[A1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x0);
        mov(ax, word[A1 + LDA * 1 - 0x80]);
        vpinsrw(xmm0, xmm0, eax, 0x1);
        vmovd(dword[B - 0x80], xmm0);
        sub(B, -4);
        align(4);

        L(l1c38);
        sub(N, 0x2);
        cmp(N, 0x2);
        jge(l1b6c, T_NEAR);
        align(4);

        L(l1c46);
        cmp(N, 0x1);
        jl(l1d04, T_NEAR);
        align(4);

        L(l1c50);
        mov(A1, A);
        add(A, LDA);
        mov(I, M);
        sar(I, 0x4);
        jle(l1c7c, T_NEAR);
        align(4);

        L(l1c60);
        vmovdqu(ymm0, yword[A1 - 0x80]);
        sub(A1, -32);
        vmovdqu(yword[B - 0x80], ymm0);
        sub(B, -32);
        dec(I);
        jg(l1c60, T_NEAR);
        align(4);

        L(l1c7c);
        test(M, 0x8);
        jle(l1c9c, T_NEAR);
        vmovdqu(xmm0, xword[A1 - 0x80]);
        sub(A1, -16);
        vmovdqu(xword[B - 0x80], xmm0);
        sub(B, -16);
        align(4);

        L(l1c9c);
        test(M, 0x4);
        jle(l1cbc, T_NEAR);
        vmovq(xmm0, qword[A1 - 0x80]);
        sub(A1, -8);
        vmovq(qword[B - 0x80], xmm0);
        sub(B, -8);
        align(4);

        L(l1cbc);
        test(M, 0x2);
        jle(l1cdc, T_NEAR);
        vmovd(xmm0, dword[A1 - 0x80]);
        sub(A1, -4);
        vmovd(dword[B - 0x80], xmm0);
        sub(B, -4);
        align(4);

        L(l1cdc);
        test(M, 0x1);
        jle(l1cf4, T_NEAR);
        mov(ax, word[A1 - 0x80]);
        mov(word[B - 0x80], ax);
        sub(B, -2);
        align(4);

        L(l1cf4);
        sub(N, 0x1);
        cmp(N, 0x1);
        jge(l1c50, T_NEAR);
        align(4);

        L(l1d04);

        postamble();
    }
    outLocalLabel();

#undef M
#undef N
#undef A
#undef LDA
#undef ALPHA
#undef B
#undef I
#undef A1
#undef A2
#undef LDA3
#ifdef _WIN32
#undef ARG_ALPHA
#undef ARG_B
#endif
}

} // namespace cpu
} // namespace impl
} // namespace dnnl
