/* version.c -- print the version number.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>


static int major_version = 1;
static int minor_version = 1;
static int patchlevel = 0;

static char buffer[32];


static char *
DEFUN_VOID (version_string)
{
  if (patchlevel)
    sprintf (buffer, "%d.%d.%d", major_version, minor_version, patchlevel);
  else
    sprintf (buffer, "%d.%d", major_version, minor_version);

  return (buffer);
}


void
DEFUN_VOID (version)
{
  fprintf (stdout, "This is FAXDVI Version %s\n", version_string ());
}
