/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQKeyProfileModel_H
#define MvQKeyProfileModel_H

#include <QAbstractItemModel>
#include <QList>
#include <QPair>
#include <QSortFilterProxyModel>
#include <QStringList>

class GribMetaData;
class MvKeyProfile;

//typedef QPair<QString,QStringList>  MvQKeyFilterItem;
//typedef QList<MvQKeyFilterItem> MvQKeyFilter;

typedef QMap<QString,QStringList> MvQKeyFilter;

class MvQKeyProfileSortFilterModel : public QSortFilterProxyModel
{
public:
	MvQKeyProfileSortFilterModel(QObject *parent=0) : QSortFilterProxyModel(parent) {};

protected:
	bool lessThan ( const QModelIndex &, const QModelIndex &) const;
};

class MvQKeyProfileModel : public QAbstractItemModel
{
	Q_OBJECT

public:
   	MvQKeyProfileModel();
 
   	int columnCount (const QModelIndex& parent = QModelIndex() ) const;
   	int rowCount (const QModelIndex& parent = QModelIndex() ) const;

   	virtual QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
   	QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;
 
   	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;

	void keyProfileIsAboutToChange();

	MvKeyProfile* keyProfile() {return profile_;}
	void setKeyProfile(MvKeyProfile*);

	MvQKeyFilter keyFilter() {return filter_;}
	void setKeyFilter(MvQKeyFilter);

	Qt::ItemFlags flags ( const QModelIndex &) const;
	Qt::DropActions supportedDropActions() const;
	QStringList mimeTypes() const;
	QMimeData* mimeData(const QModelIndexList &) const;
	bool dropMimeData(const QMimeData *data,
     			Qt::DropAction action, int row, int column, 
			const QModelIndex &parent);

signals:
	void keyInserted();

protected:
    	QString label( const int,const int) const;
	void loadKeyFilter();

 	bool isDataSet() const;
	MvKeyProfile*  profile_;
	MvQKeyFilter   filter_;
	QList<bool>    messageFilterStatus_;
};

#endif 

