/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ShellTask.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ShellTask_H
#define ShellTask_H

#ifndef Task_H
#include "Task.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Input_H
#include "Input.h"
#endif


class ShellTask : public Task, public Input {
public:

// -- Exceptions
	// None

// -- Contructors

	ShellTask(const string&,IconObject*);

// -- Destructor

	virtual ~ShellTask(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators


// -- Methods
	virtual void addContext (const Request&) { };

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	 void print(ostream&) const; // Change to virtual if base class	
         void Object(IconObjectH xx) { object_ = xx; }


// -- Overridden methods
	// From Task
	virtual void start();
	// From Input
	virtual void done(FILE*);

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	ShellTask(const ShellTask&);
	ShellTask& operator=(const ShellTask&);

// -- Members

	IconObjectH object_;
	FILE*       file_;
	string      cmd_;

// -- Methods

// -- Overridden methods



	// From Input
	virtual void ready(const char*);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const ShellTask& p)
	//	{ p.print(s); return s; }

};

inline void destroy(ShellTask**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(ShellTask);
//#endif

#endif
