/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File LineFactory.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef LineFactory_H
#define LineFactory_H

#include <string>
using std::string;

#include "mars.h"

class RequestPanel;
class RequestPanelLine;
class Parameter;

class LineFactory {
public:

// -- Exceptions
	// None

// -- Contructors

	LineFactory(const string&);

// -- Destructor

	virtual ~LineFactory(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual RequestPanelLine* make(RequestPanel&,const Parameter&) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static RequestPanelLine* create(RequestPanel&,const Parameter&);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	LineFactory(const LineFactory&);
	LineFactory& operator=(const LineFactory&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const LineFactory& p)
	//	{ p.print(s); return s; }

};

template<class T>
class LineMaker : public LineFactory {
	RequestPanelLine* make(RequestPanel& e,const Parameter& p) { return new T(e,p); }
public:
	LineMaker(const string& name) : LineFactory(name) {}
};


#endif
