/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File XMString.h
// Baudouin Raoult - ECMWF Feb 99

#ifndef XMString_H
#define XMString_H

// Headers
// #ifndef   machine_H
// #include <machine.h>
// #endif

// Forward declarations

// class ostream;
// typedef class _Pvts os_typespec; // Remove if not persistant

// 

#include <Xm/Xm.h>
#include <string>
using std::string;


class XMString {
public:

// -- Exceptions
	// None

// -- Contructors

	XMString(const char* = 0, const char* set = 0);
	XMString(const string&,const char* set = 0);

	XMString(XmString);
	XMString(const XMString&);
	XMString& operator=(const XMString&);

// -- Destructor

	~XMString();

// -- Convertors
	// None

// -- Operators

	operator XmString() const { return str_; }

	XMString operator+(const XMString&) const; 
	XMString& operator+=(const XMString&);

	operator string() const;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed


// -- Members

	XmString str_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const XMString& p)
	//	{ p.print(s); return s; }

};

inline void destroy(XMString**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(XMString);
//#endif

#endif
