/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File InternalEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef InternalEditor_H
#define InternalEditor_H


#include <Xm/Xm.h>
#include <string>
using std::string;

#ifndef DropSite_H
#include "DropSite.h"
#endif

#include "UIEditor.h"

class IconObject;
class IconClass;
class EditorDrawer;
class EditorTool;
class EditorObserver;

#include "IconObject.h"
#include "Editor.h"

class InternalEditor : public Editor, public UIEditor_c, public DropSite {
public:

// -- Exceptions
	// None

// -- Destructor

	virtual ~InternalEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	Widget main();
	Widget drawer();
	Widget tool();

	void help();

	// ---

	virtual void apply() = 0;
	virtual void reset() = 0;
	virtual void close() = 0;

	virtual void merge(IconObject*) = 0;
	virtual void replace(IconObject*) = 0;

	virtual IconObject* copy(const string&);
	

// -- Overridden methods
	
	// -- From Editor

	virtual void temporary();
	virtual void empty();
	virtual void edit();
	virtual void raise();

	virtual string alternateEditor();
	virtual bool modified();

// -- Class members
	// None

// -- Class methods


protected:

// -- Contructors

	InternalEditor(const IconClass&,const string& kind);

// -- Members
	// None

	map<string,EditorDrawer*> drawers_;
	map<string,EditorTool*>   tools_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

	void startAlternate();
	void updateDrawers();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	InternalEditor(const InternalEditor&);
	InternalEditor& operator=(const InternalEditor&);

// -- Members

// -- Methods


// -- Overridden methods

	// 

	// -- From XDesigned
	virtual void closeCB(Widget,XtPointer);
	virtual void applyCB(Widget,XtPointer);
	virtual void resetCB(Widget,XtPointer);
	virtual void textEditorCB(Widget,XtPointer);


	// From DropSite

	virtual Widget dropSite();
	virtual void drop(Dropping&);

// -- Class members


// -- Class methods
	// None

	static void dropCB(Widget,XtPointer,XtPointer);

// -- Friends

	//friend ostream& operator<<(ostream& s,const InternalEditor& p)
	//	{ p.print(s); return s; }

};


inline void destroy(InternalEditor**) {}

template<class T>
class XEditor : public InternalEditor, public T {
public:
	XEditor(const IconClass& c,const string& kind): 
		InternalEditor(c,kind)
	{
		T::create(main());
		XtManageChild(T::xd_rootwidget());
	}
};

#endif
