/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Action.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Action_H
#define Action_H

#include <string>
#include "inc_iostream.h"

using std::string;


class Action {
public:

// -- Exceptions
	// None

// -- Contructors

	Action(const string& = "*" ,const string& = "*" );

// -- Destructor

	~Action(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators

	bool operator<(const Action&) const;

// -- Methods
	
	const string& name() const;
	const string& mode() const;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed


// -- Members

	string name_;
	string mode_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	friend ostream& operator<<(ostream& s,const Action& p)
		{ p.print(s); return s; }

};

inline void destroy(Action**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Action);
//#endif

#endif
