/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef GeopExaminer_H
#define GeopExaminer_H

#include <QMainWindow>
#include <QModelIndex>

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"

class QSpinBox;
class QSplitter;
class QSortFilterProxyModel;

class MvGeoPoints;
class MvQFileInfoLabel;
class MvQLogBrowser;
class MvQGeoPointsDataModel;
class MvQSearchLinePanel;
class MvQTreeView;
class MvQTreeViewSearchLine;

using namespace std;

class GeopExaminer : public MvQMainWindow
{
    Q_OBJECT

public:
    	GeopExaminer(QWidget *parent = 0);
	~GeopExaminer();
    	bool initMetaData(const string&);
	void updateFileInfoLabel();

public slots:
	void slotShowAboutBox();
	void slotUpdateLogOutput();
	void slotClearLog(bool);
	void slotStatusMessage(QString);
	void slotDataRowSpinChanged(int);
	void slotSelectDataRow(const QModelIndex&);

signals:
	void statusMessage(QString);

private:
	void setupEditActions();
	void setupViewActions();
	void setupHelpActions();
	void setupDataBox();
	void setupFindBox();
	void setupLogArea();

	void readSettings();
	void writeSettings();

	MvGeoPoints *data_;
	MvQGeoPointsDataModel* gpModel_;
	QSortFilterProxyModel* gpSortModel_;
	MvQMainWindow::MenuItemMap menuItems_;
	MvQFileInfoLabel*  fileInfoLabel_;

	QAction* actionFileInfo_;
	QSplitter* mainSplitter_;
	QTabWidget* metaTab_;
	MvQLogBrowser* logBrowser_;
	MvQTreeView* treeData_;
	QWidget* logPanel_;
	QAction* actionLog_;
	QLabel* statusMessageLabel_;
	bool ignoreDataRowSpinChangeSignal_;
	QSpinBox* dataRowSpin_;
	QWidget* dataPanel_;
	
	MvQSearchLinePanel* findPanel_;
	MvQTreeViewSearchLine* dataFind_;
};

#endif
