# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class WordCloud(ImageAlgorithm):
    r"""
    WordCloud - generate a word cloud visualization of a text document
    
    Superclass: ImageAlgorithm
    
    Word Clouds, AKA Tag Clouds
    (https://en.wikipedia.org/wiki/Tag_cloud), are a text visualization
    technique that displays individual words with properties that depend
    on the frequency of a word in a document. WordCloud varies the
    font size based on word frequency. Word Clouds are useful for quickly
    perceiving the most prominent terms in a document. Also, Word Clouds
    can identify trends and patterns that would otherwise be unclear or
    difficult to see in a tabular format. Frequently used keywords stand
    out better in a word cloud. Common words that might be overlooked in
    tabular form are highlighted in the larger text, making them pop out
    when displayed in a word cloud.
    
    There is some controversy about the usefulness of word clouds. Their
    best use may be for presentations, see https://tinyurl.com/y59hy7oa
    
    The generation of the word cloud proceeds as follows:
    1. Read the text file
    2. Split text into words to be processed Extract words from the text
       Drop the case of each word for filtering Filter the words Replace
       words from the replacement_pairs list Skip the word if it is in the
    stop list or contains a digit Skip single character words Raise the
       case of the first letter in each word Sort the word list by
       frequency
    3. Create a rectangular mask image or read a mask image
    4. For each word Render the word into an image Try to add the word to
    the word cloud image. For each orientation, see if the word "fits" If
    no fit, move along a path to try another location
    
    NOTE: A word fits if all of the non-zero word cloud pixels in the
    extent of the text image are background pixels.
    
    NOTE: The path is an Archimedean Spiral
    (https://en.wikipedia.org/wiki/Archimedean_spiral)
    
    * NOTE: WordCloud has a built-in list of stop word. Stop words are
    * words that are filtered out before processing of the text, such as
    * the, is, at, which, and so on.
    *
    * NOTE: Color names are defined in NamedColors. A visual
    * representation of color names is here: https://tinyurl.com/y3yxcxj6
    *
    * NOTE: WordCloud offers Several methods to customize the
      resulting
    * visualization. The class provides defaults that provide a
      reasonable
    * result.
    *
    * background_color_name - The NamedColors name for the background
    * (mid_night_blue). See https://tinyurl.com/y3yxcxj6 for a visual
    * representation of the named colors.
    *
    * color_distribution - Distribution of random colors(.6 1.0), if
    * word_color_name is empty.
    *
    * color_scheme_name - Name of a color scheme from ColorSeries to be
    * used to select colors for the words (), if word_color_name is empty.
    * See https://tinyurl.com/y3j6c27o for a visual representation of the
    * color schemes.
    *
    * DPI - Dots per inch(200) of the rendered text. DPI is used as a
    * scaling mechanism for the words. As DPI increases, the word size
    * increases. If there are too, few skipped words, increase this
      value,
    * too many, decrease it.
    *
    * font_file_name - If empty, the built-in Arial font is used(). The
    * font_file_name is the name of a file that contains a true_type font.
    * https://www.1001freefonts.com/ is a good source for free true_type
    * fonts.
    *
    * font_multiplier - Font multiplier(6). The final font_size is this
      value
    * times the word frequency.
    *
    * Gap - Space gap of words (2). The gap is the number of spaces added
    to
    * the beginning and end of each word.
    *
    * mask_color_name - Name of the color for the mask (black). This is the
    * name of the vtknamedColors that defines the foreground of the
    * mask. Usually black or white.  See https://tinyurl.com/y3yxcxj6 for
    * a visual representation of the named colors.
    *
    * mask_file_name - Mask file name(). If a mask file is specified, it
      will be
    * used as the mask. Otherwise, a black square is used as the mask.
      The
    * mask file should contain three channels of unsigned char values. If
    * the mask file is just a single unsigned char, specify turn the
      boolean
    * BWMask on.  If BWmask is on, the class will create a three channel
    * image using ImageAppendComponents.
    *
    * BWMask - Mask image has a single channel(false). Mask images
      typically
    * have three channels (r,g,b).
    *
    * max_font_size - Maximum font size(48).
    *
    * min_font_size - Minimum font size(8).
    *
    * min_frequency - Minimum word frequency accepted(2). Word with
    * frequencies less than this will be ignored.
    *
    * offset_distribution - Range of uniform random offsets(-size[0]/100.0
    * -size{1]/100.0)(-20 20). These offsets are offsets from the
      generated
    * path for word layout.
    *
    * orientation_distribution - Ranges of random orientations(-20 20). If
    * discrete orientations are not defined, these orientations will be
    * generated.
    *
    * Orientations - Vector of discrete orientations(). If non-empty,
    * these will be used instead of the orientations distribution");
    *
    * replacement_pairs - Replace the first word with another second word
    * ().  The each word will also added to the stop_list. The second
    * argument can contain multiple words. For example you could replace
    * "bill" with "Bill Lorensen" or, "vtk" with "VTK . Remember that
    * words are always stored internally with lower case, even though the
    * first letter is capitalized in the Word Cloud.
    *
    * Sizes - Size of image(640 480).
    *
    * stop_words - User provided stop words(). Stop words are words that
    * are filtered out before processing of the text, such as the, is,
    * at, which, and so on.  WordClass has built-in stop words. The
    * user-provided stop words are added to the built-in list. See
    * https://en.wikipedia.org/wiki/Stop_words for a description.  The
    * built-in stop words were derived from the english stop words at
    * https://www.ranks.nl/stopwords. Stop words for other languages are
    * also available.
    *
    * stop_list_file_name - the name of a file that contains stop words,
    * one word per line (). If present, the stop words in the file
    * replace the built-in stop list.
    *
    * Title - Add this word to the document's words and set a high
    * frequency, so that is will be rendered first.
    *
    * word_color_name - Name of the color for the words(). The name is
    * selected from NamedColors. If the name is empty, the
    * color_distribution will generate random colors.  See
    * https://tinyurl.com/y3yxcxj6 for a visual representation of the
    * named colors.
    *
    * The class also provided Get methods that return vectors
    * stop_words, skipped_words and kept_words.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWordCloud, obj, update, **traits)
    
    bw_mask = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _bw_mask_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBWMask,
                        self.bw_mask)

    background_color_name = traits.String('MidnightBlue', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _background_color_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackgroundColorName,
                        self.background_color_name)

    color_scheme_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _color_scheme_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorSchemeName,
                        self.color_scheme_name)

    dpi = traits.Int(200, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _dpi_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDPI,
                        self.dpi)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    font_file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _font_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFontFileName,
                        self.font_file_name)

    font_multiplier = traits.Int(6, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _font_multiplier_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFontMultiplier,
                        self.font_multiplier)

    gap = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _gap_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGap,
                        self.gap)

    mask_color_name = traits.String('black', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _mask_color_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskColorName,
                        self.mask_color_name)

    mask_file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _mask_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskFileName,
                        self.mask_file_name)

    max_font_size = traits.Int(48, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _max_font_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxFontSize,
                        self.max_font_size)

    min_font_size = traits.Int(12, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _min_font_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinFontSize,
                        self.min_font_size)

    min_frequency = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _min_frequency_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinFrequency,
                        self.min_frequency)

    orientations = traits.Array(enter_set=True, auto_set=False, shape=(0,), dtype=None, value=(), cols=0, desc=\
        r"""
        
        """
    )

    def _orientations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrientations,
                        self.orientations)

    stop_list_file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _stop_list_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStopListFileName,
                        self.stop_list_file_name)

    title = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _title_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTitle,
                        self.title)

    word_color_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _word_color_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWordColorName,
                        self.word_color_name)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_kept_words(self):
        return self._vtk_obj.GetKeptWords()
    kept_words = traits.Property(_get_kept_words, desc=\
        r"""
        
        """
    )

    def _get_skipped_words(self):
        return self._vtk_obj.GetSkippedWords()
    skipped_words = traits.Property(_get_skipped_words, desc=\
        r"""
        
        """
    )

    def _get_stopped_words(self):
        return self._vtk_obj.GetStoppedWords()
    stopped_words = traits.Property(_get_stopped_words, desc=\
        r"""
        
        """
    )

    def add_orientation(self, *args):
        """
        add_orientation(self, arg:float) -> None
        C++: void add_orientation(double arg)"""
        ret = self._wrap_call(self._vtk_obj.AddOrientation, *args)
        return ret

    def add_stop_word(self, *args):
        """
        add_stop_word(self, word:str) -> None
        C++: void add_stop_word(std::string word)"""
        ret = self._wrap_call(self._vtk_obj.AddStopWord, *args)
        return ret

    def clear_stop_words(self):
        """
        clear_stop_words(self) -> None
        C++: void clear_stop_words()"""
        ret = self._vtk_obj.ClearStopWords()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('bw_mask',
    'GetBWMask'), ('background_color_name', 'GetBackgroundColorName'),
    ('color_scheme_name', 'GetColorSchemeName'), ('dpi', 'GetDPI'),
    ('file_name', 'GetFileName'), ('font_file_name', 'GetFontFileName'),
    ('font_multiplier', 'GetFontMultiplier'), ('gap', 'GetGap'),
    ('mask_color_name', 'GetMaskColorName'), ('mask_file_name',
    'GetMaskFileName'), ('max_font_size', 'GetMaxFontSize'),
    ('min_font_size', 'GetMinFontSize'), ('min_frequency',
    'GetMinFrequency'), ('orientations', 'GetOrientations'),
    ('stop_list_file_name', 'GetStopListFileName'), ('title', 'GetTitle'),
    ('word_color_name', 'GetWordColorName'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'background_color_name', 'bw_mask',
    'color_scheme_name', 'dpi', 'file_name', 'font_file_name',
    'font_multiplier', 'gap', 'mask_color_name', 'mask_file_name',
    'max_font_size', 'min_font_size', 'min_frequency', 'object_name',
    'orientations', 'progress_text', 'stop_list_file_name', 'title',
    'word_color_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(WordCloud, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit WordCloud properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['background_color_name', 'bw_mask',
            'color_scheme_name', 'dpi', 'file_name', 'font_file_name',
            'font_multiplier', 'gap', 'mask_color_name', 'mask_file_name',
            'max_font_size', 'min_font_size', 'min_frequency', 'object_name',
            'orientations', 'stop_list_file_name', 'title', 'word_color_name']),
            title='Edit WordCloud properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit WordCloud properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

