C (C) Copyright 1996-2016 ECMWF.
C 
C This software is licensed under the terms of the Apache Licence Version 2.0
C which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation nor
C does it submit to any jurisdiction.
C

	PROGRAM AXIS02

	CALL POPEN

	CALL PARSE_COMMAND_LINE ('axis02')
	CALL PSETC('PAGE_ID_LINE_USER_TEXT','TESTS/AXIS02') 
C
C	SET PAGE AND SUBPAGE
C
	CALL PSETR('SUPER_PAGE_Y_LENGTH',29.7)
	CALL PSETR('SUPER_PAGE_X_LENGTH',21.0)
	CALL PSETR('PAGE_Y_LENGTH',29.7)
	CALL PSETR('PAGE_X_LENGTH',21.0)
	CALL PSETR('SUBPAGE_Y_LENGTH',1.0)
	CALL PSETR('SUBPAGE_X_LENGTH',18.0)
	CALL PSETR('SUBPAGE_Y_POSITION',20.8)
	CALL PSETR('SUBPAGE_X_POSITION',1.0)
	CALL PSETC('SUBPAGE_MAP_PROJECTION','NONE')
	CALL PSETC('PAGE_FRAME','OFF')   
	CALL PSETC('SUBPAGE_FRAME','OFF')   
	CALL PSETR('TEXT_REFERENCE_CHARACTER_HEIGHT',0.3)
	CALL PSETC('TEXT_MODE','POSITIONAL')
	CALL PSETC('TEXT_LINE_1','Data Units = DAYS, same month ')
	CALL PSETC('TEXT_LINE_2','  ')
	CALL PSETC('TEXT_LINE_3','AXIS_DATE_TYPE    DAYS')
	CALL PSETC('TEXT_LINE_4',
     x 'AXIS_DATE_MIN_VALUE  1995-06-01 00:00:00')
	CALL PSETC('TEXT_LINE_5',
     x  'AXIS_DATE_MAX_VALUE  1995-06-10 00:00:00')
	CALL PSETC('TEXT_LINE_6','AXIS_TICK_INTERVAL     1.0')
	CALL PSETI('TEXT_LINE_COUNT',6)
	CALL PSETC('TEXT_JUSTIFICATION','LEFT')
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',21.8)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PTEXT
C
C	SELECT THE PROJECTION (MUST BE DONE BEFORE CALLING PGRIB)
C
	CALL PSETC('AXIS_DATE_MIN_VALUE','1995-06-01 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1995-06-10 00:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','DAYS')         
	CALL PAXIS 
	CALL PNEW('SUBPAGE')
	CALL PSETC('TEXT_LINE_1','Data Units = DAYS, consecutive months ')
	CALL PSETC('TEXT_LINE_2','  ')
	CALL PSETC('TEXT_LINE_4',
     x 'AXIS_DATE_MIN_VALUE  1991-06-25 00:00:00')
	CALL PSETC('TEXT_LINE_5',
     x  'AXIS_DATE_MAX_VALUE  1991-07-04 00:00:00')
	CALL PSETI('TEXT_LINE_COUNT',5)
	CALL PSETR('SUBPAGE_Y_POSITION',11.9)
	CALL PSETR('SUBPAGE_Y_LENGTH',1.0)
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',12.9)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PTEXT
	CALL PSETR('SUBPAGE_Y_LENGTH',3.0)
	CALL PSETC('AXIS_DATE_MIN_VALUE','1991-06-25 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1991-06-04 00:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','DAYS')         
	CALL PAXIS 
	CALL PNEW('SUBPAGE')
	CALL PSETC ('TEXT_LINE_1',
     X  'Data units = YEARS')
	CALL PSETC ('TEXT_LINE_2',
     X  '  ') 
	CALL PSETC('TEXT_LINE_4',
     x 'AXIS_DATE_MIN_VALUE  1991-01-01 00:00:00')
	CALL PSETC('TEXT_LINE_5',
     x 'AXIS_DATE_MAX_VALUE  1999-01-01 00:00:00')
	CALL PSETC ('TEXT_LINE_3',
     X     'AXIS_DATE_TYPE    YEARS ')
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',4.0)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PSETR('SUBPAGE_Y_POSITION',3.0)
	CALL PSETR('SUBPAGE_Y_LENGTH',1.0)
	CALL PTEXT
	CALL PSETC('AXIS_DATE_MIN_VALUE','1991-01-01 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1999-01-01 00:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','YEARS')         
C	CALL PSETC('AXIS_YEARS_LABEL','OFF')
                 
	CALL PAXIS 
C
C	CLOSE MAGICS
C
	CALL PNEW('PAGE')
	CALL TWO
	CALL PNEW('PAGE')
	CALL THREE
	CALL PCLOSE

      STOP
	END
      SUBROUTINE TWO
	CALL PSETR('SUBPAGE_Y_POSITION',20.8)
	CALL PSETC ('TEXT_LINE_1',
     X  'Data units = MONTHS')
	CALL PSETC ('TEXT_LINE_2',
     X  '  ') 
	CALL PSETC('TEXT_LINE_4',
     x  'AXIS_DATE_MIN_VALUE  1995-06-01 00:00:00')
	CALL PSETC('TEXT_LINE_5',
     x  'AXIS_DATE_MAX_VALUE  1996-03-01 00:00:00')
	CALL PSETC ('TEXT_LINE_6',
     X     'AXIS_DAYS_LABEL    NAME')
	CALL PSETC ('TEXT_LINE_7',
     X     'AXIS_DAYS_NAME_COMPOSITION = FULL')
	CALL PSETC ('TEXT_LINE_3',
     X     'AXIS_DATE_TYPE    MONTHS')
	CALL PSETI('TEXT_LINE_COUNT',5)
	CALL PSETC('TEXT_JUSTIFICATION','LEFT')
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',21.8)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PTEXT

C
C	SELECT THE PROJECTION (MUST BE DONE BEFORE CALLING PGRIB)
C
	CALL PSETC('AXIS_DATE_MIN_VALUE','1995-06-01 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1996-03-01 00:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','MONTHS')         
	CALL PAXIS 
	CALL PNEW('SUBPAGE')
	CALL PSETC ('TEXT_LINE_1',
     X  'Data units = HOURS, same day  ') 
	CALL PSETC ('TEXT_LINE_2',
     X  '  ') 
	CALL PSETC('TEXT_LINE_4',
     x  'AXIS_DATE_MIN_VALUE  1995-06-25 00:00:00')
	CALL PSETC('TEXT_LINE_5',
     x  'AXIS_DATE_MAX_VALUE  1995-06-25 09:00:00')
	CALL PSETC ('TEXT_LINE_3',
     X     'AXIS_TYPE    HOURS')
	CALL PSETI('TEXT_LINE_COUNT',6)
	CALL PSETR('SUBPAGE_Y_POSITION',11.9)
	CALL PSETR('SUBPAGE_Y_LENGTH',1.0)
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',12.9)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PTEXT
	CALL PSETR('SUBPAGE_Y_LENGTH',3.0)
	CALL PSETC('AXIS_DATE_MIN_VALUE','1995-06-25 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1995-06-25 09:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','HOURS')         
	CALL PSETC('AXIS_HOURS_LABEL','ON')                 
	CALL PAXIS 
	CALL PNEW('SUBPAGE')
	CALL PSETC ('TEXT_LINE_1',
     X  'Data units = DAYS, using HOURS')
	CALL PSETC ('TEXT_LINE_2',
     X  '  ') 
	CALL PSETC('TEXT_LINE_4',
     x  'AXIS_DATE_MIN_VALUE  1995-06-25 15:00:00')
	CALL PSETC('TEXT_LINE_5',
     x  'AXIS_DATE_MAX_VALUE  1995-07-02 18:00:00')
	CALL PSETC ('TEXT_LINE_3',
     X     'AXIS_TYPE    DAYS')
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',4.0)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PSETR('SUBPAGE_Y_POSITION',3.0)
	CALL PSETR('SUBPAGE_Y_LENGTH',1.0)
	CALL PTEXT
	CALL PSETC('AXIS_DATE_MIN_VALUE','1995-06-25 15:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1995-07-02 18:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','DAYS')         
	CALL PSETC('AXIS_HOURS_LABEL','OFF')                 
                 
	CALL PAXIS 
cCALL PRESET('AXIS_BASE_DATE')
C
C	CLOSE MAGICS
C
	RETURN
	END
      SUBROUTINE THREE
	CALL PSETR('SUBPAGE_Y_POSITION',20.8)
	CALL PSETC ('TEXT_LINE_1',
     X  'Data units = DAYS, full day name but not '//
     X   ' day number')
	CALL PSETC ('TEXT_LINE_2',
     X  '  ') 
	CALL PSETC('TEXT_LINE_4',
     x  'AXIS_DATE_MIN_VALUE  1991-06-25 00:00:00')
	CALL PSETC('TEXT_LINE_5',
     x  'AXIS_DATE_MAX_VALUE  1991-07-04 00:00:00')
	CALL PSETC ('TEXT_LINE_6',
     X     'AXIS_DAYS_LABEL    NAME')
	CALL PSETC ('TEXT_LINE_7',
     X     'AXIS_DAYS_NAME_COMPOSITION = FULL')
	CALL PSETC ('TEXT_LINE_3',
     X     'AXIS_DATE_TYPE    DAYS')
	CALL PSETI('TEXT_LINE_COUNT',7)
	CALL PSETC('TEXT_JUSTIFICATION','LEFT')
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',21.8)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PTEXT

C
C	SELECT THE PROJECTION (MUST BE DONE BEFORE CALLING PGRIB)
C
	CALL PSETC('AXIS_DATE_MIN_VALUE','1991-06-25 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1991-07-04 00:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','DAYS')         
	CALL PSETC('AXIS_DAYS_LABEL','DAY')                 
	CALL PSETC('AXIS_DAYS_LABEL_COMPOSITION','FULL')
	CALL PAXIS 
	CALL PNEW('SUBPAGE')
	CALL PSETC ('TEXT_LINE_1',
     X  'Data units = DAYS, day number but '//
     X    'not day name')
	CALL PSETC ('TEXT_LINE_2',
     X  '  ') 
	CALL PSETC ('TEXT_LINE_6',
     X     'AXIS_DAYS_LABEL    NUMBER')
	CALL PSETI('TEXT_LINE_COUNT',6)
	CALL PSETR('SUBPAGE_Y_POSITION',11.9)
	CALL PSETR('SUBPAGE_Y_LENGTH',1.0)
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',12.9)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PTEXT
	CALL PSETR('SUBPAGE_Y_LENGTH',3.0)
	CALL PSETC('AXIS_DATE_MIN_VALUE','1991-06-25 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1991-07-04 00:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','DAYS')         
	CALL PSETC('AXIS_DAYS_LABEL','NUMBER')                 
	CALL PAXIS 
	CALL PNEW('SUBPAGE')
	CALL PSETC ('TEXT_LINE_1',
     X  'Data units = MONTHS, year labels '//
     X    ' turned off')
	CALL PSETC ('TEXT_LINE_2',
     X  '  ') 
	CALL PSETC('TEXT_LINE_4',
     x  'AXIS_DATE_MIN_VALUE  1991-06-25 00:00:00')
	CALL PSETC('TEXT_LINE_5',
     x  'AXIS_DATE_MAX_VALUE  1992-06-25 00:00:00')
	CALL PSETC ('TEXT_LINE_6',
     X     'AXIS_YEARS_LABEL  OFF     ')   
	CALL PSETC ('TEXT_LINE_3',
     X     'AXIS_TYPE    MONTHS')
	CALL PSETR('TEXT_BOX_X_POSITION',2.0)  
	CALL PSETR('TEXT_BOX_Y_POSITION',4.0)  
	CALL PSETR('TEXT_BOX_X_LENGTH',15.0)  
	CALL PSETR('TEXT_BOX_Y_LENGTH',7.8)
	CALL PSETR('SUBPAGE_Y_POSITION',3.0)
	CALL PSETR('SUBPAGE_Y_LENGTH',1.0)
	CALL PTEXT
	CALL PSETC('AXIS_DATE_MIN_VALUE','1991-06-25 00:00:00')
	CALL PSETC('AXIS_DATE_MAX_VALUE','1992-06-25 00:00:00')
	CALL PSETR('AXIS_TICK_INTERVAL',1.0)        
	CALL PSETC('AXIS_TYPE','DATE')         
	CALL PSETC('AXIS_DATE_TYPE','MONTHS')         
	CALL PSETC('AXIS_YEARS_LABEL','OFF')
                 
	CALL PAXIS 
C
C	CLOSE MAGICS
C
	RETURN
	END


C --------------------------------------------------------------------
C     PARSE_COMMAND_LINE
C     Checks the command-line for any arguments.
C     Arguments can come in pairs. Currently supported arguments are:
C     PROJECTION <CYLINDRICAL | POLAR_STEREOGRAPHIC>
C     DEVICE <PS | SVG | PNG>
C     e.g. Run the program with:
C       <progname> PROJECTION CYLINDRICAL  DEVICE SVG
C --------------------------------------------------------------------

      SUBROUTINE PARSE_COMMAND_LINE (OUTROOTNAME)

      CHARACTER*32 ARG
      CHARACTER*64 ID_TEXT
      CHARACTER*32 PROJECTION
      CHARACTER*32 DEVICE
      CHARACTER*48 EXENAME
      CHARACTER*8  MINIMAL
      CHARACTER*8  SEPARATOR
      CHARACTER*64 OUTNAME
      CHARACTER*(*) OUTROOTNAME

      CHARACTER*16 FORMATS_PS_GIF
      DIMENSION    FORMATS_PS_GIF(2)
      DATA         FORMATS_PS_GIF /'PS', 'GIF_ANIMATION'/

      CHARACTER*16 FORMATS_PS_GIF_PDF
      DIMENSION    FORMATS_PS_GIF_PDF(3)
      DATA         FORMATS_PS_GIF_PDF /'PS', 'GIF_ANIMATION', 'PDF'/

      CHARACTER*16 FORMATS_PS_GIF_SVG
      DIMENSION    FORMATS_PS_GIF_SVG(3)
      DATA         FORMATS_PS_GIF_SVG /'PS', 'GIF_ANIMATION', 'SVG'/

      CHARACTER*16 FORMATS_PS_PNG_SVG
      DIMENSION    FORMATS_PS_PNG_SVG(3)
      DATA         FORMATS_PS_PNG_SVG /'PS', 'PNG', 'SVG'/

      CHARACTER*16 FORMATS_PS_GIF_PNG_SVG
      DIMENSION    FORMATS_PS_GIF_PNG_SVG(4)
      DATA         FORMATS_PS_GIF_PNG_SVG /'PS', 'GIF_ANIMATION', 
     +                                     'PNG', 'SVG'/

      CHARACTER*16 FORMATS_ALL
      DIMENSION    FORMATS_ALL(5)
      DATA         FORMATS_ALL /'PS', 'SVG', 'PDF',
     +                          'KML', 'PNG'/

      INTEGER NUM_ARGS
      INTEGER DEVICE_SET

      DEVICE_SET = 0

      ID_TEXT = ''

      NUM_ARGS = IARGC()

      I = 1
C
C  Start GoTo
C
20    IF (I.LE.NUM_ARGS) THEN
          CALL GETARG ( I, ARG )
C
C         Set the projection?
C
          IF (ARG.EQ.'PROJECTION') THEN
              I = I + 1 
              CALL GETARG ( I, PROJECTION ) 
              CALL PSETC ('SUBPAGE_MAP_PROJECTION', PROJECTION)
C
C        Set the device?
C
          ELSEIF (ARG.EQ.'DEVICE') THEN
              I = I + 1 
              CALL GETARG ( I, DEVICE ) 

C             Set the output filename

              IF     (DEVICE.EQ.'PS')  THEN
                OUTNAME = OUTROOTNAME //   '.ps'
                CALL PSETC ('DEVICE',       DEVICE)
                CALL PSETC ('PS_DEVICE',   'ps_a4')
                CALL PSETC ('PS_FILE_NAME', OUTNAME)
              ELSEIF (DEVICE.EQ.'PS_NEW') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'EPS') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'EPS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'GIF') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF_ANIMATION')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
                CALL PSETI ('OUTPUT_GIF_DELAY',     150)
              ELSEIF (DEVICE.EQ.'GIF_MULTI') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PNG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PNG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'JPEG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'JPEG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'SVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'SVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'CSVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'CSVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'KML') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'KML')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'BAD') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'BAD')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'PS_GIF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF, 2)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PDF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_PDF, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_PNG_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS',
     +                               FORMATS_PS_GIF_PNG_SVG, 4)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'ALL') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_ALL, 5)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSE
                WRITE(*, '(A)') 'BAD DEVICE: ', DEVICE
              ENDIF
            
            DEVICE_SET = 1
C
C        Split the PostScript pages into separate files?
C
          ELSEIF (ARG.EQ.'PS_SPLIT') THEN
                CALL PSETC ('OUTPUT_PS_SPLIT',     'ON')
C
C        Turn on the numbering for the first page?
C
          ELSEIF (ARG.EQ.'FIRST_PAGE_NUMBER') THEN
                CALL PSETC ('OUTPUT_NAME_FIRST_PAGE_NUMBER', 'ON')
C
C         Set the minimal filename number width?
C
          ELSEIF (ARG.EQ.'MINIMAL') THEN
              I = I + 1 
              CALL GETARG (I, MINIMAL) 
              IF     (MINIMAL.EQ.'0')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 0)
              ELSEIF (MINIMAL.EQ.'1')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 1)
              ELSEIF (MINIMAL.EQ.'2') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 2)
              ELSEIF (MINIMAL.EQ.'3') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 3)
              ENDIF
C
C         Set the file number separator?
C
          ELSEIF (ARG.EQ.'SEP') THEN
              I = I + 1 
              CALL GETARG ( I, SEPARATOR ) 
              CALL PSETC ('OUTPUT_FILE_SEPARATOR', SEPARATOR)
C
C        Run using linear contouring?
C
          ELSEIF (ARG.EQ.'LINEAR') THEN
                CALL PSETC ('CONTOUR_METHOD', 'LINEAR')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT_PLOT', 'ON')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT', 'LINEAR')
          ENDIF
          I = I + 1 
          GOTO 20
      ENDIF
C
C     If no device has been set, then use PostScript by default
C
      IF (DEVICE_SET.EQ.0) THEN
        OUTNAME = OUTROOTNAME // '.ps'
        CALL PSETC ('PS_DEVICE',    'ps_a4')
        CALL PSETC ('PS_FILE_NAME', OUTNAME)
      ENDIF
C
      END
