/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.CompoundDockable;
import com.vldocking.swing.docking.DockDropReceiver;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableContainerFactory;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.SingleDockableContainer;
import com.vldocking.swing.docking.event.DockDragEvent;
import com.vldocking.swing.docking.event.DockDropEvent;
import com.vldocking.swing.docking.event.DockEvent;
import com.vldocking.swing.docking.event.DockingActionAddDockableEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CompoundDockingPanel
extends JPanel
implements DockDropReceiver {
    private static final long serialVersionUID = 1L;
    private CompoundDockable dockable;

    public CompoundDockingPanel(CompoundDockable dockable) {
        this.setLayout(new BorderLayout());
        this.dockable = dockable;
    }

    @Override
    public void processDockableDrag(DockDragEvent event) {
        this.scanContainer(event, false);
    }

    @Override
    public void processDockableDrop(DockDropEvent event) {
        this.scanContainer(event, true);
    }

    private void acceptDrop(DockEvent event) {
        ((DockDropEvent)event).acceptDrop();
        Dockable d = event.getDragSource().getDockable();
        SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(d, DockableContainerFactory.ParentType.PARENT_DESKTOP);
        dockableContainer.installDocking(event.getDesktop());
        this.add((Component)((JComponent)((Object)dockableContainer)), "Center");
    }

    private void scanContainer(DockEvent event, boolean drop) {
        if (event.getDragSource().getDockableContainer().isAncestorOf(this)) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        Point p = event.getMouseEvent().getPoint();
        Rectangle compBounds = this.getBounds();
        Dockable dragged = event.getDragSource().getDockable();
        DockableState.Location initialLocation = dragged.getDockKey().getLocation();
        DockableState.Location nextLocation = this.dockable.getDockKey().getLocation();
        event.setDockingAction(new DockingActionAddDockableEvent(event.getDesktop(), dragged, initialLocation, nextLocation, this));
        if (drop) {
            this.acceptDrop(event);
        } else {
            Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, 0.0f, compBounds.width, compBounds.height);
            ((DockDragEvent)event).acceptDrag(r2d);
        }
    }

    public CompoundDockable getDockable() {
        return this.dockable;
    }
}

