/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.toolbars;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.SwingConstants;


/** The toolbar panel is able to receive multiple toolbars and arrange them in
 * many columns or rows (depending on the horizontal/vertical orientation).
 *
 * <p align="center"><img src="doc-files/overview.gif"><br>
 *  The ToolBarPanel is a JPanel with a ToolBarPanelLayout. It support horizontal and vertical orientation,
 *  and can contain one or more VLToolbars (with given ToolBarContraints for positionning).
 * </p>
 * @author Lilian Chamontin, VLSolutions
 * @update 2006/09/09 Support for LTR and RTL component orientation
 */
public class ToolBarPanel extends JPanel {
  
  private int orientation = SwingConstants.HORIZONTAL;

  /** an optionnal background painter  */
  private BackgroundPainter painter; 
  
  /**
   * Constructs a new toobar panel with a LEADING alignment.
   */
  public ToolBarPanel() {
    this(FlowLayout.LEADING);
  }
  

  /**
   * Constructs a new <code>ToolBarPanel</code> with the specified
   * alignment.
   * @param align the alignment value
   *    The value of the alignment argument must be one of
   *    <code>FlowLayout.LEFT</code>, <code>FlowLayout.RIGHT</code>,
   *    <code>FlowLayout.CENTER</code>, <code>FlowLayout.LEADING</code>, or
   *    <code>FlowLayout.TRAILING</code>.
   * 
   */
  public ToolBarPanel(int align) {
    this(align, null);
  }
  
  /**
   * Constructs a new <code>ToolBarPanel</code> with the specified
   * alignment and background painter.
   * @param align the alignment value
   *    The value of the alignment argument must be one of
   *    <code>FlowLayout.LEFT</code>, <code>FlowLayout.RIGHT</code>,
   *    <code>FlowLayout.CENTER</code>, <code>FlowLayout.LEADING</code>, or
   *    <code>FlowLayout.TRAILING</code>.
   * @param painter  the background painter.
   * @since 2.1.4
   */
  public ToolBarPanel(int align, BackgroundPainter painter) {
    setLayout(new ToolBarPanelLayout(this, align));
    this.painter = painter;
  }
  
  
  
  /** Adds a new toolbar respecting the given positionning constraints.
   */
  public void add(JToolBar toolbar){
    add(toolbar, 0);
    setVisible(true);
  }
  
  
  /** Adds a new JToolBar to the Panel at the given row. Multiple VLToolBars
   * are constructed using Separators in the original JToolBar
   */
  public void add(JToolBar toolbar, int major){
    toolbar.setOrientation(orientation);
    VLToolBar[] bars = getVLToolBarsFromJToolBar(toolbar);
    for (int i = 0; i < bars.length; i++) {
      ToolBarConstraints toolBarConstraints = new ToolBarConstraints(major, i);
      add(bars[i], toolBarConstraints) ;
    }
  }
  
  /**
   * Helper function to convert a JToolBar into multiple VLToolBar objects. The JToolBar
   * is split at the separator boundary to create VLToolbars
   * @param bar, the JToolBar object
   * @return array of VLToolBar objects
   */
  private VLToolBar[] getVLToolBarsFromJToolBar(JToolBar bar) {
    ArrayList vlBars = new ArrayList();
    Component[] components = bar.getComponents();
    VLToolBar current = new VLToolBar();
    for (int i = 0; i < components.length; i++) {
      if (components[i] instanceof JButton) {
        JButton button = (JButton) components[i];
        if (button.getIcon() != null)
          button.setText(null);
        current.add(button);
      } else if (components[i] instanceof Separator) {
        vlBars.add(current);
        current = new VLToolBar();
      } else {
        System.err.println("Don't know how to handle this component " + components[i].getClass());
      }
    }
    vlBars.add(current);
    return (VLToolBar[]) vlBars.toArray(new VLToolBar[vlBars.size()]);
  }
  
  
  /** Adds a new toolbar respecting the given positionning constraints.
   */
  public void add(VLToolBar toolbar, ToolBarConstraints constraints){
    toolbar.setOrientation(orientation);
    super.add(toolbar, constraints);
    setVisible(true);
  }
  
  public void remove(Component comp){
    super.remove(comp);
    if (getComponentCount() == 0){
      setVisible(false);
    }
  }
  
  /* Updates the orientation of this toolbar. Valid values are SwingConstants.HORIZONTAL and VERTICAL*/
  public void setOrientation(int orientation){
    if (this.orientation != orientation){
      this.orientation = orientation;
      updateOrientation();
      revalidate();
    }
  }
  
  /** Returns the orientation of this toolbarpanel */
  public int getOrientation(){
    return this.orientation;
  }
  
  
  /** Propagates the orientation to the contained toolbars */
  private void updateOrientation(){
    for (int i=0; i < getComponentCount(); i++){
      VLToolBar tb = (VLToolBar) getComponent(i);
      tb.setOrientation(orientation);
    }
  }
  
  /** Overriden for optional background painting */
  public void paintComponent(Graphics g){
    if (painter != null){
      painter.paintBackground(this, g);
    }
    super.paintComponent(g);
  }

  /** Returns the optional background painter for this toolbar panel (may be null) 
   *@since 2.1.4
   */
  public BackgroundPainter getBackgroundPainter() {
    return painter;
  }

  /** Updates the optional background painter for this toolbar panel
   * @param painter the new painer (may be null)
   * @since 2.1.4
   */
  public void setPainter(BackgroundPainter painter) {
    this.painter = painter;
  }
  
}
