/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import com.vlsolutions.swing.docking.event.DockingActionCreateTabEvent;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;


/** A DockView suitable for detached dockables (in their own window).
 *
 * @see DockView
 *
 * @author Lilian Chamontin, VLSolutions
 * @since 2.0
 */
public class DetachedDockView extends DockView {
  
  private static final String uiClassID = "DetachedDockViewUI";
  
  public DetachedDockView(Dockable dockable) {
    super(dockable);
  }
  
   /** {@inheritDoc}
   * @since 2.0
   */
  public String getUIClassID() {
    return uiClassID;
  }
  
  /* common method for drag && drop, overriden from DockView to only allow tabbed drops */
  protected void scanDrop(DockEvent event, boolean drop){
    if (getParent() instanceof TabbedDockableContainer){
        // cannot nest DockTabbedPanes
        if (drop){
          ((DockDropEvent) event).rejectDrop();
        } else {
          ((DockDragEvent) event).delegateDrag();
        }
        return;
    }

    if (event.getDragSource().getDockable() == dockable) {
      // cannot drop onto itself
      if (drop){
        ((DockDropEvent) event).rejectDrop();
      } else {
        ((DockDragEvent) event).rejectDrag();
      }
      return;
    }
    
    

    // The dockview isn't contained inside a tabbedpane, 
    // there is only one possible option : to create an tab
    
    if (event.getDragSource().getDockableContainer() instanceof TabbedDockableContainer) {
      // but you cannot drop a whole tab container into a detached view
      if (drop){
        ((DockDropEvent) event).rejectDrop();
      } else {
        ((DockDragEvent) event).rejectDrag();
      }
      return;
    }
    
    Rectangle bounds = getBounds();

    // not on the borders : we should create a new tab
    // reject if key groups aren't compatible
    DockGroup thisGroup = dockable.getDockKey().getDockGroup();
    DockGroup dragGroup = event.getDragSource().getDockable().getDockKey().getDockGroup();
    if (!DockGroup.areGroupsCompatible( thisGroup, dragGroup)){
      if (drop){
        ((DockDropEvent) event).rejectDrop();
      } else {
        ((DockDragEvent) event).rejectDrag();
      }
      return;
    }
    
    Dockable d = event.getDragSource().getDockable();
    int dockableState = d.getDockKey().getDockableState();
    int viewState = dockable.getDockKey().getDockableState();
    
    if (drop){
      event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(),
            d, dockableState, viewState, dockable, 0));
      ((DockDropEvent) event).acceptDrop(false); // don't remove the floatable : we have to find it's current position
      desktop.createTab(dockable, event.getDragSource().getDockable(), 0, true);
    } else {
      Rectangle2D r2d = new Rectangle2D.Float(bounds.x, bounds.y,
          bounds.width,
          bounds.height);
      event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(),
            d, dockableState, viewState, dockable, 0));
      if (r2d.equals(lastDropShape)) {
        // optimized shape caching
        ( (DockDragEvent) event).acceptDrag(lastDropGeneralPath);
      } else {
        // draw a 'tabbed pane shape'
        GeneralPath path = buildPathForTab(bounds);;
        
        lastDropShape = r2d;
        lastDropGeneralPath = path;
        ( (DockDragEvent) event).acceptDrag(lastDropGeneralPath);
      }
    }    
  
  }
  
  /** {@inheritDoc}
   */
  public String toString(){
     return "DetachedDockView of " + dockable.getDockKey();
  }
  
}
