#!/bin/sh
#
# Copyright (C) 2005 Jean-Yves Lefort
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

thread_re="Thread .* has exited with leftover"

fatal() {
    echo "$1"
    exit 1
}

test_translate () {
    echo "translating \"$4\" from \"$2\" to \"$3\" using \"$1\""
    translation=`echo "$4" | ./translate -s $1 -f $2 -t $3 | grep -v "$thread_re"` \
	|| fatal "FAILED"
    [ "x$translation" = "x$5" ] || fatal "FAILED (expected \"$5\", got \"$translation\")"
    echo "PASSED"
}

# test all services separately, and test UTF-8 input/output
test_translate babelfish fr it "Cet été sera chaud." "Quest'estate sarà calda."
test_translate systran fr it "Cet été sera chaud." "Quest'estate sarà calda."
test_translate google fr de "Cet été sera chaud." "Dieser Sommer wird heiß sein."
test_translate freetranslation fr en "Cet été sera chaud." "This summer will be hot.  "
test_translate freetranslation en fr "This summer will be hot." "Cet été aura chaud. "
test_translate worldlingo fr it "Cet été sera chaud." "Quest'estate sarà calda."
test_translate 1800translate fr it "Cet été sera chaud." "Questa estate sarà calda."
test_translate tsunami fr it "Cet été sera chaud." "Quest'estate sarà calda."
test_translate kataku en id "This été will be hot." "Ini été akan panas."
test_translate papiamentu en pap "This été will be hot." "esaki été ta wòrdu kayente."

# test the translation of a multi-chunk text using Babel Fish
echo "translating sample-text.input from \"en\" to \"fr\" using \"babelfish\""
./translate sample-text.input -s babelfish -f en -t fr | grep -v "$thread_re" > sample-text.output || fatal "FAILED"
diff sample-text.expected sample-text.output || fatal "FAILED"
echo "PASSED"
rm -f sample-text.output
