[comment {-*- tcl -*- doctools}]
[vset FORMATNAME bmp]
[vset FORMATFULLNAME {Windows Bitmap Format}]

[include format-header.inc]

This handler provides new additional configuration options. See
section [sectref {BMP OPTIONS}] for more detailed explanations.


[include format-middle.inc]


In addition the value for the option is treated as list and may
contain any of the special options listed in section

[sectref {BMP OPTIONS}].

[list_end]



[section {BMP OPTIONS}]

The handler provides an option to influence the writing of a BMP image.

[list_begin definitions]

[lst_item "[option -resolution] [arg res]"]

The display resulation and/or aspect ratio property of the outputted bmp
file may be set using this option.
The default values are an x and y resolution of 74 dpi.

[arg res] is a list of 2 or 3 elements and may have one of the following formats.
The values [arg xres], [arg yres] and [arg unit] are specified after the formats.

[list_begin definitions]

[lst_item "[arg res] = [arg xres] [arg unit]"]

Set the same resolution for x and y.

Example: Write image with a resolution of 300dpi:
[example_begin]
img write out.bmp -format {bmp -resolution {300 i}}
[example_end]

[lst_item "[arg res] = [arg xres] [arg yres]"]

Set the aspect ratio only.
The x resolution remains to the default value 74dpi, as the bmp format does not allow to specify the aspect ratio only. The y resolution is set to 74*[arg yres]/[arg xres].

Example: Write image with an aspect ratio of 1/3:
[example_begin]
img write out.bmp -format {bmp -resolution {1 3}}
[example_end]

[lst_item "[arg res] = [arg xres] [arg yres] [arg unit]"]

Set an independent resolution for x and y direction.

Example: Write image with a resolution of x=300dpi and y=150dpi:
[example_begin]
img write out.bmp -format {bmp -resolution {300 100 i}}
[example_end]

[list_end]


The used parameters are:

[list_begin arg]

[arg_def float xres input]

The output resolution in x direction as a float number.

[arg_def float yres input]

The output resolution in x direction as a float number.

[arg_def string unit input]

Unit of the given resolution numbers similar to Tk_GetPixel.
Possible units are:

[list_begin definitions]

[lst_item "c"]
pixel per centimeter.
[lst_item "m"]
pixel per meter.
[lst_item "i"]
pixel per inch.
[lst_item "p"]
pixel per inch/72 (Printer points).

[list_end]

[list_end]

[list_end]

[list_begin definitions]
[include format-footer.inc]
