/*
 * $Id: StringUtilsTest.java,v 1.1 2007-03-02 19:45:53 larry Exp $ 
 */
package com.representqueens.util;

/*
 * 
 * Copyright 2007 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

/**
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.1 $ $Date: 2007-03-02 19:45:53 $
 */
public class StringUtilsTest extends TestCase
{

  /**
   * Test method for {@link com.representqueens.util.StringUtils#toString(java.util.List)}.
   */
  public void testToStringListOfInteger()
  {
    final List<Integer> data = new ArrayList<Integer>();
    
    assertEquals("", StringUtils.toString(data));
    
    data.add(5);
    assertEquals("5", StringUtils.toString(data));
    
    data.add(6);
    assertEquals("5,6", StringUtils.toString(data));
    
    data.add(7);
    assertEquals("5,6,7", StringUtils.toString(data));    
  }

}
