/****************************************************************************
 * NCSA HDF                                                                 *
 * National Comptational Science Alliance                                   *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 *                                                                          *
 * For conditions of distribution and use, see the accompanying             *
 * hdf-java/COPYING file.                                                   *
 *                                                                          *
 ****************************************************************************/

package ch.systemsx.cisd.hdf5.hdf5lib;

/**
 * /** This class contains C constants and enumerated types of HDF5 library. The values of these constants are obtained
 * from the library by calling J2C(int jconstant), where jconstant is any of the private constants which start their
 * name with "JH5" need to be converted.
 * <P>
 * <B>Do not edit this file!</b> <b>See also:</b> ncsa.hdf.hdf5lib.HDF5Library
 * <p>
 * <b>This is an internal API that should not be expected to be stable between releases!</b>
 */
public class HDF5Constants
{
    // /////////////////////////////////////////////////////////////////////////
    // This list must be identical to H5Constants.h //
    // DO NOT EDIT THE LIST !!! //
    // /////////////////////////////////////////////////////////////////////////

    final private static int JH5_SZIP_MAX_PIXELS_PER_BLOCK = 1000;

    final private static int JH5_SZIP_NN_OPTION_MASK = 1010;

    final private static int JH5_SZIP_EC_OPTION_MASK = 1020;

    final private static int JH5_SZIP_ALLOW_K13_OPTION_MASK = 1021;

    final private static int JH5_SZIP_CHIP_OPTION_MASK = 1022;

    final private static int JH5D_ALLOC_TIME_DEFAULT = 1030;

    final private static int JH5D_ALLOC_TIME_EARLY = 1040;

    final private static int JH5D_ALLOC_TIME_ERROR = 1050;

    final private static int JH5D_ALLOC_TIME_INCR = 1060;

    final private static int JH5D_ALLOC_TIME_LATE = 1070;

    final private static int JH5D_CHUNKED = 1080;

    final private static int JH5D_COMPACT = 1090;

    final private static int JH5D_CONTIGUOUS = 1100;

    final private static int JH5D_FILL_TIME_ALLOC = 1110;

    final private static int JH5D_FILL_TIME_ERROR = 1120;

    final private static int JH5D_FILL_TIME_NEVER = 1130;

    final private static int JH5D_FILL_VALUE_DEFAULT = 1140;

    final private static int JH5D_FILL_VALUE_ERROR = 1150;

    final private static int JH5D_FILL_VALUE_UNDEFINED = 1160;

    final private static int JH5D_FILL_VALUE_USER_DEFINED = 1170;

    final private static int JH5D_LAYOUT_ERROR = 1180;

    final private static int JH5D_NLAYOUTS = 1190;

    final private static int JH5D_SPACE_STATUS_ALLOCATED = 1200;

    final private static int JH5D_SPACE_STATUS_ERROR = 1210;

    final private static int JH5D_SPACE_STATUS_NOT_ALLOCATED = 1220;

    final private static int JH5D_SPACE_STATUS_PART_ALLOCATED = 1230;

    final private static int JH5E_ALIGNMENT = 1240;

    final private static int JH5E_ALREADYEXISTS = 1250;

    final private static int JH5E_ALREADYINIT = 1260;

    final private static int JH5E_ARGS = 1270;

    final private static int JH5E_ATOM = 1280;

    final private static int JH5E_ATTR = 1290;

    final private static int JH5E_BADATOM = 1300;

    final private static int JH5E_BADFILE = 1310;

    final private static int JH5E_BADGROUP = 1320;

    final private static int JH5E_BADMESG = 1330;

    final private static int JH5E_BADRANGE = 1340;

    final private static int JH5E_BADSELECT = 1350;

    final private static int JH5E_BADSIZE = 1360;

    final private static int JH5E_BADTYPE = 1370;

    final private static int JH5E_BADVALUE = 1380;

    final private static int JH5E_BTREE = 1390;

    final private static int JH5E_CACHE = 1400;

    final private static int JH5E_CALLBACK = 1410;

    final private static int JH5E_CANAPPLY = 1420;

    final private static int JH5E_CANTCLIP = 1450;

    final private static int JH5E_CANTCLOSEFILE = 1460;

    final private static int JH5E_CANTCONVERT = 1470;

    final private static int JH5E_CANTCOPY = 1480;

    final private static int JH5E_CANTCOUNT = 1490;

    final private static int JH5E_CANTCREATE = 1500;

    final private static int JH5E_CANTDEC = 1510;

    final private static int JH5E_CANTDECODE = 1520;

    final private static int JH5E_CANTDELETE = 1530;

    final private static int JH5E_CANTENCODE = 1540;

    final private static int JH5E_CANTFLUSH = 1550;

    final private static int JH5E_CANTFREE = 1560;

    final private static int JH5E_CANTGET = 1570;

    final private static int JH5E_CANTINC = 1580;

    final private static int JH5E_CANTINIT = 1590;

    final private static int JH5E_CANTINSERT = 1600;

    final private static int JH5E_CANTLIST = 1610;

    final private static int JH5E_CANTLOAD = 1620;

    final private static int JH5E_CANTLOCK = 1630;

    final private static int JH5E_CANTNEXT = 1650;

    final private static int JH5E_CANTOPENFILE = 1660;

    final private static int JH5E_CANTOPENOBJ = 1670;

    final private static int JH5E_CANTREGISTER = 1690;

    final private static int JH5E_CANTRELEASE = 1700;

    final private static int JH5E_CANTSELECT = 1710;

    final private static int JH5E_CANTSET = 1730;

    final private static int JH5E_CANTSPLIT = 1740;

    final private static int JH5E_CANTUNLOCK = 1750;

    final private static int JH5E_CLOSEERROR = 1760;

    final private static int JH5E_COMPLEN = 1770;

    final private static int JH5E_DATASET = 1790;

    final private static int JH5E_DATASPACE = 1800;

    final private static int JH5E_DATATYPE = 1810;

    final private static int JH5E_DUPCLASS = 1820;

    final private static int JH5E_EFL = 1830;

    final private static int JH5E_EXISTS = 1840;

    final private static int JH5E_FCNTL = 1850;

    final private static int JH5E_FILE = 1860;

    final private static int JH5E_FILEEXISTS = 1870;

    final private static int JH5E_FILEOPEN = 1880;

    final private static int JH5E_FUNC = 1900;

    final private static int JH5E_HEAP = 1910;

    final private static int JH5E_INTERNAL = 1920;

    final private static int JH5E_IO = 1930;

    final private static int JH5E_LINK = 1940;

    final private static int JH5E_LINKCOUNT = 1950;

    final private static int JH5E_MOUNT = 1960;

    final private static int JH5E_MPI = 1970;

    final private static int JH5E_MPIERRSTR = 1980;

    final private static int JH5E_NOFILTER = 1990;

    final private static int JH5E_NOIDS = 2000;

    final private static int JH5E_NONE_MAJOR = 2010;

    final private static int JH5E_NONE_MINOR = 2020;

    final private static int JH5E_NOSPACE = 2030;

    final private static int JH5E_NOTCACHED = 2040;

    final private static int JH5E_NOTFOUND = 2050;

    final private static int JH5E_NOTHDF5 = 2060;

    final private static int JH5E_OHDR = 2070;

    final private static int JH5E_OVERFLOW = 2080;

    final private static int JH5E_PLINE = 2090;

    final private static int JH5E_PLIST = 2100;

    final private static int JH5E_PROTECT = 2110;

    final private static int JH5E_READERROR = 2120;

    final private static int JH5E_REFERENCE = 2130;

    final private static int JH5E_RESOURCE = 2140;

    final private static int JH5E_RS = 2150;

    final private static int JH5E_SEEKERROR = 2160;

    final private static int JH5E_SETLOCAL = 2170;

    final private static int JH5E_STORAGE = 2190;

    final private static int JH5E_SYM = 2200;

    final private static int JH5E_TRUNCATED = 2220;

    final private static int JH5E_TST = 2230;

    final private static int JH5E_UNINITIALIZED = 2240;

    final private static int JH5E_UNSUPPORTED = 2250;

    final private static int JH5E_VERSION = 2260;

    final private static int JH5E_VFL = 2270;

    final private static int JH5E_WALK_DOWNWARD = 2280;

    final private static int JH5E_WALK_UPWARD = 2290;

    final private static int JH5E_WRITEERROR = 2300;

    final private static int JH5F_ACC_CREAT = 2310;

    final private static int JH5F_ACC_DEBUG = 2320;

    final private static int JH5F_ACC_EXCL = 2330;

    final private static int JH5F_ACC_RDONLY = 2340;

    final private static int JH5F_ACC_RDWR = 2350;

    final private static int JH5F_ACC_TRUNC = 2360;

    final private static int JH5F_CLOSE_DEFAULT = 2370;

    final private static int JH5F_CLOSE_SEMI = 2380;

    final private static int JH5F_CLOSE_STRONG = 2390;

    final private static int JH5F_CLOSE_WEAK = 2400;

    final private static int JH5F_OBJ_ALL = 2410;

    final private static int JH5F_OBJ_ATTR = 2415;

    final private static int JH5F_OBJ_DATASET = 2420;

    final private static int JH5F_OBJ_DATATYPE = 2430;

    final private static int JH5F_OBJ_FILE = 2440;

    final private static int JH5F_OBJ_GROUP = 2450;

    final private static int JH5F_SCOPE_GLOBAL = 2470;

    final private static int JH5F_SCOPE_LOCAL = 2480;

    final private static int JH5F_UNLIMITED = 2490;

    final private static int JH5F_LIBVER_EARLIEST = 2494;

    final private static int JH5F_LIBVER_LATEST = 2495;

    final private static int JH5G_DATASET = 2500;

    final private static int JH5G_GROUP = 2510;

    final private static int JH5G_LINK = 2520;

    final private static int JH5G_LINK_ERROR = 2530;

    final private static int JH5G_LINK_HARD = 2540;

    final private static int JH5G_LINK_SOFT = 2550;

    final private static int JH5G_NLIBTYPES = 2560;

    final private static int JH5G_NTYPES = 2570;

    final private static int JH5G_NUSERTYPES = 2580;

    final private static int JH5G_RESERVED_5 = 2600;

    final private static int JH5G_RESERVED_6 = 2610;

    final private static int JH5G_RESERVED_7 = 2620;

    final private static int JH5G_SAME_LOC = 2630;

    final private static int JH5G_TYPE = 2640;

    final private static int JH5G_UNKNOWN = 2650;

    final private static int JH5I_ATTR = 2670;

    final private static int JH5I_BADID = 2680;

    final private static int JH5I_DATASET = 2690;

    final private static int JH5I_DATASPACE = 2700;

    final private static int JH5I_DATATYPE = 2710;

    final private static int JH5I_FILE = 2720;

    final private static int JH5I_GENPROP_CLS = 2740;

    final private static int JH5I_GENPROP_LST = 2750;

    final private static int JH5I_GROUP = 2760;

    final private static int JH5I_INVALID_HID = 2770;

    final private static int JH5I_REFERENCE = 2790;

    final private static int JH5I_VFL = 2810;

    final private static int JH5O_TYPE_UNKNOWN = 5510;

    final private static int JH5O_TYPE_GROUP = 5520;

    final private static int JH5O_TYPE_DATASET = 5530;

    final private static int JH5O_TYPE_NAMED_DATATYPE = 5540;

    final private static int JH5O_TYPE_NTYPES = 5550;

    final private static int JH5L_TYPE_ERROR = 5560;

    final private static int JH5L_TYPE_HARD = 5570;

    final private static int JH5L_TYPE_SOFT = 5580;

    final private static int JH5L_TYPE_EXTERNAL = 5590;

    final private static int JH5L_TYPE_MAX = 5600;

    final private static int JH5P_DATASET_CREATE = 2820;

    final private static int JH5P_DATASET_CREATE_DEFAULT = 2830;

    final private static int JH5P_DATASET_XFER = 2840;

    final private static int JH5P_DATASET_XFER_DEFAULT = 2850;

    final private static int JH5P_DEFAULT = 2860;

    final private static int JH5P_FILE_ACCESS = 2870;

    final private static int JH5P_FILE_ACCESS_DEFAULT = 2880;

    final private static int JH5P_FILE_CREATE = 2890;

    final private static int JH5P_FILE_CREATE_DEFAULT = 2900;

    final private static int JH5P_NO_CLASS = 2930;

    final private static int JH5P_ROOT = 6000;
    
    final private static int JH5P_OBJECT_CREATE = 6010;
    
    final private static int JH5P_DATASET_ACCESS = 6020;
    
    final private static int JH5P_DATASET_ACCESS_DEFAULT = 6030;
    
    final private static int JH5P_FILE_MOUNT = 6040;
    
    final private static int JH5P_FILE_MOUNT_DEFAULT = 6050;
    
    final private static int JH5P_GROUP_CREATE = 6060;
    
    final private static int JH5P_GROUP_CREATE_DEFAULT = 6070;
    
    final private static int JH5P_GROUP_ACCESS = 6080;
    
    final private static int JH5P_GROUP_ACCESS_DEFAULT = 6090;
    
    final private static int JH5P_DATATYPE_CREATE = 6100;
    
    final private static int JH5P_DATATYPE_CREATE_DEFAULT = 6110;
    
    final private static int JH5P_DATATYPE_ACCESS = 6120;
    
    final private static int JH5P_DATATYPE_ACCESS_DEFAULT = 6130;
    
    final private static int JH5P_STRING_CREATE = 6140;
    
    final private static int JH5P_ATTRIBUTE_CREATE = 6150;
    
    final private static int JH5P_ATTRIBUTE_CREATE_DEFAULT = 6160;
    
    final private static int JH5P_OBJECT_COPY = 6170;
    
    final private static int JH5P_OBJECT_COPY_DEFAULT = 6180;
    
    final private static int JH5P_LINK_CREATE = 6190;
    
    final private static int JH5P_LINK_CREATE_DEFAULT = 6200;
    
    final private static int JH5P_LINK_ACCESS = 6210;
    
    final private static int JH5P_LINK_ACCESS_DEFAULT = 6220;
    
    final private static int JH5R_BADTYPE = 2950;

    final private static int JH5R_DATASET_REGION = 2960;

    final private static int JH5R_MAXTYPE = 2980;

    final private static int JH5R_OBJ_REF_BUF_SIZE = 2990;

    final private static int JH5R_OBJECT = 3000;

    final private static int JH5S_ALL = 3010;

    final private static int JH5S_MAX_RANK = 3030;

    final private static int JH5S_NO_CLASS = 3040;

    final private static int JH5S_SCALAR = 3050;

    final private static int JH5S_SEL_ALL = 3060;

    final private static int JH5S_SEL_ERROR = 3070;

    final private static int JH5S_SEL_HYPERSLABS = 3080;

    final private static int JH5S_SEL_N = 3090;

    final private static int JH5S_SEL_NONE = 3100;

    final private static int JH5S_SEL_POINTS = 3110;

    final private static int JH5S_SELECT_AND = 3120;

    final private static int JH5S_SELECT_APPEND = 3130;

    final private static int JH5S_SELECT_INVALID = 3140;

    final private static int JH5S_SELECT_NOOP = 3150;

    final private static int JH5S_SELECT_NOTA = 3160;

    final private static int JH5S_SELECT_NOTB = 3170;

    final private static int JH5S_SELECT_OR = 3180;

    final private static int JH5S_SELECT_PREPEND = 3190;

    final private static int JH5S_SELECT_SET = 3200;

    final private static int JH5S_SELECT_XOR = 3210;

    final private static int JH5S_SIMPLE = 3220;

    final private static int JH5S_UNLIMITED = 3230;

    final private static int JH5T_ALPHA_B16 = 3240;

    final private static int JH5T_ALPHA_B32 = 3250;

    final private static int JH5T_ALPHA_B64 = 3260;

    final private static int JH5T_ALPHA_B8 = 3270;

    final private static int JH5T_ALPHA_F32 = 3280;

    final private static int JH5T_ALPHA_F64 = 3290;

    final private static int JH5T_ALPHA_I16 = 3300;

    final private static int JH5T_ALPHA_I32 = 3310;

    final private static int JH5T_ALPHA_I64 = 3320;

    final private static int JH5T_ALPHA_I8 = 3330;

    final private static int JH5T_ALPHA_U16 = 3340;

    final private static int JH5T_ALPHA_U32 = 3350;

    final private static int JH5T_ALPHA_U64 = 3360;

    final private static int JH5T_ALPHA_U8 = 3370;

    final private static int JH5T_ARRAY = 3380;

    final private static int JH5T_BITFIELD = 3390;

    final private static int JH5T_BKG_NO = 3400;

    final private static int JH5T_BKG_YES = 3410;

    final private static int JH5T_C_S1 = 3420;

    final private static int JH5T_COMPOUND = 3430;

    final private static int JH5T_CONV_CONV = 3440;

    final private static int JH5T_CONV_FREE = 3450;

    final private static int JH5T_CONV_INIT = 3460;

    final private static int JH5T_CSET_ASCII = 3470;

    final private static int JH5T_CSET_ERROR = 3480;
    
    final private static int JH5T_CSET_UTF8 = 3490;

    final private static int JH5T_CSET_RESERVED_10 = 3500;

    final private static int JH5T_CSET_RESERVED_11 = 3510;

    final private static int JH5T_CSET_RESERVED_12 = 3520;

    final private static int JH5T_CSET_RESERVED_13 = 3530;

    final private static int JH5T_CSET_RESERVED_14 = 3540;

    final private static int JH5T_CSET_RESERVED_15 = 3550;

    final private static int JH5T_CSET_RESERVED_2 = 3560;

    final private static int JH5T_CSET_RESERVED_3 = 3570;

    final private static int JH5T_CSET_RESERVED_4 = 3580;

    final private static int JH5T_CSET_RESERVED_5 = 3590;

    final private static int JH5T_CSET_RESERVED_6 = 3600;

    final private static int JH5T_CSET_RESERVED_7 = 3610;

    final private static int JH5T_CSET_RESERVED_8 = 3620;

    final private static int JH5T_CSET_RESERVED_9 = 3630;

    final private static int JH5T_DIR_ASCEND = 3640;

    final private static int JH5T_DIR_DEFAULT = 3650;

    final private static int JH5T_DIR_DESCEND = 3660;

    final private static int JH5T_ENUM = 3670;

    final private static int JH5T_FLOAT = 3680;

    final private static int JH5T_FORTRAN_S1 = 3690;

    final private static int JH5T_IEEE_F32BE = 3700;

    final private static int JH5T_IEEE_F32LE = 3710;

    final private static int JH5T_IEEE_F64BE = 3720;

    final private static int JH5T_IEEE_F64LE = 3730;

    final private static int JH5T_INTEGER = 3740;

    final private static int JH5T_INTEL_B16 = 3750;

    final private static int JH5T_INTEL_B32 = 3760;

    final private static int JH5T_INTEL_B64 = 3770;

    final private static int JH5T_INTEL_B8 = 3780;

    final private static int JH5T_INTEL_F32 = 3790;

    final private static int JH5T_INTEL_F64 = 3800;

    final private static int JH5T_INTEL_I16 = 3810;

    final private static int JH5T_INTEL_I32 = 3820;

    final private static int JH5T_INTEL_I64 = 3830;

    final private static int JH5T_INTEL_I8 = 3840;

    final private static int JH5T_INTEL_U16 = 3850;

    final private static int JH5T_INTEL_U32 = 3860;

    final private static int JH5T_INTEL_U64 = 3870;

    final private static int JH5T_INTEL_U8 = 3880;

    final private static int JH5T_MIPS_B16 = 3890;

    final private static int JH5T_MIPS_B32 = 3900;

    final private static int JH5T_MIPS_B64 = 3910;

    final private static int JH5T_MIPS_B8 = 3920;

    final private static int JH5T_MIPS_F32 = 3930;

    final private static int JH5T_MIPS_F64 = 3940;

    final private static int JH5T_MIPS_I16 = 3950;

    final private static int JH5T_MIPS_I32 = 3960;

    final private static int JH5T_MIPS_I64 = 3970;

    final private static int JH5T_MIPS_I8 = 3980;

    final private static int JH5T_MIPS_U16 = 3990;

    final private static int JH5T_MIPS_U32 = 4000;

    final private static int JH5T_MIPS_U64 = 4010;

    final private static int JH5T_MIPS_U8 = 4020;

    final private static int JH5T_NATIVE_B16 = 4030;

    final private static int JH5T_NATIVE_B32 = 4040;

    final private static int JH5T_NATIVE_B64 = 4050;

    final private static int JH5T_NATIVE_B8 = 4060;

    final private static int JH5T_NATIVE_CHAR = 4070;

    final private static int JH5T_NATIVE_DOUBLE = 4080;

    final private static int JH5T_NATIVE_FLOAT = 4090;

    final private static int JH5T_NATIVE_HADDR = 4100;

    final private static int JH5T_NATIVE_HBOOL = 4110;

    final private static int JH5T_NATIVE_HERR = 4120;

    final private static int JH5T_NATIVE_HSIZE = 4130;

    final private static int JH5T_NATIVE_HSSIZE = 4140;

    final private static int JH5T_NATIVE_INT = 4150;

    final private static int JH5T_NATIVE_INT_FAST16 = 4160;

    final private static int JH5T_NATIVE_INT_FAST32 = 4170;

    final private static int JH5T_NATIVE_INT_FAST64 = 4180;

    final private static int JH5T_NATIVE_INT_FAST8 = 4190;

    final private static int JH5T_NATIVE_INT_LEAST16 = 4200;

    final private static int JH5T_NATIVE_INT_LEAST32 = 4210;

    final private static int JH5T_NATIVE_INT_LEAST64 = 4220;

    final private static int JH5T_NATIVE_INT_LEAST8 = 4230;

    final private static int JH5T_NATIVE_INT16 = 4240;

    final private static int JH5T_NATIVE_INT32 = 4250;

    final private static int JH5T_NATIVE_INT64 = 4260;

    final private static int JH5T_NATIVE_INT8 = 4270;

    final private static int JH5T_NATIVE_LDOUBLE = 4280;

    final private static int JH5T_NATIVE_LLONG = 4290;

    final private static int JH5T_NATIVE_LONG = 4300;

    final private static int JH5T_NATIVE_OPAQUE = 4310;

    final private static int JH5T_NATIVE_SCHAR = 4320;

    final private static int JH5T_NATIVE_SHORT = 4330;

    final private static int JH5T_NATIVE_UCHAR = 4340;

    final private static int JH5T_NATIVE_UINT = 4350;

    final private static int JH5T_NATIVE_UINT_FAST16 = 4360;

    final private static int JH5T_NATIVE_UINT_FAST32 = 4370;

    final private static int JH5T_NATIVE_UINT_FAST64 = 4380;

    final private static int JH5T_NATIVE_UINT_FAST8 = 4390;

    final private static int JH5T_NATIVE_UINT_LEAST16 = 4400;

    final private static int JH5T_NATIVE_UINT_LEAST32 = 4410;

    final private static int JH5T_NATIVE_UINT_LEAST64 = 4420;

    final private static int JH5T_NATIVE_UINT_LEAST8 = 4430;

    final private static int JH5T_NATIVE_UINT16 = 4440;

    final private static int JH5T_NATIVE_UINT32 = 4450;

    final private static int JH5T_NATIVE_UINT64 = 4460;

    final private static int JH5T_NATIVE_UINT8 = 4470;

    final private static int JH5T_NATIVE_ULLONG = 4480;

    final private static int JH5T_NATIVE_ULONG = 4490;

    final private static int JH5T_NATIVE_USHORT = 4500;

    final private static int JH5T_NCLASSES = 4510;

    final private static int JH5T_NO_CLASS = 4520;

    final private static int JH5T_NORM_ERROR = 4530;

    final private static int JH5T_NORM_IMPLIED = 4540;

    final private static int JH5T_NORM_MSBSET = 4550;

    final private static int JH5T_NORM_NONE = 4560;

    final private static int JH5T_NPAD = 4570;

    final private static int JH5T_NSGN = 4580;

    final private static int JH5T_OPAQUE = 4590;

    final private static int JH5T_OPAQUE_TAG_MAX = 4595; /* 1.6.5 */

    final private static int JH5T_ORDER_BE = 4600;

    final private static int JH5T_ORDER_ERROR = 4610;

    final private static int JH5T_ORDER_LE = 4620;

    final private static int JH5T_ORDER_NONE = 4630;

    final private static int JH5T_ORDER_VAX = 4640;

    final private static int JH5T_PAD_BACKGROUND = 4650;

    final private static int JH5T_PAD_ERROR = 4660;

    final private static int JH5T_PAD_ONE = 4670;

    final private static int JH5T_PAD_ZERO = 4680;

    final private static int JH5T_PERS_DONTCARE = 4690;

    final private static int JH5T_PERS_HARD = 4700;

    final private static int JH5T_PERS_SOFT = 4710;

    final private static int JH5T_REFERENCE = 4720;

    final private static int JH5T_SGN_2 = 4730;

    final private static int JH5T_SGN_ERROR = 4740;

    final private static int JH5T_SGN_NONE = 4750;

    final private static int JH5T_STD_B16BE = 4760;

    final private static int JH5T_STD_B16LE = 4770;

    final private static int JH5T_STD_B32BE = 4780;

    final private static int JH5T_STD_B32LE = 4790;

    final private static int JH5T_STD_B64BE = 4800;

    final private static int JH5T_STD_B64LE = 4810;

    final private static int JH5T_STD_B8BE = 4820;

    final private static int JH5T_STD_B8LE = 4830;

    final private static int JH5T_STD_I16BE = 4840;

    final private static int JH5T_STD_I16LE = 4850;

    final private static int JH5T_STD_I32BE = 4860;

    final private static int JH5T_STD_I32LE = 4870;

    final private static int JH5T_STD_I64BE = 4880;

    final private static int JH5T_STD_I64LE = 4890;

    final private static int JH5T_STD_I8BE = 4900;

    final private static int JH5T_STD_I8LE = 4910;

    final private static int JH5T_STD_REF_DSETREG = 4920;

    final private static int JH5T_STD_REF_OBJ = 4930;

    final private static int JH5T_STD_U16BE = 4940;

    final private static int JH5T_STD_U16LE = 4950;

    final private static int JH5T_STD_U32BE = 4960;

    final private static int JH5T_STD_U32LE = 4970;

    final private static int JH5T_STD_U64BE = 4980;

    final private static int JH5T_STD_U64LE = 4990;

    final private static int JH5T_STD_U8BE = 5000;

    final private static int JH5T_STD_U8LE = 5010;

    final private static int JH5T_STR_ERROR = 5020;

    final private static int JH5T_STR_NULLPAD = 5030;

    final private static int JH5T_STR_NULLTERM = 5040;

    final private static int JH5T_STR_RESERVED_10 = 5050;

    final private static int JH5T_STR_RESERVED_11 = 5060;

    final private static int JH5T_STR_RESERVED_12 = 5070;

    final private static int JH5T_STR_RESERVED_13 = 5080;

    final private static int JH5T_STR_RESERVED_14 = 5090;

    final private static int JH5T_STR_RESERVED_15 = 5100;

    final private static int JH5T_STR_RESERVED_3 = 5110;

    final private static int JH5T_STR_RESERVED_4 = 5120;

    final private static int JH5T_STR_RESERVED_5 = 5130;

    final private static int JH5T_STR_RESERVED_6 = 5140;

    final private static int JH5T_STR_RESERVED_7 = 5150;

    final private static int JH5T_STR_RESERVED_8 = 5160;

    final private static int JH5T_STR_RESERVED_9 = 5170;

    final private static int JH5T_STR_SPACEPAD = 5180;

    final private static int JH5T_STRING = 5190;

    final private static int JH5T_TIME = 5200;

    final private static int JH5T_UNIX_D32BE = 5210;

    final private static int JH5T_UNIX_D32LE = 5220;

    final private static int JH5T_UNIX_D64BE = 5230;

    final private static int JH5T_UNIX_D64LE = 5240;

    final private static int JH5T_VARIABLE = 5245;

    final private static int JH5T_VLEN = 5250;

    final private static int JH5Z_CB_CONT = 5260;

    final private static int JH5Z_CB_ERROR = 5270;

    final private static int JH5Z_CB_FAIL = 5280;

    final private static int JH5Z_CB_NO = 5290;

    final private static int JH5Z_DISABLE_EDC = 5300;

    final private static int JH5Z_ENABLE_EDC = 5310;

    final private static int JH5Z_ERROR_EDC = 5320;

    final private static int JH5Z_FILTER_DEFLATE = 5330;

    final private static int JH5Z_FILTER_ERROR = 5340;

    final private static int JH5Z_FILTER_FLETCHER32 = 5350;

    final private static int JH5Z_FILTER_MAX = 5360;

    final private static int JH5Z_FILTER_NONE = 5370;

    final private static int JH5Z_FILTER_RESERVED = 5380;

    final private static int JH5Z_FILTER_SHUFFLE = 5390;

    final private static int JH5Z_FILTER_SZIP = 5400;

    final private static int JH5Z_FLAG_DEFMASK = 5410;

    final private static int JH5Z_FLAG_INVMASK = 5420;

    final private static int JH5Z_FLAG_MANDATORY = 5430;

    final private static int JH5Z_FLAG_OPTIONAL = 5440;

    final private static int JH5Z_FLAG_REVERSE = 5450;

    final private static int JH5Z_FLAG_SKIP_EDC = 5460;

    final private static int JH5Z_MAX_NFILTERS = 5470;

    final private static int JH5Z_NO_EDC = 5480;
    
    final private static int JH5Z_SO_INT = 5481;

    final private static int JH5Z_SO_FLOAT_DSCALE = 5482;

    final private static int JH5Z_SO_FLOAT_ESCALE = 5483;

    final private static int JH5Z_FILTER_CONFIG_ENCODE_ENABLED = 5490;

    final private static int JH5Z_FILTER_CONFIG_DECODE_ENABLED = 5500;

    // /////////////////////////////////////////////////////////////////////////
    // Get the HDF5 constants from the library //
    // /////////////////////////////////////////////////////////////////////////

    final public static int H5_SZIP_MAX_PIXELS_PER_BLOCK = javaToC(JH5_SZIP_MAX_PIXELS_PER_BLOCK);

    final public static int H5_SZIP_NN_OPTION_MASK = javaToC(JH5_SZIP_NN_OPTION_MASK);

    final public static int H5_SZIP_EC_OPTION_MASK = javaToC(JH5_SZIP_EC_OPTION_MASK);

    final public static int H5_SZIP_ALLOW_K13_OPTION_MASK = javaToC(JH5_SZIP_ALLOW_K13_OPTION_MASK);

    final public static int H5_SZIP_CHIP_OPTION_MASK = javaToC(JH5_SZIP_CHIP_OPTION_MASK);

    final public static int H5D_ALLOC_TIME_DEFAULT = javaToC(JH5D_ALLOC_TIME_DEFAULT);

    final public static int H5D_ALLOC_TIME_EARLY = javaToC(JH5D_ALLOC_TIME_EARLY);

    final public static int H5D_ALLOC_TIME_ERROR = javaToC(JH5D_ALLOC_TIME_ERROR);

    final public static int H5D_ALLOC_TIME_INCR = javaToC(JH5D_ALLOC_TIME_INCR);

    final public static int H5D_ALLOC_TIME_LATE = javaToC(JH5D_ALLOC_TIME_LATE);

    final public static int H5D_CHUNKED = javaToC(JH5D_CHUNKED);

    final public static int H5D_COMPACT = javaToC(JH5D_COMPACT);

    final public static int H5D_CONTIGUOUS = javaToC(JH5D_CONTIGUOUS);

    final public static int H5D_FILL_TIME_ALLOC = javaToC(JH5D_FILL_TIME_ALLOC);

    final public static int H5D_FILL_TIME_ERROR = javaToC(JH5D_FILL_TIME_ERROR);

    final public static int H5D_FILL_TIME_NEVER = javaToC(JH5D_FILL_TIME_NEVER);

    final public static int H5D_FILL_VALUE_DEFAULT = javaToC(JH5D_FILL_VALUE_DEFAULT);

    final public static int H5D_FILL_VALUE_ERROR = javaToC(JH5D_FILL_VALUE_ERROR);

    final public static int H5D_FILL_VALUE_UNDEFINED = javaToC(JH5D_FILL_VALUE_UNDEFINED);

    final public static int H5D_FILL_VALUE_USER_DEFINED = javaToC(JH5D_FILL_VALUE_USER_DEFINED);

    final public static int H5D_LAYOUT_ERROR = javaToC(JH5D_LAYOUT_ERROR);

    final public static int H5D_NLAYOUTS = javaToC(JH5D_NLAYOUTS);

    final public static int H5D_SPACE_STATUS_ALLOCATED = javaToC(JH5D_SPACE_STATUS_ALLOCATED);

    final public static int H5D_SPACE_STATUS_ERROR = javaToC(JH5D_SPACE_STATUS_ERROR);

    final public static int H5D_SPACE_STATUS_NOT_ALLOCATED =
            javaToC(JH5D_SPACE_STATUS_NOT_ALLOCATED);

    final public static int H5D_SPACE_STATUS_PART_ALLOCATED =
            javaToC(JH5D_SPACE_STATUS_PART_ALLOCATED);

    final public static int H5E_ALIGNMENT = javaToC(JH5E_ALIGNMENT);

    final public static int H5E_ALREADYEXISTS = javaToC(JH5E_ALREADYEXISTS);

    final public static int H5E_ALREADYINIT = javaToC(JH5E_ALREADYINIT);

    final public static int H5E_ARGS = javaToC(JH5E_ARGS);

    final public static int H5E_ATOM = javaToC(JH5E_ATOM);

    final public static int H5E_ATTR = javaToC(JH5E_ATTR);

    final public static int H5E_BADATOM = javaToC(JH5E_BADATOM);

    final public static int H5E_BADFILE = javaToC(JH5E_BADFILE);

    final public static int H5E_BADGROUP = javaToC(JH5E_BADGROUP);

    final public static int H5E_BADMESG = javaToC(JH5E_BADMESG);

    final public static int H5E_BADRANGE = javaToC(JH5E_BADRANGE);

    final public static int H5E_BADSELECT = javaToC(JH5E_BADSELECT);

    final public static int H5E_BADSIZE = javaToC(JH5E_BADSIZE);

    final public static int H5E_BADTYPE = javaToC(JH5E_BADTYPE);

    final public static int H5E_BADVALUE = javaToC(JH5E_BADVALUE);

    final public static int H5E_BTREE = javaToC(JH5E_BTREE);

    final public static int H5E_CACHE = javaToC(JH5E_CACHE);

    final public static int H5E_CALLBACK = javaToC(JH5E_CALLBACK);

    final public static int H5E_CANAPPLY = javaToC(JH5E_CANAPPLY);

    final public static int H5E_CANTCLIP = javaToC(JH5E_CANTCLIP);

    final public static int H5E_CANTCLOSEFILE = javaToC(JH5E_CANTCLOSEFILE);

    final public static int H5E_CANTCONVERT = javaToC(JH5E_CANTCONVERT);

    final public static int H5E_CANTCOPY = javaToC(JH5E_CANTCOPY);

    final public static int H5E_CANTCOUNT = javaToC(JH5E_CANTCOUNT);

    final public static int H5E_CANTCREATE = javaToC(JH5E_CANTCREATE);

    final public static int H5E_CANTDEC = javaToC(JH5E_CANTDEC);

    final public static int H5E_CANTDECODE = javaToC(JH5E_CANTDECODE);

    final public static int H5E_CANTDELETE = javaToC(JH5E_CANTDELETE);

    final public static int H5E_CANTENCODE = javaToC(JH5E_CANTENCODE);

    final public static int H5E_CANTFLUSH = javaToC(JH5E_CANTFLUSH);

    final public static int H5E_CANTFREE = javaToC(JH5E_CANTFREE);

    final public static int H5E_CANTGET = javaToC(JH5E_CANTGET);

    final public static int H5E_CANTINC = javaToC(JH5E_CANTINC);

    final public static int H5E_CANTINIT = javaToC(JH5E_CANTINIT);

    final public static int H5E_CANTINSERT = javaToC(JH5E_CANTINSERT);

    final public static int H5E_CANTLIST = javaToC(JH5E_CANTLIST);

    final public static int H5E_CANTLOAD = javaToC(JH5E_CANTLOAD);

    final public static int H5E_CANTLOCK = javaToC(JH5E_CANTLOCK);

    final public static int H5E_CANTNEXT = javaToC(JH5E_CANTNEXT);

    final public static int H5E_CANTOPENFILE = javaToC(JH5E_CANTOPENFILE);

    final public static int H5E_CANTOPENOBJ = javaToC(JH5E_CANTOPENOBJ);

    final public static int H5E_CANTREGISTER = javaToC(JH5E_CANTREGISTER);

    final public static int H5E_CANTRELEASE = javaToC(JH5E_CANTRELEASE);

    final public static int H5E_CANTSELECT = javaToC(JH5E_CANTSELECT);

    final public static int H5E_CANTSET = javaToC(JH5E_CANTSET);

    final public static int H5E_CANTSPLIT = javaToC(JH5E_CANTSPLIT);

    final public static int H5E_CANTUNLOCK = javaToC(JH5E_CANTUNLOCK);

    final public static int H5E_CLOSEERROR = javaToC(JH5E_CLOSEERROR);

    final public static int H5E_COMPLEN = javaToC(JH5E_COMPLEN);

    final public static int H5E_DATASET = javaToC(JH5E_DATASET);

    final public static int H5E_DATASPACE = javaToC(JH5E_DATASPACE);

    final public static int H5E_DATATYPE = javaToC(JH5E_DATATYPE);

    final public static int H5E_DUPCLASS = javaToC(JH5E_DUPCLASS);

    final public static int H5E_EFL = javaToC(JH5E_EFL);

    final public static int H5E_EXISTS = javaToC(JH5E_EXISTS);

    final public static int H5E_FCNTL = javaToC(JH5E_FCNTL);

    final public static int H5E_FILE = javaToC(JH5E_FILE);

    final public static int H5E_FILEEXISTS = javaToC(JH5E_FILEEXISTS);

    final public static int H5E_FILEOPEN = javaToC(JH5E_FILEOPEN);

    final public static int H5E_FUNC = javaToC(JH5E_FUNC);

    final public static int H5E_HEAP = javaToC(JH5E_HEAP);

    final public static int H5E_INTERNAL = javaToC(JH5E_INTERNAL);

    final public static int H5E_IO = javaToC(JH5E_IO);

    final public static int H5E_LINK = javaToC(JH5E_LINK);

    final public static int H5E_LINKCOUNT = javaToC(JH5E_LINKCOUNT);

    final public static int H5E_MOUNT = javaToC(JH5E_MOUNT);

    final public static int H5E_MPI = javaToC(JH5E_MPI);

    final public static int H5E_MPIERRSTR = javaToC(JH5E_MPIERRSTR);

    final public static int H5E_NOFILTER = javaToC(JH5E_NOFILTER);

    final public static int H5E_NOIDS = javaToC(JH5E_NOIDS);

    final public static int H5E_NONE_MAJOR = javaToC(JH5E_NONE_MAJOR);

    final public static int H5E_NONE_MINOR = javaToC(JH5E_NONE_MINOR);

    final public static int H5E_NOSPACE = javaToC(JH5E_NOSPACE);

    final public static int H5E_NOTCACHED = javaToC(JH5E_NOTCACHED);

    final public static int H5E_NOTFOUND = javaToC(JH5E_NOTFOUND);

    final public static int H5E_NOTHDF5 = javaToC(JH5E_NOTHDF5);

    final public static int H5E_OHDR = javaToC(JH5E_OHDR);

    final public static int H5E_OVERFLOW = javaToC(JH5E_OVERFLOW);

    final public static int H5E_PLINE = javaToC(JH5E_PLINE);

    final public static int H5E_PLIST = javaToC(JH5E_PLIST);

    final public static int H5E_PROTECT = javaToC(JH5E_PROTECT);

    final public static int H5E_READERROR = javaToC(JH5E_READERROR);

    final public static int H5E_REFERENCE = javaToC(JH5E_REFERENCE);

    final public static int H5E_RESOURCE = javaToC(JH5E_RESOURCE);

    final public static int H5E_RS = javaToC(JH5E_RS);

    final public static int H5E_SEEKERROR = javaToC(JH5E_SEEKERROR);

    final public static int H5E_SETLOCAL = javaToC(JH5E_SETLOCAL);

    final public static int H5E_STORAGE = javaToC(JH5E_STORAGE);

    final public static int H5E_SYM = javaToC(JH5E_SYM);

    final public static int H5E_TRUNCATED = javaToC(JH5E_TRUNCATED);

    final public static int H5E_TST = javaToC(JH5E_TST);

    final public static int H5E_UNINITIALIZED = javaToC(JH5E_UNINITIALIZED);

    final public static int H5E_UNSUPPORTED = javaToC(JH5E_UNSUPPORTED);

    final public static int H5E_VERSION = javaToC(JH5E_VERSION);

    final public static int H5E_VFL = javaToC(JH5E_VFL);

    final public static int H5E_WALK_DOWNWARD = javaToC(JH5E_WALK_DOWNWARD);

    final public static int H5E_WALK_UPWARD = javaToC(JH5E_WALK_UPWARD);

    final public static int H5E_WRITEERROR = javaToC(JH5E_WRITEERROR);

    final public static int H5F_ACC_CREAT = javaToC(JH5F_ACC_CREAT);

    final public static int H5F_ACC_DEBUG = javaToC(JH5F_ACC_DEBUG);

    final public static int H5F_ACC_EXCL = javaToC(JH5F_ACC_EXCL);

    final public static int H5F_ACC_RDONLY = javaToC(JH5F_ACC_RDONLY);

    final public static int H5F_ACC_RDWR = javaToC(JH5F_ACC_RDWR);

    final public static int H5F_ACC_TRUNC = javaToC(JH5F_ACC_TRUNC);

    final public static int H5F_CLOSE_DEFAULT = javaToC(JH5F_CLOSE_DEFAULT);

    final public static int H5F_CLOSE_SEMI = javaToC(JH5F_CLOSE_SEMI);

    final public static int H5F_CLOSE_STRONG = javaToC(JH5F_CLOSE_STRONG);

    final public static int H5F_CLOSE_WEAK = javaToC(JH5F_CLOSE_WEAK);

    final public static int H5F_OBJ_ALL = javaToC(JH5F_OBJ_ALL);

    final public static int H5F_OBJ_ATTR = javaToC(JH5F_OBJ_ATTR);

    final public static int H5F_OBJ_DATASET = javaToC(JH5F_OBJ_DATASET);

    final public static int H5F_OBJ_DATATYPE = javaToC(JH5F_OBJ_DATATYPE);

    final public static int H5F_OBJ_FILE = javaToC(JH5F_OBJ_FILE);

    final public static int H5F_OBJ_GROUP = javaToC(JH5F_OBJ_GROUP);

    final public static int H5F_SCOPE_GLOBAL = javaToC(JH5F_SCOPE_GLOBAL);

    final public static int H5F_SCOPE_LOCAL = javaToC(JH5F_SCOPE_LOCAL);

    final public static int H5F_UNLIMITED = javaToC(JH5F_UNLIMITED);

    final public static int H5F_LIBVER_EARLIEST = javaToC(JH5F_LIBVER_EARLIEST);

    final public static int H5F_LIBVER_LATEST = javaToC(JH5F_LIBVER_LATEST);

    final public static int H5G_DATASET = javaToC(JH5G_DATASET);

    final public static int H5G_GROUP = javaToC(JH5G_GROUP);

    final public static int H5G_LINK = javaToC(JH5G_LINK);

    final public static int H5G_LINK_ERROR = javaToC(JH5G_LINK_ERROR);

    final public static int H5G_LINK_HARD = javaToC(JH5G_LINK_HARD);

    final public static int H5G_LINK_SOFT = javaToC(JH5G_LINK_SOFT);

    final public static int H5G_NLIBTYPES = javaToC(JH5G_NLIBTYPES);

    final public static int H5G_NTYPES = javaToC(JH5G_NTYPES);

    final public static int H5G_NUSERTYPES = javaToC(JH5G_NUSERTYPES);

    final public static int H5G_RESERVED_5 = javaToC(JH5G_RESERVED_5);

    final public static int H5G_RESERVED_6 = javaToC(JH5G_RESERVED_6);

    final public static int H5G_RESERVED_7 = javaToC(JH5G_RESERVED_7);

    final public static int H5G_SAME_LOC = javaToC(JH5G_SAME_LOC);

    final public static int H5G_TYPE = javaToC(JH5G_TYPE);

    final public static int H5G_UNKNOWN = javaToC(JH5G_UNKNOWN);

    final public static int H5I_ATTR = javaToC(JH5I_ATTR);

    final public static int H5I_BADID = javaToC(JH5I_BADID);

    final public static int H5I_DATASET = javaToC(JH5I_DATASET);

    final public static int H5I_DATASPACE = javaToC(JH5I_DATASPACE);

    final public static int H5I_DATATYPE = javaToC(JH5I_DATATYPE);

    final public static int H5I_FILE = javaToC(JH5I_FILE);

    final public static int H5I_GENPROP_CLS = javaToC(JH5I_GENPROP_CLS);

    final public static int H5I_GENPROP_LST = javaToC(JH5I_GENPROP_LST);

    final public static int H5I_GROUP = javaToC(JH5I_GROUP);

    final public static int H5I_INVALID_HID = javaToC(JH5I_INVALID_HID);

    final public static int H5I_REFERENCE = javaToC(JH5I_REFERENCE);

    final public static int H5I_VFL = javaToC(JH5I_VFL);

    final public static int H5O_TYPE_UNKNOWN = javaToC(JH5O_TYPE_UNKNOWN);

    final public static int H5O_TYPE_GROUP = javaToC(JH5O_TYPE_GROUP);

    final public static int H5O_TYPE_DATASET = javaToC(JH5O_TYPE_DATASET);

    final public static int H5O_TYPE_NAMED_DATATYPE = javaToC(JH5O_TYPE_NAMED_DATATYPE);

    final public static int H5O_TYPE_NTYPES = javaToC(JH5O_TYPE_NTYPES);

    final public static int H5L_TYPE_ERROR = javaToC(JH5L_TYPE_ERROR);

    final public static int H5L_TYPE_HARD = javaToC(JH5L_TYPE_HARD);

    final public static int H5L_TYPE_SOFT = javaToC(JH5L_TYPE_SOFT);

    final public static int H5L_TYPE_EXTERNAL = javaToC(JH5L_TYPE_EXTERNAL);

    final public static int H5L_TYPE_MAX = javaToC(JH5L_TYPE_MAX);

    final public static int H5P_DATASET_CREATE = javaToC(JH5P_DATASET_CREATE);

    final public static int H5P_DATASET_CREATE_DEFAULT = javaToC(JH5P_DATASET_CREATE_DEFAULT);

    final public static int H5P_DATASET_XFER = javaToC(JH5P_DATASET_XFER);

    final public static int H5P_DATASET_XFER_DEFAULT = javaToC(JH5P_DATASET_XFER_DEFAULT);

    final public static int H5P_DEFAULT = javaToC(JH5P_DEFAULT);

    final public static int H5P_FILE_ACCESS = javaToC(JH5P_FILE_ACCESS);

    final public static int H5P_FILE_ACCESS_DEFAULT = javaToC(JH5P_FILE_ACCESS_DEFAULT);

    final public static int H5P_FILE_CREATE = javaToC(JH5P_FILE_CREATE);

    final public static int H5P_FILE_CREATE_DEFAULT = javaToC(JH5P_FILE_CREATE_DEFAULT);

    final public static int H5P_NO_CLASS = javaToC(JH5P_NO_CLASS);
    
    final public static int H5P_ROOT = javaToC(JH5P_ROOT);

    final public static int H5P_OBJECT_CREATE = javaToC(JH5P_OBJECT_CREATE);

    final public static int H5P_DATASET_ACCESS = javaToC(JH5P_DATASET_ACCESS);

    final public static int H5P_DATASET_ACCESS_DEFAULT = javaToC(JH5P_DATASET_ACCESS_DEFAULT);

    final public static int H5P_FILE_MOUNT = javaToC(JH5P_FILE_MOUNT);

    final public static int H5P_FILE_MOUNT_DEFAULT = javaToC(JH5P_FILE_MOUNT_DEFAULT);

    final public static int H5P_GROUP_CREATE = javaToC(JH5P_GROUP_CREATE);

    final public static int H5P_GROUP_CREATE_DEFAULT = javaToC(JH5P_GROUP_CREATE_DEFAULT);

    final public static int H5P_GROUP_ACCESS = javaToC(JH5P_GROUP_ACCESS);

    final public static int H5P_GROUP_ACCESS_DEFAULT = javaToC(JH5P_GROUP_ACCESS_DEFAULT);

    final public static int H5P_DATATYPE_CREATE = javaToC(JH5P_DATATYPE_CREATE);

    final public static int H5P_DATATYPE_CREATE_DEFAULT = javaToC(JH5P_DATATYPE_CREATE_DEFAULT);

    final public static int H5P_DATATYPE_ACCESS = javaToC(JH5P_DATATYPE_ACCESS);

    final public static int H5P_DATATYPE_ACCESS_DEFAULT = javaToC(JH5P_DATATYPE_ACCESS_DEFAULT);

    final public static int H5P_STRING_CREATE = javaToC(JH5P_STRING_CREATE);

    final public static int H5P_ATTRIBUTE_CREATE = javaToC(JH5P_ATTRIBUTE_CREATE);

    final public static int H5P_ATTRIBUTE_CREATE_DEFAULT = javaToC(JH5P_ATTRIBUTE_CREATE_DEFAULT);

    final public static int H5P_OBJECT_COPY = javaToC(JH5P_OBJECT_COPY);

    final public static int H5P_OBJECT_COPY_DEFAULT = javaToC(JH5P_OBJECT_COPY_DEFAULT);

    final public static int H5P_LINK_CREATE = javaToC(JH5P_LINK_CREATE);

    final public static int H5P_LINK_CREATE_DEFAULT = javaToC(JH5P_LINK_CREATE_DEFAULT);

    final public static int H5P_LINK_ACCESS = javaToC(JH5P_LINK_ACCESS);

    final public static int H5P_LINK_ACCESS_DEFAULT = javaToC(JH5P_LINK_ACCESS_DEFAULT);

    final public static int H5R_BADTYPE = javaToC(JH5R_BADTYPE);

    final public static int H5R_DATASET_REGION = javaToC(JH5R_DATASET_REGION);

    final public static int H5R_MAXTYPE = javaToC(JH5R_MAXTYPE);

    final public static int H5R_OBJ_REF_BUF_SIZE = javaToC(JH5R_OBJ_REF_BUF_SIZE);

    final public static int H5R_OBJECT = javaToC(JH5R_OBJECT);

    final public static int H5S_ALL = javaToC(JH5S_ALL);

    final public static int H5S_MAX_RANK = javaToC(JH5S_MAX_RANK);

    final public static int H5S_NO_CLASS = javaToC(JH5S_NO_CLASS);

    final public static int H5S_SCALAR = javaToC(JH5S_SCALAR);

    final public static int H5S_SEL_ALL = javaToC(JH5S_SEL_ALL);

    final public static int H5S_SEL_ERROR = javaToC(JH5S_SEL_ERROR);

    final public static int H5S_SEL_HYPERSLABS = javaToC(JH5S_SEL_HYPERSLABS);

    final public static int H5S_SEL_N = javaToC(JH5S_SEL_N);

    final public static int H5S_SEL_NONE = javaToC(JH5S_SEL_NONE);

    final public static int H5S_SEL_POINTS = javaToC(JH5S_SEL_POINTS);

    final public static int H5S_SELECT_AND = javaToC(JH5S_SELECT_AND);

    final public static int H5S_SELECT_APPEND = javaToC(JH5S_SELECT_APPEND);

    final public static int H5S_SELECT_INVALID = javaToC(JH5S_SELECT_INVALID);

    final public static int H5S_SELECT_NOOP = javaToC(JH5S_SELECT_NOOP);

    final public static int H5S_SELECT_NOTA = javaToC(JH5S_SELECT_NOTA);

    final public static int H5S_SELECT_NOTB = javaToC(JH5S_SELECT_NOTB);

    final public static int H5S_SELECT_OR = javaToC(JH5S_SELECT_OR);

    final public static int H5S_SELECT_PREPEND = javaToC(JH5S_SELECT_PREPEND);

    final public static int H5S_SELECT_SET = javaToC(JH5S_SELECT_SET);

    final public static int H5S_SELECT_XOR = javaToC(JH5S_SELECT_XOR);

    final public static int H5S_SIMPLE = javaToC(JH5S_SIMPLE);

    final public static int H5S_UNLIMITED = javaToC(JH5S_UNLIMITED);

    final public static int H5T_ALPHA_B16 = javaToC(JH5T_ALPHA_B16);

    final public static int H5T_ALPHA_B32 = javaToC(JH5T_ALPHA_B32);

    final public static int H5T_ALPHA_B64 = javaToC(JH5T_ALPHA_B64);

    final public static int H5T_ALPHA_B8 = javaToC(JH5T_ALPHA_B8);

    final public static int H5T_ALPHA_F32 = javaToC(JH5T_ALPHA_F32);

    final public static int H5T_ALPHA_F64 = javaToC(JH5T_ALPHA_F64);

    final public static int H5T_ALPHA_I16 = javaToC(JH5T_ALPHA_I16);

    final public static int H5T_ALPHA_I32 = javaToC(JH5T_ALPHA_I32);

    final public static int H5T_ALPHA_I64 = javaToC(JH5T_ALPHA_I64);

    final public static int H5T_ALPHA_I8 = javaToC(JH5T_ALPHA_I8);

    final public static int H5T_ALPHA_U16 = javaToC(JH5T_ALPHA_U16);

    final public static int H5T_ALPHA_U32 = javaToC(JH5T_ALPHA_U32);

    final public static int H5T_ALPHA_U64 = javaToC(JH5T_ALPHA_U64);

    final public static int H5T_ALPHA_U8 = javaToC(JH5T_ALPHA_U8);

    final public static int H5T_ARRAY = javaToC(JH5T_ARRAY);

    final public static int H5T_BITFIELD = javaToC(JH5T_BITFIELD);

    final public static int H5T_BKG_NO = javaToC(JH5T_BKG_NO);

    final public static int H5T_BKG_YES = javaToC(JH5T_BKG_YES);

    final public static int H5T_C_S1 = javaToC(JH5T_C_S1);

    final public static int H5T_COMPOUND = javaToC(JH5T_COMPOUND);

    final public static int H5T_CONV_CONV = javaToC(JH5T_CONV_CONV);

    final public static int H5T_CONV_FREE = javaToC(JH5T_CONV_FREE);

    final public static int H5T_CONV_INIT = javaToC(JH5T_CONV_INIT);

    final public static int H5T_CSET_ASCII = javaToC(JH5T_CSET_ASCII);
    
    final public static int H5T_CSET_UTF8 = javaToC(JH5T_CSET_UTF8);

    final public static int H5T_CSET_ERROR = javaToC(JH5T_CSET_ERROR);

    final public static int H5T_CSET_RESERVED_10 = javaToC(JH5T_CSET_RESERVED_10);

    final public static int H5T_CSET_RESERVED_11 = javaToC(JH5T_CSET_RESERVED_11);

    final public static int H5T_CSET_RESERVED_12 = javaToC(JH5T_CSET_RESERVED_12);

    final public static int H5T_CSET_RESERVED_13 = javaToC(JH5T_CSET_RESERVED_13);

    final public static int H5T_CSET_RESERVED_14 = javaToC(JH5T_CSET_RESERVED_14);

    final public static int H5T_CSET_RESERVED_15 = javaToC(JH5T_CSET_RESERVED_15);

    final public static int H5T_CSET_RESERVED_2 = javaToC(JH5T_CSET_RESERVED_2);

    final public static int H5T_CSET_RESERVED_3 = javaToC(JH5T_CSET_RESERVED_3);

    final public static int H5T_CSET_RESERVED_4 = javaToC(JH5T_CSET_RESERVED_4);

    final public static int H5T_CSET_RESERVED_5 = javaToC(JH5T_CSET_RESERVED_5);

    final public static int H5T_CSET_RESERVED_6 = javaToC(JH5T_CSET_RESERVED_6);

    final public static int H5T_CSET_RESERVED_7 = javaToC(JH5T_CSET_RESERVED_7);

    final public static int H5T_CSET_RESERVED_8 = javaToC(JH5T_CSET_RESERVED_8);

    final public static int H5T_CSET_RESERVED_9 = javaToC(JH5T_CSET_RESERVED_9);

    final public static int H5T_DIR_ASCEND = javaToC(JH5T_DIR_ASCEND);

    final public static int H5T_DIR_DEFAULT = javaToC(JH5T_DIR_DEFAULT);

    final public static int H5T_DIR_DESCEND = javaToC(JH5T_DIR_DESCEND);

    final public static int H5T_ENUM = javaToC(JH5T_ENUM);

    final public static int H5T_FLOAT = javaToC(JH5T_FLOAT);

    final public static int H5T_FORTRAN_S1 = javaToC(JH5T_FORTRAN_S1);

    final public static int H5T_IEEE_F32BE = javaToC(JH5T_IEEE_F32BE);

    final public static int H5T_IEEE_F32LE = javaToC(JH5T_IEEE_F32LE);

    final public static int H5T_IEEE_F64BE = javaToC(JH5T_IEEE_F64BE);

    final public static int H5T_IEEE_F64LE = javaToC(JH5T_IEEE_F64LE);

    final public static int H5T_INTEGER = javaToC(JH5T_INTEGER);

    final public static int H5T_INTEL_B16 = javaToC(JH5T_INTEL_B16);

    final public static int H5T_INTEL_B32 = javaToC(JH5T_INTEL_B32);

    final public static int H5T_INTEL_B64 = javaToC(JH5T_INTEL_B64);

    final public static int H5T_INTEL_B8 = javaToC(JH5T_INTEL_B8);

    final public static int H5T_INTEL_F32 = javaToC(JH5T_INTEL_F32);

    final public static int H5T_INTEL_F64 = javaToC(JH5T_INTEL_F64);

    final public static int H5T_INTEL_I16 = javaToC(JH5T_INTEL_I16);

    final public static int H5T_INTEL_I32 = javaToC(JH5T_INTEL_I32);

    final public static int H5T_INTEL_I64 = javaToC(JH5T_INTEL_I64);

    final public static int H5T_INTEL_I8 = javaToC(JH5T_INTEL_I8);

    final public static int H5T_INTEL_U16 = javaToC(JH5T_INTEL_U16);

    final public static int H5T_INTEL_U32 = javaToC(JH5T_INTEL_U32);

    final public static int H5T_INTEL_U64 = javaToC(JH5T_INTEL_U64);

    final public static int H5T_INTEL_U8 = javaToC(JH5T_INTEL_U8);

    final public static int H5T_MIPS_B16 = javaToC(JH5T_MIPS_B16);

    final public static int H5T_MIPS_B32 = javaToC(JH5T_MIPS_B32);

    final public static int H5T_MIPS_B64 = javaToC(JH5T_MIPS_B64);

    final public static int H5T_MIPS_B8 = javaToC(JH5T_MIPS_B8);

    final public static int H5T_MIPS_F32 = javaToC(JH5T_MIPS_F32);

    final public static int H5T_MIPS_F64 = javaToC(JH5T_MIPS_F64);

    final public static int H5T_MIPS_I16 = javaToC(JH5T_MIPS_I16);

    final public static int H5T_MIPS_I32 = javaToC(JH5T_MIPS_I32);

    final public static int H5T_MIPS_I64 = javaToC(JH5T_MIPS_I64);

    final public static int H5T_MIPS_I8 = javaToC(JH5T_MIPS_I8);

    final public static int H5T_MIPS_U16 = javaToC(JH5T_MIPS_U16);

    final public static int H5T_MIPS_U32 = javaToC(JH5T_MIPS_U32);

    final public static int H5T_MIPS_U64 = javaToC(JH5T_MIPS_U64);

    final public static int H5T_MIPS_U8 = javaToC(JH5T_MIPS_U8);

    final public static int H5T_NATIVE_B16 = javaToC(JH5T_NATIVE_B16);

    final public static int H5T_NATIVE_B32 = javaToC(JH5T_NATIVE_B32);

    final public static int H5T_NATIVE_B64 = javaToC(JH5T_NATIVE_B64);

    final public static int H5T_NATIVE_B8 = javaToC(JH5T_NATIVE_B8);

    final public static int H5T_NATIVE_CHAR = javaToC(JH5T_NATIVE_CHAR);

    final public static int H5T_NATIVE_DOUBLE = javaToC(JH5T_NATIVE_DOUBLE);

    final public static int H5T_NATIVE_FLOAT = javaToC(JH5T_NATIVE_FLOAT);

    final public static int H5T_NATIVE_HADDR = javaToC(JH5T_NATIVE_HADDR);

    final public static int H5T_NATIVE_HBOOL = javaToC(JH5T_NATIVE_HBOOL);

    final public static int H5T_NATIVE_HERR = javaToC(JH5T_NATIVE_HERR);

    final public static int H5T_NATIVE_HSIZE = javaToC(JH5T_NATIVE_HSIZE);

    final public static int H5T_NATIVE_HSSIZE = javaToC(JH5T_NATIVE_HSSIZE);

    final public static int H5T_NATIVE_INT = javaToC(JH5T_NATIVE_INT);

    final public static int H5T_NATIVE_INT_FAST16 = javaToC(JH5T_NATIVE_INT_FAST16);

    final public static int H5T_NATIVE_INT_FAST32 = javaToC(JH5T_NATIVE_INT_FAST32);

    final public static int H5T_NATIVE_INT_FAST64 = javaToC(JH5T_NATIVE_INT_FAST64);

    final public static int H5T_NATIVE_INT_FAST8 = javaToC(JH5T_NATIVE_INT_FAST8);

    final public static int H5T_NATIVE_INT_LEAST16 = javaToC(JH5T_NATIVE_INT_LEAST16);

    final public static int H5T_NATIVE_INT_LEAST32 = javaToC(JH5T_NATIVE_INT_LEAST32);

    final public static int H5T_NATIVE_INT_LEAST64 = javaToC(JH5T_NATIVE_INT_LEAST64);

    final public static int H5T_NATIVE_INT_LEAST8 = javaToC(JH5T_NATIVE_INT_LEAST8);

    final public static int H5T_NATIVE_INT16 = javaToC(JH5T_NATIVE_INT16);

    final public static int H5T_NATIVE_INT32 = javaToC(JH5T_NATIVE_INT32);

    final public static int H5T_NATIVE_INT64 = javaToC(JH5T_NATIVE_INT64);

    final public static int H5T_NATIVE_INT8 = javaToC(JH5T_NATIVE_INT8);

    final public static int H5T_NATIVE_LDOUBLE = javaToC(JH5T_NATIVE_LDOUBLE);

    final public static int H5T_NATIVE_LLONG = javaToC(JH5T_NATIVE_LLONG);

    final public static int H5T_NATIVE_LONG = javaToC(JH5T_NATIVE_LONG);

    final public static int H5T_NATIVE_OPAQUE = javaToC(JH5T_NATIVE_OPAQUE);

    final public static int H5T_NATIVE_SCHAR = javaToC(JH5T_NATIVE_SCHAR);

    final public static int H5T_NATIVE_SHORT = javaToC(JH5T_NATIVE_SHORT);

    final public static int H5T_NATIVE_UCHAR = javaToC(JH5T_NATIVE_UCHAR);

    final public static int H5T_NATIVE_UINT = javaToC(JH5T_NATIVE_UINT);

    final public static int H5T_NATIVE_UINT_FAST16 = javaToC(JH5T_NATIVE_UINT_FAST16);

    final public static int H5T_NATIVE_UINT_FAST32 = javaToC(JH5T_NATIVE_UINT_FAST32);

    final public static int H5T_NATIVE_UINT_FAST64 = javaToC(JH5T_NATIVE_UINT_FAST64);

    final public static int H5T_NATIVE_UINT_FAST8 = javaToC(JH5T_NATIVE_UINT_FAST8);

    final public static int H5T_NATIVE_UINT_LEAST16 = javaToC(JH5T_NATIVE_UINT_LEAST16);

    final public static int H5T_NATIVE_UINT_LEAST32 = javaToC(JH5T_NATIVE_UINT_LEAST32);

    final public static int H5T_NATIVE_UINT_LEAST64 = javaToC(JH5T_NATIVE_UINT_LEAST64);

    final public static int H5T_NATIVE_UINT_LEAST8 = javaToC(JH5T_NATIVE_UINT_LEAST8);

    final public static int H5T_NATIVE_UINT16 = javaToC(JH5T_NATIVE_UINT16);

    final public static int H5T_NATIVE_UINT32 = javaToC(JH5T_NATIVE_UINT32);

    final public static int H5T_NATIVE_UINT64 = javaToC(JH5T_NATIVE_UINT64);

    final public static int H5T_NATIVE_UINT8 = javaToC(JH5T_NATIVE_UINT8);

    final public static int H5T_NATIVE_ULLONG = javaToC(JH5T_NATIVE_ULLONG);

    final public static int H5T_NATIVE_ULONG = javaToC(JH5T_NATIVE_ULONG);

    final public static int H5T_NATIVE_USHORT = javaToC(JH5T_NATIVE_USHORT);

    final public static int H5T_NCLASSES = javaToC(JH5T_NCLASSES);

    final public static int H5T_NO_CLASS = javaToC(JH5T_NO_CLASS);

    final public static int H5T_NORM_ERROR = javaToC(JH5T_NORM_ERROR);

    final public static int H5T_NORM_IMPLIED = javaToC(JH5T_NORM_IMPLIED);

    final public static int H5T_NORM_MSBSET = javaToC(JH5T_NORM_MSBSET);

    final public static int H5T_NORM_NONE = javaToC(JH5T_NORM_NONE);

    final public static int H5T_NPAD = javaToC(JH5T_NPAD);

    final public static int H5T_NSGN = javaToC(JH5T_NSGN);

    final public static int H5T_OPAQUE = javaToC(JH5T_OPAQUE);

    final public static int H5T_OPAQUE_TAG_MAX = javaToC(JH5T_OPAQUE_TAG_MAX); /* 1.6.5 */

    final public static int H5T_ORDER_BE = javaToC(JH5T_ORDER_BE);

    final public static int H5T_ORDER_ERROR = javaToC(JH5T_ORDER_ERROR);

    final public static int H5T_ORDER_LE = javaToC(JH5T_ORDER_LE);

    final public static int H5T_ORDER_NONE = javaToC(JH5T_ORDER_NONE);

    final public static int H5T_ORDER_VAX = javaToC(JH5T_ORDER_VAX);

    final public static int H5T_PAD_BACKGROUND = javaToC(JH5T_PAD_BACKGROUND);

    final public static int H5T_PAD_ERROR = javaToC(JH5T_PAD_ERROR);

    final public static int H5T_PAD_ONE = javaToC(JH5T_PAD_ONE);

    final public static int H5T_PAD_ZERO = javaToC(JH5T_PAD_ZERO);

    final public static int H5T_PERS_DONTCARE = javaToC(JH5T_PERS_DONTCARE);

    final public static int H5T_PERS_HARD = javaToC(JH5T_PERS_HARD);

    final public static int H5T_PERS_SOFT = javaToC(JH5T_PERS_SOFT);

    final public static int H5T_REFERENCE = javaToC(JH5T_REFERENCE);

    final public static int H5T_SGN_2 = javaToC(JH5T_SGN_2);

    final public static int H5T_SGN_ERROR = javaToC(JH5T_SGN_ERROR);

    final public static int H5T_SGN_NONE = javaToC(JH5T_SGN_NONE);

    final public static int H5T_STD_B16BE = javaToC(JH5T_STD_B16BE);

    final public static int H5T_STD_B16LE = javaToC(JH5T_STD_B16LE);

    final public static int H5T_STD_B32BE = javaToC(JH5T_STD_B32BE);

    final public static int H5T_STD_B32LE = javaToC(JH5T_STD_B32LE);

    final public static int H5T_STD_B64BE = javaToC(JH5T_STD_B64BE);

    final public static int H5T_STD_B64LE = javaToC(JH5T_STD_B64LE);

    final public static int H5T_STD_B8BE = javaToC(JH5T_STD_B8BE);

    final public static int H5T_STD_B8LE = javaToC(JH5T_STD_B8LE);

    final public static int H5T_STD_I16BE = javaToC(JH5T_STD_I16BE);

    final public static int H5T_STD_I16LE = javaToC(JH5T_STD_I16LE);

    final public static int H5T_STD_I32BE = javaToC(JH5T_STD_I32BE);

    final public static int H5T_STD_I32LE = javaToC(JH5T_STD_I32LE);

    final public static int H5T_STD_I64BE = javaToC(JH5T_STD_I64BE);

    final public static int H5T_STD_I64LE = javaToC(JH5T_STD_I64LE);

    final public static int H5T_STD_I8BE = javaToC(JH5T_STD_I8BE);

    final public static int H5T_STD_I8LE = javaToC(JH5T_STD_I8LE);

    final public static int H5T_STD_REF_DSETREG = javaToC(JH5T_STD_REF_DSETREG);

    final public static int H5T_STD_REF_OBJ = javaToC(JH5T_STD_REF_OBJ);

    final public static int H5T_STD_U16BE = javaToC(JH5T_STD_U16BE);

    final public static int H5T_STD_U16LE = javaToC(JH5T_STD_U16LE);

    final public static int H5T_STD_U32BE = javaToC(JH5T_STD_U32BE);

    final public static int H5T_STD_U32LE = javaToC(JH5T_STD_U32LE);

    final public static int H5T_STD_U64BE = javaToC(JH5T_STD_U64BE);

    final public static int H5T_STD_U64LE = javaToC(JH5T_STD_U64LE);

    final public static int H5T_STD_U8BE = javaToC(JH5T_STD_U8BE);

    final public static int H5T_STD_U8LE = javaToC(JH5T_STD_U8LE);

    final public static int H5T_STR_ERROR = javaToC(JH5T_STR_ERROR);

    final public static int H5T_STR_NULLPAD = javaToC(JH5T_STR_NULLPAD);

    final public static int H5T_STR_NULLTERM = javaToC(JH5T_STR_NULLTERM);

    final public static int H5T_STR_RESERVED_10 = javaToC(JH5T_STR_RESERVED_10);

    final public static int H5T_STR_RESERVED_11 = javaToC(JH5T_STR_RESERVED_11);

    final public static int H5T_STR_RESERVED_12 = javaToC(JH5T_STR_RESERVED_12);

    final public static int H5T_STR_RESERVED_13 = javaToC(JH5T_STR_RESERVED_13);

    final public static int H5T_STR_RESERVED_14 = javaToC(JH5T_STR_RESERVED_14);

    final public static int H5T_STR_RESERVED_15 = javaToC(JH5T_STR_RESERVED_15);

    final public static int H5T_STR_RESERVED_3 = javaToC(JH5T_STR_RESERVED_3);

    final public static int H5T_STR_RESERVED_4 = javaToC(JH5T_STR_RESERVED_4);

    final public static int H5T_STR_RESERVED_5 = javaToC(JH5T_STR_RESERVED_5);

    final public static int H5T_STR_RESERVED_6 = javaToC(JH5T_STR_RESERVED_6);

    final public static int H5T_STR_RESERVED_7 = javaToC(JH5T_STR_RESERVED_7);

    final public static int H5T_STR_RESERVED_8 = javaToC(JH5T_STR_RESERVED_8);

    final public static int H5T_STR_RESERVED_9 = javaToC(JH5T_STR_RESERVED_9);

    final public static int H5T_STR_SPACEPAD = javaToC(JH5T_STR_SPACEPAD);

    final public static int H5T_STRING = javaToC(JH5T_STRING);

    final public static int H5T_TIME = javaToC(JH5T_TIME);

    final public static int H5T_UNIX_D32BE = javaToC(JH5T_UNIX_D32BE);

    final public static int H5T_UNIX_D32LE = javaToC(JH5T_UNIX_D32LE);

    final public static int H5T_UNIX_D64BE = javaToC(JH5T_UNIX_D64BE);

    final public static int H5T_UNIX_D64LE = javaToC(JH5T_UNIX_D64LE);

    final public static int H5T_VARIABLE = javaToC(JH5T_VARIABLE); // Rosetta Biosoftware

    final public static int H5T_VLEN = javaToC(JH5T_VLEN);

    final public static int H5Z_CB_CONT = javaToC(JH5Z_CB_CONT);

    final public static int H5Z_CB_ERROR = javaToC(JH5Z_CB_ERROR);

    final public static int H5Z_CB_FAIL = javaToC(JH5Z_CB_FAIL);

    final public static int H5Z_CB_NO = javaToC(JH5Z_CB_NO);

    final public static int H5Z_DISABLE_EDC = javaToC(JH5Z_DISABLE_EDC);

    final public static int H5Z_ENABLE_EDC = javaToC(JH5Z_ENABLE_EDC);

    final public static int H5Z_ERROR_EDC = javaToC(JH5Z_ERROR_EDC);

    final public static int H5Z_FILTER_DEFLATE = javaToC(JH5Z_FILTER_DEFLATE);

    final public static int H5Z_FILTER_ERROR = javaToC(JH5Z_FILTER_ERROR);

    final public static int H5Z_FILTER_FLETCHER32 = javaToC(JH5Z_FILTER_FLETCHER32);

    final public static int H5Z_FILTER_MAX = javaToC(JH5Z_FILTER_MAX);

    final public static int H5Z_FILTER_NONE = javaToC(JH5Z_FILTER_NONE);

    final public static int H5Z_FILTER_RESERVED = javaToC(JH5Z_FILTER_RESERVED);

    final public static int H5Z_FILTER_SHUFFLE = javaToC(JH5Z_FILTER_SHUFFLE);

    final public static int H5Z_FILTER_SZIP = javaToC(JH5Z_FILTER_SZIP);

    final public static int H5Z_FLAG_DEFMASK = javaToC(JH5Z_FLAG_DEFMASK);

    final public static int H5Z_FLAG_INVMASK = javaToC(JH5Z_FLAG_INVMASK);

    final public static int H5Z_FLAG_MANDATORY = javaToC(JH5Z_FLAG_MANDATORY);

    final public static int H5Z_FLAG_OPTIONAL = javaToC(JH5Z_FLAG_OPTIONAL);

    final public static int H5Z_FLAG_REVERSE = javaToC(JH5Z_FLAG_REVERSE);

    final public static int H5Z_FLAG_SKIP_EDC = javaToC(JH5Z_FLAG_SKIP_EDC);

    final public static int H5Z_MAX_NFILTERS = javaToC(JH5Z_MAX_NFILTERS);

    final public static int H5Z_NO_EDC = javaToC(JH5Z_NO_EDC);

    final public static int H5Z_SO_INT = javaToC(JH5Z_SO_INT);
    
    final public static int H5Z_SO_FLOAT_DSCALE = javaToC(JH5Z_SO_FLOAT_DSCALE);
    
    final public static int H5Z_SO_FLOAT_ESCALE = javaToC(JH5Z_SO_FLOAT_ESCALE);
    
    final public static int H5Z_FILTER_CONFIG_ENCODE_ENABLED =
            javaToC(JH5Z_FILTER_CONFIG_ENCODE_ENABLED);

    final public static int H5Z_FILTER_CONFIG_DECODE_ENABLED =
            javaToC(JH5Z_FILTER_CONFIG_DECODE_ENABLED);

    private static int javaToC(int javaConstant)
    {
        synchronized(ncsa.hdf.hdf5lib.H5.class)
        {
            return H5.J2C(javaConstant);
        }
    }
}
