/*
  libnzb

  Copyright (C) 2004 Mattias Nordstrom <matta at ftlight net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Authors:
    Mattias Nordstrom <matta at ftlight net>

  $Id: uenc.cpp,v 1.3 2005/02/28 11:08:28 mnordstr Exp $
    This file provides the uuencode decoding functions.

*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "uenc.h"

#include <iostream>
#include <stdio.h>

using namespace std;

/* Single character decode.  */
#define DEC(Char) (((Char) - ' ') & 077)

udata nzb_udecode(string data, bool multi, int type)
{
	string retdata;
	udata uret;
	string::size_type pos = 0, pos2 = 0, begin = 0, end;
	bool badnl = false; // Newlines only \n, not \r\n,
	int nlcount = 2;
	
	uret.status = 1;
	uret.filename = "";
	uret.data = "";
  
	// Check for uencoded data.
	if (!(multi && type != 1) && (pos = data.find("begin ", 0)) == string::npos) {
		return uret;
	}
	
	if (!multi || (multi && type == 1))
	if (isdigit(data[pos+6]) && isdigit(data[pos+7]) && isdigit(data[pos+8]) && data[pos+9] == ' ') {
		if ((pos2 = data.find("\r\n", pos+10)) == string::npos) {
			badnl = true;
			nlcount = 1;
			
			if ((pos2 = data.find("\n", pos+10)) == string::npos) {
				return uret;
			}
		}
		
		begin = pos2 + nlcount;
		
		uret.filename = data.substr(pos + 10, pos2 - (pos + 10));
	} else {
		return uret;
	}

	if (!multi || (multi && type == 3)) {
		if ((pos = data.find("\r\nend\r\n", begin)) == string::npos && (pos = data.find("\nend\n", begin)) == string::npos) {
			return uret;
		}
		end = pos;
	} else {
		end = data.length() - nlcount;
	}
	
	data = data.substr(begin, (end + nlcount) - begin);

	// uudecode

	char buf[64];

	pos = 0;
	pos2 = 0;
	int ok = 1;
  
	while ((pos = data.find("\n", pos2)) != string::npos) {
		strcpy(buf, (data.substr(pos2, pos + 1 - pos2)).c_str());
		pos2 = pos + 1;
 
		if  (buf[0] > ' ' && buf[0] <= '`') {
			int  cv_len, i;
			register unsigned char * p=(unsigned char*)buf;

			cv_len = DEC(*p++);

			/* Actually decode the uue data; ensure characters are in range. */
			if (ok) for (i=0; i<cv_len; i+=3, p+=4) {
				if ( (p[0]<=' ' || p[0]>'`') ||
				(p[1]<=' ' || p[1]>'`') ||
				(p[2]<=' ' || p[2]>'`') ||
				(p[3]<=' ' || p[3]>'`') ) {
					ok = 0;
					break;
				}
	    
				retdata += DEC(*p) << 2 | DEC(p[1]) >> 4;
				retdata += DEC(p[1]) << 4 | DEC(p[2]) >> 2;
				retdata += DEC(p[2]) << 6 | DEC(p[3]);
			}
		
			if (*p != '\r' && *p != '\n' && *p != '\0')
				ok=0;
			else  *p=0;
		}
	}
	
	if (!multi || type == 3) {
		uret.data = retdata.substr(0, retdata.length() - 2); // This is something fishy that should be fixed.
	} else {
		uret.data = retdata;
	}
	uret.status = 0;
	
	return uret;
}
