/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.maven.hints.pom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

/**
 *
 * @author mkleint
 */
public class ParentVersionErrorCustomizer extends javax.swing.JPanel {
    private Preferences preferences;
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();

    /** Creates new form ParentVersionErrorCustomizer */
    public ParentVersionErrorCustomizer(Preferences prefs) {
        initComponents();
        preferences = prefs;
        buttonGroup1.add(rbLatest);
        buttonGroup1.add(rbSources);
        rbSources.setSelected(preferences.getBoolean(ParentVersionError.PROP_SOURCES, true));
        rbLatest.setSelected(!preferences.getBoolean(ParentVersionError.PROP_SOURCES, true));
        cbSnapshots.setSelected(preferences.getBoolean(ParentVersionError.PROP_SNAPSHOT, false));
        enableSnapshots();
        ActionListener al = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                preferences.putBoolean(ParentVersionError.PROP_SOURCES, rbSources.isSelected());
                enableSnapshots();
            }
        };
        rbSources.addActionListener(al);
        rbLatest.addActionListener(al);
        cbSnapshots.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                preferences.putBoolean(ParentVersionError.PROP_SNAPSHOT, cbSnapshots.isSelected());
            }
        });
    
        id2Saved.put(ParentVersionError.PROP_SOURCES, rbSources.isSelected());
        id2Saved.put(ParentVersionError.PROP_SNAPSHOT, cbSnapshots.isSelected());
    }
    
    String getSavedValue(String key) {
        return id2Saved.get(key).toString();
    }

    private void enableSnapshots() {
        cbSnapshots.setEnabled(rbLatest.isSelected());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        rbSources = new javax.swing.JRadioButton();
        rbLatest = new javax.swing.JRadioButton();
        cbSnapshots = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(rbSources, org.openide.util.NbBundle.getMessage(ParentVersionErrorCustomizer.class, "ParentVersionErrorCustomizer.rbSources.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(rbLatest, org.openide.util.NbBundle.getMessage(ParentVersionErrorCustomizer.class, "ParentVersionErrorCustomizer.rbLatest.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbSnapshots, org.openide.util.NbBundle.getMessage(ParentVersionErrorCustomizer.class, "ParentVersionErrorCustomizer.cbSnapshots.text")); // NOI18N
        cbSnapshots.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbSnapshotsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addComponent(cbSnapshots))
                    .addComponent(rbSources)
                    .addComponent(rbLatest))
                .addContainerGap(37, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rbSources)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rbLatest)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cbSnapshots)
                .addContainerGap(215, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cbSnapshotsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbSnapshotsActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_cbSnapshotsActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox cbSnapshots;
    private javax.swing.JRadioButton rbLatest;
    private javax.swing.JRadioButton rbSources;
    // End of variables declaration//GEN-END:variables

}
